/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class SebouhTest
extends Thread {
    static CountDownLatch endingLatch;
    static CountDownLatch startingLatch;
    static CountDownLatch readyToStartLatch;
    double totalTime;
    long iterations;
    EvioEvent event;
    ByteBuffer buffer;
    EvioReader reader;
    EventWriter evWriter;

    public static void main(String[] arg) throws EvioException, IOException, InterruptedException {
        int i;
        int n = arg.length > 0 ? Integer.parseInt(arg[0]) : Runtime.getRuntime().availableProcessors();
        EvioEvent ev = SebouhTest.generateEvent();
        System.out.println(n + " threads");
        SebouhTest[] threads = new SebouhTest[n];
        for (i = 0; i < n; ++i) {
            threads[i] = new SebouhTest(ev);
        }
        endingLatch = new CountDownLatch(n);
        startingLatch = new CountDownLatch(1);
        readyToStartLatch = new CountDownLatch(n);
        System.out.println();
        for (i = 0; i < n; ++i) {
            threads[i].start();
        }
        readyToStartLatch.await();
        startingLatch.countDown();
        endingLatch.await();
        double avgTime = 0.0;
        long iterations = 0L;
        for (int i2 = 0; i2 < n; ++i2) {
            avgTime += threads[i2].getTotalTime();
            iterations += threads[i2].getIterations();
        }
        System.out.println(String.format("Average time = %6.6f", avgTime /= (double)iterations) + " millisec");
    }

    public SebouhTest(EvioEvent ev) {
        this.event = ev;
        int bufSize = ev.getTotalBytes() + 64 + 1024;
        this.buffer = ByteBuffer.allocate(bufSize);
    }

    long getIterations() {
        return this.iterations;
    }

    double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public void run() {
        long tStart = 0L;
        long tEnd = 0L;
        try {
            readyToStartLatch.countDown();
            startingLatch.await();
            tStart = System.nanoTime();
            for (int i = 0; i < 50000; ++i) {
                this.evioToBytes();
                this.bytesToEvio();
                ++this.iterations;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tEnd = System.nanoTime();
        double time = (double)(tEnd - tStart) / 1000000.0;
        this.totalTime += time;
        System.out.println(this.totalTime + " totaltime in ms");
        endingLatch.countDown();
    }

    public static EvioEvent generateEvent() {
        EvioEvent ev = null;
        try {
            EventBuilder eb = new EventBuilder(500, DataType.BANK, 0);
            ev = eb.getEvent();
            EvioBank ibanks = new EvioBank(500, DataType.BANK, 100);
            eb.addChild(ev, ibanks);
            int[] idata = new int[10];
            EvioBank ibanks1 = new EvioBank(500, DataType.INT32, 23);
            ibanks1.appendIntData(idata);
            eb.addChild(ibanks, ibanks1);
            EvioBank ibanks2 = new EvioBank(500, DataType.INT32, 24);
            ibanks2.appendIntData(idata);
            eb.addChild(ibanks, ibanks2);
            EvioBank ibanks3 = new EvioBank(500, DataType.INT32, 24);
            ibanks3.appendIntData(idata);
            eb.addChild(ibanks, ibanks3);
            EvioBank ibanks4 = new EvioBank(500, DataType.INT32, 24);
            ibanks4.appendIntData(idata);
            eb.addChild(ibanks, ibanks4);
            EvioBank dbanks = new EvioBank(500, DataType.BANK, 200);
            eb.addChild(ev, dbanks);
            double[] darray = new double[10];
            EvioBank dbanks1 = new EvioBank(3, DataType.DOUBLE64, 1);
            dbanks1.appendDoubleData(darray);
            eb.addChild(dbanks, dbanks1);
            EvioBank dbanks2 = new EvioBank(3, DataType.DOUBLE64, 8);
            dbanks2.appendDoubleData(darray);
            eb.addChild(dbanks, dbanks2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ev;
    }

    static void printBuf(ByteBuffer buf) {
        System.out.println("BUFFER:");
        int lim = buf.limit();
        int pos = buf.position();
        int cap = buf.capacity();
        int max = lim > 80 ? 20 : lim / 4;
        for (int i = 0; i < max; ++i) {
            System.out.println("0x" + Integer.toHexString(buf.getInt(i)));
        }
        System.out.println("\n\n");
    }

    public void evioToBytes() {
        try {
            this.buffer.clear();
            if (this.evWriter == null) {
                this.evWriter = new EventWriter(this.buffer);
            } else {
                this.evWriter.setBuffer(this.buffer);
            }
            this.evWriter.writeEvent(this.event);
            this.evWriter.close();
            this.buffer.flip();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EvioEvent bytesToEvio() {
        EvioEvent ev = null;
        try {
            if (this.reader == null) {
                this.reader = new EvioReader(this.buffer);
            } else {
                this.reader.setBuffer(this.buffer);
            }
            EventParser p = this.reader.getParser();
            p.setNotificationActive(false);
            ev = this.reader.parseNextEvent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ev;
    }

    public static ByteBuffer evioToBytesOrig(EvioEvent ev) {
        int bufSize = ev.getTotalBytes() + 64 + 1024;
        ByteBuffer buf = null;
        try {
            buf = ByteBuffer.allocate(bufSize);
            EventWriter evWriter = new EventWriter(buf);
            evWriter.writeEvent(ev);
            evWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf;
    }

    public static EvioEvent bytesToEvioOrig(ByteBuffer buf) {
        EvioEvent ev = null;
        try {
            EvioReader reader = new EvioReader(buf);
            ev = reader.parseNextEvent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ev;
    }
}

