/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.IOException;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.StructureType;

public class EventBuilder {
    private EvioEvent event;

    public EventBuilder(int tag, DataType dataType, int num) {
        this.event = new EvioEvent(tag, dataType, num);
    }

    public EventBuilder(EvioEvent event) {
        this.event = event;
    }

    public void setAllHeaderLengths() {
        try {
            this.event.setAllHeaderLengths();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public void clearData(BaseStructure structure) {
        if (structure != null) {
            structure.rawBytes = null;
            structure.doubleData = null;
            structure.floatData = null;
            structure.intData = null;
            structure.longData = null;
            structure.shortData = null;
            structure.charData = null;
            structure.stringData = null;
            structure.stringsList = null;
            structure.stringEnd = 0;
            structure.numberDataItems = 0;
        }
    }

    public void addChild(BaseStructure parent, BaseStructure child) throws EvioException {
        block11: {
            DataType parentDataType;
            block10: {
                if (child == null || parent == null) {
                    throw new EvioException("Null child or parent arg.");
                }
                if (child.getByteOrder() != this.event.getByteOrder()) {
                    throw new EvioException("Attempt to add child with opposite byte order.");
                }
                parentDataType = parent.header.getDataType();
                if (!parentDataType.isStructure()) break block10;
                switch (parentDataType) {
                    case BANK: 
                    case ALSOBANK: {
                        if (child.getStructureType() != StructureType.BANK) {
                            String errStr = "Type mismatch in addChild. Parent content type: " + (Object)((Object)parentDataType) + " child type: " + (Object)((Object)child.getStructureType());
                            throw new EvioException(errStr);
                        }
                        break block11;
                    }
                    case SEGMENT: 
                    case ALSOSEGMENT: {
                        if (child.getStructureType() != StructureType.SEGMENT) {
                            String errStr = "Type mismatch in addChild. Parent content type: " + (Object)((Object)parentDataType) + " child type: " + (Object)((Object)child.getStructureType());
                            throw new EvioException(errStr);
                        }
                        break block11;
                    }
                    case TAGSEGMENT: {
                        if (child.getStructureType() != StructureType.TAGSEGMENT) {
                            String errStr = "Type mismatch in addChild. Parent content type: " + (Object)((Object)parentDataType) + " child type: " + (Object)((Object)child.getStructureType());
                            throw new EvioException(errStr);
                        }
                        break block11;
                    }
                }
                break block11;
            }
            String errStr = "Type mismatch in addChild. Parent content type: " + (Object)((Object)parentDataType) + " cannot have children.";
            throw new EvioException(errStr);
        }
        parent.insert(child);
        child.setParent(parent);
        this.setAllHeaderLengths();
    }

    public void remove(BaseStructure child) throws EvioException {
        if (child == null) {
            throw new EvioException("Attempt to remove null child.");
        }
        BaseStructure parent = child.getParent();
        if (parent == null) {
            throw new EvioException("Attempt to remove root node, i.e., the event. Don't remove an event. Just discard it.");
        }
        child.removeFromParent();
        child.setParent(null);
        this.setAllHeaderLengths();
    }

    public void setIntData(BaseStructure structure, int[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set int data to a null structure.");
        }
        structure.setIntData(data);
        this.setAllHeaderLengths();
    }

    public void setShortData(BaseStructure structure, short[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set short data to a null structure.");
        }
        structure.setShortData(data);
        this.setAllHeaderLengths();
    }

    public void setLongData(BaseStructure structure, long[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set long data to a null structure.");
        }
        structure.setLongData(data);
        this.setAllHeaderLengths();
    }

    public void setByteData(BaseStructure structure, byte[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set byte data to a null structure.");
        }
        structure.setByteData(data);
        this.setAllHeaderLengths();
    }

    public void setFloatData(BaseStructure structure, float[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set float data to a null structure.");
        }
        structure.setFloatData(data);
        this.setAllHeaderLengths();
    }

    public void setDoubleData(BaseStructure structure, double[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set double data to a null structure.");
        }
        structure.setDoubleData(data);
        this.setAllHeaderLengths();
    }

    public void setStringData(BaseStructure structure, String[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to set string data to a null structure.");
        }
        structure.setStringData(data);
        this.setAllHeaderLengths();
    }

    public void appendIntData(BaseStructure structure, int[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append int data to a null structure.");
        }
        structure.appendIntData(data);
        this.setAllHeaderLengths();
    }

    public void appendShortData(BaseStructure structure, short[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append short data to a null structure.");
        }
        structure.appendShortData(data);
        this.setAllHeaderLengths();
    }

    public void appendLongData(BaseStructure structure, long[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append long data to a null structure.");
        }
        structure.appendLongData(data);
        this.setAllHeaderLengths();
    }

    public void appendByteData(BaseStructure structure, byte[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append byte data to a null structure.");
        }
        structure.appendByteData(data);
        this.setAllHeaderLengths();
    }

    public void appendFloatData(BaseStructure structure, float[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append float data to a null structure.");
        }
        structure.appendFloatData(data);
        this.setAllHeaderLengths();
    }

    public void appendDoubleData(BaseStructure structure, double[] data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append double data to a null structure.");
        }
        structure.appendDoubleData(data);
        this.setAllHeaderLengths();
    }

    public void appendStringData(BaseStructure structure, String data) throws EvioException {
        if (structure == null) {
            throw new EvioException("Tried to append String to a null structure.");
        }
        structure.appendStringData(data);
        this.setAllHeaderLengths();
    }

    public EvioEvent getEvent() {
        return this.event;
    }

    public void setEvent(EvioEvent event) {
        this.event = event;
    }

    public static void main(String[] args) {
        String outfile = "C:\\Documents and Settings\\heddle\\My Documents\\test.ev";
        EventWriter eventWriter = null;
        try {
            eventWriter = new EventWriter(new File(outfile));
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(1);
        }
        int eventNumber = 1;
        int tag = 11;
        try {
            EventBuilder eventBuilder = new EventBuilder(tag, DataType.INT32, eventNumber++);
            EvioEvent event1 = eventBuilder.getEvent();
            eventBuilder.appendIntData(event1, EventBuilder.fakeIntArray(25));
            eventBuilder.appendIntData(event1, EventBuilder.fakeIntArray(10));
            eventWriter.writeEvent(event1);
            eventBuilder = new EventBuilder(tag, DataType.BANK, eventNumber++);
            EvioEvent event2 = eventBuilder.getEvent();
            EvioBank bank1 = new EvioBank(22, DataType.DOUBLE64, 0);
            eventBuilder.appendDoubleData(bank1, EventBuilder.fakeDoubleArray(10));
            eventBuilder.addChild(event2, bank1);
            eventWriter.writeEvent(event2);
            event2.getHeader().setNumber(eventNumber++);
            EvioBank bank2 = new EvioBank(33, DataType.BANK, 0);
            eventBuilder.addChild(event2, bank2);
            EvioBank subBank1 = new EvioBank(34, DataType.SHORT16, 1);
            eventBuilder.addChild(bank2, subBank1);
            eventBuilder.appendShortData(subBank1, EventBuilder.fakeShortArray(5));
            EvioBank subBank2 = new EvioBank(33, DataType.SEGMENT, 0);
            eventBuilder.addChild(bank2, subBank2);
            EvioSegment segment1 = new EvioSegment(34, DataType.SHORT16);
            eventBuilder.addChild(subBank2, segment1);
            eventBuilder.appendShortData(segment1, EventBuilder.fakeShortArray(7));
            EvioSegment segment2 = new EvioSegment(34, DataType.SHORT16);
            eventBuilder.addChild(subBank2, segment2);
            eventBuilder.appendShortData(segment2, EventBuilder.fakeShortArray(10));
            EvioBank subBank3 = new EvioBank(45, DataType.TAGSEGMENT, 0);
            eventBuilder.addChild(bank2, subBank3);
            EvioTagSegment tagsegment1 = new EvioTagSegment(34, DataType.INT32);
            eventBuilder.addChild(subBank3, tagsegment1);
            eventBuilder.appendIntData(tagsegment1, EventBuilder.fakeIntArray(3));
            EvioTagSegment tagsegment2 = new EvioTagSegment(34, DataType.CHARSTAR8);
            eventBuilder.addChild(subBank3, tagsegment2);
            eventBuilder.appendStringData(tagsegment2, "This is a string");
            eventWriter.writeEvent(event2);
            eventWriter.close();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Test completed.");
    }

    private static int[] fakeIntArray(int size) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i + 1;
        }
        return array;
    }

    private static short[] fakeShortArray(int size) {
        short[] array = new short[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (short)(i + 1);
        }
        return array;
    }

    private static char[] fakeCharArray() {
        char[] array = new char[]{'T', 'h', 'i', 's', ' ', 'i', 's', ' ', 'c', 'h', 'a', 'r', ' ', 'd', 'a', 't', 'a', '.'};
        return array;
    }

    private static double[] fakeDoubleArray(int size) {
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i + 1;
        }
        return array;
    }
}

