/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class Tester {
    private static void printDoubleBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        System.out.println();
        for (int i = 0; i < byteBuffer.limit() / 8; ++i) {
            System.out.print(byteBuffer.getDouble() + " ");
            if ((i + 1) % 8 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private static void printIntBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        System.out.println();
        for (int i = 0; i < byteBuffer.limit() / 4; ++i) {
            System.out.print(byteBuffer.getInt() + " ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            EvioEvent bank = new EvioEvent(1, DataType.BANK, 1);
            EvioBank ibank = new EvioBank(2, DataType.INT32, 2);
            EvioBank bbank = new EvioBank(3, DataType.INT32, 3);
            EvioBank lbank = new EvioBank(4, DataType.LONG64, 4);
            int[] data4 = new int[1];
            int[] data2 = new int[1];
            long[] data5 = new long[0x10000000];
            EventBuilder builder = new EventBuilder(bank);
            builder.appendLongData(lbank, data5);
            for (int i = 0; i < 2000; ++i) {
                System.out.print(i + " ");
                builder.addChild(bank, ibank);
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main55(String[] args) {
        byte[] data = new byte[]{1, 2};
        int off = 0;
        short s1 = (short)(0xFF & data[off] | 0xFF & data[1 + off] << 8);
        short s2 = (short)(0xFF & data[off] | (0xFF & data[1 + off]) << 8);
        String i1 = Integer.toHexString(ByteDataTransformer.shortBitsToInt(s1));
        String i2 = Integer.toHexString(ByteDataTransformer.shortBitsToInt(s2));
        System.out.println("littleE s1 = 0x" + i1 + ", s2 = 0x" + i2);
    }

    public static void main33(String[] args) {
        EvioEvent ev = new EvioEvent(1, DataType.INT32, 1);
        EvioBank bank = new EvioBank(2, DataType.BANK, 2);
        EvioBank ibank = new EvioBank(3, DataType.INT32, 3);
        int[] data = new int[]{1, 2, 3, 4, 5};
        try {
            ev.setDictionaryXML("blah blah blah");
            ev.appendIntData(data);
        }
        catch (EvioException e) {
            // empty catch block
        }
        System.out.println("Now create the clone ...");
        EvioEvent evClone = (EvioEvent)ev.clone();
        int[] data1 = evClone.getIntData();
        if (data1 != null) {
            for (int i : data1) {
                System.out.println("event i = " + i);
            }
        } else {
            System.out.println("event int data is NULL !!!");
        }
        String dict = evClone.getDictionaryXML();
        if (dict != null) {
            System.out.println("dictionary = \n" + dict);
        } else {
            System.out.println("event dictionary is NULL !!!");
        }
        int len = ev.getHeader().getHeaderLength();
        System.out.println("header length = " + len);
        System.out.println("Change ev tag from 1 to 66");
        ev.getHeader().setTag(66);
        System.out.println("\nev header = " + ev.getHeader().toString());
        System.out.println("\nclone header = " + evClone.getHeader().toString());
    }

    public static void main2(String[] args) {
        int LOOPS = 1000000;
        try {
            String[] sData;
            byte[] ba1 = new byte[]{1, 2, 3, 4, 5, 6, 7};
            byte[] ba2 = new byte[]{8, 9, 10, 11, 12, 13, 14};
            short[] sa1 = new short[]{1, 2, 3, 4, 5, 6, 7};
            short[] sa2 = new short[]{8, 9, 10, 11, 12, 13, 14};
            int[] ia1 = new int[]{1, 2, 3, 4, 5};
            int[] ia2 = new int[]{6, 7, 8, 9, 10};
            long[] la1 = new long[]{1L, 2L, 3L, 4L, 5L};
            long[] la2 = new long[]{6L, 7L, 8L, 9L, 10L};
            float[] fa1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
            float[] fa2 = new float[]{6.0f, 7.0f, 8.0f, 9.0f, 10.0f};
            double[] da1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
            double[] da2 = new double[]{6.0, 7.0, 8.0, 9.0, 10.0};
            EventBuilder eb = new EventBuilder(1, DataType.BANK, 1);
            EvioEvent ev = eb.getEvent();
            EvioBank ibanks = new EvioBank(3, DataType.CHARSTAR8, 3);
            ibanks.appendStringData("string 1");
            eb.addChild(ev, ibanks);
            eb.setAllHeaderLengths();
            String file = "/tmp/out.ev";
            EventWriter eventWriter = new EventWriter(new File(file));
            eventWriter.writeEvent(ev);
            eventWriter.close();
            System.out.println("Read in from file & print");
            EvioReader fReader = new EvioReader(file);
            EvioEvent evR = fReader.parseNextEvent();
            EvioBank bank = (EvioBank)evR.getChildAt(0);
            for (String i : sData = bank.getStringData()) {
                System.out.println("" + i);
            }
            System.out.println("Read in from file, add more, & print");
            fReader = new EvioReader(file);
            evR = fReader.parseNextEvent();
            bank = (EvioBank)evR.getChildAt(0);
            bank.appendStringData("string 2");
            bank.appendStringData("string 3");
            for (String i : sData = bank.getStringData()) {
                System.out.println("" + i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }
}

