/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.List;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class CompositeTester {
    public static void main0(String[] args) {
        int fi;
        int[] bank = new int[24];
        bank[0] = 23;
        bank[1] = 397059;
        bank[2] = 5439492;
        bank[3] = 1311263020;
        bank[4] = 1143752236;
        bank[5] = 844311608;
        bank[6] = 1630076932;
        bank[7] = 16;
        bank[8] = 397057;
        bank[9] = 2;
        bank[10] = 4369;
        double d = -3.141592653589793E-100;
        long dl = Double.doubleToLongBits(d);
        bank[11] = (int)(dl >>> 32);
        bank[12] = (int)dl;
        float f = -3.1415926E-24f;
        bank[13] = fi = Float.floatToIntBits(f);
        bank[14] = 287454020;
        bank[15] = 1212743752;
        bank[16] = 0x4F000404;
        for (int i = 0; i < 7; ++i) {
            bank[17 + i] = bank[10 + i];
        }
        int[] allData = new int[22];
        for (int i = 0; i < 22; ++i) {
            allData[i] = bank[i + 2];
        }
        String format = "N(I,D,F,2S,8a)";
        try {
            String[] strs;
            int i;
            byte[] byteArray = ByteDataTransformer.toBytes(allData, ByteOrder.BIG_ENDIAN);
            ByteBuffer buf = ByteBuffer.wrap(byteArray);
            buf.order(ByteOrder.BIG_ENDIAN);
            System.out.println("Call CompositeData.swapAll()");
            CompositeData.swapAll(byteArray, 0, null, 0, allData.length, ByteOrder.BIG_ENDIAN);
            System.out.println("SWAPPED DATA:");
            IntBuffer iBuf = buf.asIntBuffer();
            for (i = 0; i < allData.length; ++i) {
                System.out.println("     0x" + Integer.toHexString(iBuf.get(i)));
            }
            System.out.println();
            System.out.println("Call CompositeData.swapAll()");
            CompositeData.swapAll(byteArray, 0, null, 0, allData.length, ByteOrder.LITTLE_ENDIAN);
            System.out.println("DOUBLE SWAPPED DATA:");
            for (i = 0; i < allData.length; ++i) {
                System.out.println("     0x" + Integer.toHexString(iBuf.get(i)));
            }
            System.out.println();
            CompositeData cData = new CompositeData(byteArray, ByteOrder.BIG_ENDIAN);
            CompositeTester.printCompositeDataObject(cData);
            cData.index(0);
            System.out.println("\nInt    = 0x" + Integer.toHexString(cData.getInt()));
            System.out.println("Double = " + cData.getDouble());
            System.out.println("Float  = " + cData.getFloat());
            System.out.println("Short  = 0x" + Integer.toHexString(cData.getShort().shortValue()));
            System.out.println("Short  = 0x" + Integer.toHexString(cData.getShort().shortValue()));
            for (String s : strs = cData.getStrings()) {
                System.out.println("String = " + s);
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        String myString = "string";
        String stringFormat = CompositeData.stringsToFormat(new String[]{myString});
        String format = "I," + stringFormat;
        System.out.println("format = " + format);
        CompositeData.Data myData = new CompositeData.Data();
        myData.addInt(2);
        myData.addString(myString);
        CompositeData cData = null;
        try {
            cData = new CompositeData(format, 1, myData, 0, 0);
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        CompositeTester.printCompositeDataObject(cData);
    }

    public static void main2(String[] args) {
        String format = "N(NS,F,D)";
        System.out.println("format = " + format);
        CompositeData.Data myData = new CompositeData.Data();
        myData.addN(2);
        myData.addN(3);
        myData.addShort(new short[]{1, 2, 3});
        myData.addFloat(1.0f);
        myData.addDouble(Math.PI);
        myData.addN(1);
        myData.addShort((short)4);
        myData.addFloat(2.0f);
        myData.addDouble(Math.PI * 2);
        CompositeData cData = null;
        try {
            cData = new CompositeData(format, 1, myData, 0, 0);
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        CompositeTester.printCompositeDataObject(cData);
        try {
            EvioEvent ev = new EvioEvent(0, DataType.COMPOSITE, 0);
            ev.appendCompositeData(new CompositeData[]{cData});
            String fileName = "./composite.dat";
            EventWriter writer = new EventWriter(fileName);
            writer.writeEvent(ev);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String format = "N(I,F)";
        System.out.println("format = " + format);
        CompositeData.Data myData1 = new CompositeData.Data();
        myData1.addN(1);
        myData1.addInt(1);
        myData1.addFloat(1.0f);
        CompositeData.Data myData2 = new CompositeData.Data();
        myData2.addN(1);
        myData2.addInt(2);
        myData2.addFloat(2.0f);
        CompositeData.Data myData3 = new CompositeData.Data();
        myData3.addN(1);
        myData3.addInt(3);
        myData3.addFloat(3.0f);
        System.out.println("Create composite data objects");
        CompositeData[] cData = new CompositeData[3];
        try {
            cData[0] = new CompositeData(format, 1, myData1, 1, 1);
            cData[1] = new CompositeData(format, 2, myData2, 2, 2);
            cData[2] = new CompositeData(format, 3, myData3, 3, 3);
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Print composite data objects");
        CompositeTester.printCompositeDataObject(cData[0]);
        CompositeTester.printCompositeDataObject(cData[1]);
        CompositeTester.printCompositeDataObject(cData[2]);
        try {
            EvioEvent ev = new EvioEvent(0, DataType.COMPOSITE, 0);
            ev.appendCompositeData(cData);
            String fileName = "./composite.dat";
            System.out.println("WRITE FILE:");
            EventWriter writer = new EventWriter(fileName);
            writer.writeEvent(ev);
            writer.close();
            System.out.println("READ FILE & PRINT CONTENTS:");
            EvioReader reader = new EvioReader(fileName);
            EvioEvent evR = reader.parseNextEvent();
            BaseStructureHeader h = evR.getHeader();
            System.out.println("event: tag = " + h.getTag() + ", type = " + h.getDataTypeName() + ", len = " + h.getLength());
            if (evR != null) {
                CompositeData[] cDataR;
                for (CompositeData cd : cDataR = evR.getCompositeData()) {
                    CompositeTester.printCompositeDataObject(cd);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main4(String[] args) {
        String fileName = "/daqfs/home/timmer/coda/evio-4.0.sergey/Linux-x86_64/bin/sample.dat";
        File fileIn = new File(fileName);
        System.out.println("read ev file: " + fileName + " size: " + fileIn.length());
        try {
            EvioEvent ev;
            EvioReader evioReader = new EvioReader(fileName);
            while ((ev = evioReader.parseNextEvent()) != null) {
                System.out.println("EVENT:\n" + ev.toXML());
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printCompositeDataObject(CompositeData cData) {
        List<Object> items = cData.getItems();
        List<DataType> types = cData.getTypes();
        int len = items.size();
        block9: for (int i = 0; i < len; ++i) {
            DataType type = types.get(i);
            System.out.print(String.format("type = %9s, val = ", new Object[]{type}));
            switch (type) {
                case NVALUE: 
                case INT32: 
                case UINT32: 
                case UNKNOWN32: {
                    int j = (Integer)items.get(i);
                    System.out.println("0x" + Integer.toHexString(j));
                    continue block9;
                }
                case LONG64: 
                case ULONG64: {
                    long l = (Long)items.get(i);
                    System.out.println("0x" + Long.toHexString(l));
                    continue block9;
                }
                case SHORT16: 
                case USHORT16: {
                    short s = (Short)items.get(i);
                    System.out.println("0x" + Integer.toHexString(s));
                    continue block9;
                }
                case CHAR8: 
                case UCHAR8: {
                    byte b = (Byte)items.get(i);
                    System.out.println("0x" + Integer.toHexString(b));
                    continue block9;
                }
                case FLOAT32: {
                    float ff = ((Float)items.get(i)).floatValue();
                    System.out.println("" + ff);
                    continue block9;
                }
                case DOUBLE64: {
                    double dd = (Double)items.get(i);
                    System.out.println("" + dd);
                    continue block9;
                }
                case CHARSTAR8: {
                    String[] strs;
                    for (String ss : strs = (String[])items.get(i)) {
                        System.out.print(ss + ", ");
                    }
                    System.out.println();
                    continue block9;
                }
            }
        }
    }
}

