/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;

public class cMsgHandler {
    private cMsg cmsg;
    private String udl;
    private String subject;
    private String type;
    private cMsgSubscriptionHandle handle;
    private myCallback callback = new myCallback();
    private BlockingQueue<EvioEvent> eventQueue = new LinkedBlockingQueue<EvioEvent>(1000);
    private cMsgMessage lastRetrievedMessage;
    private String lastDictionaryLoaded;
    private static cMsgHandler handler = new cMsgHandler();

    public static cMsgHandler getInstance() {
        return handler;
    }

    private cMsgHandler() {
    }

    public String getSubject() {
        return this.subject;
    }

    public String getType() {
        return this.type;
    }

    public void disconnect() {
        if (this.cmsg == null || !this.cmsg.isConnected()) {
            return;
        }
        try {
            this.cmsg.disconnect();
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.handle = null;
        this.subject = null;
        this.type = null;
    }

    public void connect(String udl) throws cMsgException {
        String descr;
        String name;
        if (this.cmsg == null) {
            name = "evioViewer_" + System.currentTimeMillis();
            descr = "evio event viewer";
            this.cmsg = new cMsg(udl, name, descr);
            this.udl = udl;
        }
        if (this.cmsg.isConnected()) {
            if (udl.equals(this.udl)) {
                return;
            }
            this.cmsg.disconnect();
        }
        if (!udl.equals(this.udl)) {
            name = "evioViewer_" + System.currentTimeMillis();
            descr = "evio event viewer";
            this.cmsg = new cMsg(udl, name, descr);
            this.udl = udl;
        }
        this.cmsg.connect();
        this.cmsg.start();
        this.subject = null;
        this.type = null;
    }

    public boolean subscribe(String subject, String type) throws cMsgException {
        if (this.cmsg == null || !this.cmsg.isConnected() || subject == null || type == null || subject.length() < 1 || type.length() < 1) {
            this.handle = null;
            return false;
        }
        if (subject.equals(this.subject) && type.equals(this.type)) {
            return true;
        }
        if (this.handle != null) {
            try {
                this.cmsg.unsubscribe(this.handle);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        this.handle = this.cmsg.subscribe(subject, type, (cMsgCallbackInterface)this.callback, null);
        this.subject = subject;
        this.type = type;
        return true;
    }

    private void extractEvents(cMsgMessage msg) {
        try {
            EvioEvent ev;
            ByteBuffer buf = ByteBuffer.wrap(msg.getByteArray());
            EvioReader reader = new EvioReader(buf);
            String dictionary = reader.getDictionaryXML();
            while ((ev = reader.parseNextEvent()) != null) {
                ev.setDictionaryXML(dictionary);
                this.eventQueue.offer(ev);
            }
        }
        catch (IOException e) {
        }
        catch (EvioException evioException) {
            // empty catch block
        }
    }

    public EvioEvent getNextEvent() {
        try {
            return this.eventQueue.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void clearQueue() {
        this.eventQueue.clear();
    }

    public void clearQueue(int numberToDelete) {
        if (numberToDelete <= this.eventQueue.size()) {
            for (int i = 0; i < numberToDelete; ++i) {
                this.eventQueue.poll();
            }
            return;
        }
        this.eventQueue.clear();
    }

    public int getQueueSize() {
        return this.eventQueue.size();
    }

    public String getDictionaryString() {
        return this.lastDictionaryLoaded;
    }

    public boolean setDictionary() {
        return this.setDictionary(this.lastRetrievedMessage);
    }

    public boolean setDictionary(cMsgMessage msg) {
        if (msg == null) {
            return false;
        }
        cMsgPayloadItem payloadItem = msg.getPayloadItem("dictionary");
        if (payloadItem == null) {
            return false;
        }
        try {
            String dictionary = payloadItem.getString();
            NameProvider.setProvider(NameProviderFactory.createNameProvider(dictionary));
            this.lastDictionaryLoaded = dictionary;
            return true;
        }
        catch (cMsgException cMsgException2) {
            return false;
        }
    }

    public ByteOrder getByteOrder() {
        return this.getByteOrder(this.lastRetrievedMessage);
    }

    public ByteOrder getByteOrder(cMsgMessage msg) {
        int endian = msg.getByteArrayEndian();
        if (endian == 1) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    private class myCallback
    extends cMsgCallbackAdapter {
        private myCallback() {
        }

        public void callback(cMsgMessage msg, Object userObject) {
            byte[] data = msg.getByteArray();
            if (data == null) {
                return;
            }
            cMsgHandler.this.extractEvents(msg);
        }
    }
}

