/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.SegmentHeader;
import org.jlab.coda.jevio.TagSegmentHeader;

public class StructureTransformer {
    public static EvioBank transform(EvioSegment segment, int num) {
        BaseStructureHeader header = segment.getHeader();
        DataType type = header.getDataType();
        BankHeader bankHeader = new BankHeader(header.getTag(), type, num);
        bankHeader.setLength(header.getLength() + 1);
        bankHeader.setPadding(header.getPadding());
        EvioBank bank = new EvioBank(bankHeader);
        bank.transform(segment);
        return bank;
    }

    public static EvioBank transform(EvioTagSegment tagsegment, int num) {
        BaseStructureHeader header = tagsegment.getHeader();
        DataType type = header.getDataType();
        BankHeader bankHeader = new BankHeader(header.getTag(), type, num);
        bankHeader.setLength(header.getLength() + 1);
        bankHeader.setPadding(header.getPadding());
        EvioBank bank = new EvioBank(bankHeader);
        bank.transform(tagsegment);
        return bank;
    }

    public static EvioTagSegment transform(EvioSegment segment) {
        BaseStructureHeader segHeader = segment.getHeader();
        DataType type = segHeader.getDataType();
        DataType segType = type;
        if (segType == DataType.ALSOBANK) {
            type = DataType.BANK;
        } else if (segType == DataType.ALSOSEGMENT) {
            type = DataType.SEGMENT;
        }
        TagSegmentHeader tagsegHeader = new TagSegmentHeader(segHeader.getTag(), type);
        tagsegHeader.setLength(segHeader.getLength());
        EvioTagSegment tagseg = new EvioTagSegment(tagsegHeader);
        tagseg.transform(segment);
        return tagseg;
    }

    public static EvioSegment transform(EvioTagSegment tagsegment) {
        BaseStructureHeader tagsegHeader = tagsegment.getHeader();
        DataType type = tagsegHeader.getDataType();
        SegmentHeader segHeader = new SegmentHeader(tagsegHeader.getTag(), type);
        segHeader.setLength(tagsegHeader.getLength());
        segHeader.setPadding(tagsegHeader.getPadding());
        EvioSegment seg = new EvioSegment(segHeader);
        seg.transform(tagsegment);
        return seg;
    }

    public static EvioSegment transform(EvioBank bank) throws EvioException {
        BaseStructureHeader header = bank.getHeader();
        if (header.getLength() > 65535) {
            throw new EvioException("Bank is too long to transform into segment");
        }
        DataType type = header.getDataType();
        SegmentHeader segHeader = new SegmentHeader(bank.getHeader().getTag(), type);
        segHeader.setLength(header.getLength() - 1);
        segHeader.setPadding(header.getPadding());
        EvioSegment seg = new EvioSegment(segHeader);
        seg.transform(bank);
        return seg;
    }

    public static EvioTagSegment transform(EvioBank bank, int dummy) throws EvioException {
        BaseStructureHeader header = bank.getHeader();
        if (header.getLength() > 65535) {
            throw new EvioException("Bank is too long to transform into tagsegment");
        }
        DataType type = header.getDataType();
        DataType bankType = type;
        if (bankType == DataType.ALSOBANK) {
            type = DataType.BANK;
        } else if (bankType == DataType.ALSOSEGMENT) {
            type = DataType.SEGMENT;
        }
        TagSegmentHeader tagsegHeader = new TagSegmentHeader(bank.getHeader().getTag(), type);
        tagsegHeader.setLength(header.getLength() - 1);
        tagsegHeader.setPadding(header.getPadding());
        EvioTagSegment tagseg = new EvioTagSegment(tagsegHeader);
        tagseg.transform(bank);
        return tagseg;
    }
}

