/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioXMLDictionary;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.StructureFinder;
import org.jlab.coda.jevio.StructureTransformer;
import org.jlab.coda.jevio.StructureType;

public class FileTest {
    static int[] data1 = new int[]{20, 1, 10, 2, 0, 4, 0, -1059454720, 3, 2, 4, 65793, 1, 1, 1, 4, 65793, 2, 2, 2, 25, 2, 10, 3, 0, 4, 0, -1059454720, 1, 2, 4, 65793, 3, 3, 3, 4, 65793, 4, 4, 4, 4, 65793, 5, 5, 5, 9, 3, 9, 0, 0, 516, 0, -1059454720, 3};

    public static void main11(String[] args) {
        String fileName = "/daqfs/home/timmer/coda/jevio-4.0/testdata/speedTest.ev";
        File file = new File(fileName);
        byte[] byteData1 = new byte[499990];
        int count = 0;
        long t1 = 0L;
        long t2 = 0L;
        long totalT = 0L;
        long totalCount = 0L;
        try {
            EventWriter eventWriter = new EventWriter(file, 1000000, 2, ByteOrder.BIG_ENDIAN, null, null);
            EventBuilder eventBuilder = new EventBuilder(1, DataType.CHAR8, 1);
            EvioEvent ev = eventBuilder.getEvent();
            ev.appendByteData(byteData1);
            t1 = System.currentTimeMillis();
            for (int j = 0; j < 10; ++j) {
                for (int i = 0; i < 2; ++i) {
                    eventWriter.writeEvent(ev);
                    ++count;
                }
            }
            eventWriter.close();
            t2 = System.currentTimeMillis();
            long time = t2 - t1;
            double rate = 1000.0 * (double)count / (double)time;
            double avgRate = 1000.0 * (double)(totalCount += (long)count) / (double)(totalT += time);
            System.out.println("rate = " + String.format("%.3g", rate) + " Hz,  avg = " + String.format("%.3g", avgRate));
            System.out.println("time = " + time + " milliseconds");
            count = 0;
            t1 = System.currentTimeMillis();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main12(String[] args) {
        String fileName = "/daqfs/home/timmer/coda/jevio-4.0/testdata/fileTest.ev";
        File file = new File(fileName);
        ByteBuffer myBuf = null;
        String xmlDictionary = "<xmlDict>\n  <bank name=\"bank of banks\"          tag=\"1\"   num=\"1\">\n     <bank name=\"bank of segments\"    tag=\"2\"   num=\"2\">\n       <leaf name=\"segment of shorts\" tag=\"3\"   />\n     </bank>\n     <bank name=\"bank of banks\"       tag=\"4\"   num=\"4\">\n       <leaf name=\"bank of chars\"     tag=\"5\"   num=\"5\"/>\n     </bank>\n  </bank>\n  <dictEntry name=\"last bank\"        tag=\"33\"  num=\"66\"/>\n</xmlDict>";
        byte[] byteData1 = new byte[]{1, 2, 3, 4, 5};
        int[] intData1 = new int[]{4, 5, 6};
        int[] intData2 = new int[]{7, 8, 9};
        short[] shortData = new short[]{11, 22, 33};
        boolean append = false;
        boolean useFile = true;
        EvioEvent event = null;
        try {
            EventWriter writer;
            if (useFile) {
                writer = new EventWriter(file, xmlDictionary, append);
            } else {
                myBuf = ByteBuffer.allocate(10000);
                myBuf.order(ByteOrder.LITTLE_ENDIAN);
                writer = new EventWriter(myBuf, xmlDictionary, append);
            }
            EventBuilder builder = new EventBuilder(1, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankSegs = new EvioBank(2, DataType.SEGMENT, 2);
            builder.addChild(event, bankSegs);
            EvioSegment segShorts = new EvioSegment(3, DataType.SHORT16);
            segShorts.appendShortData(shortData);
            builder.addChild(bankSegs, segShorts);
            EvioBank bankBanks = new EvioBank(4, DataType.BANK, 4);
            builder.addChild(event, bankBanks);
            EvioBank charBank = new EvioBank(5, DataType.CHAR8, 5);
            charBank.appendByteData(byteData1);
            builder.addChild(bankBanks, charBank);
            writer.writeEvent(event);
            if (!useFile) {
                System.out.println("Buffer has " + myBuf.remaining() + " bytes left");
            }
            EvioEvent lastEvent = new EvioEvent(33, DataType.INT32, 66);
            lastEvent.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            lastEvent.appendIntData(intData1);
            lastEvent.setIntData(intData2);
            lastEvent.appendIntData(intData2);
            writer.writeEvent(lastEvent);
            writer.close();
            EvioBank segBank1 = StructureTransformer.transform(segShorts, 10);
            StructureTransformer T = new StructureTransformer();
            EvioBank segBank2 = StructureTransformer.transform(segShorts, 10);
            EvioXMLDictionary dict = new EvioXMLDictionary(xmlDictionary);
            NameProvider.setProvider(dict);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        try {
            EvioReader evioReader;
            if (useFile) {
                System.out.println("read ev file: " + fileName + ", size: " + file.length());
                evioReader = new EvioReader(fileName);
            } else {
                myBuf.flip();
                evioReader = new EvioReader(myBuf);
            }
            EventParser parser = evioReader.getParser();
            IEvioListener listener = new IEvioListener(){

                @Override
                public void gotStructure(BaseStructure topStructure, IEvioStructure structure) {
                    System.out.println("Parsed structure of type " + (Object)((Object)structure.getStructureType()));
                }

                @Override
                public void startEventParse(BaseStructure structure) {
                    System.out.println("Starting event parse");
                }

                @Override
                public void endEventParse(BaseStructure structure) {
                    System.out.println("Ended event parse");
                }
            };
            parser.addEvioListener(listener);
            String xmlDictString = evioReader.getDictionaryXML();
            EvioXMLDictionary dictionary = null;
            if (xmlDictString == null) {
                System.out.println("Ain't got no dictionary!");
            } else {
                dictionary = new EvioXMLDictionary(xmlDictString);
                System.out.println("Got a dictionary:\n" + dictionary.toString());
            }
            int evCount = evioReader.getEventCount();
            System.out.println("Read file, got " + evCount + " events:\n");
            EvioEvent ev = evioReader.parseEvent(evCount);
            System.out.println("Last event = " + ev.toString());
            ev.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            int[] intData = ev.getIntData();
            if (intData != null) {
                for (int i = 0; i < intData.length; ++i) {
                    System.out.println("intData[" + i + "] = " + intData[i]);
                }
            }
            if (dictionary != null) {
                String eventName = dictionary.getName(ev);
                System.out.println("Name of last event = " + eventName);
            }
            while ((ev = evioReader.parseNextEvent()) != null) {
                System.out.println("Event = " + ev.toString());
            }
            evioReader.rewind();
            int tag = 1;
            int num = 1;
            ev = evioReader.parseNextEvent();
            List<BaseStructure> list = StructureFinder.getMatchingBanks(ev, tag, num);
            System.out.println("Event = " + ev.toString());
            for (BaseStructure s : list) {
                System.out.println("Evio structure named \"" + dictionary.getName(s) + "\" has tag=1 & num=1");
            }
            class MyEvioFilter
            implements IEvioFilter {
                MyEvioFilter() {
                }

                @Override
                public boolean accept(StructureType structureType, IEvioStructure struct) {
                    return structureType == StructureType.SEGMENT && struct.getHeader().getTag() % 2 == 1;
                }
            }
            MyEvioFilter filter = new MyEvioFilter();
            list = StructureFinder.getMatchingStructures((BaseStructure)event, filter);
            if (list != null) {
                System.out.println("list size = " + list.size());
                for (BaseStructure s : list) {
                    System.out.println("Evio structure named " + dictionary.getName(s) + " is a segment with an odd numbered tag");
                }
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main9(String[] args) {
        String fileName = "../../testdata/BigOut2.ev";
        File file = new File(fileName);
        ByteBuffer myBuf = ByteBuffer.allocate(800);
        String dictionary = "<xmlDict>\n  <xmldumpDictEntry name=\"bank\"           tag=\"1\"   num=\"1\"/>\n  <xmldumpDictEntry name=\"bank of shorts\" tag=\"2\"   num=\"1.2\"/>\n  <xmldumpDictEntry name=\"shorts pad0\"    tag=\"3\"   num=\"1.2.3\"/>\n  <xmldumpDictEntry name=\"shorts pad2\"    tag=\"4\"   num=\"1.2.4\"/>\n  <xmldumpDictEntry name=\"bank of chars\"  tag=\"5\"   num=\"5\"/>\n</xmlDict>";
        short[] shortData1 = new short[]{11, 22};
        short[] shortData2 = new short[]{11, 22, 33};
        BaseStructure event = null;
        try {
            EventWriter eventWriterNew = new EventWriter(file, 1000, 3, ByteOrder.BIG_ENDIAN, dictionary, null);
            EventBuilder eventBuilder2 = new EventBuilder(1, DataType.BANK, 1);
            event = eventBuilder2.getEvent();
            EvioBank bankBanks = new EvioBank(2, DataType.BANK, 2);
            EvioBank shortBank1 = new EvioBank(3, DataType.SHORT16, 3);
            shortBank1.appendShortData(shortData1);
            eventBuilder2.addChild(bankBanks, shortBank1);
            EvioBank shortBank2 = new EvioBank(3, DataType.SHORT16, 3);
            shortBank2.appendShortData(shortData2);
            eventBuilder2.addChild(bankBanks, shortBank2);
            eventBuilder2.addChild(event, bankBanks);
            eventWriterNew.writeEvent((EvioBank)event);
            eventWriterNew.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        System.out.println("Event = \n" + event.toXML());
        File fileIn = new File(fileName);
        System.out.println("read ev file: " + fileName + " size: " + fileIn.length());
        try {
            EvioReader fileReader = new EvioReader(fileName);
            System.out.println("\nnum ev = " + fileReader.getEventCount());
            System.out.println("dictionary = " + fileReader.getDictionaryXML() + "\n");
            event = fileReader.parseNextEvent();
            if (event == null) {
                System.out.println("We got a NULL event !!!");
                return;
            }
            System.out.println("Event = \n" + event.toXML());
            while ((event = fileReader.parseNextEvent()) != null) {
                System.out.println("Event = " + ((EvioEvent)event).toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String fileName = "/local/scratch/LittleFile.ev";
        File file = new File(fileName);
        System.out.println("\nTRY READING");
        File fileIn = new File(fileName);
        System.out.println("read ev file: " + fileName + " size: " + fileIn.length());
        try {
            EvioReader fileReader = new EvioReader(fileName);
            int evCount = fileReader.getEventCount();
            System.out.println("\nnum ev = " + evCount);
            System.out.println("dictionary = " + fileReader.getDictionaryXML() + "\n");
            long t1 = System.currentTimeMillis();
            EvioEvent event = fileReader.getEvent(290);
            System.out.println("Got 290th event");
            int counter = 0;
            while ((event = fileReader.parseNextEvent()) != null) {
                if (event == null) {
                    System.out.println("We got a NULL event !!!");
                    return;
                }
                System.out.println("Event #" + counter++ + " =\n" + event);
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Sequential Time = " + (t2 - t1) + " milliseconds");
            fileReader.rewind();
            t1 = System.currentTimeMillis();
            for (int i = 1; i <= evCount; ++i) {
                event = fileReader.getEvent(i);
                if (event != null) continue;
                System.out.println("We got a NULL event !!!");
                return;
            }
            t2 = System.currentTimeMillis();
            System.out.println("Random access Time = " + (t2 - t1) + " milliseconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        System.out.println("DONE READING");
    }
}

