/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jlab.coda.jevio.graphics.NamedLabel;

public class EventInfoPanel
extends JPanel {
    private NamedLabel eventSourceLabel;
    private NamedLabel dictionaryLabel;
    private NamedLabel numEventsLabel;
    private NamedLabel eventNumberLabel;

    public EventInfoPanel() {
        this.setLayout(new GridLayout(2, 1, 0, 3));
        this.setBorder(new EmptyBorder(5, 200, 5, 0));
        this.eventSourceLabel = new NamedLabel("event source", "event_source", 430);
        this.dictionaryLabel = new NamedLabel("dictionary", "event_source", 430);
        this.eventNumberLabel = new NamedLabel("event#", "num_events", 150);
        this.numEventsLabel = new NamedLabel("num events", "num_events", 150);
        Dimension d1 = this.eventSourceLabel.getPreferredSize();
        Dimension d2 = this.eventNumberLabel.getPreferredSize();
        this.eventSourceLabel.setMaximumSize(d1);
        this.dictionaryLabel.setMaximumSize(d1);
        this.eventNumberLabel.setMaximumSize(d2);
        this.numEventsLabel.setMaximumSize(d2);
        JPanel p0 = new JPanel();
        p0.setLayout(new BoxLayout(p0, 0));
        p0.add(this.eventSourceLabel);
        p0.add(Box.createRigidArea(new Dimension(5, 0)));
        p0.add(this.eventNumberLabel);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.add(this.dictionaryLabel);
        p1.add(Box.createRigidArea(new Dimension(5, 0)));
        p1.add(this.numEventsLabel);
        this.add(p0);
        this.add(p1);
    }

    public void setDisplay(String source, int eventNumber, int numberOfEvents, String dictionary) {
        if (source != null) {
            this.eventSourceLabel.setText(source);
        }
        if (dictionary != null) {
            this.dictionaryLabel.setText(dictionary);
        }
        this.eventNumberLabel.setText("" + eventNumber);
        this.numEventsLabel.setText("" + numberOfEvents);
    }

    public void setDisplay(String source, int numberOfEvents) {
        if (source != null) {
            this.eventSourceLabel.setText(source);
        }
        this.numEventsLabel.setText("" + numberOfEvents);
    }

    public void setDictionary(String dictionary) {
        if (dictionary != null) {
            this.dictionaryLabel.setText(dictionary);
        }
    }

    public String getDictionary() {
        return this.dictionaryLabel.getText();
    }

    public void setSource(String source) {
        if (source != null) {
            this.eventSourceLabel.setText(source);
        }
    }

    public String getSource() {
        return this.eventSourceLabel.getText();
    }

    public void setEventNumber(int eventNumber) {
        if (eventNumber > -1) {
            this.eventNumberLabel.setText("" + eventNumber);
        }
    }

    public int getEventNumber() {
        return Integer.parseInt(this.eventNumberLabel.getText());
    }

    public void setNumberOfEvents(int numberOfEvents) {
        if (numberOfEvents > -1) {
            this.numEventsLabel.setText("" + numberOfEvents);
        }
    }

    public int getNumberOfEvents() {
        return Integer.parseInt(this.numEventsLabel.getText());
    }
}

