/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class EvioFileTest {
    public static int totalBlockCount(EvioReader reader) {
        reader.rewind();
        EvioReader.ReadStatus status = EvioReader.ReadStatus.SUCCESS;
        int count = 0;
        while (status == EvioReader.ReadStatus.SUCCESS) {
            status = reader.nextBlockHeader();
            if (status != EvioReader.ReadStatus.SUCCESS) continue;
            reader.position(reader.getCurrentBlockHeader().nextBufferStartingPosition());
            ++count;
        }
        System.out.println("total block count: " + count);
        reader.rewind();
        return count;
    }

    public static TestResult readAllBlockHeadersTest(EvioReader reader) {
        TestResult result;
        reader.rewind();
        EvioReader.ReadStatus status = EvioReader.ReadStatus.SUCCESS;
        int blockCount = 0;
        while (status == EvioReader.ReadStatus.SUCCESS) {
            status = reader.nextBlockHeader();
            if (status != EvioReader.ReadStatus.SUCCESS) continue;
            reader.position(reader.getCurrentBlockHeader().nextBufferStartingPosition());
            ++blockCount;
        }
        if (status == EvioReader.ReadStatus.END_OF_FILE) {
            System.out.println("Total blocks read: " + blockCount);
            result = TestResult.PASS;
        } else {
            result = TestResult.FAIL;
        }
        System.out.println("readAllBlockHeadersTest: " + (Object)((Object)result));
        reader.rewind();
        return result;
    }

    public static TestResult readAllEventsTest(EvioReader reader) {
        int oldPosition = reader.position();
        reader.rewind();
        int count = 0;
        TestResult result = TestResult.PASS;
        try {
            EvioEvent event;
            while ((event = reader.nextEvent()) != null) {
                BaseStructureHeader header = event.getHeader();
                System.out.println(++count + ")  size: " + header.getLength() + " type: " + header.getDataTypeName() + " \"" + event.getDescription() + "\"");
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
            result = TestResult.FAIL;
        }
        System.out.println("readAllBlockHeadersTest: " + (Object)((Object)result));
        reader.position(oldPosition);
        return result;
    }

    public static TestResult parseEventsTest(EvioReader reader, int num) {
        int count;
        int oldPosition = reader.position();
        if (num < 0) {
            num = Integer.MAX_VALUE;
        }
        reader.rewind();
        TestResult result = TestResult.PASS;
        try {
            EvioEvent event;
            for (count = 0; count < num && (event = reader.nextEvent()) != null; ++count) {
                reader.parseEvent(event);
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
            result = TestResult.FAIL;
        }
        System.out.println("parseEventsTest parsed: " + count + " events");
        System.out.println("parseEventsTest result: " + (Object)((Object)result));
        reader.position(oldPosition);
        return result;
    }

    public static enum TestResult {
        PASS,
        FAIL;

    }
}

