/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.swing.tree.DefaultTreeModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;

public class EvioEvent
extends EvioBank {
    public static final String ELEMENT_NAME = "event";
    protected DefaultTreeModel treeModel;
    private int eventNumber;
    private String dictionaryXML;

    public EvioEvent() {
    }

    public EvioEvent(BankHeader bankHeader) {
        super(bankHeader);
    }

    public EvioEvent(int tag, DataType dataType, int num) {
        this(new BankHeader(tag, dataType, num));
    }

    @Override
    public Object clone() {
        EvioEvent ev = (EvioEvent)super.clone();
        this.treeModel = null;
        return ev;
    }

    public boolean hasDictionaryXML() {
        return this.dictionaryXML != null;
    }

    public String getDictionaryXML() {
        return this.dictionaryXML;
    }

    public void setDictionaryXML(String dictionaryXML) {
        this.dictionaryXML = dictionaryXML;
    }

    @Override
    public String toString() {
        String description = this.getDescription();
        if ("???".equals(description)) {
            description = null;
        }
        String s = "<Event>  len (ints): " + this.header.length + " " + " tag: " + this.header.tag + " num: " + this.header.number;
        if (this.header.dataType.isStructure()) {
            s = s + " content: " + this.xmlContentAttributeName;
        }
        if (description != null) {
            s = s + " [" + description + "]";
        }
        return s;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void insert(BaseStructure child, BaseStructure parent) {
        this.treeModel.insertNodeInto(child, parent, parent.getChildCount());
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public void setEventNumber(int eventNumber) {
        this.eventNumber = eventNumber;
    }

    @Override
    public void toXML(XMLStreamWriter xmlWriter) {
        try {
            int totalLen = this.header.length + 1;
            this.increaseXmlIndent();
            xmlWriter.writeCharacters(this.xmlIndent);
            xmlWriter.writeComment(" Buffer " + this.getEventNumber() + " contains " + totalLen + " words (" + 4 * totalLen + " bytes)");
            this.commonXMLStart(xmlWriter);
            xmlWriter.writeAttribute("format", "evio");
            xmlWriter.writeAttribute("count", "" + this.getEventNumber());
            if (this.header.dataType.isStructure()) {
                xmlWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xmlWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType.getValue()));
            xmlWriter.writeAttribute("tag", "" + this.header.tag);
            xmlWriter.writeAttribute("num", "" + this.header.number);
            xmlWriter.writeAttribute("length", "" + this.header.length);
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xmlWriter);
            this.decreaseXmlIndent();
            this.commonXMLClose(xmlWriter);
            xmlWriter.writeCharacters("\n");
            this.decreaseXmlIndent();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }
}

