/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;

public final class BankHeader
extends BaseStructureHeader {
    public BankHeader() {
    }

    public BankHeader(int tag, DataType dataType, int num) {
        super(tag, dataType, num);
    }

    @Override
    public int getHeaderLength() {
        return 2;
    }

    @Override
    protected void toArray(byte[] bArray, int offset, ByteOrder order) {
        try {
            ByteDataTransformer.toBytes(this.length, order, bArray, offset);
            if (order == ByteOrder.BIG_ENDIAN) {
                ByteDataTransformer.toBytes((short)this.tag, order, bArray, offset + 4);
                bArray[offset + 6] = (byte)(this.dataType.getValue() & 0x3F | this.padding << 6);
                bArray[offset + 7] = (byte)this.number;
            } else {
                bArray[offset + 4] = (byte)this.number;
                bArray[offset + 5] = (byte)(this.dataType.getValue() & 0x3F | this.padding << 6);
                ByteDataTransformer.toBytes((short)this.tag, order, bArray, offset + 6);
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(String.format("bank length: %d\n", this.length));
        sb.append(String.format("number:      %d\n", this.number));
        sb.append(String.format("data type:   %s\n", this.getDataTypeName()));
        sb.append(String.format("tag:         %d\n", this.tag));
        sb.append(String.format("padding:     %d\n", this.padding));
        return sb.toString();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.length);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.putShort((short)this.tag);
            byteBuffer.put((byte)(this.dataType.getValue() & 0x3F | this.padding << 6));
            byteBuffer.put((byte)this.number);
        } else {
            byteBuffer.put((byte)this.number);
            byteBuffer.put((byte)(this.dataType.getValue() & 0x3F | this.padding << 6));
            byteBuffer.putShort((short)this.tag);
        }
        return 8;
    }
}

