/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class BufferTest {
    static int[] data1 = new int[]{20, 1, 10, 2, 0, 4, 0, -1059454720, 3, 2, 4, 65793, 1, 1, 1, 4, 65793, 2, 2, 2, 25, 2, 10, 3, 0, 4, 0, -1059454720, 1, 2, 4, 65793, 3, 3, 3, 4, 65793, 4, 4, 4, 4, 65793, 5, 5, 5, 9, 3, 9, 0, 0, 516, 0, -1059454720, 3};
    static int[] data2 = new int[]{13, 1, 8, 1, 0, 516, 0, -1059454720, 4, 65793, 1, 1, 1};
    static int[] data3 = new int[]{9, 1, 9, 0, 0, 516, 0, -1059454720, 4};
    static int[] data4 = new int[]{9, 1, 9, 0, 0, 4, 0, -1059454720, 4, 9, 2, 9, 0, 0, 516, 0, -1059454720, 4};

    public static void main0(String[] args) {
        try {
            EvioEvent event;
            EventBuilder eb = new EventBuilder(1, DataType.INT32, 1);
            EvioEvent ev = eb.getEvent();
            int[] dat = new int[100];
            ev.appendIntData(dat);
            EventWriter evWriter = new EventWriter(ByteBuffer.allocate(32), 114, 20, null, null);
            evWriter.close();
            ByteBuffer buffer = ByteBuffer.allocate(600);
            buffer.clear();
            evWriter.setBuffer(buffer);
            evWriter.writeEvent(ev);
            EvioEvent ev2 = new EvioEvent(2, DataType.INT32, 2);
            int[] dat2 = new int[]{2, 2, 2, 2};
            ev2.appendIntData(dat2);
            evWriter.writeEvent(ev2);
            evWriter.close();
            buffer.flip();
            EvioReader reader = new EvioReader(buffer);
            long evCount = reader.getEventCount();
            System.out.println("Read buffer, got " + evCount + " number of events\n");
            while ((event = reader.parseNextEvent()) != null) {
                System.out.println("Event = " + event.toXML());
                System.out.println("\nevent count = " + reader.getEventCount() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        try {
            EventBuilder eb = new EventBuilder(1, DataType.DOUBLE64, 1);
            EvioEvent ev = eb.getEvent();
            double[] da = new double[]{1.0, 2.0, 3.0};
            ev.appendDoubleData(da);
            EventWriter evWriter = new EventWriter(ByteBuffer.allocate(32), 550000, 200, null, null);
            evWriter.close();
            ByteBuffer buffer = ByteBuffer.allocate(4000);
            for (int j = 0; j < 2; ++j) {
                EvioEvent event;
                buffer.clear();
                evWriter.setBuffer(buffer);
                evWriter.writeEvent(ev);
                evWriter.close();
                buffer.flip();
                EvioReader reader = new EvioReader(buffer);
                long evCount = reader.getEventCount();
                System.out.println("Read file, got " + evCount + " number of events\n");
                while ((event = reader.parseNextEvent()) != null) {
                    System.out.println("Event = " + event.toXML());
                    System.out.println("\nevent count = " + reader.getEventCount() + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        try {
            EventBuilder eventBuilder = new EventBuilder(1, DataType.INT32, 1);
            EvioEvent ev = eventBuilder.getEvent();
            ev.appendIntData(new int[]{4, 5, 6});
            byte[] be = ByteDataTransformer.toBytes(data2, ByteOrder.BIG_ENDIAN);
            byte[] bee = Arrays.copyOf(be, be.length + 400);
            ByteBuffer buf = ByteBuffer.wrap(bee);
            EventWriter writer = new EventWriter(buf, 1000000, 3, null, null, true);
            System.out.println("Main: writer blockNum = " + writer.getBlockNumber());
            writer.writeEvent(ev);
            writer.close();
            System.out.println("Main: (before flip) buf limit = " + buf.limit() + ", pos = " + buf.position() + ", cap = " + buf.capacity());
            buf.flip();
            System.out.println("Main: (after flip) buf limit = " + buf.limit() + ", pos = " + buf.position() + ", cap = " + buf.capacity());
            IntBuffer iBuf = buf.asIntBuffer();
            while (iBuf.hasRemaining()) {
                System.out.println("0x" + Integer.toHexString(iBuf.get()));
            }
            be = ByteDataTransformer.toBytes(data3, ByteOrder.BIG_ENDIAN);
            bee = Arrays.copyOf(be, be.length + 400);
            buf = ByteBuffer.wrap(bee);
            writer.setBuffer(buf);
            writer.writeEvent(ev);
            writer.close();
            System.out.println("Main: (before flip) buf limit = " + buf.limit() + ", pos = " + buf.position() + ", cap = " + buf.capacity());
            buf.flip();
            System.out.println("Main: (after flip) buf limit = " + buf.limit() + ", pos = " + buf.position() + ", cap = " + buf.capacity());
            iBuf = buf.asIntBuffer();
            while (iBuf.hasRemaining()) {
                System.out.println("0x" + Integer.toHexString(iBuf.get()));
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main3(String[] args) {
        String dictionary = "<xmlDict>\n  <xmldumpDictEntry name=\"bank of ints\"   tag=\"1\"   num=\"1\"/>\n</xmlDict>";
        try {
            EvioEvent event;
            byte[] be = ByteDataTransformer.toBytes(data1, ByteOrder.BIG_ENDIAN);
            byte[] bee = Arrays.copyOf(be, be.length + 400);
            ByteBuffer buf = ByteBuffer.wrap(bee);
            EventWriter writer = new EventWriter(buf, 1000000, 3, null, null, true);
            int eventsWritten = writer.getEventsWritten();
            System.out.println("Main: read buffer for writing, already contains " + eventsWritten + " events\n");
            int[] intData = new int[]{4, 5, 6};
            EventBuilder eventBuilder = new EventBuilder(1, DataType.INT32, 1);
            EvioEvent ev = eventBuilder.getEvent();
            ev.appendIntData(intData);
            System.out.println("Main: writer blockNum = " + writer.getBlockNumber());
            writer.writeEvent(ev);
            writer.close();
            System.out.println("Main: (before flip) buf limit = " + buf.limit() + ", pos = " + buf.position() + ", cap = " + buf.capacity());
            buf.flip();
            System.out.println("Main: (after flip) buf limit = " + buf.limit() + ", pos = " + buf.position() + ", cap = " + buf.capacity());
            EvioReader reader = new EvioReader(buf);
            long evCount = reader.getEventCount();
            String dict = reader.getDictionaryXML();
            if (dict == null) {
                System.out.println("Main: ain't got no dictionary!");
            } else {
                System.out.println("Main: dict-> \n" + dict);
            }
            System.out.println("Main: read file, got " + evCount + " number of events\n");
            while ((event = reader.parseNextEvent()) != null) {
                System.out.println("Main: event = " + event.toXML());
                System.out.println("\nMain: event count = " + reader.getEventCount() + "\n");
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            EvioEvent event;
            EventBuilder eb = new EventBuilder(1, DataType.CHAR8, 1);
            EvioEvent ev = eb.getEvent();
            byte[] da = new byte[]{1, 2, 3, 4, 5, 6, 7};
            ev.appendByteData(da);
            ByteBuffer buffer = ByteBuffer.allocate(100);
            EventWriter evWriter = new EventWriter(buffer, 550000, 200, null, null);
            evWriter.writeEvent(ev);
            evWriter.close();
            buffer.flip();
            EvioReader reader = new EvioReader(buffer);
            long evCount = reader.getEventCount();
            System.out.println("Read file, got " + evCount + " number of events\n");
            while ((event = reader.parseNextEvent()) != null) {
                System.out.println("Event = " + event.toXML());
                System.out.println("\nevent count = " + reader.getEventCount() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

