/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.INameProvider;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EvioXMLDictionary
implements INameProvider {
    private static String DICT_TOP_LEVEL = "xmlDict";
    private static String ENTRY = "xmldumpDictEntry";
    private static String ENTRY_ALT = "dictEntry";
    private static String ENTRY_BANK = "bank";
    private static String ENTRY_LEAF = "leaf";
    private static String DESCRIPTION = "description";
    private static String FORMAT = "format";
    private static String TYPE = "type";
    private static String NAME = "name";
    private static String TAG = "tag";
    private static String NUM = "num";
    private String delimiter = ".";
    private LinkedHashMap<EntryData, String> dictMap = new LinkedHashMap(1000);
    private LinkedHashMap<String, EntryData> reverseMap = new LinkedHashMap(1000);
    private Node topLevelDoc;

    public EvioXMLDictionary(File file) {
        this(EvioXMLDictionary.getDomObject(file));
    }

    public EvioXMLDictionary(File file, String delimiter) {
        this(EvioXMLDictionary.getDomObject(file), delimiter);
    }

    public EvioXMLDictionary(String xmlString) {
        this(EvioXMLDictionary.getDomObject(xmlString));
    }

    public EvioXMLDictionary(String xmlString, String delimiter) {
        this(EvioXMLDictionary.getDomObject(xmlString), delimiter);
    }

    public EvioXMLDictionary(Document domDocument) {
        this(domDocument, null);
    }

    public EvioXMLDictionary(Document domDocument, String delimiter) {
        Node topNode;
        NodeList list;
        if (domDocument == null) {
            return;
        }
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
        if ((list = domDocument.getElementsByTagName(DICT_TOP_LEVEL)).getLength() < 1) {
            return;
        }
        this.topLevelDoc = topNode = list.item(0);
        NodeList kidList = topNode.getChildNodes();
        if (kidList.getLength() < 1) {
            return;
        }
        for (int index = 0; index < kidList.getLength(); ++index) {
            NodeList children;
            Node node = kidList.item(index);
            if (node == null || !node.getNodeName().equalsIgnoreCase(ENTRY) && !node.getNodeName().equalsIgnoreCase(ENTRY_ALT) || !node.hasAttributes()) continue;
            int num = 0;
            int tag = 0;
            boolean badEntry = false;
            String description = null;
            String format = null;
            String type = null;
            String tagStr = null;
            String name = null;
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME);
            if (attrNode != null) {
                name = attrNode.getNodeValue();
            }
            if ((attrNode = map.getNamedItem(TAG)) != null) {
                tagStr = attrNode.getNodeValue();
                try {
                    tag = Integer.parseInt(tagStr);
                    if (tag < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((attrNode = map.getNamedItem(NUM)) != null) {
                String numStr = attrNode.getNodeValue();
                try {
                    num = Integer.parseInt(numStr);
                    if (num < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((attrNode = map.getNamedItem(TYPE)) != null) {
                type = attrNode.getNodeValue();
            }
            if ((children = node.getChildNodes()).getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node childNode = children.item(i);
                    if (childNode == null || !childNode.getNodeName().equalsIgnoreCase(DESCRIPTION)) continue;
                    description = childNode.getTextContent();
                    if (!childNode.hasAttributes() || (attrNode = (map = childNode.getAttributes()).getNamedItem(FORMAT)) == null) break;
                    format = attrNode.getNodeValue();
                    break;
                }
            }
            if (name == null || tagStr == null || badEntry) {
                System.out.println("IGNORING badly formatted dictionary entry: name = " + name);
                continue;
            }
            EntryData key = new EntryData(tag, num, type, description, format);
            if (!this.dictMap.containsKey(key) && !this.reverseMap.containsKey(name)) {
                this.dictMap.put(key, name);
                this.reverseMap.put(name, key);
                continue;
            }
            System.out.println("IGNORING duplicate dictionary entry: name = " + name);
        }
        this.addHierachicalDictEntries(kidList, null);
    }

    private void addHierachicalDictEntries(NodeList kidList, String parentName) {
        if (kidList == null || kidList.getLength() < 1) {
            return;
        }
        for (int i = 0; i < kidList.getLength(); ++i) {
            EntryData key;
            NodeList children;
            Node numNode;
            Node tagNode;
            Node node = kidList.item(i);
            if (node == null) continue;
            boolean isLeaf = node.getNodeName().equalsIgnoreCase(ENTRY_LEAF);
            if (!node.getNodeName().equalsIgnoreCase(ENTRY_BANK) && !isLeaf || !node.hasAttributes()) continue;
            int num = 0;
            int tag = 0;
            boolean badEntry = false;
            String description = null;
            String format = null;
            String type = null;
            String tagStr = null;
            String name = null;
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME);
            if (attrNode != null) {
                name = attrNode.getNodeValue();
            }
            if ((tagNode = map.getNamedItem(TAG)) != null) {
                tagStr = tagNode.getNodeValue();
                try {
                    tag = Integer.parseInt(tagStr);
                    if (tag < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((numNode = map.getNamedItem(NUM)) != null) {
                String numStr = numNode.getNodeValue();
                try {
                    num = Integer.parseInt(numStr);
                    if (num < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((attrNode = map.getNamedItem(TYPE)) != null) {
                type = attrNode.getNodeValue();
            }
            if ((children = node.getChildNodes()).getLength() > 0) {
                for (int j = 0; j < children.getLength(); ++j) {
                    Node childNode = children.item(j);
                    if (childNode == null || !childNode.getNodeName().equalsIgnoreCase(DESCRIPTION)) continue;
                    description = childNode.getTextContent();
                    if (!childNode.hasAttributes() || (attrNode = (map = childNode.getAttributes()).getNamedItem(FORMAT)) == null) break;
                    format = attrNode.getNodeValue();
                    break;
                }
            }
            if (name == null || tagStr == null || badEntry) {
                System.out.println("IGNORING badly formatted dictionary entry: name = " + name);
                continue;
            }
            if (parentName != null) {
                name = parentName + this.delimiter + name;
            }
            if (!this.dictMap.containsKey(key = new EntryData(tag, num, type, description, format)) && !this.reverseMap.containsKey(name)) {
                this.dictMap.put(key, name);
                this.reverseMap.put(name, key);
                if (!isLeaf) {
                    this.addHierachicalDictEntries(node.getChildNodes(), name);
                    continue;
                }
                if (!node.hasChildNodes()) continue;
                System.out.println("IGNORING children of \"leaf\" element " + name);
                continue;
            }
            System.out.println("IGNORING duplicate dictionary entry: name = " + name);
        }
    }

    @Override
    public String getName(BaseStructure structure) {
        int tag = structure.getHeader().getTag();
        int num = structure.getHeader().getNumber();
        return this.getName(tag, num);
    }

    public String getName(int tag, int num) {
        EntryData key = new EntryData(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            return "???";
        }
        return name;
    }

    public String getDescription(int tag, int num) {
        EntryData key = new EntryData(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            System.out.println("getDescription: no entry for that key (tag/num)");
            return null;
        }
        EntryData origKey = this.reverseMap.get(name);
        if (origKey == null) {
            System.out.println("getDescription: no orig entry for that key (tag/num)");
            return null;
        }
        return origKey.getDescription();
    }

    public String getDescription(String name) {
        EntryData entry = this.reverseMap.get(name);
        if (entry == null) {
            return null;
        }
        return entry.getDescription();
    }

    public String getFormat(int tag, int num) {
        EntryData key = new EntryData(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            return null;
        }
        EntryData origKey = this.reverseMap.get(name);
        if (origKey == null) {
            return null;
        }
        return origKey.getFormat();
    }

    public String getFormat(String name) {
        EntryData data = this.reverseMap.get(name);
        if (data == null) {
            return null;
        }
        return data.getFormat();
    }

    public DataType getType(int tag, int num) {
        EntryData key = new EntryData(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            return null;
        }
        EntryData origKey = this.reverseMap.get(name);
        if (origKey == null) {
            return null;
        }
        return origKey.getType();
    }

    public DataType getType(String name) {
        EntryData data = this.reverseMap.get(name);
        if (data == null) {
            return null;
        }
        return data.getType();
    }

    public int[] getTagNum(String name) {
        EntryData pair = this.reverseMap.get(name);
        if (pair == null) {
            return null;
        }
        return new int[]{pair.getTag(), pair.getNum()};
    }

    public int getTag(String name) {
        EntryData data = this.reverseMap.get(name);
        if (data == null) {
            return -1;
        }
        return data.getTag();
    }

    public int getNum(String name) {
        EntryData data = this.reverseMap.get(name);
        if (data == null) {
            return -1;
        }
        return data.getNum();
    }

    private static Document getDomObject(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(file);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dom;
    }

    private static Document getDomObject(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(bais);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dom;
    }

    public String toXML() {
        return this.nodeToString(this.topLevelDoc);
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer t = transformerFactory.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            return null;
        }
        return sw.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("-- Dictionary --\n");
        for (String name : this.reverseMap.keySet()) {
            EntryData pair = this.reverseMap.get(name);
            sb.append(String.format("tag: %-15s num: %-15s name: %s\n", pair.tag, pair.num, name));
        }
        return sb.toString();
    }

    private final class EntryData {
        private final Integer tag;
        private final Integer num;
        private DataType type;
        private final String format;
        private final String description;

        public EntryData(int tag, int num) {
            this(tag, num, null, null, null);
        }

        public EntryData(int tag, int num, String type) {
            this(tag, num, type, null, null);
        }

        public EntryData(int tag, int num, String type, String description) {
            this(tag, num, type, description, null);
        }

        public EntryData(int tag, int num, String type, String description, String format) {
            this.tag = tag;
            this.num = num;
            this.format = format;
            this.description = description;
            this.type = null;
            if (type != null) {
                try {
                    this.type = DataType.valueOf(type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }

        public final int hashCode() {
            int hashTag = this.tag.hashCode();
            int hashNum = this.num.hashCode();
            return (hashTag + hashNum) * hashNum + hashTag;
        }

        public final boolean equals(Object other) {
            if (other instanceof EntryData) {
                EntryData otherPair = (EntryData)other;
                return this.tag.equals(otherPair.tag) && this.num.equals(otherPair.num);
            }
            return false;
        }

        public final String toString() {
            if (this.type == null) {
                return "(tag=" + this.tag + ",num =" + this.num + ")";
            }
            return "(tag=" + this.tag + ",num =" + this.num + ",type=" + (Object)((Object)this.type) + ")";
        }

        public final int getTag() {
            return this.tag;
        }

        public final int getNum() {
            return this.num;
        }

        public final DataType getType() {
            return this.type;
        }

        public final String getFormat() {
            return this.format;
        }

        public final String getDescription() {
            return this.description;
        }
    }
}

