/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.IEvioWriter;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.StructureType;

public abstract class BaseStructure
implements Cloneable,
IEvioStructure,
MutableTreeNode,
IEvioWriter {
    protected BaseStructureHeader header;
    protected byte[] rawBytes;
    protected byte[] charData;
    protected int[] intData;
    protected long[] longData;
    protected short[] shortData;
    protected double[] doubleData;
    protected float[] floatData;
    protected CompositeData[] compositeData;
    protected StringBuffer stringData;
    protected LinkedList<String> stringsList;
    protected int stringEnd;
    protected int numberDataItems;
    private static byte[] padValues = new byte[]{0, 0, 0};
    private static int[] padCount = new int[]{0, 3, 2, 1};
    protected String xmlIndent = "";
    protected String xmlElementName = "unknown";
    protected String xmlContentAttributeName = "unknown32";
    protected ByteOrder byteOrder;
    private BaseStructure parent;
    protected Vector<BaseStructure> children;
    protected boolean lengthsUpToDate;
    protected boolean isLeaf = true;

    public BaseStructure(BaseStructureHeader header) {
        this.header = header;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.setXmlNames();
    }

    public void transform(BaseStructure structure) {
        if (structure == null) {
            return;
        }
        this.rawBytes = null;
        this.charData = null;
        this.intData = null;
        this.longData = null;
        this.shortData = null;
        this.doubleData = null;
        this.floatData = null;
        this.compositeData = null;
        this.stringData = null;
        this.stringsList = null;
        this.stringEnd = 0;
        if (this.children != null) {
            this.children.clear();
        } else {
            this.children = new Vector(10);
        }
        this.isLeaf = structure.isLeaf;
        this.lengthsUpToDate = structure.lengthsUpToDate;
        this.byteOrder = structure.byteOrder;
        this.numberDataItems = structure.numberDataItems;
        this.xmlIndent = structure.xmlIndent;
        this.xmlElementName = structure.xmlElementName;
        this.xmlContentAttributeName = structure.xmlContentAttributeName;
        if (structure.getRawBytes() != null) {
            this.setRawBytes((byte[])structure.getRawBytes().clone());
        }
        DataType type = structure.getHeader().getDataType();
        switch (type) {
            case SHORT16: 
            case USHORT16: {
                if (structure.shortData == null) break;
                this.shortData = (short[])structure.shortData.clone();
                break;
            }
            case INT32: 
            case UINT32: {
                if (structure.intData == null) break;
                this.intData = (int[])structure.intData.clone();
                break;
            }
            case LONG64: 
            case ULONG64: {
                if (structure.longData == null) break;
                this.longData = (long[])structure.longData.clone();
                break;
            }
            case FLOAT32: {
                if (structure.floatData == null) break;
                this.floatData = (float[])structure.floatData.clone();
                break;
            }
            case DOUBLE64: {
                if (structure.doubleData == null) break;
                this.doubleData = (double[])structure.doubleData.clone();
                break;
            }
            case CHAR8: 
            case UCHAR8: {
                if (structure.charData == null) break;
                this.charData = (byte[])structure.charData.clone();
                break;
            }
            case CHARSTAR8: {
                if (structure.stringsList == null) break;
                this.stringsList = new LinkedList();
                this.stringsList.addAll(structure.stringsList);
                this.stringData = new StringBuffer(structure.stringData);
                this.stringEnd = structure.stringEnd;
                break;
            }
            case COMPOSITE: {
                if (structure.compositeData == null) break;
                int len = structure.compositeData.length;
                this.compositeData = new CompositeData[len];
                for (int i = 0; i < len; ++i) {
                    this.compositeData[i] = (CompositeData)structure.compositeData[i].clone();
                }
                break;
            }
            case ALSOBANK: 
            case ALSOSEGMENT: 
            case BANK: 
            case SEGMENT: 
            case TAGSEGMENT: {
                for (BaseStructure kid : structure.children) {
                    this.children.add(kid);
                }
                break;
            }
        }
    }

    public Object clone() {
        try {
            BaseStructure bs = (BaseStructure)super.clone();
            bs.header = (BaseStructureHeader)this.header.clone();
            if (this.rawBytes != null) {
                bs.rawBytes = (byte[])this.rawBytes.clone();
            }
            switch (this.header.getDataType()) {
                case SHORT16: 
                case USHORT16: {
                    if (this.shortData == null) break;
                    bs.shortData = (short[])this.shortData.clone();
                    break;
                }
                case INT32: 
                case UINT32: {
                    if (this.intData == null) break;
                    bs.intData = (int[])this.intData.clone();
                    break;
                }
                case LONG64: 
                case ULONG64: {
                    if (this.longData == null) break;
                    bs.longData = (long[])this.longData.clone();
                    break;
                }
                case FLOAT32: {
                    if (this.floatData == null) break;
                    bs.floatData = (float[])this.floatData.clone();
                    break;
                }
                case DOUBLE64: {
                    if (this.doubleData == null) break;
                    bs.doubleData = (double[])this.doubleData.clone();
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    if (this.charData == null) break;
                    bs.charData = (byte[])this.charData.clone();
                    break;
                }
                case CHARSTAR8: {
                    if (this.stringsList == null) break;
                    bs.stringsList = new LinkedList();
                    bs.stringsList.addAll(this.stringsList);
                    bs.stringData = new StringBuffer(this.stringData);
                    bs.stringEnd = this.stringEnd;
                    break;
                }
                case COMPOSITE: {
                    if (this.compositeData == null) break;
                    int len = this.compositeData.length;
                    bs.compositeData = new CompositeData[len];
                    for (int i = 0; i < len; ++i) {
                        bs.compositeData[i] = (CompositeData)this.compositeData[i].clone();
                    }
                    break;
                }
                case ALSOBANK: 
                case ALSOSEGMENT: 
                case BANK: 
                case SEGMENT: 
                case TAGSEGMENT: {
                    bs.children = new Vector(10);
                    for (BaseStructure kid : this.children) {
                        bs.children.add((BaseStructure)kid.clone());
                    }
                    break;
                }
            }
            return bs;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void clearData() {
        if (this.header.getDataType().isStructure()) {
            return;
        }
        this.rawBytes = null;
        this.charData = null;
        this.intData = null;
        this.longData = null;
        this.shortData = null;
        this.doubleData = null;
        this.floatData = null;
        this.compositeData = null;
        this.stringData = null;
        this.stringsList = null;
        this.stringEnd = 0;
        this.numberDataItems = 0;
    }

    @Override
    public abstract StructureType getStructureType();

    public abstract void toXML(XMLStreamWriter var1);

    public abstract String getXMLElementName();

    public String toXML() {
        try {
            StringWriter sWriter = new StringWriter();
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(sWriter);
            this.toXML(xmlWriter);
            return sWriter.toString();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setXmlNames() {
        boolean holdingStructureType = false;
        DataType type = this.header.getDataType();
        if (type == null) {
            return;
        }
        switch (type) {
            case CHAR8: {
                this.xmlElementName = "int8";
                break;
            }
            case UCHAR8: {
                this.xmlElementName = "uint8";
                break;
            }
            case SHORT16: {
                this.xmlElementName = "int16";
                break;
            }
            case USHORT16: {
                this.xmlElementName = "uint16";
                break;
            }
            case INT32: {
                this.xmlElementName = "int32";
                break;
            }
            case UINT32: {
                this.xmlElementName = "uint32";
                break;
            }
            case LONG64: {
                this.xmlElementName = "int64";
                break;
            }
            case ULONG64: {
                this.xmlElementName = "uint64";
                break;
            }
            case FLOAT32: {
                this.xmlElementName = "float32";
                break;
            }
            case DOUBLE64: {
                this.xmlElementName = "float64";
                break;
            }
            case CHARSTAR8: {
                this.xmlElementName = "string";
                break;
            }
            case COMPOSITE: {
                this.xmlElementName = "composite";
                break;
            }
            case UNKNOWN32: {
                holdingStructureType = true;
                this.xmlContentAttributeName = "unknown32";
                break;
            }
            case TAGSEGMENT: {
                holdingStructureType = true;
                this.xmlContentAttributeName = "tagsegment";
                break;
            }
            case ALSOSEGMENT: 
            case SEGMENT: {
                holdingStructureType = true;
                this.xmlContentAttributeName = "segment";
                break;
            }
            case ALSOBANK: 
            case BANK: {
                holdingStructureType = true;
                this.xmlContentAttributeName = "bank";
                break;
            }
            default: {
                this.xmlElementName = "unknown";
            }
        }
        if (holdingStructureType) {
            StructureType structType = this.getStructureType();
            this.xmlElementName = structType == StructureType.UNKNOWN32 ? "unknown32" : this.getXMLElementName();
        }
    }

    protected void setXmlIndent(String s) {
        this.xmlIndent = s;
    }

    protected void increaseXmlIndent() {
        this.xmlIndent = this.xmlIndent + "   ";
    }

    protected void decreaseXmlIndent() {
        this.xmlIndent = this.xmlIndent.substring(0, this.xmlIndent.length() - 3);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean isSwap() {
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public String getDescription() {
        return NameProvider.getName(this);
    }

    public String toString() {
        StructureType stype = this.getStructureType();
        DataType dtype = this.header.getDataType();
        String description = this.getDescription();
        if ("???".equals(description)) {
            description = null;
        }
        String s = (Object)((Object)stype) + " of " + (Object)((Object)dtype) + "s " + " len (ints): " + this.header.length + " " + " tag: " + this.header.tag;
        if (this instanceof EvioBank) {
            s = s + " num: " + this.header.number;
        }
        s = this.rawBytes == null ? s + " data: null" : s + " datalen (bytes): " + this.rawBytes.length;
        if (description != null) {
            s = s + " [" + description + "]";
        }
        int numChildren = this.children == null ? 0 : this.children.size();
        s = s + " <#children: " + numChildren + ">";
        return s;
    }

    @Override
    public BaseStructureHeader getHeader() {
        return this.header;
    }

    public int getNumberDataItems() {
        if (this.isContainer()) {
            this.numberDataItems = this.header.getLength() + 1 - this.header.getHeaderLength();
        }
        if (this.numberDataItems < 1) {
            int divisor = 0;
            int padding = 0;
            DataType type = this.header.getDataType();
            switch (type) {
                case CHAR8: 
                case UCHAR8: {
                    padding = this.header.getPadding();
                    divisor = 1;
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    padding = this.header.getPadding();
                    divisor = 2;
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    divisor = 4;
                    break;
                }
                case LONG64: 
                case ULONG64: 
                case DOUBLE64: {
                    divisor = 8;
                    break;
                }
                case CHARSTAR8: {
                    String[] s = this.getStringData();
                    this.numberDataItems = s.length;
                    break;
                }
                case COMPOSITE: {
                    this.numberDataItems = 1;
                    if (this.compositeData == null) break;
                    this.numberDataItems = this.compositeData.length;
                    break;
                }
            }
            if (divisor > 0 && this.rawBytes != null) {
                this.numberDataItems = (this.rawBytes.length - padding) / divisor;
            }
        }
        return this.numberDataItems;
    }

    public int getTotalBytes() {
        return 4 * (this.header.getLength() + 1);
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public void setRawBytes(byte[] rawBytes) {
        this.rawBytes = rawBytes;
    }

    @Override
    public int[] getIntData() {
        switch (this.header.getDataType()) {
            case INT32: 
            case UINT32: {
                if (this.intData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.intData = ByteDataTransformer.toIntArray(this.rawBytes, this.byteOrder);
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                return this.intData;
            }
        }
        return null;
    }

    @Override
    public long[] getLongData() {
        switch (this.header.getDataType()) {
            case LONG64: 
            case ULONG64: {
                if (this.longData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.longData = ByteDataTransformer.toLongArray(this.rawBytes, this.byteOrder);
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                return this.longData;
            }
        }
        return null;
    }

    @Override
    public float[] getFloatData() {
        switch (this.header.getDataType()) {
            case FLOAT32: {
                if (this.floatData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.floatData = ByteDataTransformer.toFloatArray(this.rawBytes, this.byteOrder);
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                return this.floatData;
            }
        }
        return null;
    }

    @Override
    public double[] getDoubleData() {
        switch (this.header.getDataType()) {
            case DOUBLE64: {
                if (this.doubleData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.doubleData = ByteDataTransformer.toDoubleArray(this.rawBytes, this.byteOrder);
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                return this.doubleData;
            }
        }
        return null;
    }

    @Override
    public short[] getShortData() {
        switch (this.header.getDataType()) {
            case SHORT16: 
            case USHORT16: {
                if (this.shortData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.shortData = ByteDataTransformer.toShortArray(this.rawBytes, this.header.getPadding(), this.byteOrder);
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                return this.shortData;
            }
        }
        return null;
    }

    @Override
    public CompositeData[] getCompositeData() throws EvioException {
        switch (this.header.getDataType()) {
            case COMPOSITE: {
                if (this.compositeData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.compositeData = CompositeData.parse(this.rawBytes, this.byteOrder);
                }
                return this.compositeData;
            }
        }
        return null;
    }

    @Override
    public byte[] getByteData() {
        switch (this.header.getDataType()) {
            case CHAR8: 
            case UCHAR8: {
                if (this.charData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.charData = new byte[this.rawBytes.length - this.header.getPadding()];
                    System.arraycopy(this.rawBytes, 0, this.charData, 0, this.rawBytes.length - this.header.getPadding());
                }
                return this.charData;
            }
        }
        return null;
    }

    @Override
    public String[] getStringData() {
        switch (this.header.getDataType()) {
            case CHARSTAR8: {
                if (this.stringsList != null) {
                    return this.stringsList.toArray(new String[this.stringsList.size()]);
                }
                if (this.stringData == null && this.rawBytes == null) {
                    return null;
                }
                this.unpackRawBytesToStrings();
                return this.stringsList.toArray(new String[this.stringsList.size()]);
            }
        }
        return null;
    }

    public static int stringsToRawSize(String[] strings) {
        if (strings == null || strings.length < 1) {
            return 0;
        }
        int dataLen = 0;
        for (String s : strings) {
            dataLen += s.length() + 1;
        }
        int[] pads = new int[]{4, 3, 2, 1};
        dataLen += pads[dataLen % 4];
        return dataLen;
    }

    public static byte[] stringsToRawBytes(String[] strings) {
        if (strings == null || strings.length < 1) {
            return null;
        }
        int dataLen = 0;
        for (String s : strings) {
            dataLen += s.length() + 1;
        }
        StringBuilder stringData = new StringBuilder(dataLen += 4);
        for (String s : strings) {
            stringData.append(s);
            stringData.append('\u0000');
        }
        int[] pads = new int[]{4, 3, 2, 1};
        switch (pads[stringData.length() % 4]) {
            case 4: {
                stringData.append("\u0004\u0004\u0004\u0004");
                break;
            }
            case 3: {
                stringData.append("\u0004\u0004\u0004");
                break;
            }
            case 2: {
                stringData.append("\u0004\u0004");
                break;
            }
            case 1: {
                stringData.append('\u0004');
            }
        }
        try {
            return stringData.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String[] unpackRawBytesToStrings(byte[] rawBytes, int offset) {
        if (rawBytes == null || offset < 0) {
            return null;
        }
        int length = rawBytes.length - offset;
        StringBuffer stringData = new StringBuffer();
        try {
            stringData = new StringBuffer(new String(rawBytes, offset, length, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        boolean newVersion = true;
        if (stringData.charAt(stringData.length() - 1) != '\u0004') {
            newVersion = false;
        }
        LinkedList<String> stringsList = new LinkedList<String>();
        LinkedList<Integer> nullIndexList = new LinkedList<Integer>();
        for (int i = 0; i < stringData.length(); ++i) {
            char c = stringData.charAt(i);
            if (c == '\u0000') {
                nullIndexList.add(i);
                if (newVersion) continue;
                break;
            }
            if ((c < ' ' || c == '\u007f') && !Character.isWhitespace(c)) break;
        }
        int firstIndex = 0;
        Iterator i$ = nullIndexList.iterator();
        while (i$.hasNext()) {
            int nullIndex = (Integer)i$.next();
            stringsList.add(stringData.substring(firstIndex, nullIndex));
            firstIndex = nullIndex + 1;
        }
        if (stringsList.size() < 1) {
            return null;
        }
        String[] strs = new String[stringsList.size()];
        stringsList.toArray(strs);
        return strs;
    }

    private void unpackRawBytesToStrings() {
        if (this.rawBytes == null) {
            return;
        }
        try {
            this.stringData = new StringBuffer(new String(this.rawBytes, "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        boolean newVersion = true;
        if (this.stringData.charAt(this.stringData.length() - 1) != '\u0004') {
            newVersion = false;
        }
        this.stringsList = new LinkedList();
        LinkedList<Integer> nullIndexList = new LinkedList<Integer>();
        for (int i = 0; i < this.stringData.length(); ++i) {
            char c = this.stringData.charAt(i);
            if (c == '\u0000') {
                nullIndexList.add(i);
                if (newVersion) continue;
                break;
            }
            if ((c < ' ' || c == '\u007f') && !Character.isWhitespace(c)) break;
        }
        int firstIndex = 0;
        Iterator i$ = nullIndexList.iterator();
        while (i$.hasNext()) {
            int nullIndex = (Integer)i$.next();
            this.stringsList.add(this.stringData.substring(firstIndex, nullIndex));
            firstIndex = nullIndex + 1;
        }
        this.stringEnd = firstIndex;
        this.stringData.setLength(this.stringEnd);
        if (!newVersion) {
            int[] pads = new int[]{4, 3, 2, 1};
            switch (pads[this.stringData.length() % 4]) {
                case 4: {
                    this.stringData.append("\u0004\u0004\u0004\u0004");
                    break;
                }
                case 3: {
                    this.stringData.append("\u0004\u0004\u0004");
                    break;
                }
                case 2: {
                    this.stringData.append("\u0004\u0004");
                    break;
                }
                case 1: {
                    this.stringData.append('\u0004');
                }
            }
            try {
                this.rawBytes = this.stringData.toString().getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    @Override
    public BaseStructure getParent() {
        return this.parent;
    }

    public Enumeration<?> children() {
        if (this.children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (this.children == null) {
            this.children = new Vector(10);
        }
        this.children.add(index, (BaseStructure)child);
        child.setParent(this);
        this.isLeaf = false;
        this.lengthsUpToDate(false);
    }

    public void insert(MutableTreeNode child) {
        if (this.children == null) {
            this.children = new Vector(10);
        }
        this.insert(child, this.children.size());
    }

    @Override
    public void remove(int index) {
        if (this.children == null) {
            return;
        }
        BaseStructure bs = this.children.remove(index);
        bs.setParent(null);
        if (this.children.size() < 1) {
            this.isLeaf = true;
        }
        this.lengthsUpToDate(false);
    }

    @Override
    public void remove(MutableTreeNode child) {
        if (this.children == null || child == null) {
            return;
        }
        this.children.remove(child);
        child.setParent(null);
        if (this.children.size() < 1) {
            this.isLeaf = true;
        }
        this.lengthsUpToDate(false);
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode parent) {
        this.parent = (BaseStructure)parent;
    }

    public void vistAllStructures(IEvioListener listener) {
        this.visitAllDescendants(this, listener, null);
    }

    public void vistAllStructures(IEvioListener listener, IEvioFilter filter) {
        this.visitAllDescendants(this, listener, filter);
    }

    private void visitAllDescendants(BaseStructure structure, IEvioListener listener, IEvioFilter filter) {
        if (listener != null) {
            boolean accept = true;
            if (filter != null) {
                accept = filter.accept(structure.getStructureType(), structure);
            }
            if (accept) {
                listener.gotStructure(this, structure);
            }
        }
        if (!structure.isLeaf()) {
            for (BaseStructure child : structure.getChildren()) {
                this.visitAllDescendants(child, listener, filter);
            }
        }
    }

    public List<BaseStructure> getMatchingStructures(IEvioFilter filter) {
        final Vector<BaseStructure> structures = new Vector<BaseStructure>(25, 10);
        IEvioListener listener = new IEvioListener(){

            @Override
            public void startEventParse(BaseStructure structure) {
            }

            @Override
            public void endEventParse(BaseStructure structure) {
            }

            @Override
            public void gotStructure(BaseStructure topStructure, IEvioStructure structure) {
                structures.add((BaseStructure)structure);
            }
        };
        this.vistAllStructures(listener, filter);
        if (structures.size() == 0) {
            return null;
        }
        return structures;
    }

    @Override
    public void setUserObject(Object arg0) {
    }

    @Override
    public boolean getAllowsChildren() {
        return this.header.getDataType().isStructure();
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (this.children == null) {
            return null;
        }
        BaseStructure b = null;
        try {
            b = this.children.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return b;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.children == null || node == null) {
            return -1;
        }
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isContainer() {
        return this.header.getDataType().isStructure();
    }

    protected void childrenToXML(XMLStreamWriter xmlWriter) {
        if (this.children == null) {
            return;
        }
        this.increaseXmlIndent();
        for (BaseStructure structure : this.children) {
            structure.setXmlIndent(this.xmlIndent);
            structure.toXML(xmlWriter);
        }
        this.decreaseXmlIndent();
    }

    protected void commonXMLStart(XMLStreamWriter xmlWriter) {
        try {
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeCharacters(this.xmlIndent);
            xmlWriter.writeStartElement(this.xmlElementName);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected void commonXMLClose(XMLStreamWriter xmlWriter) {
        this.childrenToXML(xmlWriter);
        try {
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeCharacters(this.xmlIndent);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected void commonXMLDataWrite(XMLStreamWriter xmlWriter) {
        if (!this.isLeaf()) {
            return;
        }
        try {
            String indent = String.format("\n%s", this.xmlIndent);
            BaseStructureHeader header = this.getHeader();
            switch (header.getDataType()) {
                case DOUBLE64: {
                    double[] doubledata = this.getDoubleData();
                    for (int i = 0; i < doubledata.length; ++i) {
                        if (i % 2 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%24.16e  ", doubledata[i]);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case FLOAT32: {
                    float[] floatdata = this.getFloatData();
                    for (int i = 0; i < floatdata.length; ++i) {
                        if (i % 2 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%14.7e  ", Float.valueOf(floatdata[i]));
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case LONG64: 
                case ULONG64: {
                    long[] longdata = this.getLongData();
                    for (int i = 0; i < longdata.length; ++i) {
                        if (i % 2 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%20d  ", longdata[i]);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case INT32: 
                case UINT32: {
                    int[] intdata = this.getIntData();
                    for (int i = 0; i < intdata.length; ++i) {
                        if (i % 5 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%11d  ", intdata[i]);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    short[] shortdata = this.getShortData();
                    for (int i = 0; i < shortdata.length; ++i) {
                        if (i % 5 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%6d  ", shortdata[i]);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    byte[] bytedata = this.getByteData();
                    for (int i = 0; i < bytedata.length; ++i) {
                        if (i % 5 == 0) {
                            xmlWriter.writeCharacters(indent);
                        }
                        String s = String.format("%4d  ", bytedata[i]);
                        xmlWriter.writeCharacters(s);
                    }
                    break;
                }
                case CHARSTAR8: {
                    String[] stringdata;
                    for (String str : stringdata = this.getStringData()) {
                        xmlWriter.writeCharacters("\n");
                        xmlWriter.writeCData(str);
                    }
                    break;
                }
                case COMPOSITE: {
                    if (this.compositeData == null) {
                        try {
                            this.getCompositeData();
                        }
                        catch (EvioException e) {
                            return;
                        }
                    }
                    for (int i = 0; i < this.compositeData.length; ++i) {
                        this.compositeData[i].toXML(xmlWriter, this, true);
                    }
                    break;
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected int dataLength() {
        int datalen = 0;
        if (this.isLeaf()) {
            BaseStructureHeader header = this.getHeader();
            switch (header.getDataType()) {
                case LONG64: 
                case ULONG64: 
                case DOUBLE64: {
                    datalen = 2 * this.getNumberDataItems();
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    datalen = this.getNumberDataItems();
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    datalen = 1 + (this.getNumberDataItems() - 1) / 2;
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    datalen = 1 + (this.getNumberDataItems() - 1) / 4;
                    break;
                }
                case CHARSTAR8: 
                case COMPOSITE: {
                    if (this.rawBytes == null) break;
                    datalen = 1 + (this.rawBytes.length - 1) / 4;
                }
            }
        }
        return datalen;
    }

    public Vector<BaseStructure> getChildren() {
        return this.children;
    }

    protected boolean lengthsUpToDate() {
        return this.lengthsUpToDate;
    }

    protected void lengthsUpToDate(boolean lengthsUpToDate) {
        this.lengthsUpToDate = lengthsUpToDate;
        if (!lengthsUpToDate && this.parent != null) {
            this.parent.lengthsUpToDate(false);
        }
    }

    public int setAllHeaderLengthsSemiOrig() throws EvioException {
        int datalen;
        if (this.lengthsUpToDate) {
            return this.header.getLength();
        }
        if (this.isLeaf()) {
            datalen = this.dataLength();
        } else {
            datalen = 0;
            if (this.children == null) {
                System.err.println("Non leaf with null children!");
                System.exit(1);
            }
            for (BaseStructure child : this.children) {
                datalen += child.setAllHeaderLengths();
                ++datalen;
            }
        }
        this.header.setLength(datalen += this.header.getHeaderLength() - 1);
        this.lengthsUpToDate(true);
        return datalen;
    }

    public int setAllHeaderLengths() throws EvioException {
        int len;
        int datalen;
        if (this.lengthsUpToDate) {
            return this.header.getLength();
        }
        if (this.isLeaf()) {
            datalen = this.dataLength();
        } else {
            datalen = 0;
            if (this.children == null) {
                System.err.println("Non leaf with null children!");
                System.exit(1);
            }
            for (BaseStructure child : this.children) {
                len = child.setAllHeaderLengths();
                if (Integer.MAX_VALUE - datalen < len) {
                    throw new EvioException("added data overflowed containing structure");
                }
                datalen += len + 1;
            }
        }
        len = this.header.getHeaderLength() - 1;
        if (Integer.MAX_VALUE - datalen < len) {
            throw new EvioException("added data overflowed containing structure");
        }
        this.header.setLength(datalen += len);
        this.lengthsUpToDate(true);
        return datalen;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        int startPos;
        block28: {
            block27: {
                startPos = byteBuffer.position();
                this.header.write(byteBuffer);
                int curPos = byteBuffer.position();
                if (!this.isLeaf()) break block27;
                switch (this.header.getDataType()) {
                    case DOUBLE64: {
                        if (this.rawBytes != null) {
                            if (this.byteOrder == byteBuffer.order()) {
                                byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                                break;
                            }
                            DoubleBuffer db = byteBuffer.asDoubleBuffer();
                            DoubleBuffer rawBuf = ByteBuffer.wrap(this.rawBytes).order(this.byteOrder).asDoubleBuffer();
                            db.put(rawBuf);
                            byteBuffer.position(curPos + this.rawBytes.length);
                            break;
                        }
                        DoubleBuffer db = byteBuffer.asDoubleBuffer();
                        db.put(this.doubleData, 0, this.doubleData.length);
                        byteBuffer.position(curPos + 8 * this.doubleData.length);
                        break;
                    }
                    case FLOAT32: {
                        if (this.rawBytes != null) {
                            if (this.byteOrder == byteBuffer.order()) {
                                byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                                break;
                            }
                            FloatBuffer db = byteBuffer.asFloatBuffer();
                            FloatBuffer rawBuf = ByteBuffer.wrap(this.rawBytes).order(this.byteOrder).asFloatBuffer();
                            db.put(rawBuf);
                            byteBuffer.position(curPos + this.rawBytes.length);
                            break;
                        }
                        FloatBuffer db = byteBuffer.asFloatBuffer();
                        db.put(this.floatData, 0, this.floatData.length);
                        byteBuffer.position(curPos + 4 * this.floatData.length);
                        break;
                    }
                    case LONG64: 
                    case ULONG64: {
                        if (this.rawBytes != null) {
                            if (this.byteOrder == byteBuffer.order()) {
                                byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                                break;
                            }
                            LongBuffer db = byteBuffer.asLongBuffer();
                            LongBuffer rawBuf = ByteBuffer.wrap(this.rawBytes).order(this.byteOrder).asLongBuffer();
                            db.put(rawBuf);
                            byteBuffer.position(curPos + this.rawBytes.length);
                            break;
                        }
                        LongBuffer db = byteBuffer.asLongBuffer();
                        db.put(this.longData, 0, this.longData.length);
                        byteBuffer.position(curPos + 8 * this.longData.length);
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        if (this.rawBytes != null) {
                            if (this.byteOrder == byteBuffer.order()) {
                                byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                                break;
                            }
                            IntBuffer db = byteBuffer.asIntBuffer();
                            IntBuffer rawBuf = ByteBuffer.wrap(this.rawBytes).order(this.byteOrder).asIntBuffer();
                            db.put(rawBuf);
                            byteBuffer.position(curPos + this.rawBytes.length);
                            break;
                        }
                        IntBuffer db = byteBuffer.asIntBuffer();
                        db.put(this.intData, 0, this.intData.length);
                        byteBuffer.position(curPos + 4 * this.intData.length);
                        break;
                    }
                    case SHORT16: 
                    case USHORT16: {
                        if (this.rawBytes != null) {
                            if (this.byteOrder == byteBuffer.order()) {
                                byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                                break;
                            }
                            ShortBuffer db = byteBuffer.asShortBuffer();
                            ShortBuffer rawBuf = ByteBuffer.wrap(this.rawBytes).order(this.byteOrder).asShortBuffer();
                            db.put(rawBuf);
                            byteBuffer.position(curPos + this.rawBytes.length);
                            break;
                        }
                        ShortBuffer db = byteBuffer.asShortBuffer();
                        db.put(this.shortData, 0, this.shortData.length);
                        byteBuffer.position(curPos + 2 * this.shortData.length);
                        if (this.shortData.length % 2 > 0) {
                            byteBuffer.putShort((short)0);
                            break;
                        }
                        break block28;
                    }
                    case CHAR8: 
                    case UCHAR8: {
                        if (this.rawBytes != null) {
                            byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                            break;
                        }
                        byteBuffer.put(this.charData, 0, this.charData.length);
                        byteBuffer.put(padValues, 0, padCount[this.charData.length % 4]);
                        break;
                    }
                    case CHARSTAR8: {
                        if (this.rawBytes == null) break;
                        byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                        break;
                    }
                    case COMPOSITE: {
                        if (this.rawBytes == null) break;
                        if (this.byteOrder == byteBuffer.order()) {
                            byteBuffer.put(this.rawBytes, 0, this.rawBytes.length);
                            break;
                        }
                        byte[] swappedRaw = new byte[this.rawBytes.length];
                        try {
                            CompositeData.swapAll(this.rawBytes, 0, swappedRaw, 0, this.rawBytes.length / 4, this.byteOrder);
                        }
                        catch (EvioException e) {
                            // empty catch block
                        }
                        byteBuffer.put(swappedRaw, 0, swappedRaw.length);
                    }
                }
                break block28;
            }
            if (this.children != null) {
                for (BaseStructure child : this.children) {
                    child.write(byteBuffer);
                }
            }
        }
        return byteBuffer.position() - startPos;
    }

    public void appendIntData(int[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.INT32 && dataType != DataType.UINT32) {
            throw new EvioException("Tried to append int data to a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null) {
            return;
        }
        if (this.intData == null) {
            if (this.rawBytes == null) {
                this.intData = data;
                this.numberDataItems = data.length;
            } else {
                int size1 = this.rawBytes.length / 4;
                int size2 = data.length;
                if (Integer.MAX_VALUE - size1 < size2) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.intData = new int[size1 + size2];
                ByteDataTransformer.toIntArray(this.rawBytes, this.byteOrder, this.intData, 0);
                System.arraycopy(data, 0, this.intData, size1, size2);
                this.numberDataItems = size1 + size2;
            }
        } else {
            int size1 = this.intData.length;
            int size2 = data.length;
            if (Integer.MAX_VALUE - size1 < size2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.intData = Arrays.copyOf(this.intData, size1 + size2);
            System.arraycopy(data, 0, this.intData, size1, size2);
            this.numberDataItems += size2;
        }
        this.rawBytes = ByteDataTransformer.toBytes(this.intData, this.byteOrder);
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendShortData(short[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.SHORT16 && dataType != DataType.USHORT16) {
            throw new EvioException("Tried to append short data to a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null) {
            return;
        }
        if (this.shortData == null) {
            if (this.rawBytes == null) {
                this.shortData = data;
                this.numberDataItems = data.length;
            } else {
                int size2;
                int size1 = (this.rawBytes.length - this.header.getPadding()) / 2;
                if (Integer.MAX_VALUE - size1 < (size2 = data.length)) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.shortData = new short[size1 + size2];
                ByteDataTransformer.toShortArray(this.rawBytes, this.header.getPadding(), this.byteOrder, this.shortData, 0);
                System.arraycopy(data, 0, this.shortData, size1, size2);
                this.numberDataItems = size1 + size2;
            }
        } else {
            int size1 = this.shortData.length;
            int size2 = data.length;
            if (Integer.MAX_VALUE - size1 < size2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.shortData = Arrays.copyOf(this.shortData, size1 + size2);
            System.arraycopy(data, 0, this.shortData, size1, size2);
            this.numberDataItems += size2;
        }
        if (this.numberDataItems % 2 != 0) {
            this.header.setPadding(2);
            if (Integer.MAX_VALUE - 2 * this.numberDataItems < 2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.rawBytes = new byte[2 * this.numberDataItems + 2];
            ByteDataTransformer.toBytes(this.shortData, this.byteOrder, this.rawBytes, 0);
        } else {
            this.header.setPadding(0);
            this.rawBytes = ByteDataTransformer.toBytes(this.shortData, this.byteOrder);
        }
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendLongData(long[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.LONG64 && dataType != DataType.ULONG64) {
            throw new EvioException("Tried to append long data to a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null) {
            return;
        }
        if (this.longData == null) {
            if (this.rawBytes == null) {
                this.longData = data;
                this.numberDataItems = data.length;
            } else {
                int size1 = this.rawBytes.length / 8;
                int size2 = data.length;
                if (Integer.MAX_VALUE - size1 < size2) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.longData = new long[size1 + size2];
                ByteDataTransformer.toLongArray(this.rawBytes, this.byteOrder, this.longData, 0);
                System.arraycopy(data, 0, this.longData, size1, size2);
                this.numberDataItems = size1 + size2;
            }
        } else {
            int size1 = this.longData.length;
            int size2 = data.length;
            if (Integer.MAX_VALUE - size1 < size2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.longData = Arrays.copyOf(this.longData, size1 + size2);
            System.arraycopy(data, 0, this.longData, size1, size2);
            this.numberDataItems += size2;
        }
        this.rawBytes = ByteDataTransformer.toBytes(this.longData, this.byteOrder);
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendByteData(byte[] data) throws EvioException {
        int size1;
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.CHAR8 && dataType != DataType.UCHAR8) {
            throw new EvioException("Tried to append byte data to a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null) {
            return;
        }
        if (this.charData == null) {
            if (this.rawBytes == null) {
                this.charData = data;
                this.numberDataItems = data.length;
            } else {
                int size2;
                size1 = this.rawBytes.length - this.header.getPadding();
                if (Integer.MAX_VALUE - size1 < (size2 = data.length)) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.charData = new byte[size1 + size2];
                System.arraycopy(this.rawBytes, 0, this.charData, 0, size1);
                System.arraycopy(data, 0, this.charData, size1, size2);
                this.numberDataItems = size1 + size2;
            }
        } else {
            size1 = this.charData.length;
            int size2 = data.length;
            if (Integer.MAX_VALUE - size1 < size2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.charData = Arrays.copyOf(this.charData, size1 + size2);
            System.arraycopy(data, 0, this.charData, size1, size2);
            this.numberDataItems += data.length;
        }
        int padding = padCount[this.numberDataItems % 4];
        this.header.setPadding(padding);
        if (Integer.MAX_VALUE - this.numberDataItems < padding) {
            throw new EvioException("added data overflowed containing structure");
        }
        this.rawBytes = new byte[this.numberDataItems + padding];
        System.arraycopy(this.charData, 0, this.rawBytes, 0, this.numberDataItems);
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendFloatData(float[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.FLOAT32) {
            throw new EvioException("Tried to append float data to a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null) {
            return;
        }
        if (this.floatData == null) {
            if (this.rawBytes == null) {
                this.floatData = data;
                this.numberDataItems = data.length;
            } else {
                int size1 = this.rawBytes.length / 4;
                int size2 = data.length;
                if (Integer.MAX_VALUE - size1 < size2) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.floatData = new float[size1 + size2];
                ByteDataTransformer.toFloatArray(this.rawBytes, this.byteOrder, this.floatData, 0);
                System.arraycopy(data, 0, this.floatData, size1, size2);
                this.numberDataItems = size1 + size2;
            }
        } else {
            int size1 = this.floatData.length;
            int size2 = data.length;
            if (Integer.MAX_VALUE - size1 < size2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.floatData = Arrays.copyOf(this.floatData, size1 + size2);
            System.arraycopy(data, 0, this.floatData, size1, size2);
            this.numberDataItems += data.length;
        }
        this.rawBytes = ByteDataTransformer.toBytes(this.floatData, this.byteOrder);
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendStringData(String s) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.CHARSTAR8) {
            throw new EvioException("Tried to append string to a structure of type: " + (Object)((Object)dataType));
        }
        if (s == null) {
            return;
        }
        if (this.stringData == null) {
            if (this.rawBytes == null) {
                this.stringsList = new LinkedList();
                this.stringData = new StringBuffer(s.length() + 1);
                this.numberDataItems = 1;
            } else {
                this.unpackRawBytesToStrings();
                this.stringData.delete(this.stringEnd, this.stringData.length());
                this.numberDataItems = this.stringsList.size() + 1;
            }
        } else {
            this.stringData.delete(this.stringEnd, this.stringData.length());
            ++this.numberDataItems;
        }
        this.stringsList.add(s);
        this.stringData.append(s);
        this.stringData.append('\u0000');
        this.stringEnd = this.stringData.length();
        int[] pads = new int[]{4, 3, 2, 1};
        switch (pads[this.stringData.length() % 4]) {
            case 4: {
                this.stringData.append("\u0004\u0004\u0004\u0004");
                break;
            }
            case 3: {
                this.stringData.append("\u0004\u0004\u0004");
                break;
            }
            case 2: {
                this.stringData.append("\u0004\u0004");
                break;
            }
            case 1: {
                this.stringData.append('\u0004');
            }
        }
        try {
            this.rawBytes = this.stringData.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendDoubleData(double[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.DOUBLE64) {
            throw new EvioException("Tried to append double data to a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null) {
            return;
        }
        if (this.doubleData == null) {
            if (this.rawBytes == null) {
                this.doubleData = data;
                this.numberDataItems = data.length;
            } else {
                int size1 = this.rawBytes.length / 8;
                int size2 = data.length;
                if (Integer.MAX_VALUE - size1 < size2) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.doubleData = new double[size1 + size2];
                ByteDataTransformer.toDoubleArray(this.rawBytes, this.byteOrder, this.doubleData, 0);
                System.arraycopy(data, 0, this.doubleData, size1, size2);
                this.numberDataItems = size1 + size2;
            }
        } else {
            int size1 = this.doubleData.length;
            int size2 = data.length;
            if (Integer.MAX_VALUE - size1 < size2) {
                throw new EvioException("added data overflowed containing structure");
            }
            this.doubleData = Arrays.copyOf(this.doubleData, size1 + size2);
            System.arraycopy(data, 0, this.doubleData, size1, size2);
            this.numberDataItems += data.length;
        }
        this.rawBytes = ByteDataTransformer.toBytes(this.doubleData, this.byteOrder);
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void appendCompositeData(CompositeData[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.COMPOSITE) {
            throw new EvioException("Tried to set composite data in a structure of type: " + (Object)((Object)dataType));
        }
        if (data == null || data.length < 1) {
            return;
        }
        if (this.compositeData == null) {
            if (this.rawBytes == null) {
                this.compositeData = data;
                this.numberDataItems = data.length;
            } else {
                int i;
                CompositeData[] cdArray = CompositeData.parse(this.rawBytes, this.byteOrder);
                int len1 = cdArray.length;
                int len2 = data.length;
                int totalLen = len1 + len2;
                if (Integer.MAX_VALUE - len1 < len2) {
                    throw new EvioException("added data overflowed containing structure");
                }
                this.compositeData = new CompositeData[totalLen];
                for (i = 0; i < len1; ++i) {
                    this.compositeData[i] = cdArray[i];
                }
                for (i = len1; i < totalLen; ++i) {
                    this.compositeData[i] = cdArray[i];
                }
                this.numberDataItems = totalLen;
            }
        } else {
            int i;
            int len1 = this.compositeData.length;
            int len2 = data.length;
            int totalLen = len1 + len2;
            if (Integer.MAX_VALUE - len1 < len2) {
                throw new EvioException("added data overflowed containing structure");
            }
            CompositeData[] cdArray = this.compositeData;
            this.compositeData = new CompositeData[totalLen];
            for (i = 0; i < len1; ++i) {
                this.compositeData[i] = cdArray[i];
            }
            for (i = len1; i < totalLen; ++i) {
                this.compositeData[i] = cdArray[i];
            }
            this.numberDataItems = totalLen;
        }
        this.rawBytes = CompositeData.generateRawBytes(this.compositeData);
        this.byteOrder = data[0].getByteOrder();
        this.lengthsUpToDate(false);
        this.setAllHeaderLengths();
    }

    public void setIntData(int[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.INT32 && dataType != DataType.UINT32) {
            this.header.setDataType(DataType.INT32);
        }
        this.clearData();
        this.appendIntData(data);
    }

    public void setShortData(short[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.SHORT16 && dataType != DataType.USHORT16) {
            this.header.setDataType(DataType.SHORT16);
        }
        this.clearData();
        this.appendShortData(data);
    }

    public void setLongData(long[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.LONG64 && dataType != DataType.ULONG64) {
            this.header.setDataType(DataType.LONG64);
        }
        this.clearData();
        this.appendLongData(data);
    }

    public void setByteData(byte[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.CHAR8 && dataType != DataType.UCHAR8) {
            this.header.setDataType(DataType.CHAR8);
        }
        this.clearData();
        this.appendByteData(data);
    }

    public void setFloatData(float[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.FLOAT32) {
            this.header.setDataType(DataType.FLOAT32);
        }
        this.clearData();
        this.appendFloatData(data);
    }

    public void setDoubleData(double[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.DOUBLE64) {
            this.header.setDataType(DataType.DOUBLE64);
        }
        this.clearData();
        this.appendDoubleData(data);
    }

    public void setStringData(String[] data) {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.CHARSTAR8) {
            this.header.setDataType(DataType.CHARSTAR8);
        }
        this.clearData();
        for (String str : data) {
            try {
                this.appendStringData(str);
            }
            catch (EvioException e) {
                // empty catch block
            }
        }
    }

    public void setCompositeData(CompositeData[] data) throws EvioException {
        DataType dataType = this.header.getDataType();
        if (dataType != DataType.COMPOSITE) {
            this.header.setDataType(DataType.COMPOSITE);
        }
        this.clearData();
        this.appendCompositeData(data);
    }
}

