/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jlab.coda.et.EtConstants;
import org.jlab.coda.et.system.ClientThread;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

class SystemTcpServer
extends Thread {
    private int port;
    private SystemCreate sys;
    private SystemConfig config;
    private ThreadGroup tGroup;

    SystemTcpServer(SystemCreate sys, ThreadGroup tGroup) {
        super(tGroup, "tcpServerThread");
        this.sys = sys;
        this.tGroup = tGroup;
        this.config = sys.getConfig();
        this.port = this.config.getServerPort();
    }

    @Override
    public void run() {
        if (this.config.getDebug() >= 4) {
            System.out.println("Running TCP Server Thread");
        }
        if (this.port < 1) {
            this.port = 11111;
        }
        try {
            int BYTES_TO_READ = 12;
            ByteBuffer buffer = ByteBuffer.allocateDirect(BYTES_TO_READ);
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.socket().setReuseAddress(true);
            serverChannel.socket().setSoTimeout(2000);
            if (this.config.getTcpRecvBufSize() > 0) {
                serverChannel.socket().setReceiveBufferSize(this.config.getTcpRecvBufSize());
            }
            serverChannel.socket().bind(new InetSocketAddress(this.port));
            while (true) {
                Socket sock;
                SocketChannel channel;
                try {
                    channel = serverChannel.accept();
                    sock = channel.socket();
                }
                catch (InterruptedIOException ex) {
                    if (!this.sys.killAllThreads()) continue;
                    return;
                }
                sock.setSoTimeout(500);
                if (this.config.getTcpSendBufSize() > 0) {
                    sock.setSendBufferSize(this.sys.getConfig().getTcpSendBufSize());
                }
                if (this.config.isNoDelay()) {
                    sock.setTcpNoDelay(this.config.isNoDelay());
                }
                int bytesRead = 0;
                int loops = 0;
                buffer.clear();
                buffer.limit(BYTES_TO_READ);
                channel.configureBlocking(false);
                while (bytesRead < BYTES_TO_READ) {
                    int bytes = channel.read(buffer);
                    if (bytes == -1) {
                        channel.close();
                        continue;
                    }
                    if ((bytesRead += bytes) >= BYTES_TO_READ) {
                        buffer.flip();
                        int magic1 = buffer.getInt();
                        int magic2 = buffer.getInt();
                        int magic3 = buffer.getInt();
                        if (magic1 == EtConstants.magicNumbers[0] && magic2 == EtConstants.magicNumbers[1] && magic3 == EtConstants.magicNumbers[2]) continue;
                        channel.close();
                        continue;
                    }
                    if (++loops > 10) {
                        channel.close();
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                }
                channel.configureBlocking(true);
                ClientThread connection = new ClientThread(this.sys, channel.socket(), this.tGroup);
                connection.start();
            }
        }
        catch (SocketException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

