/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.jlab.coda.et.EtConstants;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

class ListeningThread
extends Thread {
    private SystemCreate sys;
    private SystemConfig config;
    private DatagramSocket sock;
    private int cast;
    private String incomingAddress = "0.0.0.0";
    private static int counter = 0;

    ListeningThread(SystemCreate sys, MulticastSocket mSock, ThreadGroup tGroup) throws IOException {
        super(tGroup, "listenThread" + counter++);
        this.sys = sys;
        this.config = sys.getConfig();
        for (InetAddress address : this.config.getMulticastAddrs()) {
            if (!address.isMulticastAddress()) continue;
            mSock.joinGroup(address);
        }
        this.sock = mSock;
        this.cast = 3;
    }

    ListeningThread(SystemCreate sys, DatagramSocket sock, ThreadGroup tGroup) throws UnknownHostException {
        super(tGroup, "listenThread" + counter++);
        this.sys = sys;
        this.config = sys.getConfig();
        this.sock = sock;
        this.cast = 1;
    }

    @Override
    public void run() {
        byte[] rBuffer = new byte[1024];
        DatagramPacket rPacket = new DatagramPacket(rBuffer, 1024);
        byte[] etNameBytes = new byte[101];
        ByteArrayOutputStream baos = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String canon = addr.getCanonicalHostName();
            String hostName = addr.getHostName();
            int bufferSize = 44 + this.incomingAddress.length() + hostName.length() + canon.length() + 3;
            for (InetAddress netAddress : this.sys.getNetAddresses()) {
                bufferSize += 8 + netAddress.getHostAddress().length() + 1;
            }
            for (String address : this.sys.broadAddresses) {
                bufferSize += 4 + address.length() + 1;
            }
            baos = new ByteArrayOutputStream(bufferSize);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(EtConstants.magicNumbers[0]);
            dos.writeInt(EtConstants.magicNumbers[1]);
            dos.writeInt(EtConstants.magicNumbers[2]);
            dos.writeInt(15);
            dos.writeInt(this.config.getServerPort());
            dos.writeInt(this.cast);
            dos.writeInt(this.incomingAddress.length() + 1);
            dos.write(this.incomingAddress.getBytes("ASCII"));
            dos.writeByte(0);
            dos.writeInt(hostName.length() + 1);
            dos.write(hostName.getBytes("ASCII"));
            dos.writeByte(0);
            dos.writeInt(canon.length() + 1);
            dos.write(canon.getBytes("ASCII"));
            dos.writeByte(0);
            dos.writeInt(this.sys.getNetAddresses().length);
            for (InetAddress netAddress : this.sys.getNetAddresses()) {
                int addr32 = 0;
                for (int j = 0; j < 4; ++j) {
                    addr32 = addr32 << 8 | netAddress.getAddress()[j] & 0xFF;
                }
                dos.writeInt(addr32);
                dos.writeInt(netAddress.getHostAddress().length() + 1);
                dos.write(netAddress.getHostAddress().getBytes("ASCII"));
                dos.writeByte(0);
            }
            dos.writeInt(this.sys.broadAddresses.length);
            for (String address : this.sys.broadAddresses) {
                dos.writeInt(address.length() + 1);
                dos.write(address.getBytes("ASCII"));
                dos.writeByte(0);
            }
            dos.flush();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] sBuffer = baos.toByteArray();
        while (true) {
            try {
                while (true) {
                    try {
                        this.sock.receive(rPacket);
                    }
                    catch (InterruptedIOException ex) {
                        if (!this.sys.killAllThreads()) continue;
                        return;
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(rPacket.getData());
                    DataInputStream dis = new DataInputStream(bais);
                    int magic1 = dis.readInt();
                    int magic2 = dis.readInt();
                    int magic3 = dis.readInt();
                    if (magic1 != EtConstants.magicNumbers[0] || magic2 != EtConstants.magicNumbers[1] || magic3 != EtConstants.magicNumbers[2]) {
                        System.out.println("SystemUdpServer:  Magic numbers did NOT match");
                        continue;
                    }
                    int version = dis.readInt();
                    int length = dis.readInt();
                    if (version != 15 || length < 1 || length > 101) continue;
                    if (length > etNameBytes.length) {
                        etNameBytes = new byte[length];
                    }
                    dis.readFully(etNameBytes, 0, length - 1);
                    String etName = new String(etNameBytes, 0, length - 1, "US-ASCII");
                    if (this.config.getDebug() >= 4) {
                        System.out.println("et_listen_thread: received packet from " + rPacket.getAddress().getHostName() + " @ " + rPacket.getAddress().getHostAddress() + " for " + etName);
                    }
                    if (!etName.equals(this.sys.getName())) continue;
                    DatagramPacket sPacket = new DatagramPacket(sBuffer, sBuffer.length, rPacket.getAddress(), rPacket.getPort());
                    if (this.config.getDebug() >= 4) {
                        System.out.println("et_listen_thread: send return packet");
                    }
                    this.sock.send(sPacket);
                }
            }
            catch (IOException ex) {
                if (this.config.getDebug() < 2) continue;
                System.out.println("error handling UDP packets");
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

