/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.enums.Priority;
import org.jlab.coda.et.exception.EtEmptyException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtWakeUpException;
import org.jlab.coda.et.system.AttachmentLocal;

class EventList {
    private ArrayList<EtEventImpl> events;
    private long eventsIn;
    private long eventsOut;
    private long eventsTry;
    private boolean wakeAll;
    private int waitingCount;
    private int lastHigh;

    EventList(int listSize) {
        this.events = new ArrayList(listSize);
    }

    ArrayList<EtEventImpl> getEvents() {
        return this.events;
    }

    long getEventsTry() {
        return this.eventsTry;
    }

    void setEventsTry(long eventsTry) {
        this.eventsTry = eventsTry;
    }

    long getEventsIn() {
        return this.eventsIn;
    }

    void setEventsIn(long eventsIn) {
        this.eventsIn = eventsIn;
    }

    long getEventsOut() {
        return this.eventsOut;
    }

    void setEventsOut(long eventsOut) {
        this.eventsOut = eventsOut;
    }

    synchronized void wakeUp(AttachmentLocal att) {
        if (!att.isWaiting()) {
            return;
        }
        att.setWakeUp(true);
        this.notifyAll();
    }

    synchronized void wakeUpAll() {
        if (this.waitingCount < 1) {
            return;
        }
        this.wakeAll = true;
        this.notifyAll();
    }

    void putInLow(List<EtEventImpl> newEvents) {
        this.events.addAll(newEvents);
        this.eventsIn += (long)newEvents.size();
    }

    synchronized void putInGC(EtEventImpl[] newEvents) {
        this.putInLow(Arrays.asList(newEvents));
    }

    synchronized void putInGC(List<EtEventImpl> newEvents) {
        this.putInLow(newEvents);
    }

    void putAll(List<EtEventImpl> newEvents) {
        int num = newEvents.size();
        if (this.events.size() == 0 || newEvents.get(0).getPriority() == Priority.LOW) {
            this.events.addAll(newEvents);
        } else {
            EtEvent ev;
            int highCount = 0;
            Iterator<EtEventImpl> i$ = this.events.iterator();
            while (i$.hasNext() && (ev = (EtEvent)i$.next()).getPriority() == Priority.HIGH) {
                ++highCount;
            }
            int newHighCount = 0;
            for (EtEventImpl ev2 : newEvents) {
                if (ev2.getPriority() != Priority.HIGH) break;
                this.events.add(highCount + newHighCount++, ev2);
            }
            if (newHighCount < num) {
                this.events.addAll(newEvents.subList(newHighCount, num));
            }
        }
        this.eventsIn += (long)num;
    }

    synchronized void put(EtEventImpl[] newEvents) {
        if (this.events.size() == 0) {
            this.lastHigh = 0;
        }
        for (EtEventImpl ev : newEvents) {
            if (ev.getPriority() == Priority.LOW) {
                this.events.add(ev);
                continue;
            }
            this.events.add(this.lastHigh++, ev);
        }
        this.notify();
    }

    synchronized void put(List<EtEventImpl> newEvents) {
        if (this.events.size() == 0) {
            this.lastHigh = 0;
        }
        for (EtEventImpl ev : newEvents) {
            if (ev.getPriority() == Priority.LOW) {
                this.events.add(ev);
                continue;
            }
            this.events.add(this.lastHigh++, ev);
        }
        this.notify();
    }

    synchronized void putReverse(List<EtEventImpl> newEvents) {
        if (this.events.size() == 0) {
            this.lastHigh = 0;
        } else {
            EtEvent ev;
            int highCount = 0;
            Iterator<EtEventImpl> i$ = this.events.iterator();
            while (i$.hasNext() && (ev = (EtEvent)i$.next()).getPriority() == Priority.HIGH) {
                ++highCount;
            }
            this.lastHigh = highCount;
        }
        for (EtEventImpl ev : newEvents) {
            if (ev.getPriority() == Priority.LOW) {
                this.events.add(this.lastHigh, ev);
                continue;
            }
            this.events.add(0, ev);
            ++this.lastHigh;
        }
        this.notify();
    }

    synchronized void get(List<EtEventImpl> eventsToGo) {
        eventsToGo.addAll(this.events);
        this.eventsOut += (long)this.events.size();
        this.events.clear();
    }

    synchronized EtEventImpl[] get(AttachmentLocal att, int mode, int microSec, int quantity) throws EtEmptyException, EtWakeUpException, EtTimeoutException {
        int count = this.events.size();
        long elapsedTime = 0L;
        if (count == 0) {
            if (mode == 0) {
                while (count < 1) {
                    ++this.waitingCount;
                    att.setWaiting(true);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (att.isWakeUp() || this.wakeAll) {
                        att.setWakeUp(false);
                        att.setWaiting(false);
                        if (--this.waitingCount < 1) {
                            this.wakeAll = false;
                        }
                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                    }
                    att.setWaiting(false);
                    --this.waitingCount;
                    count = this.events.size();
                }
            } else if (mode == 1) {
                while (count < 1) {
                    long microDelay = (long)microSec - 1000L * elapsedTime;
                    if (microDelay <= 0L) {
                        throw new EtTimeoutException("timed out");
                    }
                    long milliSec = microDelay / 1000L;
                    int nanos = 1000 * (int)(microDelay - 1000L * milliSec);
                    ++this.waitingCount;
                    att.setWaiting(true);
                    long begin = System.currentTimeMillis();
                    try {
                        this.wait(milliSec, nanos);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    elapsedTime += System.currentTimeMillis() - begin;
                    if (att.isWakeUp() || this.wakeAll) {
                        att.setWakeUp(false);
                        att.setWaiting(false);
                        if (--this.waitingCount < 1) {
                            this.wakeAll = false;
                        }
                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                    }
                    att.setWaiting(false);
                    --this.waitingCount;
                    count = this.events.size();
                }
            } else if (mode == 2) {
                throw new EtEmptyException("no events in list");
            }
        }
        if (quantity > count) {
            quantity = count;
        }
        List<EtEventImpl> deleteList = this.events.subList(0, quantity);
        EtEventImpl[] eventsToGo = new EtEventImpl[quantity];
        deleteList.toArray(eventsToGo);
        deleteList.clear();
        this.eventsOut += (long)quantity;
        return eventsToGo;
    }

    synchronized List<EtEventImpl> get(AttachmentLocal att, int mode, int microSec, int quantity, int group) throws EtEmptyException, EtWakeUpException, EtTimeoutException {
        int count = this.events.size();
        int groupCount = 0;
        boolean scanList = true;
        long elapsedTime = 0L;
        LinkedList<EtEventImpl> groupList = new LinkedList<EtEventImpl>();
        do {
            if (mode == 0) {
                while (count < 1 || !scanList) {
                    ++this.waitingCount;
                    att.setWaiting(true);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (att.isWakeUp() || this.wakeAll) {
                        att.setWakeUp(false);
                        att.setWaiting(false);
                        if (--this.waitingCount < 1) {
                            this.wakeAll = false;
                        }
                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                    }
                    att.setWaiting(false);
                    --this.waitingCount;
                    count = this.events.size();
                    scanList = true;
                }
            } else if (mode == 1) {
                while (count < 1 || !scanList) {
                    long microDelay = (long)microSec - 1000L * elapsedTime;
                    if (microDelay <= 0L) {
                        throw new EtTimeoutException("timed out");
                    }
                    long milliSec = microDelay / 1000L;
                    int nanos = 1000 * (int)(microDelay - 1000L * milliSec);
                    ++this.waitingCount;
                    att.setWaiting(true);
                    long begin = System.currentTimeMillis();
                    try {
                        this.wait(milliSec, nanos);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    elapsedTime += System.currentTimeMillis() - begin;
                    if (att.isWakeUp() || this.wakeAll) {
                        att.setWakeUp(false);
                        att.setWaiting(false);
                        if (--this.waitingCount < 1) {
                            this.wakeAll = false;
                        }
                        throw new EtWakeUpException("attachment " + att.getId() + " woken up");
                    }
                    att.setWaiting(false);
                    --this.waitingCount;
                    count = this.events.size();
                    scanList = true;
                }
            } else if (mode == 2) {
                throw new EtEmptyException("no events in list");
            }
            if (quantity > count) {
                quantity = count;
            }
            ListIterator<EtEventImpl> liter = this.events.listIterator();
            while (liter.hasNext()) {
                EtEventImpl ev = liter.next();
                if (ev.getGroup() != group) continue;
                groupList.add(ev);
                if (++groupCount < quantity) continue;
            }
            scanList = false;
        } while (groupCount == 0 && mode != 2);
        this.events.removeAll(groupList);
        this.eventsOut += (long)groupList.size();
        return groupList;
    }
}

