/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private boolean enforceLimits = false;
    private int upperLimit = 0;
    private int lowerLimit = 0;

    public WholeNumberField(int value, int columns) {
        super(columns);
        this.setValue(value);
    }

    public WholeNumberField(int value, int columns, int limit1, int limit2) {
        super(columns);
        this.enforceLimits = true;
        this.setLimits(limit1, limit2);
        this.setValue(value);
    }

    private int adjustValue(int value) {
        if (this.enforceLimits) {
            if (value > this.upperLimit) {
                value = this.upperLimit;
            } else if (value < this.lowerLimit) {
                value = this.lowerLimit;
            }
        }
        return value;
    }

    public int getValue() {
        int value = 0;
        try {
            value = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            this.toolkit.beep();
        }
        value = this.adjustValue(value);
        return value;
    }

    public void correctValue() {
        int value = 0;
        try {
            value = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            this.toolkit.beep();
        }
        this.setValue(value);
    }

    public void setValue(int value) {
        value = this.adjustValue(value);
        this.setText("" + value);
    }

    public void setLimits(int limit1, int limit2) {
        this.enforceLimits = true;
        if (limit1 >= limit2) {
            this.upperLimit = limit1;
            this.lowerLimit = limit2;
        } else {
            this.upperLimit = limit2;
            this.lowerLimit = limit1;
        }
    }

    public void removeLimits() {
        this.enforceLimits = false;
    }

    public void setUpperLimit(int limit) {
        this.enforceLimits = true;
        this.upperLimit = limit;
    }

    public void setLowerLimit(int limit) {
        this.enforceLimits = true;
        this.lowerLimit = limit;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (offs == 0 && i == 0 && source[0] == '-') {
                    result[j++] = source[0];
                    if (result.length != 1) continue;
                    super.insertString(0, new String(source, 0, 1), a);
                    return;
                }
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                WholeNumberField.this.toolkit.beep();
            }
            String number = new String(this.getText(0, offs) + new String(result, 0, j));
            super.remove(0, offs);
            super.insertString(0, number, a);
        }
    }
}

