/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jlab.coda.et.EtUtils;

public class AddressJList
extends JPanel
implements ListSelectionListener {
    private JList<String> list;
    private DefaultListModel<String> listModel;
    private static final String addString = "Add";
    private static final String deleteString = "Delete";
    private JButton deleteButton;
    private JTextField netAddress;
    private boolean forMulticasting;

    public AddressJList() {
        this(false);
    }

    public AddressJList(boolean forMulticasting) {
        super(new BorderLayout(0, 10));
        this.forMulticasting = forMulticasting;
        this.listModel = new DefaultListModel();
        this.list = new JList<String>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        this.list.setVisibleRowCount(4);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        JButton addButton = new JButton(addString);
        AddListener addListener = new AddListener(addButton);
        addButton.setActionCommand(addString);
        addButton.addActionListener(addListener);
        addButton.setEnabled(false);
        this.deleteButton = new JButton(deleteString);
        this.deleteButton.setActionCommand(deleteString);
        this.deleteButton.addActionListener(new DeleteListener());
        this.deleteButton.setEnabled(false);
        this.netAddress = new JTextField(0);
        this.netAddress.addActionListener(addListener);
        this.netAddress.getDocument().addDocumentListener(addListener);
        JPanel buttonPane2 = new JPanel();
        buttonPane2.setLayout(new GridLayout(1, 2, 5, 0));
        buttonPane2.add(this.deleteButton);
        buttonPane2.add(addButton);
        JPanel buttonPane1 = new JPanel();
        buttonPane1.setLayout(new BorderLayout(0, 2));
        buttonPane1.add((Component)this.netAddress, "North");
        buttonPane1.add((Component)buttonPane2, "South");
        this.add((Component)listScrollPane, "Center");
        this.add((Component)buttonPane1, "South");
    }

    public synchronized void setTextColor(Color color) {
        this.list.setForeground(color);
    }

    public synchronized void clearAddresses() {
        this.listModel.removeAllElements();
    }

    public synchronized void addAddress(String address) {
        if (address == null) {
            return;
        }
        this.addAddressToJList(address, false);
    }

    public synchronized void addAddresses(Collection<String> addresses) {
        if (addresses == null) {
            return;
        }
        for (String addr : addresses) {
            this.addAddressToJList(addr, false);
        }
    }

    public synchronized List<String> getAddresses() {
        ArrayList<String> list = new ArrayList<String>(10);
        Enumeration<String> en = this.listModel.elements();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    public boolean addressAlreadyListed(String address) {
        return this.listModel.contains(address);
    }

    private void addAddressToJList(String addr, boolean hitAddButton) {
        int index;
        if (addr.equals("") || this.addressAlreadyListed(addr)) {
            Toolkit.getDefaultToolkit().beep();
            this.netAddress.requestFocusInWindow();
            this.netAddress.selectAll();
            return;
        }
        if (EtUtils.isDottedDecimal(addr) == null) {
            Toolkit.getDefaultToolkit().beep();
            this.netAddress.requestFocusInWindow();
            this.netAddress.selectAll();
            if (hitAddButton) {
                JOptionPane.showMessageDialog(new JFrame(), "Address not in dotted-decimal format", "Error", 0);
            }
            return;
        }
        if (this.forMulticasting) {
            try {
                InetAddress a = InetAddress.getByName(addr);
                if (!a.isMulticastAddress()) {
                    if (hitAddButton) {
                        JOptionPane.showMessageDialog(new JFrame(), "Address not a multicast address", "Error", 0);
                    }
                    return;
                }
            }
            catch (UnknownHostException e1) {
                if (hitAddButton) {
                    JOptionPane.showMessageDialog(new JFrame(), "Address not a multicast address", "Error", 0);
                }
                return;
            }
        }
        index = (index = this.list.getSelectedIndex()) == -1 ? 0 : ++index;
        this.listModel.insertElementAt(addr, index);
        if (hitAddButton) {
            this.netAddress.requestFocusInWindow();
            this.netAddress.setText("");
        }
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.deleteButton.setEnabled(false);
            } else {
                this.deleteButton.setEnabled(true);
            }
        }
    }

    class AddListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public AddListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddressJList.this.addAddressToJList(AddressJList.this.netAddress.getText(), true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleEmptyTextField(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!this.handleEmptyTextField(e)) {
                this.enableButton();
            }
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent e) {
            if (e.getDocument().getLength() <= 0) {
                this.button.setEnabled(false);
                this.alreadyEnabled = false;
                return true;
            }
            return false;
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = AddressJList.this.list.getSelectedIndex();
            AddressJList.this.listModel.remove(index);
            int size = AddressJList.this.listModel.getSize();
            if (size == 0) {
                AddressJList.this.deleteButton.setEnabled(false);
            } else {
                if (index == AddressJList.this.listModel.getSize()) {
                    --index;
                }
                AddressJList.this.list.setSelectedIndex(index);
                AddressJList.this.list.ensureIndexIsVisible(index);
            }
        }
    }
}

