/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.exception.EtBusyException;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtDeadException;
import org.jlab.coda.et.exception.EtEmptyException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtWakeUpException;

class EtJniAccess {
    static ReentrantLock classLock = new ReentrantLock();
    static HashMap<String, EtJniAccess> classMap = new HashMap(10);
    static boolean jniLibLoaded;
    private int numberOpens;
    private long localEtId;
    private String etSystemName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EtJniAccess getInstance(String etName) throws EtException, EtTimeoutException {
        try {
            classLock.lock();
            if (!jniLibLoaded) {
                try {
                    System.loadLibrary("et_jni");
                }
                catch (Error e) {
                    throw new EtException("Error loading libet_jni.so");
                }
            }
            jniLibLoaded = true;
            if (classMap.containsKey(etName)) {
                EtJniAccess jni = classMap.get(etName);
                ++jni.numberOpens;
                EtJniAccess etJniAccess = jni;
                return etJniAccess;
            }
            EtJniAccess jni = new EtJniAccess();
            jni.openLocalEtSystem(etName);
            jni.etSystemName = etName;
            jni.numberOpens = 1;
            classMap.put(etName, jni);
            EtJniAccess etJniAccess = jni;
            return etJniAccess;
        }
        finally {
            classLock.unlock();
        }
    }

    private EtJniAccess() {
    }

    long getLocalEtId() {
        return this.localEtId;
    }

    private void setLocalEtId(long id) {
        this.localEtId = id;
    }

    private native void openLocalEtSystem(String var1) throws EtException, EtTimeoutException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            classLock.lock();
            --this.numberOpens;
            if (this.numberOpens < 1) {
                classMap.remove(this.etSystemName);
                this.closeLocalEtSystem(this.localEtId);
            }
        }
        finally {
            classLock.unlock();
        }
    }

    private native void closeLocalEtSystem(long var1);

    native void putEvents(long var1, int var3, EtEventImpl[] var4, int var5) throws EtException, EtDeadException, EtClosedException;

    native void dumpEvents(long var1, int var3, EtEventImpl[] var4, int var5) throws EtException, EtDeadException, EtClosedException;

    native EtEventImpl[] getEvents(long var1, int var3, int var4, int var5, int var6, int var7) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException;

    native EtEventImpl[] newEvents(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9) throws EtException, EtDeadException, EtClosedException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException;
}

