/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.IOException;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.exception.EtException;

public class EtAttachment {
    private int id;
    private EtSystem sys;
    private EtStation station;
    private boolean usable;

    EtAttachment(EtStation station, int id, EtSystem sys) {
        this.id = id;
        this.sys = sys;
        this.station = station;
    }

    public EtStation getStation() {
        return this.station;
    }

    public int getId() {
        return this.id;
    }

    public boolean isUsable() {
        return this.usable;
    }

    void setUsable(boolean usable) {
        this.usable = usable;
    }

    public EtSystem getSys() {
        return this.sys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLongValue(int cmd) throws IOException, EtException {
        long val;
        int err;
        EtSystem etSystem = this.sys;
        synchronized (etSystem) {
            this.sys.getOutputStream().writeInt(cmd);
            this.sys.getOutputStream().writeInt(this.id);
            this.sys.getOutputStream().flush();
            err = this.sys.getInputStream().readInt();
            val = this.sys.getInputStream().readLong();
        }
        if (err != 0) {
            throw new EtException("this station has been revmoved from ET system");
        }
        return val;
    }

    public long getEventsPut() throws IOException, EtException {
        return this.getLongValue(130);
    }

    public long getEventsGet() throws IOException, EtException {
        return this.getLongValue(131);
    }

    public long getEventsDump() throws IOException, EtException {
        return this.getLongValue(132);
    }

    public long getEventsMake() throws IOException, EtException {
        return this.getLongValue(133);
    }
}

