/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpen;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.monitorGui.AddressJList;
import org.jlab.coda.et.monitorGui.ConnectionThread;
import org.jlab.coda.et.monitorGui.MonitorConfiguration;
import org.jlab.coda.et.monitorGui.MonitorSingleSystem;
import org.jlab.coda.et.monitorGui.WholeNumberField;
import org.xml.sax.SAXException;

public class Monitor
extends JFrame {
    private static MonitorConfiguration config;
    private static File configurationFile;
    private final JTabbedPane tabbedPane;
    private final JFrame openFrame;
    private final JMenu disconnectMenu;
    private final JMenu loadConnectionParametersMenu;
    private AddressJList bAddress;
    private AddressJList mAddress;
    private JComboBox<String> etName;
    private JComboBox<String> hostname;
    private JComboBox<String> cast;
    private WholeNumberField ttl;
    private WholeNumberField udpPort;
    private WholeNumberField mcastPort;
    private WholeNumberField tcpPort;
    private WholeNumberField period;
    private JButton connect;
    private JCheckBox allBroadcastAddrsBox;
    private String currentMonitorKey;
    private int defaultPeriod;
    private Color entryColor = Color.blue;
    private List<String> broadcastAddresses;
    private boolean multicasting = false;
    private boolean broadcasting = true;
    public final Map<String, EtSystem> connections = Collections.synchronizedMap(new HashMap(20));
    public final Map<String, MonitorSingleSystem> monitors = Collections.synchronizedMap(new HashMap(20));

    public Monitor() {
        this((Dimension)null, (Point)null);
    }

    public Monitor(Dimension frameSize, Point frameLocation) {
        super("ET System Monitor");
        if (frameLocation != null) {
            this.setLocation(frameLocation);
        }
        this.defaultPeriod = 5;
        this.tabbedPane = new JTabbedPane();
        if (frameSize == null) {
            frameSize = new Dimension(1100, 700);
        }
        this.tabbedPane.setPreferredSize(frameSize);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane source = (JTabbedPane)e.getSource();
                int tabIndex = source.getSelectedIndex();
                if (tabIndex < 1) {
                    Monitor.this.period.setValue(Monitor.this.defaultPeriod);
                    Monitor.this.currentMonitorKey = "Help";
                    return;
                }
                Monitor.this.currentMonitorKey = source.getTitleAt(tabIndex);
                int updatePeriod = Monitor.this.monitors.get(Monitor.this.currentMonitorKey).getUpdatePeriod();
                Monitor.this.period.setValue(updatePeriod);
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.openFrame = new JFrame("Open ET System");
        this.disconnectMenu = new JMenu("Disconnect");
        this.loadConnectionParametersMenu = new JMenu("Load Connection Parameters");
        this.makeEtOpenWindow();
        this.makeMenubar();
        this.tabbedPane.addTab("Help", null, this.makeHelpPane(), "help");
        this.currentMonitorKey = "Help";
    }

    private void setUpdatePeriod() {
        if (this.currentMonitorKey.equals("Help")) {
            return;
        }
        int updatePeriod = this.period.getValue();
        MonitorSingleSystem mon = this.monitors.get(this.currentMonitorKey);
        mon.setUpdatePeriod(updatePeriod);
    }

    public void addFileName(String name) {
        boolean nameIsThere = false;
        int count = this.etName.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals(this.etName.getItemAt(i))) continue;
            return;
        }
        if (!nameIsThere) {
            this.etName.addItem(name);
        }
    }

    public boolean addHostname(String name) {
        if (name.equals(".local") || name.equals(".remote") || name.equals(".anywhere")) {
            return false;
        }
        boolean nameIsThere = false;
        int count = this.hostname.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals(this.hostname.getItemAt(i))) continue;
            return true;
        }
        if (!nameIsThere) {
            this.hostname.addItem(name);
        }
        return true;
    }

    public void addBroadcastAddress(String addr) {
        this.bAddress.addAddress(addr);
    }

    public void addMulticastAddress(String addr) {
        this.mAddress.addAddress(addr);
    }

    public String[] getFileNames() {
        int count = this.etName.getItemCount();
        if (count == 0) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this.etName.getItemAt(i);
        }
        return names;
    }

    public String[] getHostnames() {
        int count = this.hostname.getItemCount() - 3;
        if (count < 1) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this.hostname.getItemAt(i + 3);
        }
        return names;
    }

    public int getMonitorWidth() {
        return this.tabbedPane.getWidth();
    }

    public int getMonitorHeight() {
        return this.tabbedPane.getHeight();
    }

    private boolean isValidIpAddress(String addr) {
        StringTokenizer tok = new StringTokenizer(addr, ".");
        if (tok.countTokens() != 4) {
            return false;
        }
        try {
            while (tok.hasMoreTokens()) {
                String num = tok.nextToken();
                int number = Integer.parseInt(num);
                if (number < 0 || number > 255) {
                    return false;
                }
                if (num.charAt(0) != '0' || number == 0 && num.length() <= 1) continue;
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean isValidMulticastAddress(String addr) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return address.isMulticastAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Monitor frame = null;
            if (args.length > 0) {
                if (args.length != 2) {
                    System.out.println("Usage: java Monitor [-f,-file <configFile>]");
                    return;
                }
                if (!args[0].equalsIgnoreCase("-f") && !args[0].equalsIgnoreCase("-file")) {
                    System.out.println("Usage: java Monitor [-f,-file <configFile>]");
                    return;
                }
                configurationFile = new File(args[1]);
                config = new MonitorConfiguration(null);
                config.loadWindowParameters(configurationFile);
                Dimension size = config.getWindowSize();
                Point location = config.getWindowLocation();
                frame = new Monitor(size, location);
                config.setMonitor(frame);
                config.load(configurationFile);
            } else {
                frame = new Monitor();
                config = new MonitorConfiguration(frame);
            }
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.setVisible(true);
            MonitorSingleSystem mon = null;
            Object monNode = null;
            class Updater
            extends Thread {
                MonitorSingleSystem mon;

                public void setMonitor(MonitorSingleSystem m) {
                    this.mon = m;
                }

                public Updater(MonitorSingleSystem m) {
                    this.mon = m;
                }

                @Override
                public void run() {
                    if (this.mon.isInitialized()) {
                        this.mon.updateDisplay();
                        this.mon.treeDidChange();
                    } else {
                        this.mon.staticDisplay();
                        this.mon.updateDisplay();
                        this.mon.updateUI();
                    }
                }
            }
            Updater updater = new Updater(mon);
            while (true) {
                Map<String, MonitorSingleSystem> map = frame.monitors;
                synchronized (map) {
                    Iterator<Map.Entry<String, MonitorSingleSystem>> i = frame.monitors.entrySet().iterator();
                    while (i.hasNext()) {
                        mon = i.next().getValue();
                        try {
                            if (!mon.timeToUpdate()) continue;
                            mon.getData();
                            updater.setMonitor(mon);
                            SwingUtilities.invokeLater(updater);
                        }
                        catch (EtException ex) {
                        }
                        catch (Exception ex) {
                            String key = mon.getKey();
                            frame.removeConnection(frame, mon, key, false);
                            i.remove();
                            frame.connections.remove(key);
                        }
                    }
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception ex) {
            System.out.println("Unrecoverable error in ET monitor:");
            ex.printStackTrace();
            return;
        }
    }

    private void makeMenubar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        final JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        JMenuItem menuItem = new JMenuItem("Save Configuration");
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                if (configurationFile == null) {
                    if (fc.showSaveDialog(Monitor.this) == 1) {
                        return;
                    }
                    file = fc.getSelectedFile();
                } else {
                    file = configurationFile;
                }
                try {
                    config.save(file);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(new JFrame(), "Cannot write to file \"" + file.getName() + "\"", "Error", 0);
                    return;
                }
                configurationFile = file;
            }
        });
        menuItem = new JMenuItem("Save Configuration As");
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(Monitor.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        int n;
                        if (file.exists() && (n = JOptionPane.showConfirmDialog(new JFrame(), "Overwrite existing file?", "WARNING", 0)) == 1) {
                            return;
                        }
                        config.save(file);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Cannot write to file \"" + file.getName() + "\"", "Error", 0);
                        return;
                    }
                    configurationFile = file;
                }
            }
        });
        menuItem = new JMenuItem("Load Configuration");
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showDialog(Monitor.this, "Load");
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        config.load(file);
                    }
                    catch (SAXException ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Cannot load file \"" + file.getName() + "\"", "Error", 0);
                        return;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Cannot load file \"" + file.getName() + "\"", "Error", 0);
                        return;
                    }
                }
            }
        });
        menuItem = new JMenuItem("Quit");
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenu viewMenu = new JMenu("View");
        menuBar.add(viewMenu);
        this.period = new WholeNumberField(this.defaultPeriod, 5, 1, Integer.MAX_VALUE);
        this.period.setAlignmentX(0.0f);
        this.period.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
                Monitor.this.setUpdatePeriod();
            }
        });
        this.period.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
                Monitor.this.setUpdatePeriod();
            }
        });
        JMenu updatePeriod = new JMenu("Update Period (sec)");
        updatePeriod.add(this.period);
        viewMenu.add(updatePeriod);
        viewMenu.add(this.loadConnectionParametersMenu);
        menuItem = new JMenuItem("Change Orientation");
        viewMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Monitor.this.currentMonitorKey.equals("Help")) {
                    return;
                }
                MonitorSingleSystem mon = Monitor.this.monitors.get(Monitor.this.currentMonitorKey);
                int orient = mon.getOrientation();
                if (orient == 1) {
                    mon.setOrientation(0);
                } else {
                    mon.setOrientation(1);
                }
            }
        });
        JMenu connectMenu = new JMenu("Connections");
        menuBar.add(connectMenu);
        menuItem = new JMenuItem("Connect to ET System");
        connectMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitor.this.openFrame.setVisible(true);
                Monitor.this.openFrame.setState(0);
            }
        });
        connectMenu.add(this.disconnectMenu);
    }

    private JScrollPane makeHelpPane() {
        JTextArea text = new JTextArea(10, 200);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setTabSize(3);
        text.setEditable(false);
        text.setBorder(new EmptyBorder(20, 20, 20, 20));
        JScrollPane pane = new JScrollPane(text);
        text.append("CONNECTING TO AN ET SYSTEM\nSelect the \"Connect to ET System\" option of the \"Connections\" menu. There are a number of options on the appearing window which must be set.\n\n1) ET Name\nThis is the name of the ET system (actually, its file) that you want to connect to. The names of several ET systems can be stored in its list. The \"X\" button is for removing unwanted entries.\n\n2) ET Location\nTo look for the named ET system on the local computer or host, select \"local\". To look only on another computer, select \"remote\", or \"anywhere\" if you don't care where the ET system is. If you know the name of the computer, this is the place to type it in.\n\n3) Find ET by\nThere are several ways to connect to an ET system. The following list showing the available choices:\n\n\ta) broadcasting\nThis selection is generally chosen when the name of the host that the ET system is residing on is unknown or if the user wants to write a very general application with no hostnames \"hardcoded\" or input in some fashion. (If a specific hostname is used, a UDP packet is sent directly to that host in addition to a broadcast being made.)\nA UDP broadcast is made on all the subnet broadcast addresses listed in the \"Subnet Addresses\" entry. Items can be removed with the \"X\" button. This broadcast is sent to the port found in the \"UDP Port\" entry. Once an ET system receives the broadcast, it responds by sending its host name and the tcp port on which it is listening. This information is used to establish a permanent tcp connection.\n\n\tb) multicasting\nAs in broadcasting, this selection is generally chosen when the name of the host that the ET system is residing on is unknown or if the user wants to write a very general application with no hostnames \"hardcoded\" or input in some fashion. (If a specific hostname is used, a UDP packet is sent directly to that host on the port in the \"UDP Port\" entry in addition to a multicast being made.)\nA UDP multicast is made on all the multicast addresses listed in the \"Multicast Addresses\" entry. Items can be removed with the \"X\" button. This multicast is sent to the port found in the \"Multicast Port\" entry, and its \"ttl\" value can be set as well. (It defaults to \"1\" which should limit its scope to the local subnets.) Once an ET system receives the multicast, it responds by sending its host name and the tcp port on which it is listening. This information is used to establish a permanent tcp connection.\n\n\tc) broad & multicasting\nThis selection can simultaneously UDP broadcast and UDP multicast.\n\n\td) direct connection\nA direct, permanent tcp connection is made between the ET system and the user. In this case, a specific hostname must be used (not \"local\", \"remote\", or \"anywhere\"). The \"TCP Port\" entry is used for the port number.\n\nRESETTING CONNECTION PARAMETERS\nReseting all connection parameters to those previously used to make an actual connection can be done by selecting the \"Load connection parameters\" item from the \"View\" menu. Simply select from the list of existing connections.\n\n\n\nVIEWING AN ET SYSTEM\nAfter connecting to an ET system, a tab appears with the ET system's name on it. By selecting this tab, the user can see all the system parameters in text form on the left side of the window and a visual representation on the right side. Not all text information is relevant for all systems. For example, the ET systems written in Java do not have process or mutex information available. Text information is divided into sections with a short explanation of each following:\n\n1) System - general ET system parameters\n\ta) Static Info - information that does NOT change\n\t\tHost - host system is running on, language code was written in, and unix pid\n\t\tPorts - the tcp, udp, and multicast port numbers\n\t\tEvents - total # of events, size of each, # of temporary (extra large) events\n\t\tMax - maximum number of stations, attachments, and processes allowed\n\t\tNetwork interfaces - list of host's network interfaces\n\t\tMulticast addreses - list of multicast addresses the system is listening on\n\n\tb) Dynamic Info - information that can or will change in time\n\t\tEvents rate - rate of events leaving GRAND_CENTRAL station\n\t\tEvents owned by - number of events owned by each attachment & system.\n\t\tIdle stations - list of stations with no attachments (receive no events)\n\t\tAll stations - list of all stations in proper order\n\t\tStations - current number of stations, attachments, and temporary events\n\t\tProcesses - # of non-system, unix processes with access to shared memory (Solaris)\n\t\tHeartbeat - value of non-Java system's counter in shared memory (changes if alive)\n\t\tLocked Mutexes - on non-Java systems, locked pthread mutexes.\n\n2) Stations - stations are listed by name under this heading\n\ta) Configuration - parameters which define station behavior\n\t\t- active or idle,  blocking or nonblocking,  prescale & cue values\n\t\t- single user, multiple users, or the exact number of allowed users\n\t\t- events restored to station's input, output, or to GRAND_CENTRAL station\n\t\t- select all events, those matching default condition, or matching user condition\n\t\t- values of integers in selection array\n\t\t- class or library & function of user's matching condition\n\n\tb) Statistics - \n\t\t- total number of attachments and their id numbers\n\t\t- current # of events in input list, total # put in input, # tried to put in input\n\t\t- current # of events in output list, total # put in output list\n\n3) Processes - on Solaris, local unix processes with attachments are listed by id #\n\t- total # of attachments, list of attachments' ids, unix pid, current heartbeat value\n\n4) Attachments - attachments are listed by their id numbers\n\t- name of station attached to, host attachment is running on\n\t- is attachment blocked waiting to read events?\n\t- has attachment been told to quit reading events and return?\n\t- unix pid and process id (non-Java)\n\t- # events currently owned, total #: newly made, gotten, put, and dumped\n\n\n\nSETTING AN UPDATE PERIOD\nEach ET system has its information updated at a regular period which can be set by selecting the \"View\" menu item and typing in the period value.\n\n\n\nDISCONNECTING AN ET SYSTEM\nEach ET system can be removed from the monitor by selecting the \"Connections\" menu item followed by selecting the \"Disconnect\" item, and then selecting the system to be removed.\n\n\n\nCONFIGURATION FILES\nConfiguration files can be created, saved, and loaded through the \"File\" menu item. The configuration files are in XML format and store all current connections and thecurrent state of the application.The main window's size and placement, is recorded in the configuration file. These particular parameters, however, will only be set in the application if the configuration file is given on the command line (-f or -file). Once the monitor is up and running, loading a configuration file simply adds any additional ET system connections listed there as well as adding items to the \"ET Name\" or \"ET Location\" lists.");
        return pane;
    }

    private void makeEtOpenWindow() {
        int edge1 = 10;
        int edge2 = 5;
        int horSpace = 10;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String selectedItem = (String)jcb.getSelectedItem();
                int numItems = jcb.getItemCount();
                boolean addNewItem = true;
                if (selectedItem == null || selectedItem.equals("")) {
                    addNewItem = false;
                } else if (numItems == 0) {
                    addNewItem = true;
                } else {
                    for (int i = 0; i < numItems; ++i) {
                        String listItem = (String)jcb.getItemAt(i);
                        if (!listItem.equals(selectedItem)) continue;
                        addNewItem = false;
                        break;
                    }
                }
                if (addNewItem) {
                    jcb.addItem(selectedItem);
                }
            }
        };
        TitledBorder border1 = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "ET Name", 1, 2);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.setBorder(border1);
        this.etName = new JComboBox();
        this.etName.setEditable(true);
        this.etName.addActionListener(al);
        this.etName.getEditor().getEditorComponent().setForeground(this.entryColor);
        JButton removeName = new JButton("X");
        removeName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.etName.getSelectedIndex();
                if (index > -1) {
                    Monitor.this.etName.removeItemAt(index);
                }
            }
        });
        p1.add(this.etName, "Center");
        p1.add((Component)removeName, "East");
        TitledBorder border2 = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "ET Location", 1, 2);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.setBorder(border2);
        this.hostname = new JComboBox<String>(new String[]{"anywhere", "local", "remote"});
        this.hostname.setEditable(true);
        this.hostname.addActionListener(al);
        this.hostname.getEditor().getEditorComponent().setForeground(this.entryColor);
        JButton removeHost = new JButton("X");
        removeHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.hostname.getSelectedIndex();
                if (index > 2) {
                    Monitor.this.hostname.removeItemAt(index);
                }
            }
        });
        p2.add(this.hostname, "Center");
        p2.add((Component)removeHost, "East");
        JPanel p1and2 = new JPanel();
        p1and2.setLayout(new GridLayout(2, 1, 0, 10));
        p1and2.add(p1);
        p1and2.add(p2);
        this.bAddress = new AddressJList();
        this.bAddress.setTextColor(this.entryColor);
        TitledBorder border3 = new TitledBorder(new EtchedBorder(), "Subnet Addresses", 1, 1);
        this.bAddress.setBorder(border3);
        this.mAddress = new AddressJList(true);
        this.mAddress.setTextColor(this.entryColor);
        TitledBorder border4 = new TitledBorder(new EtchedBorder(), "Multicast Addresses", 1, 1);
        this.mAddress.setBorder(border4);
        this.mAddress.addAddress("239.200.0.0");
        JLabel l0 = new JLabel("UDP Port: ", 4);
        JLabel l1 = new JLabel("TCP Port: ", 4);
        JLabel l2 = new JLabel("Multicast Port: ", 4);
        JLabel l3 = new JLabel("TTL Value: ", 4);
        this.udpPort = new WholeNumberField(11111, 8, 1024, 65535);
        this.udpPort.setForeground(this.entryColor);
        this.udpPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.udpPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.udpPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.mcastPort = new WholeNumberField(11112, 8, 1024, 65535);
        this.mcastPort.setForeground(this.entryColor);
        this.mcastPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.mcastPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.mcastPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.tcpPort = new WholeNumberField(11111, 8, 1024, 65535);
        this.tcpPort.setForeground(this.entryColor);
        this.tcpPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.tcpPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.tcpPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.ttl = new WholeNumberField(32, 6, 0, 255);
        this.ttl.setForeground(this.entryColor);
        this.ttl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.ttl.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.ttl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        JPanel portsLeft = new JPanel();
        portsLeft.setLayout(new GridLayout(2, 2, horSpace, 0));
        portsLeft.setBorder(new EmptyBorder(edge2, edge2, 0, edge2));
        JPanel portsRight = new JPanel();
        portsRight.setLayout(new GridLayout(2, 2, horSpace, 0));
        portsRight.setBorder(new EmptyBorder(edge2, edge2, 0, edge2));
        portsRight.add(l2);
        portsRight.add(this.mcastPort);
        portsRight.add(l3);
        portsRight.add(this.ttl);
        portsLeft.add(l0);
        portsLeft.add(this.udpPort);
        portsLeft.add(l1);
        portsLeft.add(this.tcpPort);
        UIManager.put("ComboBox.foreground", this.entryColor);
        this.cast = new JComboBox<String>(new String[]{"broadcasting", "multicasting", "broad & multicasting", "direct connection"});
        this.cast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String selecteditem = (String)jcb.getSelectedItem();
                if (selecteditem.equals("broadcasting")) {
                    Monitor.this.broadcasting = true;
                    Monitor.this.multicasting = false;
                } else if (selecteditem.equals("multicasting")) {
                    Monitor.this.broadcasting = false;
                    Monitor.this.multicasting = true;
                } else if (selecteditem.equals("broad & multicasting")) {
                    Monitor.this.broadcasting = true;
                    Monitor.this.multicasting = true;
                } else {
                    Monitor.this.broadcasting = false;
                    Monitor.this.multicasting = false;
                }
            }
        });
        this.cast.setSelectedIndex(0);
        int castEdge = edge1 + edge2;
        this.cast.setBorder(new EmptyBorder(castEdge, castEdge, 0, castEdge));
        this.cast.setEditable(true);
        this.cast.getEditor().getEditorComponent().setForeground(this.entryColor);
        this.cast.setEditable(false);
        this.allBroadcastAddrsBox = new JCheckBox("Broadcast on all local subnets");
        this.allBroadcastAddrsBox.setBorder(new EmptyBorder(castEdge, castEdge, 0, castEdge));
        this.allBroadcastAddrsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox jcb = (JCheckBox)e.getSource();
                if (jcb.isSelected()) {
                    Monitor.this.broadcastAddresses = EtUtils.getAllBroadcastAddresses();
                    Monitor.this.bAddress.addAddresses(Monitor.this.broadcastAddresses);
                }
            }
        });
        this.allBroadcastAddrsBox.doClick();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 10, 0));
        this.connect = new JButton("Connect");
        this.connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtSystemOpenConfig config = Monitor.this.getEtSystemConfig();
                if (config == null) {
                    return;
                }
                Monitor.this.addEtSystem(config);
            }
        });
        JButton dismiss = new JButton("Dismiss");
        dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitor.this.openFrame.setVisible(false);
            }
        });
        buttonPanel.add(this.connect);
        buttonPanel.add(dismiss);
        JPanel allLeft = new JPanel();
        allLeft.setLayout(new BorderLayout());
        allLeft.setBorder(new EmptyBorder(edge2, edge2, edge2, edge2));
        allLeft.add((Component)this.bAddress, "North");
        allLeft.add((Component)portsLeft, "South");
        JPanel allRight = new JPanel();
        allRight.setLayout(new BorderLayout());
        allRight.setBorder(new EmptyBorder(edge2, edge2, edge2, edge2));
        allRight.add((Component)this.mAddress, "North");
        allRight.add((Component)portsRight, "South");
        JPanel portsAddrs = new JPanel();
        portsAddrs.setLayout(new GridLayout(1, 2));
        portsAddrs.setBorder(new EmptyBorder(edge2, edge2, edge2, edge2));
        portsAddrs.add(allLeft);
        portsAddrs.add(allRight);
        TitledBorder border5 = new TitledBorder(new EtchedBorder(), "Find ET by", 1, 1);
        JPanel findByPanel = new JPanel();
        findByPanel.setLayout(new BorderLayout());
        findByPanel.setBorder(border5);
        findByPanel.add(this.cast, "North");
        findByPanel.add((Component)this.allBroadcastAddrsBox, "Center");
        findByPanel.add((Component)portsAddrs, "South");
        JPanel openPanel = new JPanel();
        openPanel.setLayout(new BorderLayout(0, 10));
        openPanel.setBorder(new EmptyBorder(edge1, edge1, edge1, edge1));
        openPanel.add((Component)p1and2, "North");
        openPanel.add((Component)findByPanel, "Center");
        openPanel.add((Component)buttonPanel, "South");
        this.openFrame.getContentPane().add(openPanel);
        this.openFrame.pack();
    }

    private void addEtSystem(EtSystemOpenConfig config) {
        ConnectionThread t = new ConnectionThread(this, config);
        t.start();
    }

    public void addEtSystem(EtSystemOpenConfig config, int updatePeriod, int dividerLocation, int orientation, Color[] colors) {
        ConnectionThread t = new ConnectionThread(this, config, updatePeriod, dividerLocation, orientation, colors);
        t.start();
    }

    private EtSystemOpenConfig getEtSystemConfig() {
        try {
            boolean specifingHostname = false;
            EtSystemOpenConfig config = null;
            String etSystem = (String)this.etName.getSelectedItem();
            String host = (String)this.hostname.getSelectedItem();
            String howToConnect = (String)this.cast.getSelectedItem();
            if (host.equals("local")) {
                host = ".local";
                specifingHostname = true;
            } else if (host.equals("remote")) {
                host = ".remote";
            } else if (host.equals("anywhere")) {
                host = ".anywhere";
            } else {
                specifingHostname = true;
            }
            List<String> bAddresses = null;
            if (this.broadcasting) {
                bAddresses = this.bAddress.getAddresses();
            }
            List<String> mAddresses = null;
            if (this.multicasting) {
                mAddresses = this.mAddress.getAddresses();
            }
            if (howToConnect.equals("broadcasting")) {
                config = this.allBroadcastAddrsBox.isSelected() ? new EtSystemOpenConfig(etSystem, this.udpPort.getValue(), host) : new EtSystemOpenConfig(etSystem, host, bAddresses, null, false, 1, 11111, this.udpPort.getValue(), 11112, 32, 0);
            } else if (howToConnect.equals("multicasting")) {
                config = new EtSystemOpenConfig(etSystem, host, mAddresses, this.udpPort.getValue(), this.mcastPort.getValue(), this.ttl.getValue());
            } else if (howToConnect.equals("broad & multicasting")) {
                config = new EtSystemOpenConfig(etSystem, host, bAddresses, mAddresses, false, 3, this.tcpPort.getValue(), this.udpPort.getValue(), this.mcastPort.getValue(), this.ttl.getValue(), 2);
            } else if (howToConnect.equals("direct connection")) {
                if (!specifingHostname) {
                    throw new EtException("Specify a host's name (not remote, or anywhere) to make a direct connection.");
                }
                config = new EtSystemOpenConfig(etSystem, host, this.tcpPort.getValue());
            }
            return config;
        }
        catch (EtException ex) {
            JOptionPane.showMessageDialog(new JFrame(), ex.getMessage(), "Error", 0);
            return null;
        }
    }

    public EtSystem makeConnection(EtSystemOpenConfig config) {
        EtSystemOpen open;
        block13: {
            if (config == null) {
                return null;
            }
            config.setConnectRemotely(true);
            open = new EtSystemOpen(config);
            this.openFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.connect.setEnabled(false);
            try {
                open.connect();
            }
            catch (UnknownHostException ex) {
                JOptionPane.showMessageDialog(new JFrame(), config.getHost() + " is an unknown host", "Error", 0);
                this.openFrame.setCursor(Cursor.getDefaultCursor());
                this.connect.setEnabled(true);
                return null;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
                this.openFrame.setCursor(Cursor.getDefaultCursor());
                this.connect.setEnabled(true);
                return null;
            }
            catch (EtTooManyException ex) {
                String host = null;
                Object[] hosts = open.getAllHosts();
                int port = 0;
                int[] ports = open.getAllPorts();
                if (hosts.length <= 1) break block13;
                host = (String)JOptionPane.showInputDialog(new JFrame(), "Choose the ET system responding from host:", "ET System Choice", -1, null, hosts, hosts[0]);
                if (host == null) {
                    return null;
                }
                for (int i = 0; i < hosts.length; ++i) {
                    if (!host.equals(hosts[i])) continue;
                    port = ports[i];
                }
                try {
                    config.setHost(host);
                    config.setTcpPort(port);
                    config.setNetworkContactMethod(2);
                    open.connect();
                }
                catch (Exception except) {
                    JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
                    this.openFrame.setCursor(Cursor.getDefaultCursor());
                    this.connect.setEnabled(true);
                    return null;
                }
            }
            catch (EtException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Cannot find or connect to " + config.getEtName(), "Error", 0);
                this.openFrame.setCursor(Cursor.getDefaultCursor());
                this.connect.setEnabled(true);
                return null;
            }
        }
        this.openFrame.setCursor(Cursor.getDefaultCursor());
        this.connect.setEnabled(true);
        String key = new String(config.getEtName() + " (" + open.getHostAddress() + ")");
        if (this.connections.containsKey(key)) {
            open.disconnect();
            JOptionPane.showMessageDialog(new JFrame(), "You are already connected to " + config.getEtName() + " on " + config.getHost(), "ERROR", 0);
            return null;
        }
        EtSystem use = null;
        try {
            use = new EtSystem(open, 0);
        }
        catch (Exception ex) {
            open.disconnect();
            JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
        }
        this.connections.put(key, use);
        final EtSystem useObject = use;
        JMenuItem menuItem = new JMenuItem(key);
        this.loadConnectionParametersMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int method;
                EtSystemOpenConfig config = useObject.getConfig();
                Monitor.this.addFileName(config.getEtName());
                Monitor.this.etName.setSelectedItem(config.getEtName());
                String host = config.getHost();
                if (host.equals(".local")) {
                    host = "local";
                } else if (host.equals(".remote")) {
                    host = "remote";
                } else if (host.equals(".anywhere")) {
                    host = "anywhere";
                }
                if (Monitor.this.addHostname(host)) {
                    Monitor.this.hostname.setSelectedItem(host);
                }
                if ((method = config.getNetworkContactMethod()) == 1) {
                    Monitor.this.cast.setSelectedItem("broadcasting");
                    Monitor.this.bAddress.clearAddresses();
                    Monitor.this.bAddress.addAddresses(config.getBroadcastAddrs());
                    Monitor.this.udpPort.setValue(config.getUdpPort());
                } else if (method == 0) {
                    Monitor.this.cast.setSelectedItem("multicasting");
                    Monitor.this.mAddress.clearAddresses();
                    Monitor.this.mAddress.addAddresses(config.getMulticastAddrs());
                    Monitor.this.mcastPort.setValue(config.getMulticastPort());
                    Monitor.this.udpPort.setValue(config.getUdpPort());
                    Monitor.this.ttl.setValue(config.getTTL());
                } else if (method == 3) {
                    Monitor.this.cast.setSelectedItem("broad & multicasting");
                    Monitor.this.bAddress.clearAddresses();
                    Monitor.this.bAddress.addAddresses(config.getBroadcastAddrs());
                    Monitor.this.mAddress.clearAddresses();
                    Monitor.this.mAddress.addAddresses(config.getMulticastAddrs());
                    Monitor.this.mcastPort.setValue(config.getMulticastPort());
                    Monitor.this.udpPort.setValue(config.getUdpPort());
                    Monitor.this.ttl.setValue(config.getTTL());
                } else if (method == 2) {
                    Monitor.this.cast.setSelectedItem("direct connection");
                    Monitor.this.tcpPort.setValue(config.getTcpPort());
                }
            }
        });
        return use;
    }

    private void removeConnection(Monitor monitor, MonitorSingleSystem mon, String key, boolean notInIterator) {
        JMenuItem mi;
        int j;
        monitor.tabbedPane.remove(mon.getDisplayPane());
        int count = monitor.disconnectMenu.getItemCount();
        for (j = 0; j < count; ++j) {
            mi = monitor.disconnectMenu.getItem(j);
            if (!mi.getText().equals(key)) continue;
            monitor.disconnectMenu.remove(mi);
            break;
        }
        count = monitor.loadConnectionParametersMenu.getItemCount();
        for (j = 0; j < count; ++j) {
            mi = monitor.loadConnectionParametersMenu.getItem(j);
            if (!mi.getText().equals(key)) continue;
            monitor.loadConnectionParametersMenu.remove(mi);
            break;
        }
        mon.close();
        if (notInIterator) {
            monitor.monitors.remove(key);
            monitor.connections.remove(key);
        }
        int index = monitor.tabbedPane.getSelectedIndex();
        monitor.currentMonitorKey = key = monitor.tabbedPane.getTitleAt(index);
        if (key.equals("Help")) {
            monitor.period.setValue(monitor.defaultPeriod);
        } else {
            mon = monitor.monitors.get(key);
            monitor.period.setValue(mon.getUpdatePeriod());
        }
    }

    public void displayEtSystem(EtSystemOpenConfig config, EtSystem use) {
        this.displayEtSystem(config, use, this.defaultPeriod, this.tabbedPane.getWidth() / 2, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayEtSystem(EtSystemOpenConfig config, EtSystem use, int updatePeriod, int dividerLocation, int orientation, Color[] colors) {
        final String key = new String(config.getEtName() + " (" + use.getHost() + ")");
        final MonitorSingleSystem et = new MonitorSingleSystem(use, key, this.tabbedPane, updatePeriod, dividerLocation, orientation, colors);
        Map<String, MonitorSingleSystem> map = this.monitors;
        synchronized (map) {
            this.monitors.put(key, et);
        }
        JMenuItem menuItem = new JMenuItem(key);
        this.disconnectMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitor.this.removeConnection(Monitor.this, et, key, true);
            }
        });
    }
}

