/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;

public class Killer {
    private static void usage() {
        System.out.println("\nUsage: java Killer -f <ET name> -host <ET host> [-h] [-v] [-r] [-p <ET server port>]\n\n       -host  ET system's host\n       -f     ET system's (memory-mapped file) name\n       -h     help\n       -v     verbose output\n       -r     act as remote (TCP) client even if ET system is local\n       -p     ET server port\n       -i     outgoing network interface IP address (dot-decimal)\n\n        This consumer works by making a direct connection to the\n        ET system's server port.\n");
    }

    public static void main(String[] args) {
        String etName = null;
        String host = null;
        String netInterface = null;
        int port = 11111;
        boolean verbose = false;
        boolean remote = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                netInterface = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    Killer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    Killer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                remote = true;
                continue;
            }
            Killer.usage();
            return;
        }
        if (host == null || etName == null) {
            Killer.usage();
            return;
        }
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig(etName, host, port);
            config.setConnectRemotely(remote);
            if (netInterface != null) {
                config.setNetworkInterface(netInterface);
            }
            EtSystem sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            sys.kill();
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as killer");
            ex.printStackTrace();
        }
    }
}

