/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.nio.ByteBuffer;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.enums.Mode;

public class Consumer {
    private static void usage() {
        System.out.println("\nUsage: java Consumer -f <et name> -host <ET host> -s <station name> [-h] [-v] [-nb]\n                      [-p <ET server port>] [-c <chunk size>] [-q <queue size>]\n                      [-pos <station position>] [-ppos <parallel station position>]\n\n       -host  ET system's host\n       -f     ET system's (memory-mapped file) name\n       -s     create station of this name\n       -h     help\n       -v     verbose output\n       -nb    make station non-blocking\n       -p     ET server port\n       -c     number of events in one get/put array\n       -q     queue size if creating nonblocking station\n       -pos   position of created station in station list (1,2,...)\n       -ppos  position of created station within a group of parallel stations (-1=end, -2=head)\n\n        This consumer works by making a direct connection\n        to the ET system's tcp server port.\n");
    }

    public static void main(String[] args) {
        int position = 1;
        int pposition = 0;
        int qSize = 0;
        int chunk = 1;
        boolean blocking = true;
        boolean verbose = false;
        String etName = null;
        String host = null;
        String statName = null;
        int port = 11111;
        int flowMode = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-nb")) {
                blocking = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                statName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-c")) {
                try {
                    chunk = Integer.parseInt(args[++i]);
                    if (chunk >= 1 && chunk <= 1000) continue;
                    System.out.println("Chunk size may be 1 - 1000.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper chunk size.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-q")) {
                try {
                    qSize = Integer.parseInt(args[++i]);
                    if (qSize >= 1) continue;
                    System.out.println("Queue size must be > 0.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper queue size number.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-pos")) {
                try {
                    position = Integer.parseInt(args[++i]);
                    if (position >= 1) continue;
                    System.out.println("Position must be > 0.");
                    Consumer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper position number.");
                    Consumer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-ppos")) {
                try {
                    pposition = Integer.parseInt(args[++i]);
                    if (pposition < -2 || pposition == 0) {
                        System.out.println("Parallel position must be > -3 and != 0.");
                        Consumer.usage();
                        return;
                    }
                    System.out.println("FLOW moDE is ||");
                    flowMode = 1;
                    if (pposition == -2) {
                        pposition = -2;
                        continue;
                    }
                    if (pposition != -1) continue;
                    pposition = -1;
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper parallel position number.");
                    Consumer.usage();
                    return;
                }
            }
            Consumer.usage();
            return;
        }
        if (host == null || etName == null || statName == null) {
            Consumer.usage();
            return;
        }
        try {
            EtSystemOpenConfig config = new EtSystemOpenConfig(etName, host, port);
            EtSystem sys = new EtSystem(config, 4);
            sys.open();
            EtStationConfig statConfig = new EtStationConfig();
            statConfig.setFlowMode(flowMode);
            if (!blocking) {
                statConfig.setBlockMode(0);
                if (qSize > 0) {
                    statConfig.setCue(qSize);
                }
            }
            EtStation stat = sys.createStation(statConfig, statName, position, pposition);
            EtAttachment att = sys.attach(stat);
            int count = 0;
            long t1 = 0L;
            long t2 = 0L;
            long totalT = 0L;
            long totalCount = 0L;
            t1 = System.currentTimeMillis();
            while (true) {
                EtEvent[] mevs = sys.getEvents(att, Mode.SLEEP, null, 0, chunk);
                if (verbose) {
                    for (EtEvent mev : mevs) {
                        int[] con;
                        ByteBuffer buf = mev.getDataBuffer();
                        int num = buf.getInt(0);
                        System.out.println("    data (len = " + mev.getLength() + ") = " + num);
                        try {
                            byte[] data = mev.getData();
                            int idata = EtUtils.bytesToInt(data, 0);
                            System.out.println("data byte order = " + mev.getByteOrder());
                            if (mev.needToSwap()) {
                                System.out.println("    data (len = " + mev.getLength() + ") needs swapping, swapped int = " + Integer.reverseBytes(idata));
                            } else {
                                System.out.println("    data (len = " + mev.getLength() + ")does NOT need swapping, int = " + idata);
                            }
                        }
                        catch (UnsupportedOperationException e) {
                            // empty catch block
                        }
                        System.out.print("control array = {");
                        for (int j : con = mev.getControl()) {
                            System.out.print(j + " ");
                        }
                        System.out.println("}");
                    }
                }
                sys.putEvents(att, mevs);
                count += mevs.length;
                t2 = System.currentTimeMillis();
                long time = t2 - t1;
                if (time <= 5000L) continue;
                if (totalCount >= Long.MAX_VALUE - (long)count || totalT >= Long.MAX_VALUE - time) {
                    count = 0;
                    totalT = totalCount = (long)0;
                    t1 = System.currentTimeMillis();
                    continue;
                }
                double rate = 1000.0 * (double)count / (double)time;
                double avgRate = 1000.0 * (double)(totalCount += (long)count) / (double)(totalT += time);
                System.out.println("rate = " + String.format("%.3g", rate) + " Hz,  avg = " + String.format("%.3g", avgRate));
                count = 0;
                t1 = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as consumer");
            ex.printStackTrace();
            return;
        }
    }
}

