/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.enums.Age;
import org.jlab.coda.et.enums.Priority;
import org.jlab.coda.et.exception.EtBusyException;
import org.jlab.coda.et.exception.EtEmptyException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtExistsException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.exception.EtWakeUpException;
import org.jlab.coda.et.system.AttachmentLocal;
import org.jlab.coda.et.system.EventList;
import org.jlab.coda.et.system.StationLocal;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemTcpServer;
import org.jlab.coda.et.system.SystemUdpServer;

public class SystemCreate {
    private SystemConfig config;
    private String name;
    private ArrayList<StationLocal> stations;
    private int stationCount;
    private StationLocal gcStation;
    private HashMap<Integer, AttachmentLocal> attachments;
    private EtEventImpl[] events;
    private InetAddress[] netAddresses;
    String[] ipAddresses;
    String[] broadAddresses;
    private boolean running;
    private byte[] systemLock;
    private byte[] stationLock;
    private SystemTcpServer tcpServer;
    private SystemUdpServer udpServer;
    ThreadGroup etSystemThreads;
    private volatile boolean killAllThreads;
    private boolean gather = true;
    private long time1 = 0L;
    private int dataLength = 0;
    private byte[] infoArray = new byte[6000];

    public SystemCreate(String name) throws EtException {
        this(name, new SystemConfig());
    }

    public SystemCreate(String name, SystemConfig config) throws EtException {
        if (!config.selfConsistent()) {
            if (config.getDebug() >= 4) {
                System.out.println("Number of events in groups does not equal total number of events");
            }
            throw new EtException("Number of events in groups does not equal total number of events");
        }
        if (name == null || config == null) {
            throw new EtException("arg is null");
        }
        if (name.length() > 101) {
            throw new EtException("ET system name too long (> 101 chars)");
        }
        this.name = name;
        this.config = new SystemConfig(config);
        this.attachments = new HashMap(111);
        this.events = new EtEventImpl[config.getNumEvents()];
        this.stations = new ArrayList(100);
        this.systemLock = new byte[0];
        this.stationLock = new byte[0];
        File etFile = new File(name);
        try {
            if (!etFile.createNewFile()) {
                if (config.getDebug() >= 4) {
                    System.out.println("ET file already exists");
                }
                throw new EtException("ET file already exists");
            }
        }
        catch (IOException ex) {
            if (config.getDebug() >= 4) {
                System.out.println("cannot create ET file");
            }
            throw new EtException("Cannot create ET file");
        }
        etFile.deleteOnExit();
        try {
            FileOutputStream fos = new FileOutputStream(etFile);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.writeInt(67305985);
            dos.writeInt(2);
            dos.writeInt(15);
            dos.writeInt(1);
            dos.writeInt(6);
            dos.writeInt(0);
            dos.writeLong(0L);
            dos.writeLong(0L);
            dos.writeLong(0L);
            dos.writeLong(0L);
            dos.writeLong(0L);
            dos.flush();
        }
        catch (FileNotFoundException ex) {
        }
        catch (UnsupportedEncodingException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        ArrayList<String> ipAddrs = new ArrayList<String>();
        ArrayList<String> broadAddrs = new ArrayList<String>();
        ArrayList<Inet4Address> ipAddrObjs = new ArrayList<Inet4Address>();
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address addrv4;
                    try {
                        addrv4 = (Inet4Address)ifAddr.getAddress();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    ipAddrObjs.add(addrv4);
                    ipAddrs.add(addrv4.getHostAddress());
                    broadAddrs.add(ifAddr.getBroadcast().getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        this.netAddresses = new InetAddress[0];
        this.netAddresses = ipAddrObjs.toArray(this.netAddresses);
        this.ipAddresses = new String[0];
        this.ipAddresses = ipAddrs.toArray(this.ipAddresses);
        this.broadAddresses = new String[0];
        this.broadAddresses = broadAddrs.toArray(this.broadAddresses);
        this.startUp();
    }

    public String getName() {
        return this.name;
    }

    public SystemConfig getConfig() {
        return new SystemConfig(this.config);
    }

    public synchronized boolean running() {
        return this.running;
    }

    public ArrayList<StationLocal> getStations() {
        return this.stations;
    }

    public byte[] getStationLock() {
        return this.stationLock;
    }

    public byte[] getSystemLock() {
        return this.systemLock;
    }

    public EtEventImpl[] getEvents() {
        return this.events;
    }

    public InetAddress[] getNetAddresses() {
        return this.netAddresses;
    }

    public HashMap<Integer, AttachmentLocal> getAttachments() {
        return this.attachments;
    }

    public boolean killAllThreads() {
        return this.killAllThreads;
    }

    public byte[] getInfoArray() {
        return this.infoArray;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public synchronized void startUp() {
        if (this.running) {
            return;
        }
        this.gcStation = this.createGrandCentral();
        int index = 0;
        int count = 0;
        ArrayList<EtEventImpl> eventList = new ArrayList<EtEventImpl>(this.config.getNumEvents());
        for (int i = 0; i < this.config.getNumEvents(); ++i) {
            EtEventImpl ev = new EtEventImpl(this.config.getEventSize());
            ev.setId(i);
            if (count < 1) {
                count = this.config.getGroups()[index++];
            }
            ev.setGroup(index);
            --count;
            eventList.add(ev);
            this.events[i] = ev;
        }
        this.gcStation.getInputList().putInLow(eventList);
        this.gcStation.getInputList().setEventsIn(0L);
        this.etSystemThreads = new ThreadGroup("etSystemThreads");
        this.tcpServer = new SystemTcpServer(this, this.etSystemThreads);
        this.tcpServer.start();
        this.udpServer = new SystemUdpServer(this, this.etSystemThreads);
        this.udpServer.start();
        this.running = true;
    }

    public synchronized void shutdown() {
        if (!this.running) {
            return;
        }
        this.killAllThreads = true;
        this.etSystemThreads.interrupt();
        try {
            Thread.sleep(2100L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.etSystemThreads.stop();
        File etFile = new File(this.name);
        etFile.delete();
        this.stations = null;
        this.attachments = null;
        this.events = null;
        this.netAddresses = null;
        this.ipAddresses = null;
        this.broadAddresses = null;
        this.stationLock = null;
        this.killAllThreads = false;
        this.running = false;
    }

    private void lockAllStationTransferLocks() {
        for (StationLocal mainListStation : this.stations) {
            mainListStation.getStopTransferLock().lock();
            if (mainListStation.getConfig().getFlowMode() != 1) continue;
            ListIterator<StationLocal> iter = mainListStation.getParallelStations().listIterator(1);
            while (iter.hasNext()) {
                StationLocal parallelListStation = iter.next();
                parallelListStation.getStopTransferLock().lock();
            }
        }
    }

    private void unlockAllStationTransferLocks() {
        for (StationLocal mainListStation : this.stations) {
            mainListStation.getStopTransferLock().unlock();
            if (mainListStation.getConfig().getFlowMode() != 1) continue;
            ListIterator<StationLocal> iter = mainListStation.getParallelStations().listIterator(1);
            while (iter.hasNext()) {
                StationLocal parallelListStation = iter.next();
                parallelListStation.getStopTransferLock().unlock();
            }
        }
    }

    private void insertStation(StationLocal newStation, int position, int parallelPosition) throws EtException {
        if (this.stations.size() < 2 || position >= this.stations.size() || position == -1) {
            this.stations.add(newStation);
            if (newStation.getConfig().getFlowMode() == 1) {
                newStation.getParallelStations().clear();
                newStation.getParallelStations().add(newStation);
            }
        } else {
            StationLocal stat = this.stations.get(position);
            if (newStation.getConfig().getFlowMode() == 1 && stat.getConfig().getFlowMode() == 1 && parallelPosition != -2) {
                if (!EtStationConfig.compatibleParallelConfigs(stat.getConfig(), newStation.getConfig())) {
                    throw new EtException("trying to add incompatible parallel station\n");
                }
                if (parallelPosition == 0) {
                    throw new EtException("trying to add parallel station to head of existing parallel group\n");
                }
                if (parallelPosition == -1 || parallelPosition >= stat.getParallelStations().size()) {
                    stat.getParallelStations().add(newStation);
                } else {
                    stat.getParallelStations().add(parallelPosition, newStation);
                }
            } else {
                this.stations.add(position, newStation);
                if (newStation.getConfig().getFlowMode() == 1) {
                    newStation.getParallelStations().clear();
                    newStation.getParallelStations().add(newStation);
                }
            }
        }
    }

    private void deleteStation(StationLocal station) {
        if (this.stations.contains(station)) {
            int index = this.stations.indexOf(station);
            this.stations.remove(station);
            if (station.getConfig().getFlowMode() == 0) {
                return;
            }
            station.getParallelStations().remove(0);
            if (station.getParallelStations().size() < 1) {
                return;
            }
            StationLocal nextStation = station.getParallelStations().get(0);
            nextStation.getParallelStations().clear();
            nextStation.getParallelStations().addAll(station.getParallelStations());
            station.getParallelStations().clear();
            this.stations.add(index, nextStation);
        } else {
            for (StationLocal nextStation : this.stations) {
                if (nextStation.getConfig().getFlowMode() != 1 || !nextStation.getParallelStations().remove(station)) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStationToList(StationLocal newStation, int position, int parallelPosition) throws EtException {
        this.lockAllStationTransferLocks();
        try {
            this.insertStation(newStation, position, parallelPosition);
            newStation.getStopTransferLock().lock();
        }
        finally {
            this.unlockAllStationTransferLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStationFromList(StationLocal station) {
        this.lockAllStationTransferLocks();
        try {
            this.deleteStation(station);
            station.getStopTransferLock().unlock();
        }
        finally {
            this.unlockAllStationTransferLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveStationInList(StationLocal station, int position, int parallelPosition) throws EtException {
        this.lockAllStationTransferLocks();
        try {
            this.deleteStation(station);
            this.insertStation(station, position, parallelPosition);
        }
        finally {
            this.unlockAllStationTransferLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStationStatus(StationLocal station, int status) {
        this.lockAllStationTransferLocks();
        try {
            station.setStatus(status);
        }
        finally {
            this.unlockAllStationTransferLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StationLocal createStation(EtStationConfig stationConfig, String name) throws EtException, EtExistsException, EtTooManyException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.createStation(stationConfig, name, this.stations.size(), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StationLocal createStation(EtStationConfig stationConfig, String name, int position, int parallelPosition) throws EtException, EtExistsException, EtTooManyException {
        int id = 0;
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            StationLocal station;
            if (this.stations.size() >= this.config.getStationsMax()) {
                throw new EtTooManyException("Maximum number of stations already created");
            }
            if (position > this.stations.size()) {
                position = this.stations.size();
            }
            try {
                StationLocal listStation = this.stationNameToObject(name);
                EtStationConfig listStationConfig = listStation.getConfig();
                if (listStationConfig.getFlowMode() == stationConfig.getFlowMode() && listStationConfig.getUserMode() == stationConfig.getUserMode() && listStationConfig.getBlockMode() == stationConfig.getBlockMode() && listStationConfig.getSelectMode() == stationConfig.getSelectMode() && listStationConfig.getRestoreMode() == stationConfig.getRestoreMode() && listStationConfig.getPrescale() == stationConfig.getPrescale() && listStationConfig.getCue() == stationConfig.getCue() && Arrays.equals(listStationConfig.getSelect(), stationConfig.getSelect())) {
                    if (listStationConfig.getSelectClass() != null && !listStationConfig.getSelectClass().equals(stationConfig.getSelectClass())) {
                        throw new EtExistsException("Station already exists with different configuration");
                    }
                    // ** MonitorExit[var7_6] (shouldn't be in output)
                    return listStation;
                }
                throw new EtExistsException("Station already exists with different configuration");
            }
            catch (EtException ex) {
                block7: for (int i = 0; i < this.stationCount + 1; ++i) {
                    ListIterator<StationLocal> j = this.stations.listIterator();
                    while (j.hasNext()) {
                        StationLocal listStation = j.next();
                        if (listStation.getStationId() == i) continue block7;
                        if (listStation.getConfig().getFlowMode() != 1) continue;
                        ListIterator<StationLocal> k = listStation.getParallelStations().listIterator(1);
                        while (k.hasNext()) {
                            listStation = k.next();
                            if (listStation.getStationId() != i) continue;
                            continue block7;
                        }
                    }
                    id = i;
                    break;
                }
                station = new StationLocal(this, name, stationConfig, id);
                station.start();
                Thread.yield();
                while (station.getStatus() != 2) {
                    if (this.config.getDebug() >= 4) {
                        System.out.println("Waiting for " + name + "'s conductor thread to start");
                    }
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException ex2) {}
                }
                this.addStationToList(station, position, parallelPosition);
                ++this.stationCount;
                // ** MonitorExit[var7_6] (shouldn't be in output)
            }
            return station;
        }
    }

    private StationLocal createGrandCentral() {
        EtStationConfig gcConfig = new EtStationConfig();
        StationLocal station = null;
        try {
            station = new StationLocal(this, "GRAND_CENTRAL", gcConfig, 0);
        }
        catch (EtException etException) {
            // empty catch block
        }
        this.stations.clear();
        this.stations.add(0, station);
        station.start();
        ++this.stationCount;
        return station;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStation(int statId) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            StationLocal stat = this.stationIdToObject(statId);
            if (stat.getAttachments().size() != 0) {
                throw new EtException("Remove all attachments before removing station");
            }
            this.removeStationFromList(stat);
            stat.killConductor();
            stat.interrupt();
            stat.setStatus(0);
            --this.stationCount;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStationPosition(int statId, int position, int parallelPosition) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            StationLocal stat = this.stationIdToObject(statId);
            this.moveStationInList(stat, position, parallelPosition);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStationPosition(int statId) throws EtException {
        if (statId == 0) {
            return 0;
        }
        int position = 0;
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            for (StationLocal stat : this.stations) {
                if (stat.getStationId() == statId) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return position;
                }
                if (stat.getConfig().getFlowMode() == 1) {
                    for (StationLocal stat2 : stat.getParallelStations()) {
                        if (stat2.getStationId() != statId) continue;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return position;
                    }
                }
                ++position;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            throw new EtException("cannot find station");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStationParallelPosition(int statId) throws EtException {
        if (statId == 0) {
            return 0;
        }
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            for (StationLocal stat : this.stations) {
                if (stat.getStationId() == statId) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return 0;
                }
                if (stat.getConfig().getFlowMode() != 1) continue;
                int pposition = 1;
                for (StationLocal stat2 : stat.getParallelStations()) {
                    if (stat2.getStationId() == statId) {
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return pposition;
                    }
                    ++pposition;
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            throw new EtException("cannot find station");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stationAttached(int statId, int attId) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            StationLocal stat = this.stationIdToObject(statId);
            for (AttachmentLocal att : stat.getAttachments()) {
                if (att.getId() != attId) continue;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stationExists(StationLocal station) {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            if (this.stations.contains(station)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            for (StationLocal listStation : this.stations) {
                if (listStation.getConfig().getFlowMode() != 1 || !listStation.getParallelStations().contains(station)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public boolean stationExists(String name) {
        try {
            this.stationNameToObject(name);
        }
        catch (EtException ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StationLocal stationNameToObject(String name) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            for (StationLocal listStation : this.stations) {
                if (listStation.getStationName().equals(name)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return listStation;
                }
                if (listStation.getConfig().getFlowMode() != 1) continue;
                for (StationLocal listStation2 : listStation.getParallelStations()) {
                    if (!listStation2.getStationName().equals(name)) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return listStation2;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new EtException("station " + name + " does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StationLocal stationIdToObject(int statId) throws EtException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            for (StationLocal stat : this.stations) {
                if (stat.getStationId() == statId) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return stat;
                }
                if (stat.getConfig().getFlowMode() != 1) continue;
                for (StationLocal stat2 : stat.getParallelStations()) {
                    if (stat2.getStationId() != statId) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return stat2;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new EtException("station  with id \"" + statId + "\" does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentLocal attach(int statId) throws EtException, EtTooManyException {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            AttachmentLocal att;
            StationLocal station = this.stationIdToObject(statId);
            if (station.getConfig().getUserMode() > 0 && station.getConfig().getUserMode() <= station.getAttachments().size()) {
                throw new EtTooManyException("no more attachments allowed to station");
            }
            byte[] byArray2 = this.systemLock;
            synchronized (this.systemLock) {
                if (this.attachments.size() >= this.config.getAttachmentsMax()) {
                    throw new EtTooManyException("no more attachments allowed to ET system");
                }
                att = new AttachmentLocal();
                String host = "unknown";
                String ipAddress = "unknown";
                try {
                    host = InetAddress.getLocalHost().getHostName();
                    ipAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                att.setHost(host);
                att.setStation(station);
                att.setIpAddress(ipAddress);
                if (this.attachments.size() == 0) {
                    att.setId(0);
                } else {
                    block8: for (int i = 0; i < this.attachments.size() + 1; ++i) {
                        for (Integer j : this.attachments.keySet()) {
                            if (j != i) continue;
                            continue block8;
                        }
                        att.setId(i);
                        break;
                    }
                }
                this.attachments.put(att.getId(), att);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                station.getAttachments().add(att);
                this.changeStationStatus(station, 3);
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
            return att;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(AttachmentLocal att) {
        byte[] byArray = this.stationLock;
        synchronized (this.stationLock) {
            if (att.getStation().getAttachments().size() == 1 && att.getStation().getStationId() != 0) {
                this.changeStationStatus(att.getStation(), 2);
                Thread.yield();
                if (att.getStation().getConfig().getRestoreMode() == 3) {
                    try {
                        int pos = this.getStationPosition(att.getStation().getStationId());
                        if (--pos < 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        StationLocal prevStat = this.stations.get(pos);
                        try {
                            this.moveEvents(prevStat.getOutputList(), Arrays.asList(this.getEvents(att, 2, 0, this.config.getNumEvents())));
                        }
                        catch (Exception e) {}
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                } else {
                    try {
                        this.putEvents(att, this.getEvents(att, 2, 0, this.config.getNumEvents()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            att.getStation().getAttachments().remove(att);
            this.restoreEvents(att);
            byte[] byArray2 = this.systemLock;
            synchronized (this.systemLock) {
                this.attachments.remove(new Integer(att.getId()));
                // ** MonitorExit[var3_6] (shouldn't be in output)
            }
            return;
        }
    }

    private void restoreEvents(AttachmentLocal att) {
        ArrayList<EtEventImpl> usedEvs = new ArrayList<EtEventImpl>(this.config.getNumEvents());
        ArrayList<EtEventImpl> newEvs = new ArrayList<EtEventImpl>(this.config.getNumEvents());
        for (EtEventImpl ev : this.events) {
            if (ev.getOwner() != att.getId()) continue;
            if (ev.getAge().getValue() == 1) {
                newEvs.add(ev);
                continue;
            }
            if (ev.getPriority() == Priority.HIGH) {
                usedEvs.add(0, ev);
                continue;
            }
            usedEvs.add(ev);
        }
        if (newEvs.size() > 0) {
            this.dumpEvents(att, newEvs);
        }
        if (usedEvs.size() > 0) {
            if (att.getStation().getConfig().getRestoreMode() == 2 || att.getStation().getStationId() == 0) {
                this.dumpEvents(att, usedEvs);
            } else if (att.getStation().getConfig().getRestoreMode() == 0 || att.getStation().getConfig().getRestoreMode() == 1 && att.getStation().getAttachments().size() == 0) {
                this.putEvents(att, usedEvs);
            } else if (att.getStation().getConfig().getRestoreMode() == 1) {
                if (att.getStation().getConfig().getBlockMode() == 1) {
                    this.moveEvents(att.getStation().getInputList(), usedEvs);
                } else {
                    try {
                        int pos = this.getStationPosition(att.getStation().getStationId());
                        if (--pos < 0) {
                            return;
                        }
                        StationLocal prevStat = this.stations.get(pos);
                        this.moveEvents(prevStat.getOutputList(), usedEvs);
                    }
                    catch (EtException e) {
                        return;
                    }
                }
            } else if (att.getStation().getConfig().getRestoreMode() == 3) {
                try {
                    int pos = this.getStationPosition(att.getStation().getStationId());
                    if (--pos < 0) {
                        return;
                    }
                    StationLocal prevStat = this.stations.get(pos);
                    this.moveEvents(prevStat.getOutputList(), usedEvs);
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    public EtEventImpl[] newEvents(AttachmentLocal att, int mode, int microSec, int count, int size) throws EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        EtEventImpl[] evs;
        for (EtEventImpl ev : evs = this.gcStation.getInputList().get(att, mode, microSec, count)) {
            ev.init();
            ev.setOwner(att.getId());
            if (ev.getMemSize() >= size) continue;
            ev.setData(new byte[size]);
            ev.setMemSize(size);
        }
        att.setEventsMake(att.getEventsMake() + (long)evs.length);
        return evs;
    }

    public List<EtEventImpl> newEvents(AttachmentLocal att, int mode, int microSec, int count, int size, int group) throws EtException, EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        if (group > this.config.getGroups().length) {
            throw new EtException("group number is too high");
        }
        List<EtEventImpl> evs = this.gcStation.getInputList().get(att, mode, microSec, count, group);
        for (EtEventImpl ev : evs) {
            ev.init();
            ev.setOwner(att.getId());
            if (ev.getMemSize() >= size) continue;
            ev.setData(new byte[size]);
            ev.setMemSize(size);
        }
        att.setEventsMake(att.getEventsMake() + (long)evs.size());
        return evs;
    }

    public EtEventImpl[] getEvents(AttachmentLocal att, int mode, int microSec, int count) throws EtEmptyException, EtBusyException, EtTimeoutException, EtWakeUpException {
        EtEventImpl[] evs;
        for (EtEventImpl ev : evs = att.getStation().getInputList().get(att, mode, microSec, count)) {
            ev.setOwner(att.getId());
        }
        att.setEventsGet(att.getEventsGet() + (long)evs.length);
        return evs;
    }

    private void moveEvents(EventList list, List<EtEventImpl> eventList) {
        for (EtEventImpl ev : eventList) {
            ev.setAge(Age.USED);
            ev.setOwner(-1);
        }
        list.putReverse(eventList);
    }

    public void putEvents(AttachmentLocal att, EtEventImpl[] eventArray) {
        if (eventArray.length < 1) {
            return;
        }
        for (EtEventImpl ev : eventArray) {
            ev.setAge(Age.USED);
            ev.setOwner(-1);
        }
        att.getStation().getOutputList().put(eventArray);
        att.setEventsPut(att.getEventsPut() + (long)eventArray.length);
    }

    private void putEvents(AttachmentLocal att, ArrayList<EtEventImpl> eventList) {
        if (eventList.size() < 1) {
            return;
        }
        for (EtEventImpl ev : eventList) {
            ev.setAge(Age.USED);
            ev.setOwner(-1);
        }
        att.getStation().getOutputList().put(eventList);
        att.setEventsPut(att.getEventsPut() + (long)eventList.size());
    }

    public void dumpEvents(AttachmentLocal att, EtEventImpl[] eventArray) {
        if (eventArray.length < 1) {
            return;
        }
        for (EtEventImpl ev : eventArray) {
            ev.setOwner(-1);
        }
        this.gcStation.getInputList().putInGC(eventArray);
        att.setEventsDump(att.getEventsDump() + (long)eventArray.length);
    }

    private void dumpEvents(AttachmentLocal att, ArrayList<EtEventImpl> eventList) {
        if (eventList.size() < 1) {
            return;
        }
        for (EtEventImpl ev : eventList) {
            ev.setOwner(-1);
        }
        this.gcStation.getInputList().putInGC(eventList);
        att.setEventsDump(att.getEventsDump() + (long)eventList.size());
    }

    int gatherSystemData() {
        int err = 0;
        long time2 = System.currentTimeMillis();
        if (time2 - this.time1 > 1000L) {
            this.gather = true;
        }
        if (this.gather) {
            this.time1 = System.currentTimeMillis();
            try {
                int numStations = this.stationCount;
                int numAtts = this.attachments.size();
                int size = 600 + 570 * numStations + 160 * numAtts;
                if (size > this.infoArray.length) {
                    this.infoArray = new byte[size];
                }
                int len1 = this.writeSystemData(this.infoArray, 4);
                int len2 = this.writeStationData(this.infoArray, 4 + len1, numStations);
                int len3 = this.writeAttachmentData(this.infoArray, 4 + len1 + len2, numAtts);
                EtUtils.intToBytes(0, this.infoArray, 4 + len1 + len2 + len3);
                int len4 = 4;
                this.dataLength = len1 + len2 + len3 + len4;
                EtUtils.intToBytes(this.dataLength, this.infoArray, 0);
                this.gather = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                err = -1;
            }
        }
        return err;
    }

    private int writeSystemData(byte[] info, int off) {
        EtUtils.intToBytes(1, info, off);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(this.stations.size(), info, off += 4);
        EtUtils.intToBytes(this.attachments.size(), info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        int eventsOwned = 0;
        for (EtEventImpl ev : this.events) {
            if (ev.getOwner() != -1) continue;
            ++eventsOwned;
        }
        EtUtils.intToBytes(eventsOwned, info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(1, info, off += 4);
        EtUtils.intToBytes(-1, info, off += 4);
        EtUtils.intToBytes(6, info, off += 4);
        EtUtils.intToBytes(this.config.getNumEvents(), info, off += 4);
        EtUtils.longToBytes(this.config.getEventSize(), info, off += 4);
        EtUtils.intToBytes(0, info, off += 8);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(this.config.getStationsMax(), info, off += 4);
        EtUtils.intToBytes(this.config.getAttachmentsMax(), info, off += 4);
        EtUtils.intToBytes(0, info, off += 4);
        EtUtils.intToBytes(this.config.getServerPort(), info, off += 4);
        EtUtils.intToBytes(this.config.getUdpPort(), info, off += 4);
        EtUtils.intToBytes(this.config.getMulticastPort(), info, off += 4);
        EtUtils.intToBytes(this.ipAddresses.length, info, off += 4);
        EtUtils.intToBytes(this.config.getMulticastAddrs().size(), info, off += 4);
        int totalInts = 27;
        int totalStringLen = 0;
        for (String addr : this.ipAddresses) {
            int len = addr.length() + 1;
            EtUtils.intToBytes(len, info, off += 4);
            ++totalInts;
            totalStringLen += len;
        }
        for (InetAddress addr : this.config.getMulticastAddrs()) {
            int len = addr.getHostAddress().length() + 1;
            EtUtils.intToBytes(len, info, off += 4);
            ++totalInts;
            totalStringLen += len;
        }
        int len = this.name.length() + 1;
        EtUtils.intToBytes(len, info, off += 4);
        int byteSize = 4 * ++totalInts + (totalStringLen += len);
        off += 4;
        for (String addr : this.ipAddresses) {
            try {
                byte[] outString = addr.getBytes("ASCII");
                System.arraycopy(outString, 0, info, off, outString.length);
                off += outString.length;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            info[off++] = 0;
        }
        for (InetAddress addr : this.config.getMulticastAddrs()) {
            try {
                byte[] outString = addr.getHostAddress().getBytes("ASCII");
                System.arraycopy(outString, 0, info, off, outString.length);
                off += outString.length;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            info[off++] = 0;
        }
        try {
            byte[] outString = this.name.getBytes("ASCII");
            System.arraycopy(outString, 0, info, off, outString.length);
            off += outString.length;
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        info[off] = 0;
        return byteSize;
    }

    private int writeStationData(byte[] info, int offset, int stationsMax) {
        int off = offset;
        int byteSize = 0;
        int statCount = 0;
        boolean isHead = true;
        byteSize += 4;
        off += 4;
        ListIterator<StationLocal> parallelIterator = null;
        ListIterator<StationLocal> mainIterator = this.stations.listIterator();
        StationLocal stat = mainIterator.next();
        while (true) {
            int offAtt = off;
            EtUtils.intToBytes(stat.getStationId(), info, off += 4);
            EtUtils.intToBytes(stat.getStatus(), info, off += 4);
            EtUtils.intToBytes(0, info, off += 4);
            int counter = 0;
            for (AttachmentLocal att : stat.getAttachments()) {
                EtUtils.intToBytes(att.getId(), info, off += 4);
                ++counter;
            }
            EtUtils.intToBytes(counter, info, offAtt);
            int numAtts = counter;
            EtUtils.intToBytes(0, info, off += 4);
            EtUtils.intToBytes(stat.getInputList().getEvents().size(), info, off += 4);
            EtUtils.longToBytes(stat.getInputList().getEventsTry(), info, off += 4);
            EtUtils.longToBytes(stat.getInputList().getEventsIn(), info, off += 8);
            EtUtils.intToBytes(0, info, off += 8);
            EtUtils.intToBytes(stat.getOutputList().getEvents().size(), info, off += 4);
            EtUtils.longToBytes(stat.getOutputList().getEventsOut(), info, off += 4);
            if (stat.getConfig().getFlowMode() == 1 && isHead) {
                EtUtils.intToBytes(2, info, off += 8);
            } else {
                EtUtils.intToBytes(stat.getConfig().getFlowMode(), info, off += 8);
            }
            EtUtils.intToBytes(stat.getConfig().getUserMode(), info, off += 4);
            EtUtils.intToBytes(stat.getConfig().getRestoreMode(), info, off += 4);
            EtUtils.intToBytes(stat.getConfig().getBlockMode(), info, off += 4);
            EtUtils.intToBytes(stat.getConfig().getPrescale(), info, off += 4);
            EtUtils.intToBytes(stat.getConfig().getCue(), info, off += 4);
            EtUtils.intToBytes(stat.getConfig().getSelectMode(), info, off += 4);
            int[] select = stat.getConfig().getSelect();
            for (int j = 0; j < 6; ++j) {
                EtUtils.intToBytes(select[j], info, off += 4);
            }
            int len1 = 0;
            if (stat.getConfig().getSelectFunction() != null) {
                len1 = stat.getConfig().getSelectFunction().length() + 1;
            }
            int len2 = 0;
            if (stat.getConfig().getSelectLibrary() != null) {
                len2 = stat.getConfig().getSelectLibrary().length() + 1;
            }
            int len3 = 0;
            if (stat.getConfig().getSelectClass() != null) {
                len3 = stat.getConfig().getSelectClass().length() + 1;
            }
            int len4 = stat.getStationName().length() + 1;
            EtUtils.intToBytes(len1, info, off += 4);
            EtUtils.intToBytes(len2, info, off += 4);
            EtUtils.intToBytes(len3, info, off += 4);
            EtUtils.intToBytes(len4, info, off += 4);
            off += 4;
            try {
                if (len1 > 0) {
                    byte[] outString = stat.getConfig().getSelectFunction().getBytes("ASCII");
                    System.arraycopy(outString, 0, info, off, outString.length);
                    off += outString.length;
                    info[off++] = 0;
                }
                if (len2 > 0) {
                    byte[] outString = stat.getConfig().getSelectLibrary().getBytes("ASCII");
                    System.arraycopy(outString, 0, info, off, outString.length);
                    off += outString.length;
                    info[off++] = 0;
                }
                if (len3 > 0) {
                    byte[] outString = stat.getConfig().getSelectClass().getBytes("ASCII");
                    System.arraycopy(outString, 0, info, off, outString.length);
                    off += outString.length;
                    info[off++] = 0;
                }
                byte[] outString = stat.getStationName().getBytes("ASCII");
                System.arraycopy(outString, 0, info, off, outString.length);
                off += outString.length;
                info[off++] = 0;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            byteSize += 4 * (19 + numAtts + 6) + 24 + len1 + len2 + len3 + len4;
            if (++statCount >= stationsMax) break;
            if (stat.getConfig().getFlowMode() == 1 && this.stations.contains(stat)) {
                parallelIterator = stat.getParallelStations().listIterator(1);
                if (parallelIterator.hasNext()) {
                    isHead = false;
                    stat = parallelIterator.next();
                    continue;
                }
            } else if (stat.getConfig().getFlowMode() == 1 && parallelIterator.hasNext()) {
                isHead = false;
                stat = parallelIterator.next();
                continue;
            }
            isHead = true;
            if (!mainIterator.hasNext()) continue;
            stat = mainIterator.next();
        }
        EtUtils.intToBytes(statCount, info, offset);
        return byteSize;
    }

    private int writeAttachmentData(byte[] info, int offset, int attsMax) {
        if (attsMax == 0) {
            EtUtils.intToBytes(0, info, offset);
            return 4;
        }
        int off = offset;
        int byteSize = 0;
        int attCount = 0;
        off += 4;
        byteSize += 4;
        for (AttachmentLocal att : this.attachments.values()) {
            EtUtils.intToBytes(att.getId(), info, off);
            EtUtils.intToBytes(-1, info, off += 4);
            EtUtils.intToBytes(att.getStation().getStationId(), info, off += 4);
            EtUtils.intToBytes(-1, info, off += 4);
            EtUtils.intToBytes(att.isWaiting() ? 1 : 0, info, off += 4);
            EtUtils.intToBytes(att.isWakeUp() ? 1 : 0, info, off += 4);
            int eventsOwned = 0;
            for (EtEventImpl ev : this.events) {
                if (ev.getOwner() != att.getId()) continue;
                ++eventsOwned;
            }
            EtUtils.intToBytes(eventsOwned, info, off += 4);
            EtUtils.longToBytes(att.getEventsPut(), info, off += 4);
            EtUtils.longToBytes(att.getEventsGet(), info, off += 8);
            EtUtils.longToBytes(att.getEventsDump(), info, off += 8);
            EtUtils.longToBytes(att.getEventsMake(), info, off += 8);
            int len1 = att.getHost().length() + 1;
            int len2 = att.getStation().getStationName().length() + 1;
            int len3 = att.getIpAddress().length() + 1;
            EtUtils.intToBytes(len1, info, off += 8);
            EtUtils.intToBytes(len2, info, off += 4);
            EtUtils.intToBytes(len3, info, off += 4);
            off += 4;
            try {
                byte[] outString = att.getHost().getBytes("ASCII");
                System.arraycopy(outString, 0, info, off, outString.length);
                off += outString.length;
                info[off++] = 0;
                outString = att.getStation().getStationName().getBytes("ASCII");
                System.arraycopy(outString, 0, info, off, outString.length);
                off += outString.length;
                info[off++] = 0;
                outString = att.getIpAddress().getBytes("ASCII");
                System.arraycopy(outString, 0, info, off, outString.length);
                off += outString.length;
                info[off++] = 0;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            byteSize += 72 + len1 + len2 + len3;
            if (++attCount < attsMax) continue;
            break;
        }
        EtUtils.intToBytes(attCount, info, offset);
        return byteSize;
    }
}

