/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.apps;

import java.util.ArrayList;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;

public class Producer {
    private static void usage() {
        System.out.println("\nUsage: java Producer -f <ET name> -host <ET host> [-h] [-v] [-r] [-c <chunk size>] [-d <delay>]\n                     [-s <event size>] [-g <group>] [-p <ET server port>] [-i <interface address>]\n\n       -host  ET system's host\n       -f     ET system's (memory-mapped file) name\n       -h     help\n       -v     verbose output\n       -r     act as remote (TCP) client even if ET system is local\n       -c     number of events in one get/put array\n       -d     delay in millisec between each round of getting and putting events\n       -s     event size in bytes\n       -g     group from which to get new events (1,2,...)\n       -p     ET server port\n       -i     preferred subnet/interface (dot-decimal)\n\n        This consumer works by making a direct connection to the\n        ET system's server port.\n");
    }

    public static void main(String[] args) {
        String etName = null;
        String host = null;
        String netInterface = null;
        int port = 11111;
        int group = 1;
        int delay = 0;
        int size = 32;
        int chunk = 1;
        boolean verbose = false;
        boolean remote = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-f")) {
                etName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                netInterface = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                try {
                    port = Integer.parseInt(args[++i]);
                    if (port >= 1024 && port <= 65535) continue;
                    System.out.println("Port number must be between 1024 and 65535.");
                    Producer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper port number.");
                    Producer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-c")) {
                try {
                    chunk = Integer.parseInt(args[++i]);
                    if (chunk >= 1 && chunk <= 1000) continue;
                    System.out.println("Chunk size may be 1 - 1000.");
                    Producer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper chunk size.");
                    Producer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-s")) {
                try {
                    size = Integer.parseInt(args[++i]);
                    if (size >= 1) continue;
                    System.out.println("Size needs to be positive int.");
                    Producer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper size.");
                    Producer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-g")) {
                try {
                    group = Integer.parseInt(args[++i]);
                    if (group >= 1 && group <= 10) continue;
                    System.out.println("Group number must be between 0 and 10.");
                    Producer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper group number.");
                    Producer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-d")) {
                try {
                    delay = Integer.parseInt(args[++i]);
                    if (delay >= 1) continue;
                    System.out.println("delay must be > 0.");
                    Producer.usage();
                    return;
                }
                catch (NumberFormatException ex) {
                    System.out.println("Did not specify a proper delay.");
                    Producer.usage();
                    return;
                }
            }
            if (args[i].equalsIgnoreCase("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                remote = true;
                continue;
            }
            Producer.usage();
            return;
        }
        if (host == null || etName == null) {
            Producer.usage();
            return;
        }
        try {
            ArrayList<String> mAddrs = new ArrayList<String>();
            mAddrs.add("239.200.0.0");
            EtSystemOpenConfig config = new EtSystemOpenConfig(etName, ".anywhere", mAddrs, port, 32);
            if (netInterface != null) {
                config.setNetworkInterface(netInterface);
            }
            EtSystem sys = new EtSystem(config);
            if (verbose) {
                sys.setDebug(4);
            }
            sys.open();
            EtStation gc = sys.stationNameToObject("GRAND_CENTRAL");
            EtAttachment att = sys.attach(gc);
            int count = 0;
            int skip = 5;
            int startingVal = 0;
            long totalT = 0L;
            long totalCount = 0L;
            int[] con = new int[6];
            for (int i = 0; i < 6; ++i) {
                con[i] = i + 1;
            }
            long t1 = System.currentTimeMillis();
            while (true) {
                EtEvent[] mevs = sys.newEvents(att, Mode.SLEEP, false, 0, chunk, size, group);
                if (delay > 0) {
                    Thread.sleep(delay);
                }
                for (int j = 0; j < mevs.length; ++j) {
                    mevs[j].getDataBuffer().putInt(j);
                    mevs[j].setLength(8);
                }
                startingVal += mevs.length;
                sys.putEvents(att, mevs);
                count += mevs.length;
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                if (time <= 5000L) continue;
                if (totalCount >= Long.MAX_VALUE - (long)count || totalT >= Long.MAX_VALUE - time) {
                    count = 0;
                    totalT = totalCount = (long)0;
                    t1 = System.currentTimeMillis();
                    continue;
                }
                double rate = 1000.0 * (double)count / (double)time;
                if (skip-- < 1) {
                    double avgRate = 1000.0 * (double)(totalCount += (long)count) / (double)(totalT += time);
                    System.out.println("rate = " + String.format("%.3g", rate) + " Hz,  avg = " + String.format("%.3g", avgRate));
                } else {
                    System.out.println("rate = " + String.format("%.3g", rate));
                }
                count = 0;
                t1 = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            System.out.println("Error using ET system as producer");
            ex.printStackTrace();
            return;
        }
    }
}

