/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.et.exception.EtException;

public class EtUtils {
    public static void shortToBytes(short data, ByteOrder byteOrder, byte[] dest, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >>> 8);
            dest[off + 1] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >>> 8);
        }
    }

    public static void intToBytes(int data, ByteOrder byteOrder, byte[] dest, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >> 24);
            dest[off + 1] = (byte)(data >> 16);
            dest[off + 2] = (byte)(data >> 8);
            dest[off + 3] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >> 8);
            dest[off + 2] = (byte)(data >> 16);
            dest[off + 3] = (byte)(data >> 24);
        }
    }

    public static void longToBytes(long data, ByteOrder byteOrder, byte[] dest, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >> 56);
            dest[off + 1] = (byte)(data >> 48);
            dest[off + 2] = (byte)(data >> 40);
            dest[off + 3] = (byte)(data >> 32);
            dest[off + 4] = (byte)(data >> 24);
            dest[off + 5] = (byte)(data >> 16);
            dest[off + 6] = (byte)(data >> 8);
            dest[off + 7] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >> 8);
            dest[off + 2] = (byte)(data >> 16);
            dest[off + 3] = (byte)(data >> 24);
            dest[off + 4] = (byte)(data >> 32);
            dest[off + 5] = (byte)(data >> 40);
            dest[off + 6] = (byte)(data >> 48);
            dest[off + 7] = (byte)(data >> 56);
        }
    }

    public static void shortToBytes(short shortVal, byte[] b, int off) {
        EtUtils.shortToBytes(shortVal, null, b, off);
    }

    public static void intToBytes(int intVal, byte[] b, int off) {
        EtUtils.intToBytes(intVal, null, b, off);
    }

    public static void longToBytes(long longVal, byte[] b, int off) {
        EtUtils.longToBytes(longVal, null, b, off);
    }

    public static short bytesToShort(byte[] data, ByteOrder byteOrder, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((0xFF & data[off]) << 8 | 0xFF & data[1 + off]);
        }
        return (short)(0xFF & data[off] | 0xFF & data[1 + off] << 8);
    }

    public static int bytesToInt(byte[] data, ByteOrder byteOrder, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (0xFF & data[off]) << 24 | (0xFF & data[1 + off]) << 16 | (0xFF & data[2 + off]) << 8 | 0xFF & data[3 + off];
        }
        return 0xFF & data[off] | (0xFF & data[1 + off]) << 8 | (0xFF & data[2 + off]) << 16 | (0xFF & data[3 + off]) << 24;
    }

    public static long bytesToLong(byte[] data, ByteOrder byteOrder, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (long)(0xFF & data[off]) << 56 | (long)(0xFF & data[1 + off]) << 48 | (long)(0xFF & data[2 + off]) << 40 | (long)(0xFF & data[3 + off]) << 32 | (long)(0xFF & data[4 + off]) << 24 | (long)(0xFF & data[5 + off]) << 16 | (long)(0xFF & data[6 + off]) << 8 | (long)(0xFF & data[7 + off]);
        }
        return (long)(0xFF & data[off]) | (long)(0xFF & data[1 + off]) << 8 | (long)(0xFF & data[2 + off]) << 16 | (long)(0xFF & data[3 + off]) << 24 | (long)(0xFF & data[4 + off]) << 32 | (long)(0xFF & data[5 + off]) << 40 | (long)(0xFF & data[6 + off]) << 48 | (long)(0xFF & data[7 + off]) << 56;
    }

    public static short bytesToShort(byte[] b, int off) {
        return EtUtils.bytesToShort(b, null, off);
    }

    public static int bytesToInt(byte[] b, int off) {
        return EtUtils.bytesToInt(b, null, off);
    }

    public static long bytesToLong(byte[] b, int off) {
        return EtUtils.bytesToLong(b, null, off);
    }

    public static void swapArrayInt(byte[] b, int off) {
        byte b1 = b[off];
        byte b2 = b[off + 1];
        byte b3 = b[off + 2];
        byte b4 = b[off + 3];
        b[off + 3] = b1;
        b[off + 2] = b2;
        b[off + 1] = b3;
        b[off] = b4;
    }

    public static void swapArrayShort(byte[] b, int off) {
        byte b1 = b[off];
        byte b2 = b[off + 1];
        b[off + 1] = b1;
        b[off] = b2;
    }

    public static List<String> getAllBroadcastAddresses() {
        LinkedList<String> ipList = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : inAddrs) {
                    Inet4Address bAddr;
                    try {
                        bAddr = (Inet4Address)ifAddr.getBroadcast();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (bAddr == null) continue;
                    ipList.add(bAddr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (ipList.size() < 1) {
            ipList.add("255.255.255.255");
        }
        return ipList;
    }

    public static String getMatchingLocalIpAddress(String ip) throws EtException {
        if (ip == null) {
            return null;
        }
        byte[] ipBytes = EtUtils.isDottedDecimal(ip);
        if (ipBytes == null) {
            throw new EtException("arg is not in dot-decimal (textual presentation) format");
        }
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address addrv4;
                    try {
                        addrv4 = (Inet4Address)ifAddr.getAddress();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (ip.equals(addrv4.getHostAddress())) {
                        return ip;
                    }
                    if (!ip.equals(ifAddr.getBroadcast().getHostAddress())) continue;
                    return addrv4.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static String getBroadcastAddress2(String ip) throws EtException {
        if (ip == null) {
            throw new EtException("arg is null");
        }
        byte[] ipBytes = EtUtils.isDottedDecimal(ip);
        if (ipBytes == null) {
            throw new EtException("arg is not in dot-decimal (textual presentation) format");
        }
        return null;
    }

    public static String getBroadcastAddress(String ip) throws EtException {
        if (ip == null) {
            throw new EtException("arg is null");
        }
        byte[] ipBytes = EtUtils.isDottedDecimal(ip);
        if (ipBytes == null) {
            throw new EtException("arg is not in dot-decimal (textual presentation) format");
        }
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address addrv4;
                    try {
                        addrv4 = (Inet4Address)ifAddr.getAddress();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (ip.equals(addrv4.getHostAddress())) {
                        return ifAddr.getBroadcast().getHostAddress();
                    }
                    if (!ip.equals(ifAddr.getBroadcast().getHostAddress())) continue;
                    return ip;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static List<String> orderIPAddresses(List<String> ipAddresses) {
        if (ipAddresses == null) {
            return null;
        }
        HashSet<String> ipSet = new HashSet<String>(ipAddresses);
        LinkedList<String> ipList = new LinkedList<String>();
        block6: for (String ip : ipSet) {
            try {
                Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                while (enumer.hasMoreElements()) {
                    NetworkInterface ni = enumer.nextElement();
                    if (!ni.isUp() || ni.isLoopback()) continue;
                    List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                    for (InterfaceAddress ifAddr : inAddrs) {
                        Inet4Address addrv4;
                        try {
                            addrv4 = (Inet4Address)ifAddr.getAddress();
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        int prefixLength = ifAddr.getNetworkPrefixLength();
                        int subnetMask = 0;
                        for (int j = 0; j < prefixLength; ++j) {
                            subnetMask |= 1 << 31 - j;
                        }
                        String localIP = addrv4.getHostAddress();
                        try {
                            if (!EtUtils.onSameSubnet(ip, localIP, subnetMask)) continue;
                            ipList.addFirst(ip);
                            continue block6;
                        }
                        catch (EtException e) {
                        }
                    }
                }
            }
            catch (SocketException e) {
                continue;
            }
            ipList.addLast(ip);
        }
        return ipList;
    }

    public static List<String> orderIPAddresses(List<String> ipAddresses, List<String> broadAddresses, String preferredAddress) {
        if (ipAddresses == null) {
            return null;
        }
        LinkedList<String> ipList = new LinkedList<String>();
        LinkedList<String> preferred = new LinkedList<String>();
        String prefSubnet = null;
        try {
            prefSubnet = EtUtils.getBroadcastAddress(preferredAddress);
        }
        catch (EtException e) {
            // empty catch block
        }
        block6: for (int i = 0; i < ipAddresses.size(); ++i) {
            if (broadAddresses != null && broadAddresses.size() > i) {
                String ipSubNet = broadAddresses.get(i);
                try {
                    Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                    while (enumer.hasMoreElements()) {
                        NetworkInterface ni = enumer.nextElement();
                        if (!ni.isUp() || ni.isLoopback()) continue;
                        List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                        for (InterfaceAddress ifAddr : ifAddrs) {
                            try {
                                Inet4Address addrv4 = (Inet4Address)ifAddr.getAddress();
                            }
                            catch (ClassCastException e) {
                                continue;
                            }
                            String localBroadcastAddr = ifAddr.getBroadcast().getHostAddress();
                            if (prefSubnet != null && prefSubnet.equals(ipSubNet) && prefSubnet.equals(localBroadcastAddr)) {
                                preferred.add(ipAddresses.get(i));
                                continue block6;
                            }
                            if (!localBroadcastAddr.equals(ipSubNet)) continue;
                            ipList.addFirst(ipAddresses.get(i));
                            continue block6;
                        }
                    }
                }
                catch (SocketException e) {
                    // empty catch block
                }
            }
            ipList.addLast(ipAddresses.get(i));
        }
        ipList.addAll(0, preferred);
        return ipList;
    }

    static boolean onSameSubnet(String ipAddress1, String ipAddress2, int subnetMask) throws EtException {
        if (ipAddress1 == null || ipAddress2 == null) {
            throw new EtException("null arg(s)");
        }
        byte[] ipBytes1 = EtUtils.isDottedDecimal(ipAddress1);
        byte[] ipBytes2 = EtUtils.isDottedDecimal(ipAddress2);
        if (ipBytes1 == null || ipBytes2 == null) {
            throw new EtException("one or both IP address args are not dot-decimal format");
        }
        int addr1 = ipBytes1[0] << 24 | ipBytes1[1] << 16 | ipBytes1[2] << 8 | ipBytes1[3];
        int addr2 = ipBytes2[0] << 24 | ipBytes2[1] << 16 | ipBytes2[2] << 8 | ipBytes2[3];
        return (addr1 & subnetMask) == (addr2 & subnetMask);
    }

    static boolean onSameSubnet(String ipAddress1, byte[] ipAddress2, int subnetMask) throws EtException {
        if (ipAddress1 == null || ipAddress2 == null) {
            throw new EtException("null arg(s)");
        }
        byte[] ipBytes1 = EtUtils.isDottedDecimal(ipAddress1);
        if (ipBytes1 == null) {
            throw new EtException("first IP address arg is not dot-decimal format");
        }
        int addr1 = ipBytes1[0] << 24 | ipBytes1[1] << 16 | ipBytes1[2] << 8 | ipBytes1[3];
        int addr2 = ipAddress2[0] << 24 | ipAddress2[1] << 16 | ipAddress2[2] << 8 | ipAddress2[3];
        return (addr1 & subnetMask) == (addr2 & subnetMask);
    }

    public static byte[] isDottedDecimal(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        Pattern pattern = Pattern.compile(IP_ADDRESS);
        Matcher matcher = pattern.matcher(ipAddress);
        if (!matcher.matches()) {
            return null;
        }
        int[] hostInts = new int[4];
        for (int i = 1; i <= 4; ++i) {
            hostInts[i - 1] = Integer.parseInt(matcher.group(i));
            if (hostInts[i - 1] <= 255 && hostInts[i - 1] >= 0) continue;
            return null;
        }
        byte[] hostBytes = new byte[]{(byte)hostInts[0], (byte)hostInts[1], (byte)hostInts[2], (byte)hostInts[3]};
        return hostBytes;
    }
}

