/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import com.loox.jloox.Lx;
import com.loox.jloox.LxAbstractGroup;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxGraph;
import com.loox.jloox.LxGroup;
import com.loox.jloox.LxHandle;
import com.loox.jloox.LxLink;
import com.loox.jloox.LxRectangle;
import com.loox.jloox.LxSlider;
import com.loox.jloox.LxText;
import com.loox.jloox.LxView;
import com.loox.jloox.layout.LxAlignLayout;
import com.loox.jloox.layout.LxTreeLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.data.AllData;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.monitorGui.MonitorFonts;

public class MonitorSingleSystem {
    private int updatePeriod;
    private int dividerPosition;
    private int graphHeight;
    private int orientation;
    private double attWidth;
    private double stationWidth;
    private double stationGap;
    private String key;
    private EtSystem sys;
    private AllData data;
    private boolean initialized;
    private boolean updated;
    private boolean isSolaris;
    private boolean isJava;
    private boolean isLinux;
    private boolean debug = false;
    private long rate;
    private long prevGcOut;
    private long time1;
    private long time2;
    private long updateTime;
    private final JSplitPane splitPane;
    private JScrollPane graphPane;
    private final JTree tree;
    private final DefaultTreeModel treeModel;
    private final LxView view;
    private final LxGraph graph;
    private final LxAlignLayout layout;
    private final LxLink mainLink1;
    private final LxLink mainLink2;
    private final DefaultMutableTreeNode topNode;
    private final DefaultMutableTreeNode systemNode;
    private final DefaultMutableTreeNode systemStaticNode;
    private final DefaultMutableTreeNode systemDynamicNode;
    private final DefaultMutableTreeNode stationNode;
    private final DefaultMutableTreeNode attachNode;
    private final DefaultMutableTreeNode processNode;
    private final HashMap stations;
    private final HashMap attachments;
    private final HashMap attachIcons;
    private final LinkedList stationManagers;
    private final LinkedList parallelManagers;
    public final Color stationColorDefault = Color.cyan;
    public final Color stationIdleColorDefault = Color.pink;
    public final Color attachColorDefault = new Color(255, 200, 255);
    public final Color eventColorDefault = Color.red;
    public final Color lineColorDefault = Color.black;
    public final Color textColorDefault = Color.black;
    public final Color textBackgroundColorDefault = Color.white;
    public final Color backgroundColorDefault = Color.white;
    public final Color treeTextColorDefault = Color.black;
    public final Color treeBackgroundColorDefault = Color.white;
    private Color stationColor = this.stationColorDefault;
    private Color stationIdleColor = this.stationIdleColorDefault;
    private Color attachColor = this.attachColorDefault;
    private Color eventColor = this.eventColorDefault;
    private Color lineColor = this.lineColorDefault;
    private Color textColor = this.textColorDefault;
    private Color textBackgroundColor = this.textBackgroundColorDefault;
    private Color backgroundColor = this.backgroundColorDefault;
    private Color treeTextColor = this.treeTextColorDefault;
    private Color treeBackgroundColor = this.treeBackgroundColorDefault;
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;

    public MonitorSingleSystem(EtSystem use, JTabbedPane tabbedPane, int period) {
        this(use, tabbedPane, period, tabbedPane.getWidth() / 2, 1, null);
    }

    public MonitorSingleSystem(EtSystem use, JTabbedPane tabbedPane, int period, int divider, int orient, Color[] colors) {
        this.sys = use;
        this.data = new AllData();
        this.updatePeriod = period;
        this.dividerPosition = divider;
        if (colors != null) {
            if (colors[0] != null) {
                this.stationColor = colors[0];
            }
            if (colors[1] != null) {
                this.stationIdleColor = colors[1];
            }
            if (colors[2] != null) {
                this.attachColor = colors[2];
            }
            if (colors[3] != null) {
                this.eventColor = colors[3];
            }
            if (colors[4] != null) {
                this.lineColor = colors[4];
            }
            if (colors[5] != null) {
                this.textColor = colors[5];
            }
            if (colors[6] != null) {
                this.textBackgroundColor = colors[6];
            }
            if (colors[7] != null) {
                this.backgroundColor = colors[7];
            }
            if (colors[8] != null) {
                this.treeTextColor = colors[8];
            }
            if (colors[9] != null) {
                this.treeBackgroundColor = colors[9];
            }
        }
        EtSystemOpenConfig config = this.sys.getConfig();
        this.key = this.sys.getHost().indexOf(".") < 0 ? new String(config.getEtName() + " (" + this.sys.getHost() + ")") : new String(config.getEtName() + " (" + this.sys.getHost().substring(0, this.sys.getHost().indexOf(".")) + ")");
        this.topNode = new DefaultMutableTreeNode(this.key);
        this.systemNode = new DefaultMutableTreeNode("System");
        this.systemStaticNode = new DefaultMutableTreeNode("Static Info");
        this.systemDynamicNode = new DefaultMutableTreeNode("Dynamic Info");
        this.stationNode = new DefaultMutableTreeNode("Stations");
        this.attachNode = new DefaultMutableTreeNode("Attachments");
        this.processNode = new DefaultMutableTreeNode("Proceses");
        this.topNode.add(this.systemNode);
        this.systemNode.add(this.systemStaticNode);
        this.systemNode.add(this.systemDynamicNode);
        this.topNode.add(this.stationNode);
        this.topNode.add(this.attachNode);
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setFont(MonitorFonts.treeFont);
        this.tree.setBackground(this.treeBackgroundColor);
        this.tree.setForeground(this.treeTextColor);
        this.tree.setDoubleBuffered(true);
        this.tree.setLargeModel(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setBackgroundNonSelectionColor(this.treeBackgroundColor);
        renderer.setTextNonSelectionColor(this.treeTextColor);
        this.tree.setCellRenderer(renderer);
        JScrollPane treePane = new JScrollPane(this.tree);
        this.graph = new LxGraph();
        this.view = (LxView)this.graph.addView();
        this.view.setEditMode(1);
        if (this.debug) {
            this.view.setEditMode(2);
        }
        this.view.setAntialiasingActivated(true);
        this.view.setDoubleBuffered(true);
        this.graphHeight = 304;
        this.view.setPreferredSize(new Dimension(500, this.graphHeight));
        this.view.setBackground(this.backgroundColor);
        this.graphPane = new JScrollPane();
        this.graphPane.setViewportView((Component)this.view);
        this.orientation = orient;
        this.splitPane = new JSplitPane(orient);
        this.splitPane.setLeftComponent(treePane);
        this.splitPane.setRightComponent(this.graphPane);
        this.splitPane.setDividerLocation(this.dividerPosition);
        this.splitPane.setPreferredSize(new Dimension(1100, 700));
        tabbedPane.addTab(this.key, null, this.splitPane, "monitored ET system");
        this.layout = new LxAlignLayout((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 600.0, this.graphHeight));
        this.layout.setOrder(0);
        this.layout.setOrientation(0);
        this.layout.setAlignAxisMethod(5);
        this.layout.setNormalAxisMethod(2);
        this.layout.setVisible(true);
        if (this.debug) {
            this.graph.add((LxComponent)this.layout);
        }
        int size1 = 20;
        int size2 = 50;
        try {
            size1 = this.sys.getStationsMax();
            size2 = this.sys.getAttachmentsMax();
        }
        catch (IOException ex) {
        }
        catch (EtClosedException ex) {
            // empty catch block
        }
        float loadfactor = 0.75f;
        this.stations = new HashMap(size1, loadfactor);
        this.attachments = new HashMap(size2, loadfactor);
        this.attachIcons = new HashMap(size2, loadfactor);
        this.stationManagers = new LinkedList();
        this.parallelManagers = new LinkedList();
        this.mainLink1 = new LxLink();
        this.mainLink2 = new LxLink();
        this.mainLink1.setLineArrow(2);
        this.mainLink1.setLineThickness(2.0f);
        this.mainLink1.setLineColor(this.lineColor);
        this.mainLink2.setLineArrow(8);
        this.mainLink2.setLineThickness(2.0f);
        this.mainLink2.setLineColor(this.lineColor);
        this.mainLink1.setName("link1");
        this.mainLink2.setName("link2");
    }

    public void setOrientation(int orient) {
        if (orient == this.orientation) {
            return;
        }
        this.splitPane.setOrientation(orient);
        if (orient == 1) {
            this.splitPane.setDividerLocation(this.dividerPosition);
            this.orientation = 1;
        } else {
            int height = this.splitPane.getHeight();
            height = height < 2 * (this.graphHeight + 50) ? height / 2 : height - (this.graphHeight + 50);
            this.splitPane.setDividerLocation(height);
            this.orientation = 0;
        }
        this.splitPane.updateUI();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean timeToUpdate() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.updateTime > (long)(1000 * this.updatePeriod);
    }

    public void setUpdatePeriod(int period) {
        this.updatePeriod = period < 1 ? 1 : period;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public int getDividerPosition() {
        return this.splitPane.getDividerLocation();
    }

    public Component getDisplayPane() {
        return this.splitPane;
    }

    public void treeDidChange() {
        this.tree.treeDidChange();
    }

    public void updateUI() {
        this.tree.updateUI();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public DefaultMutableTreeNode getNode() {
        return this.topNode;
    }

    public void getData() throws EtException, IOException, EtClosedException {
        this.data = this.sys.getData();
    }

    public void close() {
        this.sys.close();
    }

    public String getKey() {
        return this.key;
    }

    public Color getEventColor() {
        return new Color(this.eventColor.getRGB());
    }

    public Color getStationColor() {
        return new Color(this.stationColor.getRGB());
    }

    public Color getStationIdleColor() {
        return new Color(this.stationIdleColor.getRGB());
    }

    public Color getAttachmentColor() {
        return new Color(this.attachColor.getRGB());
    }

    public Color getLineColor() {
        return new Color(this.lineColor.getRGB());
    }

    public Color getTextColor() {
        return new Color(this.textColor.getRGB());
    }

    public Color getTextBackgroundColor() {
        return new Color(this.textBackgroundColor.getRGB());
    }

    public void staticDisplay() {
        int i;
        int limit;
        int end = 499;
        StringBuffer str = new StringBuffer(500);
        str.append("Host = ");
        str.append(this.sys.getHost());
        int lang = this.sys.getLanguage();
        if (lang != 2) {
            str.append(",  language = C,  pid = ");
            str.append(this.data.sysData.getMainPid());
            if (this.data.sysData.getShare() == 0) {
                this.isSolaris = true;
                this.topNode.add(this.processNode);
            } else {
                this.isLinux = true;
            }
        } else {
            this.isJava = true;
            str.append(",  language = Java");
        }
        if (this.data.sysData.isBit64()) {
            str.append(", bits = 64");
        } else {
            str.append(", bits = 32");
        }
        this.systemStaticNode.add(new DefaultMutableTreeNode(str.toString()));
        str.delete(0, end);
        str.append("Ports: tcp = ");
        str.append(this.data.sysData.getTcpPort());
        str.append(", udp = ");
        str.append(this.data.sysData.getUdpPort());
        str.append(", mcast = ");
        str.append(this.data.sysData.getMulticastPort());
        this.systemStaticNode.add(new DefaultMutableTreeNode(str.toString()));
        str.delete(0, end);
        str.append("Events: total = ");
        str.append(this.data.sysData.getEvents());
        str.append(", size = ");
        str.append(this.data.sysData.getEventSize());
        str.append(" bytes, temps = ");
        str.append(this.data.sysData.getTempsMax());
        this.systemStaticNode.add(new DefaultMutableTreeNode(str.toString()));
        str.delete(0, end);
        str.append("Max #: stations = ");
        str.append(this.data.sysData.getStationsMax());
        str.append(", attachments = ");
        str.append(this.data.sysData.getAttachmentsMax());
        if (this.isSolaris) {
            str.append(", processes = ");
            str.append(this.data.sysData.getProcessesMax());
        }
        this.systemStaticNode.add(new DefaultMutableTreeNode(str.toString()));
        str.delete(0, end);
        if (this.data.sysData.getInterfaces() > 0) {
            str.append("Network interfaces: ");
            limit = this.data.sysData.getInterfaces();
            for (i = 0; i < limit; ++i) {
                str.append(this.data.sysData.getInterfaceAddresses()[i]);
                if (i != limit - 1) {
                    str.append(", ");
                    continue;
                }
                break;
            }
        } else {
            str.append("network interfaces(0): none");
        }
        this.systemStaticNode.add(new DefaultMutableTreeNode(str.toString()));
        if (this.data.sysData.getMulticasts() > 0) {
            str.delete(0, end);
            str.append("Multicast addresses: ");
            limit = this.data.sysData.getMulticasts();
            for (i = 0; i < limit; ++i) {
                str.append(this.data.sysData.getMulticastAddresses()[i]);
                if (i == limit - 1) break;
                str.append(", ");
            }
            this.systemStaticNode.add(new DefaultMutableTreeNode(str.toString()));
        }
        this.initialized = true;
    }

    public void updateDisplay() {
        Integer attId;
        int j;
        int j2;
        String statName;
        int i;
        int end = 499;
        int[] kids3 = new int[]{0, 1, 2};
        int[] kids4 = new int[]{1, 2, 3, 4};
        int[] kids6 = new int[]{1, 2, 3, 4, 5, 6};
        boolean blocking = false;
        boolean isNewNode = false;
        StringBuffer str = new StringBuffer(end + 1);
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode leaf = null;
        DefaultMutableTreeNode statsNode = null;
        DefaultMutableTreeNode configNode = null;
        if (!this.updated) {
            this.time1 = System.currentTimeMillis();
            str.append("Event rate = ");
            str.append(this.rate);
            str.append(" Hz");
            this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
        }
        str.delete(0, end);
        str.append("Events owned by: ");
        str.append(" sys (");
        str.append(this.data.sysData.getEventsOwned());
        str.append("), atts ");
        for (int i2 = 0; i2 < this.data.attData.length; ++i2) {
            str.append(this.data.attData[i2].getId());
            str.append("(");
            str.append(this.data.attData[i2].getEventsOwned());
            str.append(")");
            if (i2 == this.data.attData.length - 1) break;
            str.append(", ");
        }
        if (this.updated) {
            leaf = this.systemDynamicNode.getFirstLeaf().getNextLeaf();
            leaf.setUserObject(str.toString());
        } else {
            this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
        }
        str.delete(0, end);
        str.append("Idle stations: ");
        boolean gotNone = true;
        for (i = 0; i < this.data.statData.length; ++i) {
            if (this.data.statData[i].getStatus() != 2) continue;
            str.append(this.data.statData[i].getName());
            str.append(", ");
            gotNone = false;
        }
        if (gotNone) {
            str.append("none");
        }
        if (this.updated) {
            leaf = leaf.getNextLeaf();
            leaf.setUserObject(str.toString());
        } else {
            this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
        }
        str.delete(0, end);
        str.append("All stations: ");
        for (i = 0; i < this.data.statData.length; ++i) {
            str.append(this.data.statData[i].getName());
            if (i == this.data.statData.length - 1) break;
            str.append(", ");
        }
        if (this.updated) {
            leaf = leaf.getNextLeaf();
            leaf.setUserObject(str.toString());
        } else {
            this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
        }
        str.delete(0, end);
        str.append("Stations =");
        str.append(this.data.sysData.getStations());
        str.append(", attachments = ");
        str.append(this.data.sysData.getAttachments());
        str.append(", temp events = ");
        str.append(this.data.sysData.getTemps());
        if (this.updated) {
            leaf = leaf.getNextLeaf();
            leaf.setUserObject(str.toString());
        } else {
            this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
        }
        if (!this.isJava) {
            str.delete(0, end);
            str.append("Processes = ");
            str.append(this.data.sysData.getProcesses());
            str.append(", hearbeat = ");
            str.append(this.data.sysData.getHeartbeat());
            if (this.updated) {
                leaf = leaf.getNextLeaf();
                leaf.setUserObject(str.toString());
            } else {
                this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
            }
            str.delete(0, end);
            str.append("Locked mutexes: ");
            if (this.data.sysData.getMutex() == 1) {
                str.append("sys, ");
            }
            if (this.data.sysData.getStatMutex() == 1) {
                str.append("stat, ");
            }
            if (this.data.sysData.getStatAddMutex() == 1) {
                str.append("add_stat, ");
            }
            for (i = 0; i < this.data.statData.length; ++i) {
                if (this.data.statData[i].getMutex() == 1) {
                    str.append(this.data.statData[i].getName());
                    str.append(", ");
                }
                if (this.data.statData[i].getInListMutex() == 1) {
                    str.append(this.data.statData[i].getName());
                    str.append("-in, ");
                }
                if (this.data.statData[i].getOutListMutex() != 1) continue;
                str.append(this.data.statData[i].getName());
                str.append("-out, ");
            }
            if (this.updated) {
                leaf = this.systemDynamicNode.getLastLeaf();
                leaf.setUserObject(str.toString());
                this.treeModel.nodesChanged(this.systemDynamicNode, kids6);
            } else {
                this.systemDynamicNode.add(new DefaultMutableTreeNode(str.toString()));
            }
        } else if (this.updated) {
            this.treeModel.nodesChanged(this.systemDynamicNode, kids4);
        }
        int numStations = this.data.statData.length;
        Iterator i3 = this.stations.keySet().iterator();
        block4: while (i3.hasNext()) {
            statName = (String)i3.next();
            for (j2 = 0; j2 < numStations; ++j2) {
                if (statName.equals(this.data.statData[j2].getName())) continue block4;
            }
            node = (DefaultMutableTreeNode)this.stations.get(statName);
            this.treeModel.removeNodeFromParent(node);
            i3.remove();
        }
        for (int i4 = 0; i4 < numStations; ++i4) {
            statName = this.data.statData[i4].getName();
            if (this.stations.containsKey(statName)) {
                isNewNode = false;
                node = (DefaultMutableTreeNode)this.stations.get(statName);
                configNode = (DefaultMutableTreeNode)node.getFirstChild();
                statsNode = (DefaultMutableTreeNode)node.getLastChild();
            } else {
                isNewNode = true;
                node = new DefaultMutableTreeNode(statName);
                configNode = new DefaultMutableTreeNode("Configuration");
                statsNode = new DefaultMutableTreeNode("Status");
                node.add(configNode);
                node.add(statsNode);
                this.stations.put(statName, node);
            }
            if (i4 != 0 || isNewNode) {
                str.delete(0, end);
                if (this.data.statData[i4].getFlowMode() == 0) {
                    str.append("Serial, ");
                } else {
                    str.append("Parallel, ");
                }
                if (this.data.statData[i4].getBlockMode() == 1) {
                    str.append("blocking, ");
                    blocking = true;
                    str.append("prescale = ");
                    str.append(this.data.statData[i4].getPrescale());
                    str.append(", (cue = ");
                    str.append(this.data.statData[i4].getCue());
                    str.append(")");
                } else {
                    str.append("nonblocking, ");
                    blocking = false;
                    str.append("cue = ");
                    str.append(this.data.statData[i4].getCue());
                    str.append(", (prescale = ");
                    str.append(this.data.statData[i4].getPrescale());
                    str.append(")");
                }
                if (isNewNode) {
                    configNode.add(new DefaultMutableTreeNode(str.toString()));
                } else {
                    leaf = configNode.getFirstLeaf();
                    leaf.setUserObject(str.toString());
                }
                str.delete(0, end);
                if (this.data.statData[i4].getUserMode() == 0) {
                    str.append("Users = multi");
                } else {
                    str.append("Users = ");
                    str.append(this.data.statData[i4].getUserMode());
                }
                if (this.data.statData[i4].getRestoreMode() == 0) {
                    str.append(", restore = out, ");
                } else if (this.data.statData[i4].getRestoreMode() == 1) {
                    str.append(", restore = in, ");
                } else {
                    str.append(", restore = GC, ");
                }
                if (this.data.statData[i4].getSelectMode() == 1) {
                    str.append("select = all");
                } else if (this.data.statData[i4].getSelectMode() == 2) {
                    str.append("select = match");
                } else if (this.data.statData[i4].getSelectMode() == 3) {
                    str.append("select = user");
                } else if (this.data.statData[i4].getSelectMode() == 4) {
                    str.append("select = rrobin");
                } else {
                    str.append("select = equalcue");
                }
                if (isNewNode) {
                    configNode.add(new DefaultMutableTreeNode(str.toString()));
                } else {
                    leaf = leaf.getNextLeaf();
                    leaf.setUserObject(str.toString());
                }
                str.delete(0, end);
                str.append("Select words: ");
                for (j2 = 0; j2 < 6; ++j2) {
                    str.append(this.data.statData[i4].getSelect()[j2]);
                    if (j2 == 5) break;
                    str.append(", ");
                }
                if (isNewNode) {
                    configNode.add(new DefaultMutableTreeNode(str.toString()));
                } else {
                    leaf = leaf.getNextLeaf();
                    leaf.setUserObject(str.toString());
                }
                if (this.data.statData[i4].getSelectMode() == 3) {
                    str.delete(0, end);
                    if (this.isJava) {
                        str.append("Class = ");
                        str.append(this.data.statData[i4].getSelectClass());
                    } else {
                        str.append("Function = ");
                        str.append(this.data.statData[i4].getSelectFunction());
                        str.append(", library = ");
                        str.append(this.data.statData[i4].getSelectLibrary());
                    }
                    if (isNewNode) {
                        configNode.add(new DefaultMutableTreeNode(str.toString()));
                    } else {
                        leaf = leaf.getNextLeaf();
                        leaf.setUserObject(str.toString());
                    }
                }
                if (!isNewNode) {
                    this.treeModel.nodesChanged(configNode, kids3);
                }
            }
            str.delete(0, end);
            if (this.data.statData[i4].getStatus() == 2) {
                str.append("Idle, ");
            } else {
                str.append("Active, ");
            }
            str.append("attachments: total = ");
            str.append(this.data.statData[i4].getAttachments());
            str.append(",  ids = ");
            int limit = this.data.statData[i4].getAttachments();
            for (j = 0; j < limit; ++j) {
                str.append(this.data.statData[i4].getAttachmentIds()[j]);
                if (j == limit - 1) break;
                str.append(", ");
            }
            if (isNewNode) {
                statsNode.add(new DefaultMutableTreeNode(str.toString()));
            } else {
                leaf = statsNode.getFirstLeaf();
                leaf.setUserObject(str.toString());
            }
            str.delete(0, end);
            str.append("Input events:   ");
            str.append(this.data.statData[i4].getInListCount());
            str.append(", total = ");
            str.append(this.data.statData[i4].getInListIn());
            if (blocking && this.data.statData[i4].getId() != 0) {
                str.append(", try = ");
                str.append(this.data.statData[i4].getInListTry());
            }
            str.append("            ");
            if (isNewNode) {
                statsNode.add(new DefaultMutableTreeNode(str.toString()));
            } else {
                leaf = leaf.getNextLeaf();
                leaf.setUserObject(str.toString());
            }
            str.delete(0, end);
            str.append("Output events: ");
            str.append(this.data.statData[i4].getOutListCount());
            str.append(", total = ");
            str.append(this.data.statData[i4].getOutListOut());
            str.append("            ");
            if (isNewNode) {
                statsNode.add(new DefaultMutableTreeNode(str.toString()));
                this.treeModel.insertNodeInto(node, this.stationNode, i4);
            } else {
                leaf = leaf.getNextLeaf();
                leaf.setUserObject(str.toString());
                this.treeModel.nodesChanged(statsNode, kids3);
            }
            if (i4 != 0 || !this.updated) continue;
            long gcOut = this.data.statData[i4].getOutListOut();
            this.time2 = System.currentTimeMillis();
            this.rate = 1000L * (gcOut - this.prevGcOut) / (this.time2 - this.time1);
            this.prevGcOut = gcOut;
            this.time1 = this.time2;
            str.delete(0, end);
            str.append("Event rate = ");
            str.append(this.rate);
            str.append(" Hz");
            leaf = this.systemDynamicNode.getFirstLeaf();
            leaf.setUserObject(str.toString());
            this.treeModel.nodeChanged(leaf);
        }
        if (this.isSolaris) {
            int numLeaves;
            int numProcs = this.data.procData.length;
            int leafCounter = numLeaves = this.processNode.getChildCount();
            if (numProcs > 0) {
                for (int i5 = 0; i5 < numProcs; ++i5) {
                    str.delete(0, end);
                    if (this.data.procData[i5].getAttachments() < 1) {
                        str.append("Id = ");
                        str.append(this.data.procData[i5].getId());
                        str.append(", no attachments, ");
                    } else {
                        str.append("Id = ");
                        str.append(this.data.procData[i5].getId());
                        str.append(", ");
                        str.append(this.data.procData[i5].getAttachments());
                        str.append(" attachments, ids = ");
                        for (int j3 = 0; j3 < this.data.procData[i5].getAttachments(); ++j3) {
                            str.append(this.data.procData[i5].getAttachmentIds()[j3]);
                            str.append(", ");
                        }
                    }
                    str.append("pid = ");
                    str.append(this.data.procData[i5].getPid());
                    str.append(", hbeat = ");
                    str.append(this.data.procData[i5].getHeartbeat());
                    if (leafCounter < 1) {
                        node = new DefaultMutableTreeNode(str.toString());
                        this.treeModel.insertNodeInto(node, this.processNode, i5);
                        continue;
                    }
                    node = (DefaultMutableTreeNode)this.processNode.getChildAt(i5);
                    node.setUserObject(str.toString());
                    --leafCounter;
                }
                if (numLeaves > 1) {
                    int i6;
                    leafCounter = numProcs > numLeaves ? numLeaves : numProcs;
                    int[] leaves = new int[leafCounter];
                    for (i6 = 0; i6 < leafCounter; ++i6) {
                        leaves[i6] = i6;
                    }
                    this.treeModel.nodesChanged(this.processNode, leaves);
                    if (numLeaves > numProcs) {
                        for (i6 = 0; i6 < numLeaves - numProcs; ++i6) {
                            node = (DefaultMutableTreeNode)this.processNode.getChildAt(i6 + numProcs);
                            this.treeModel.removeNodeFromParent(node);
                        }
                    }
                }
            }
        }
        int numAtts = this.data.attData.length;
        Iterator i7 = this.attachments.keySet().iterator();
        block13: while (i7.hasNext()) {
            attId = (Integer)i7.next();
            for (j = 0; j < numAtts; ++j) {
                if (attId.intValue() == this.data.attData[j].getId()) continue block13;
            }
            node = (DefaultMutableTreeNode)this.attachments.get(attId);
            this.treeModel.removeNodeFromParent(node);
            i7.remove();
        }
        if (this.data.attData.length > 0) {
            for (int i8 = 0; i8 < numAtts; ++i8) {
                attId = new Integer(this.data.attData[i8].getId());
                if (this.attachments.containsKey(attId)) {
                    isNewNode = false;
                    node = (DefaultMutableTreeNode)this.attachments.get(attId);
                } else {
                    isNewNode = true;
                    node = new DefaultMutableTreeNode(attId);
                    this.attachments.put(attId, node);
                }
                str.delete(0, end);
                str.append("Station = ");
                str.append(this.data.attData[i8].getStationName());
                str.append(", host = ");
                str.append(this.data.attData[i8].getHost());
                if (isNewNode) {
                    node.add(new DefaultMutableTreeNode(str.toString()));
                } else {
                    leaf = node.getFirstLeaf();
                    leaf.setUserObject(str.toString());
                }
                if (this.data.attData[i8].getIpAddress() != null) {
                    str.delete(0, end);
                    str.append("Sending ip address = ");
                    str.append(this.data.attData[i8].getIpAddress());
                    if (isNewNode) {
                        node.add(new DefaultMutableTreeNode(str.toString()));
                    } else {
                        leaf = leaf.getNextLeaf();
                        leaf.setUserObject(str.toString());
                    }
                }
                str.delete(0, end);
                if (this.data.attData[i8].blocked()) {
                    str.append("Blocked");
                } else {
                    str.append("Not blocked");
                }
                if (this.data.attData[i8].quitting()) {
                    str.append(", quitting");
                }
                if (!this.isJava) {
                    str.append(", pid = ");
                    str.append(this.data.attData[i8].getPid());
                    if (this.isSolaris) {
                        str.append(", proc = ");
                        str.append(this.data.attData[i8].getProc());
                    }
                }
                if (isNewNode) {
                    node.add(new DefaultMutableTreeNode(str.toString()));
                } else {
                    leaf = leaf.getNextLeaf();
                    leaf.setUserObject(str.toString());
                }
                str.delete(0, end);
                str.append("Own(");
                str.append(this.data.attData[i8].getEventsOwned());
                str.append("), make(");
                str.append(this.data.attData[i8].getEventsMake());
                str.append("), get(");
                str.append(this.data.attData[i8].getEventsGet());
                str.append("), put(");
                str.append(this.data.attData[i8].getEventsPut());
                str.append("), dump(");
                str.append(this.data.attData[i8].getEventsDump());
                str.append(")            ");
                if (isNewNode) {
                    node.add(new DefaultMutableTreeNode(str.toString()));
                    this.treeModel.insertNodeInto(node, this.attachNode, i8);
                    continue;
                }
                leaf = leaf.getNextLeaf();
                leaf.setUserObject(str.toString());
                this.treeModel.nodesChanged(node, kids3);
            }
        }
        this.updateGraph();
        this.updated = true;
        this.updateTime = System.currentTimeMillis();
    }

    private void makeStationIdle(LxGroup stat) {
        LxComponent[] comps = stat.getComponents();
        ((LxElement)comps[0]).setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.stationIdleColor, (float)200.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        ((LxRectangle)((LxAbstractGroup)comps[7]).getComponent(0)).setLineColor(this.stationIdleColor);
        ((LxRectangle)((LxAbstractGroup)comps[8]).getComponent(0)).setLineColor(this.stationIdleColor);
    }

    private void makeStationActive(LxGroup stat) {
        LxComponent[] comps = stat.getComponents();
        ((LxElement)comps[0]).setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.stationColor, (float)200.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        ((LxRectangle)((LxAbstractGroup)comps[7]).getComponent(0)).setLineColor(this.stationColor);
        ((LxRectangle)((LxAbstractGroup)comps[8]).getComponent(0)).setLineColor(this.stationColor);
    }

    private LxGroup makeStationIcon(String name, int status) {
        LxGroup station = new LxGroup();
        double width = this.stationWidth = 100.0;
        double height = 100.0;
        double border = 2.0;
        double textWidth = 90.0;
        double textHeight = 10.0;
        double textBoxHeight = 20.0;
        double x = 100.0;
        double y = 100.0;
        LxRectangle backgrd = new LxRectangle();
        backgrd.setSize(width, height);
        backgrd.setLocation(x, y);
        if (status == 3) {
            backgrd.setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.stationColor, (float)200.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        } else {
            backgrd.setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.stationIdleColor, (float)200.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        }
        station.add((LxComponent)backgrd, 0);
        LxRectangle textBackgrd = new LxRectangle();
        textBackgrd.setSize(width - 2.0 * border, textBoxHeight);
        textBackgrd.setCenter(x + width / 2.0, y + border + textBoxHeight / 2.0);
        textBackgrd.setPaint((Paint)this.textBackgroundColor);
        station.add((LxComponent)textBackgrd, 1);
        LxText text = new LxText(name);
        text.setSize(textWidth, textHeight);
        text.setCenter(x + width / 2.0, y + border + textBoxHeight / 2.0);
        text.setFont(MonitorFonts.graphFont);
        text.setPaint((Paint)this.textColor);
        text.setLineColor(this.textColor);
        LxText.setRegularTextAntialiased((boolean)true);
        station.add((LxComponent)text, 2);
        double recHeight = 14.0;
        double recTextHeight = 7.0;
        double recWidth = 35.0;
        double space = (width - 2.0 * recWidth) / 3.0;
        double yCenter = y + border + textBoxHeight + space + recHeight / 2.0;
        LxRectangle recIn = new LxRectangle();
        recIn.setSize(recWidth, recHeight);
        recIn.setCenter(x + space + recWidth / 2.0, yCenter);
        recIn.setPaint((Paint)this.textBackgroundColor);
        station.add((LxComponent)recIn, 3);
        LxRectangle recOut = new LxRectangle();
        recOut.setSize(recWidth, recHeight);
        recOut.setCenter(x + 2.0 * space + 1.5 * recWidth, yCenter);
        recOut.setPaint((Paint)this.textBackgroundColor);
        station.add((LxComponent)recOut, 4);
        LxText in = new LxText("In");
        in.setSize(recWidth - 25.0, recTextHeight);
        in.setCenter(x + space + recWidth / 2.0, yCenter);
        in.setFont(MonitorFonts.graphFont);
        LxText.setRegularTextAntialiased((boolean)true);
        in.setPaint((Paint)this.textColor);
        in.setLineColor(this.textColor);
        station.add((LxComponent)in, 5);
        LxText out = new LxText("Out");
        out.setSize(recWidth - 15.0, recTextHeight);
        out.setCenter(x + 2.0 * space + 1.5 * recWidth, yCenter);
        out.setFont(MonitorFonts.graphFont);
        LxText.setRegularTextAntialiased((boolean)true);
        out.setPaint((Paint)this.textColor);
        out.setLineColor(this.textColor);
        station.add((LxComponent)out, 6);
        double slideHeight = height - (5.0 * border + space + textBoxHeight + recHeight);
        double yTop = y + border + textBoxHeight + space + recHeight + 2.0 * border;
        double sliderWidth = 20.0;
        space = (width - 2.0 * sliderWidth) / 3.0;
        LxRectangle inBox = new LxRectangle();
        inBox.setName("BOX");
        inBox.setLocation(x + space, yTop);
        inBox.setSize(sliderWidth, slideHeight);
        if (status == 3) {
            inBox.setLineColor(this.stationColor);
        } else {
            inBox.setLineColor(this.stationIdleColor);
        }
        inBox.setLineThickness(2.0f);
        LxRectangle inIndic = new LxRectangle();
        inIndic.setName("INDICATOR");
        inIndic.setLocation(x + space, yTop);
        inIndic.setSize(sliderWidth, slideHeight);
        inIndic.setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.eventColor, (float)45.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        inIndic.setLineColor(this.eventColor);
        LxSlider inSlider = new LxSlider(false, false);
        inSlider.setName("inCount");
        inSlider.setMaximum((double)this.sys.getNumEvents());
        inSlider.setMinimum(0.0);
        inSlider.setValue(0.0);
        inSlider.add((LxComponent)inBox);
        inSlider.add((LxComponent)inIndic);
        LxRectangle outBox = new LxRectangle();
        outBox.setName("BOX");
        outBox.setLocation(x + 2.0 * space + sliderWidth, yTop);
        outBox.setSize(sliderWidth, slideHeight);
        if (status == 3) {
            outBox.setLineColor(this.stationColor);
        } else {
            outBox.setLineColor(this.stationIdleColor);
        }
        outBox.setLineThickness(2.0f);
        LxRectangle outIndic = new LxRectangle();
        outIndic.setName("INDICATOR");
        outIndic.setLocation(x + 2.0 * space + sliderWidth, yTop);
        outIndic.setSize(sliderWidth, slideHeight);
        outIndic.setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.eventColor, (float)45.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        outIndic.setLineColor(this.eventColor);
        LxSlider outSlider = new LxSlider(false, false);
        outSlider.setName("outCount");
        outSlider.setMaximum((double)this.sys.getNumEvents());
        outSlider.setMinimum(0.0);
        outSlider.setValue(0.0);
        outSlider.add((LxComponent)outBox);
        outSlider.add((LxComponent)outIndic);
        station.add((LxComponent)inSlider, 7);
        station.add((LxComponent)outSlider, 8);
        return station;
    }

    private LxGroup makeAttachmentIcon(String name) {
        LxGroup attachment = new LxGroup();
        double width = this.attWidth = 40.0;
        double height = 80.0;
        double border = 2.0;
        double textWidth = 10.0;
        double textHeight = 10.0;
        double textBoxHeight = 20.0;
        double x = 150.0;
        double y = 150.0;
        LxRectangle rec = new LxRectangle();
        rec.setSize(width, height);
        rec.setLocation(x, y);
        rec.setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.attachColor, (float)45.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        attachment.add((LxComponent)rec, 0);
        LxRectangle rec2 = new LxRectangle();
        rec2.setSize(width - 2.0 * border, textBoxHeight);
        rec2.setCenter(x + width / 2.0, y + border + textBoxHeight / 2.0);
        rec2.setPaint((Paint)this.textBackgroundColor);
        attachment.add((LxComponent)rec2, 1);
        LxText text = new LxText(name);
        text.setSize(textWidth, textHeight);
        text.setCenter(x + width / 2.0, y + border + textBoxHeight / 2.0);
        text.setFont(MonitorFonts.graphFont);
        text.setPaint((Paint)this.textColor);
        text.setLineColor(this.textColor);
        LxText.setRegularTextAntialiased((boolean)true);
        attachment.add((LxComponent)text, 2);
        double sliderWidth = 20.0;
        double space = (width - sliderWidth) / 2.0;
        double sliderHeight = height - (3.0 * border + space + textBoxHeight);
        double yTop = y + border + textBoxHeight + space;
        LxRectangle box = new LxRectangle();
        box.setName("BOX");
        box.setLocation(x + space, yTop);
        box.setSize(sliderWidth, sliderHeight);
        box.setLineColor(this.attachColor);
        box.setLineThickness(2.0f);
        LxRectangle indic = new LxRectangle();
        indic.setName("INDICATOR");
        indic.setLocation(x + space, yTop);
        indic.setSize(sliderWidth, sliderHeight);
        indic.setPaint(Lx.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.eventColor, (float)45.0f, (float)0.0f, (Color)Color.black, (boolean)true));
        indic.setLineColor(this.eventColor);
        LxSlider slider = new LxSlider(false, false);
        slider.setName("count");
        slider.setMaximum((double)this.sys.getNumEvents());
        slider.setMinimum(0.0);
        slider.setValue(0.0);
        slider.add((LxComponent)box);
        slider.add((LxComponent)indic);
        attachment.add((LxComponent)slider, 3);
        return attachment;
    }

    private void updateGraph() {
        StationFlowData userData;
        StationLinkData linkData;
        LxComponent[] comps;
        String stationName;
        double width = 0.0;
        double height = 0.0;
        LxGroup icon = null;
        LxGroup statIcon = null;
        LxGroup firstIcon = null;
        LxHandle handleA = null;
        LxHandle handleB = null;
        LxHandle handleLeftGC = null;
        LxHandle handleRightGC = null;
        LxTreeLayout statManager = null;
        LxTreeLayout prevStatManager = null;
        LxAlignLayout parallelManager = null;
        LxAlignLayout prevParallelManager = null;
        LxAlignLayout parallelLayout = null;
        String statName = null;
        int numStations = this.data.statData.length;
        boolean gotStation = false;
        boolean redoLinks = false;
        boolean didParallelLinks = false;
        boolean newParallelManager = false;
        this.stationGap = 30.0;
        double standardHeight = 270.0;
        if (this.stationManagers.size() < 1) {
            redoLinks = true;
        } else {
            if (numStations != this.stationManagers.size()) {
                redoLinks = true;
            } else {
                for (int i = 0; i < numStations; ++i) {
                    statManager = (LxTreeLayout)this.stationManagers.get(i);
                    if (statManager == null) {
                        redoLinks = true;
                        break;
                    }
                    stationName = statManager.getName();
                    statName = this.data.statData[i].getName();
                    if (statName.equals(stationName)) continue;
                    redoLinks = true;
                    break;
                }
            }
            if (redoLinks) {
                comps = this.graph.getComponents();
                for (int j = 0; j < comps.length; ++j) {
                    if (!comps[j].getName().equals("station") || (linkData = (StationLinkData)(statIcon = (LxGroup)comps[j]).getUserData()) == null) continue;
                    this.graph.remove((LxComponent)linkData.link1);
                    this.graph.remove((LxComponent)linkData.link2);
                    linkData = null;
                    statIcon.setUserData(null);
                }
            }
        }
        if (numStations < this.stationManagers.size()) {
            ListIterator it = this.stationManagers.listIterator();
            while (it.hasNext()) {
                int i;
                statManager = (LxTreeLayout)it.next();
                stationName = statManager.getName();
                gotStation = false;
                for (i = 0; i < numStations; ++i) {
                    if (!stationName.equals(this.data.statData[i].getName())) continue;
                    gotStation = true;
                    break;
                }
                if (gotStation) continue;
                statIcon = (LxGroup)statManager.getComponent(0);
                if (this.mainLink1.getHandle2() == statIcon.getHandle(2)) {
                    this.mainLink1.setHandles(this.mainLink1.getHandle1(), this.mainLink2.getHandle2());
                    this.mainLink2.setHandles(this.mainLink1.getHandle1(), this.mainLink2.getHandle2());
                    this.graph.remove((LxComponent)this.mainLink1);
                    this.graph.remove((LxComponent)this.mainLink2);
                }
                comps = statManager.getComponents();
                for (i = 0; i < comps.length; ++i) {
                    this.graph.remove(comps[i]);
                    if (!(comps[i] instanceof LxGroup) || i <= 0) continue;
                    this.attachIcons.remove(new Integer(Integer.parseInt(comps[i].getName())));
                }
                userData = (StationFlowData)statManager.getUserData();
                parallelLayout = userData.parentLayout;
                parallelLayout.remove((LxComponent)statManager);
                int statCount = parallelLayout.getComponentCount();
                if (parallelLayout.getComponentCount() > 0) {
                    parallelLayout.setHeight((double)statCount * (standardHeight + 5.0));
                }
                if (this.debug) {
                    this.graph.remove((LxComponent)statManager);
                }
                it.remove();
            }
        }
        ListIterator<LxAlignLayout> pList = this.parallelManagers.listIterator();
        int parallelPlace = 0;
        for (int i = 0; i < numStations; ++i) {
            int att;
            int j;
            LxLink link;
            int limit;
            block64: {
                block63: {
                    double totalAttWidth;
                    statName = this.data.statData[i].getName();
                    gotStation = false;
                    int position = 0;
                    ListIterator it = this.stationManagers.listIterator();
                    while (it.hasNext()) {
                        statManager = (LxTreeLayout)it.next();
                        stationName = statManager.getName();
                        if (statName.equals(stationName)) {
                            gotStation = true;
                            break;
                        }
                        ++position;
                    }
                    if (this.data.statData[i].getFlowMode() == 1) {
                        parallelManager = prevParallelManager;
                        newParallelManager = false;
                    } else if (pList.hasNext()) {
                        parallelManager = (LxAlignLayout)pList.next();
                        newParallelManager = false;
                    } else {
                        parallelManager = new LxAlignLayout((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 100.0, standardHeight + 5.0));
                        parallelManager.setOrder(0);
                        parallelManager.setOrientation(1);
                        parallelManager.setAlignAxisMethod(5);
                        parallelManager.setNormalAxisMethod(1);
                        parallelManager.setLineColor(Color.green);
                        parallelManager.setLineThickness(1.0f);
                        parallelManager.setVisible(true);
                        pList.add(parallelManager);
                        newParallelManager = true;
                    }
                    if (this.data.statData[i].getFlowMode() != 1) {
                        parallelPlace = 0;
                        prevParallelManager = parallelManager;
                    } else {
                        ++parallelPlace;
                    }
                    parallelManager.setHeight((double)(parallelPlace + 1) * (standardHeight + 5.0));
                    if (gotStation) {
                        statIcon = (LxGroup)statManager.getComponent(0);
                        if (this.data.statData[i].getStatus() == 2) {
                            this.makeStationIdle(statIcon);
                        } else {
                            this.makeStationActive(statIcon);
                        }
                        if (position != i) {
                            this.stationManagers.remove(statManager);
                            this.stationManagers.add(i, statManager);
                        }
                        userData = (StationFlowData)statManager.getUserData();
                        parallelLayout = userData.parentLayout;
                        userData.flowMode = this.data.statData[i].getFlowMode();
                        userData.isHead = false;
                        if (userData.flowMode == 2) {
                            userData.isHead = true;
                        }
                        if (parallelLayout == parallelManager) {
                            if (parallelManager.getComponentIndex((LxComponent)statManager) != parallelPlace) {
                                parallelManager.remove((LxComponent)statManager);
                                parallelManager.add((LxComponent)statManager, parallelPlace);
                            }
                        } else {
                            parallelLayout.remove((LxComponent)statManager);
                            parallelManager.add((LxComponent)statManager, parallelPlace);
                            userData.parentLayout = parallelManager;
                        }
                    } else {
                        statManager = new LxTreeLayout((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 110.0, standardHeight));
                        statManager.setOrientation(1);
                        statManager.setMethod(1);
                        statManager.setFixedSpacing(true);
                        statManager.setFixedXSpacing(5.0);
                        statManager.setFixedYSpacing(60.0);
                        statManager.setName(statName);
                        statManager.setVisible(true);
                        statManager.setLineColor(Color.red);
                        statManager.setLineThickness(1.0f);
                        statManager.setOrder(0);
                        this.stationManagers.add(i, statManager);
                        userData = new StationFlowData();
                        userData.flowMode = this.data.statData[i].getFlowMode();
                        userData.isHead = false;
                        if (userData.flowMode == 2) {
                            userData.isHead = true;
                        }
                        userData.parentLayout = parallelManager;
                        statManager.setUserData((Object)userData);
                        statIcon = this.makeStationIcon(statName, this.data.statData[i].getStatus());
                        statIcon.setName("station");
                        this.graph.add((LxComponent)statIcon);
                        statManager.add((LxComponent)statIcon, 0);
                        statManager.setRoot((LxComponent)statIcon);
                        parallelManager.add((LxComponent)statManager, parallelPlace);
                        if (this.debug) {
                            this.graph.add((LxComponent)statManager);
                        }
                    }
                    if (i == 0) {
                        firstIcon = statIcon;
                        handleLeftGC = statIcon.getHandle(2);
                        handleRightGC = statIcon.getHandle(6);
                    }
                    if (newParallelManager) {
                        this.layout.add((LxComponent)parallelManager);
                        if (this.debug) {
                            this.graph.add((LxComponent)parallelManager);
                        }
                    }
                    double newWidth = (totalAttWidth = (double)(limit = this.data.statData[i].getAttachments()) * (this.attWidth + 5.0)) > this.stationWidth + 6.0 ? totalAttWidth : this.stationWidth + 6.0;
                    statManager.setWidth(newWidth);
                    width = parallelManager.getWidth();
                    if (userData.flowMode != 0) {
                        if (!newParallelManager && userData.flowMode == 2) {
                            parallelManager.setWidth(newWidth + 50.0);
                        } else if (width < newWidth + 49.0) {
                            parallelManager.setWidth(newWidth + 50.0);
                        }
                    } else {
                        parallelManager.setWidth(newWidth + 50.0);
                    }
                    if (!redoLinks || i == 0) break block63;
                    if (userData.flowMode != 1) {
                        this.mainLink1.setHandles(handleRightGC, statIcon.getHandle(2));
                        this.mainLink2.setHandles(statIcon.getHandle(6), handleLeftGC);
                    } else {
                        link = new LxLink(handleA, statIcon.getHandle(2));
                        link.setLinkType((short)2);
                        link.setLineArrow(2);
                        link.setLineThickness(1.5f);
                        link.setLineColor(this.lineColor);
                        int linkWidth = (int)(parallelManager.getWidth() / 2.0) - 60;
                        link.setMinimumSegmentLength(linkWidth);
                        this.graph.add((LxComponent)link, 0);
                        LxLink link2 = new LxLink(handleB, statIcon.getHandle(6));
                        link2.setLinkType((short)2);
                        link2.setLineArrow(0);
                        link2.setLineThickness(1.5f);
                        link2.setLineColor(this.lineColor);
                        link2.setMinimumSegmentLength(linkWidth);
                        this.graph.add((LxComponent)link2, 0);
                        statIcon.setUserData((Object)new StationLinkData(link, link2));
                        statIcon.setCenterY(statIcon.getCenterY() + 100.0);
                        didParallelLinks = true;
                    }
                    if (i != numStations - 1) break block64;
                    if (this.graph.getComponent("link1") == null) {
                        this.graph.add((LxComponent)this.mainLink1, 0);
                    }
                    if (this.graph.getComponent("link2") != null) break block64;
                    this.graph.add((LxComponent)this.mainLink2, 1);
                    break block64;
                }
                if (userData.flowMode == 1) {
                    comps = parallelManager.getComponents();
                    for (j = 1; j < comps.length; ++j) {
                        icon = (LxGroup)((LxTreeLayout)comps[j]).getComponent(0);
                        linkData = (StationLinkData)icon.getUserData();
                        if (linkData == null) continue;
                        statIcon.setCenterY(statIcon.getCenterY() + 100.0);
                        int linkWidth = (int)(parallelManager.getWidth() / 2.0) - 60;
                        linkData.link1.setMinimumSegmentLength(linkWidth);
                        if (linkData.link2 == null) continue;
                        linkData.link2.setMinimumSegmentLength(linkWidth);
                    }
                }
            }
            LxSlider slider = (LxSlider)statIcon.getComponent(7);
            slider.setValue((double)this.data.statData[i].getInListCount());
            slider = (LxSlider)statIcon.getComponent(8);
            slider.setValue((double)this.data.statData[i].getOutListCount());
            prevStatManager = statManager;
            if (userData.flowMode != 1) {
                handleB = statIcon.getHandle(6);
                handleA = statIcon.getHandle(2);
            }
            if ((comps = statManager.getComponents()).length > 1) {
                for (j = 0; j < comps.length; ++j) {
                    try {
                        if (comps[j] instanceof LxLink || comps[j].getName().equals("station")) continue;
                        boolean match = false;
                        int previousAtt = Integer.parseInt(((LxGroup)comps[j]).getName());
                        for (int k = 0; k < limit; ++k) {
                            att = this.data.statData[i].getAttachmentIds()[k];
                            if (att != previousAtt) continue;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        statManager.remove(comps[j]);
                        this.graph.remove(comps[j]);
                        this.graph.remove((LxComponent)((LxLink)comps[j].getUserData()));
                        this.attachIcons.remove(new Integer(previousAtt));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
            LxGroup attIcon = null;
            block12: for (int j2 = 0; j2 < limit; ++j2) {
                att = this.data.statData[i].getAttachmentIds()[j2];
                boolean addLink = false;
                Integer attId = new Integer(att);
                if (this.attachIcons.containsKey(attId)) {
                    attIcon = (LxGroup)this.attachIcons.get(attId);
                    if (statManager.getComponent("" + att) == null) {
                        statManager.add((LxComponent)attIcon);
                        addLink = true;
                    }
                } else {
                    attIcon = this.makeAttachmentIcon(attId.toString());
                    attIcon.setName("" + att);
                    this.attachIcons.put(attId, attIcon);
                    this.graph.add((LxComponent)attIcon);
                    statManager.add((LxComponent)attIcon);
                    addLink = true;
                }
                if (addLink) {
                    link = new LxLink(statIcon.getHandle(4), attIcon.getHandle(8));
                    link.setLineColor(this.lineColor);
                    link.setStartOnBorder(true);
                    this.graph.add((LxComponent)link);
                    attIcon.setUserData((Object)link);
                }
                slider = (LxSlider)attIcon.getComponent(3);
                for (int k = 0; k < this.data.attData.length; ++k) {
                    if (this.data.attData[k].getId() != att) continue;
                    slider.setValue((double)this.data.attData[k].getEventsOwned());
                    continue block12;
                }
            }
        }
        while (pList.hasNext()) {
            parallelLayout = (LxAlignLayout)pList.next();
            pList.remove();
            this.layout.remove((LxComponent)parallelLayout);
            if (!this.debug) continue;
            this.graph.remove((LxComponent)parallelLayout);
        }
        width = 0.0;
        height = 0.0;
        double tempHeight = 0.0;
        ListIterator li = this.parallelManagers.listIterator();
        while (li.hasNext()) {
            parallelLayout = (LxAlignLayout)li.next();
            width += parallelLayout.getWidth();
            tempHeight = parallelLayout.getHeight();
            if (!(height < tempHeight)) continue;
            height = tempHeight;
        }
        this.layout.setWidth(width += (double)(this.parallelManagers.size() - 1) * this.stationGap + 60.0);
        this.layout.setHeight(height + 5.0);
        this.view.setPreferredSize(new Dimension((int)width, (int)height));
        this.graphPane.updateUI();
        this.layout.setPropagate(true);
        this.layout.run();
        if (numStations > 1) {
            double deltaX = 20.0;
            double deltaY = 70.0;
            double[] tempPath = new double[12];
            Point2D[] tempPoints = this.mainLink2.getPathPoints();
            tempPath[0] = tempPoints[0].getX();
            tempPath[1] = tempPoints[0].getY();
            tempPath[10] = tempPoints[tempPoints.length - 1].getX();
            tempPath[11] = tempPoints[tempPoints.length - 1].getY();
            tempPath[2] = tempPath[0] + parallelManager.getWidth() / 2.0 - 60.0;
            tempPath[3] = tempPath[1];
            tempPath[4] = tempPath[2];
            tempPath[5] = tempPath[1] - deltaY;
            tempPath[6] = tempPath[10] - deltaX;
            tempPath[7] = tempPath[1] - deltaY;
            tempPath[8] = tempPath[10] - deltaX;
            tempPath[9] = tempPath[11];
            this.mainLink2.setPath(tempPath);
        }
    }

    class StationLinkData {
        LxLink link1;
        LxLink link2;

        public StationLinkData(LxLink l1) {
            this.link1 = l1;
        }

        public StationLinkData(LxLink l1, LxLink l2) {
            this.link1 = l1;
            this.link2 = l2;
        }
    }

    class StationFlowData {
        int flowMode;
        boolean isHead;
        LxAlignLayout parentLayout;

        StationFlowData() {
        }
    }
}

