/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.exception.EtException;

public class EtSystemOpenConfig {
    public static final String broadcastIP = "255.255.255.255";
    private String name;
    private String host;
    private String networkInterface;
    private boolean broadcasting;
    private HashSet<String> broadcastAddrs;
    private HashSet<String> multicastAddrs;
    private boolean connectRemotely;
    private int networkContactMethod;
    private int udpPort;
    private int tcpPort;
    private int multicastPort;
    private int ttl;
    private int responsePolicy;
    private long waitTime;
    private int tcpSendBufSize;
    private int tcpRecvBufSize;
    private boolean noDelay;

    public EtSystemOpenConfig() {
        this.broadcasting = true;
        this.connectRemotely = false;
        this.networkContactMethod = 1;
        this.multicastPort = 11112;
        this.udpPort = 11111;
        this.tcpPort = 11111;
        this.ttl = 32;
        this.responsePolicy = 2;
        this.broadcastAddrs = new HashSet(10);
        this.multicastAddrs = new HashSet(10);
    }

    public EtSystemOpenConfig(String etName, String hostName, Collection<String> bAddrs, Collection<String> mAddrs, boolean remoteOnly, int method, int tPort, int uPort, int mPort, int ttlNum, int policy) throws EtException {
        this.name = etName;
        if (etName == null || etName.equals("")) {
            throw new EtException("Bad ET system name");
        }
        if (etName.length() > 101) {
            throw new EtException("ET system name too long (> 101 chars)");
        }
        this.host = hostName;
        if ((this.host == null || this.host.equals("")) && method != 1) {
            throw new EtException("Bad host or location name");
        }
        boolean noMulticastAddrs = true;
        if (mAddrs == null || mAddrs.size() < 1) {
            this.multicastAddrs = new HashSet(10);
            this.multicastAddrs.add("239.200.0.0");
            noMulticastAddrs = false;
        } else {
            this.multicastAddrs = new HashSet<String>(mAddrs);
            noMulticastAddrs = false;
        }
        this.connectRemotely = remoteOnly;
        if (method != 0 && method != 1 && method != 3 && method != 2) {
            throw new EtException("Bad contact method value");
        }
        this.networkContactMethod = method;
        boolean bl = this.broadcasting = this.networkContactMethod == 1 || this.networkContactMethod == 3;
        this.broadcastAddrs = bAddrs == null || bAddrs.size() < 1 ? (this.broadcasting ? new HashSet<String>(EtUtils.getAllBroadcastAddresses()) : new HashSet(10)) : new HashSet<String>(bAddrs);
        if (this.networkContactMethod == 2) {
            if (this.host.equals(".remote") || this.host.equals(".anywhere")) {
                throw new EtException("Need to specify an actual host name");
            }
        } else if ((this.networkContactMethod == 0 || this.networkContactMethod == 3) && noMulticastAddrs) {
            throw new EtException("Need to specify a multicast address");
        }
        if (uPort < 1024 || uPort > 65535) {
            throw new EtException("Bad UDP port value");
        }
        this.udpPort = uPort;
        if (tPort < 1024 || tPort > 65535) {
            throw new EtException("Bad TCP port value");
        }
        this.tcpPort = tPort;
        if (mPort < 1024 || mPort > 65535) {
            throw new EtException("Bad multicast port value");
        }
        this.multicastPort = mPort;
        if (ttlNum < 0 || ttlNum > 254) {
            throw new EtException("Bad TTL value");
        }
        this.ttl = ttlNum;
        if (policy != 0 && policy != 1 && policy != 2) {
            throw new EtException("Bad policy value");
        }
        if (this.host.equals(".remote") && policy == 1) {
            throw new EtException("Policy value cannot be local if host is remote");
        }
        this.responsePolicy = policy;
    }

    public EtSystemOpenConfig(String etName, String hostName) throws EtException {
        this(etName, hostName, null, null, false, 1, 11111, 11111, 11112, 32, 0);
    }

    public EtSystemOpenConfig(String etName, int uPort, String hostName) throws EtException {
        this(etName, hostName, null, null, false, 1, 11111, uPort, 11112, 32, 0);
    }

    public EtSystemOpenConfig(String etName, String hostName, Collection<String> mAddrs, int mPort, int ttlNum) throws EtException {
        this(etName, hostName, null, mAddrs, false, 0, 11111, 11111, mPort, ttlNum, 0);
    }

    public EtSystemOpenConfig(String etName, String hostName, Collection<String> mAddrs, int uPort, int mPort, int ttlNum) throws EtException {
        this(etName, hostName, null, mAddrs, false, 0, 11111, uPort, mPort, ttlNum, 0);
    }

    public EtSystemOpenConfig(String etName, String hostName, int tPort) throws EtException {
        this(etName, hostName, null, null, false, 2, tPort, 11111, 11112, 32, 0);
    }

    public EtSystemOpenConfig(EtSystemOpenConfig config) {
        this.name = config.name;
        this.host = config.host;
        this.broadcastAddrs = config.getBroadcastAddrs();
        this.multicastAddrs = config.getMulticastAddrs();
        this.networkContactMethod = config.networkContactMethod;
        this.connectRemotely = config.connectRemotely;
        this.udpPort = config.udpPort;
        this.tcpPort = config.tcpPort;
        this.multicastPort = config.multicastPort;
        this.ttl = config.ttl;
        this.responsePolicy = config.responsePolicy;
        this.waitTime = config.waitTime;
        this.networkInterface = config.networkInterface;
        this.tcpRecvBufSize = config.tcpRecvBufSize;
        this.tcpSendBufSize = config.tcpSendBufSize;
        this.noDelay = config.noDelay;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(300);
        builder.append("      name = ");
        builder.append(this.name);
        builder.append("\n      host = ");
        builder.append(this.host);
        builder.append("\n   version = ");
        builder.append(14);
        builder.append("\n  tcp port = ");
        builder.append(this.tcpPort);
        builder.append("\n  udp port = ");
        builder.append(this.udpPort);
        builder.append("\nmcast port = ");
        builder.append(this.multicastPort);
        builder.append("\ntcp  nodelay = ");
        builder.append(this.noDelay);
        builder.append("\ntcp recv buf = ");
        builder.append(this.tcpRecvBufSize);
        builder.append("\ntcp send buf = ");
        builder.append(this.tcpSendBufSize);
        builder.append("\nwait time (ms) = ");
        builder.append(this.waitTime);
        builder.append("\nconnect remotely = ");
        builder.append(this.connectRemotely);
        builder.append("\nnetwork IF = ");
        builder.append(this.networkInterface);
        builder.append("\nttl = ");
        builder.append(this.ttl);
        builder.append("\nmcast addrs = ");
        for (String s : this.multicastAddrs) {
            builder.append(s);
            builder.append(", ");
        }
        builder.append("\nbcast addrs = ");
        for (String s : this.broadcastAddrs) {
            builder.append(s);
            builder.append(", ");
        }
        builder.append("\nnetwork contact = ");
        switch (this.networkContactMethod) {
            case 1: {
                builder.append("broadcast");
                break;
            }
            case 0: {
                builder.append("multicast");
                break;
            }
            case 2: {
                builder.append("direct");
                break;
            }
            case 3: {
                builder.append("broad & multicast");
                break;
            }
        }
        builder.append("\nmultiple responses policy = ");
        switch (this.networkContactMethod) {
            case 0: {
                builder.append("choose first");
                break;
            }
            case 1: {
                builder.append("choose local");
                break;
            }
            case 2: {
                builder.append("throw exception");
                break;
            }
        }
        return builder.toString();
    }

    public boolean selfConsistent() {
        boolean noMulticastAddrs;
        if (this.name == null || this.name.equals("") || this.host == null || this.host.equals("")) {
            return false;
        }
        boolean bl = noMulticastAddrs = this.multicastAddrs.size() < 1;
        if (this.networkContactMethod == 2 ? this.host.equals(".remote") || this.host.equals(".anywhere") : (this.networkContactMethod == 0 || this.networkContactMethod == 3) && noMulticastAddrs) {
            return false;
        }
        return !this.host.equals(".remote") || this.responsePolicy != 1;
    }

    public String getEtName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public HashSet<String> getBroadcastAddrs() {
        return (HashSet)this.broadcastAddrs.clone();
    }

    public HashSet<String> getMulticastAddrs() {
        return (HashSet)this.multicastAddrs.clone();
    }

    public int getNetworkContactMethod() {
        return this.networkContactMethod;
    }

    public int getResponsePolicy() {
        return this.responsePolicy;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int getNumMulticastAddrs() {
        return this.multicastAddrs.size();
    }

    public boolean isBroadcasting() {
        return this.broadcasting;
    }

    public void broadcasting(boolean on) {
        this.broadcasting = on;
    }

    public boolean isConnectRemotely() {
        return this.connectRemotely;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public int getTcpSendBufSize() {
        return this.tcpSendBufSize;
    }

    public int getTcpRecvBufSize() {
        return this.tcpRecvBufSize;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public void setEtName(String etName) {
        this.name = etName;
    }

    public void setHost(String hostName) {
        this.host = hostName;
    }

    public void removeMulticastAddr(String addr) {
        this.multicastAddrs.remove(addr);
    }

    public void setConnectRemotely(boolean connectRemotely) {
        this.connectRemotely = connectRemotely;
    }

    public void setWaitTime(long waitTime) {
        if (waitTime < 0L) {
            waitTime = 0L;
        }
        this.waitTime = waitTime;
    }

    public void addBroadcastAddr(String addr) throws EtException {
        try {
            InetAddress.getByName(addr);
        }
        catch (UnknownHostException ex) {
            throw new EtException("not a broadcast address");
        }
        this.broadcastAddrs.add(addr);
    }

    public void setBroadcastAddrs(Collection<String> addrs) throws EtException {
        if (addrs == null) {
            this.broadcastAddrs = new HashSet(10);
            return;
        }
        for (String addr : addrs) {
            try {
                InetAddress.getByName(addr);
            }
            catch (UnknownHostException ex) {
                throw new EtException("not a broadcast address");
            }
        }
        this.broadcastAddrs = new HashSet<String>(addrs);
    }

    public void addMulticastAddr(String addr) throws EtException {
        InetAddress inetAddr;
        try {
            inetAddr = InetAddress.getByName(addr);
        }
        catch (UnknownHostException ex) {
            throw new EtException("not a multicast address");
        }
        if (!inetAddr.isMulticastAddress()) {
            throw new EtException("not a multicast address");
        }
        this.multicastAddrs.add(addr);
    }

    public void setMulticastAddrs(Collection<String> addrs) throws EtException {
        if (addrs == null) {
            this.multicastAddrs = new HashSet(10);
            return;
        }
        for (String addr : addrs) {
            InetAddress inetAddr;
            try {
                inetAddr = InetAddress.getByName(addr);
            }
            catch (UnknownHostException ex) {
                throw new EtException("not a broadcast address");
            }
            if (inetAddr.isMulticastAddress()) continue;
            throw new EtException(addr + " is not a multicast address");
        }
        this.multicastAddrs = new HashSet<String>(addrs);
    }

    public void setNetworkContactMethod(int method) throws EtException {
        if (method != 0 && method != 1 && method != 3 && method != 2) {
            throw new EtException("bad contact method value");
        }
        this.networkContactMethod = method;
    }

    public void setResponsePolicy(int policy) throws EtException {
        if (policy != 0 && policy != 1 && policy != 2) {
            throw new EtException("bad policy value");
        }
        if (this.host.equals(".remote") && policy == 1) {
            throw new EtException("policy value cannot be local if host is remote");
        }
        this.responsePolicy = policy;
    }

    public void setUdpPort(int port) throws EtException {
        if (port < 1024 || port > 65535) {
            throw new EtException("bad UDP port value");
        }
        this.udpPort = port;
    }

    public void setTcpPort(int port) throws EtException {
        if (port < 1024 || port > 65535) {
            throw new EtException("bad TCP port value");
        }
        this.tcpPort = port;
    }

    public void setMulticastPort(int port) throws EtException {
        if (port < 1024 || port > 65535) {
            throw new EtException("bad multicast port value");
        }
        this.multicastPort = port;
    }

    public void setTTL(int ttlNum) throws EtException {
        if (ttlNum < 0 || ttlNum > 254) {
            throw new EtException("bad TTL value");
        }
        this.ttl = ttlNum;
    }

    public void setNetworkInterface(String networkInterface) throws EtException {
        if (networkInterface != null) {
            try {
                InetAddress.getByName(networkInterface);
            }
            catch (UnknownHostException ex) {
                throw new EtException("not a valid network interface");
            }
        }
        this.networkInterface = networkInterface;
    }

    public void setTcpSendBufSize(int tcpSendBufSize) throws EtException {
        if (tcpSendBufSize < 0) {
            throw new EtException("buffer size must be >= than 0");
        }
        this.tcpSendBufSize = tcpSendBufSize;
    }

    public void setTcpRecvBufSize(int tcpRecvBufSize) throws EtException {
        if (tcpRecvBufSize < 0) {
            throw new EtException("buffer size must be >= than 0");
        }
        this.tcpRecvBufSize = tcpRecvBufSize;
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }
}

