/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.jlab.coda.et.exception.EtException;

public class SystemConfig {
    private int numEvents;
    private int eventSize;
    private int[] groups;
    private int stationsMax;
    private int attachmentsMax;
    private int debug;
    private int tcpSendBufSize;
    private int tcpRecvBufSize;
    private boolean noDelay;
    private int udpPort;
    private int serverPort;
    private int multicastPort;
    private HashSet<InetAddress> multicastAddrs;

    public SystemConfig() {
        this.numEvents = 300;
        this.eventSize = 1000;
        this.stationsMax = 20;
        this.attachmentsMax = 50;
        this.debug = 2;
        this.udpPort = 11111;
        this.serverPort = 11111;
        this.multicastPort = 11112;
        this.multicastAddrs = new HashSet(10);
        this.groups = new int[1];
        this.groups[0] = this.numEvents;
    }

    public SystemConfig(SystemConfig config) {
        this.numEvents = config.numEvents;
        this.eventSize = config.eventSize;
        this.stationsMax = config.stationsMax;
        this.attachmentsMax = config.attachmentsMax;
        this.debug = config.debug;
        this.udpPort = config.udpPort;
        this.tcpRecvBufSize = config.tcpRecvBufSize;
        this.tcpSendBufSize = config.tcpSendBufSize;
        this.noDelay = config.noDelay;
        this.serverPort = config.serverPort;
        this.multicastPort = config.multicastPort;
        this.multicastAddrs = new HashSet<InetAddress>(config.multicastAddrs);
        this.groups = (int[])config.groups.clone();
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public int[] getGroups() {
        return (int[])this.groups.clone();
    }

    public int getStationsMax() {
        return this.stationsMax;
    }

    public int getAttachmentsMax() {
        return this.attachmentsMax;
    }

    public int getDebug() {
        return this.debug;
    }

    public int getTcpSendBufSize() {
        return this.tcpSendBufSize;
    }

    public int getTcpRecvBufSize() {
        return this.tcpRecvBufSize;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public Set<InetAddress> getMulticastAddrs() {
        return new HashSet<InetAddress>(this.multicastAddrs);
    }

    public String[] getMulticastStrings() {
        if (this.multicastAddrs == null) {
            return null;
        }
        int index = 0;
        String[] addrs = new String[this.multicastAddrs.size()];
        for (InetAddress addr : this.multicastAddrs) {
            addrs[index++] = addr.getHostAddress();
        }
        return addrs;
    }

    public void addMulticastAddr(String mCastAddr) throws EtException {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(mCastAddr);
        }
        catch (UnknownHostException ex) {
            throw new EtException("not a multicast address");
        }
        if (!addr.isMulticastAddress()) {
            throw new EtException("not a multicast address");
        }
        this.multicastAddrs.add(addr);
    }

    public void removeMulticastAddr(String addr) {
        InetAddress ad;
        try {
            ad = InetAddress.getByName(addr);
        }
        catch (UnknownHostException ex) {
            return;
        }
        this.multicastAddrs.remove(ad);
    }

    public void setNumEvents(int num) throws EtException {
        if (num < 1) {
            throw new EtException("must have 1 or more events");
        }
        this.numEvents = num;
        if (this.groups.length == 1) {
            this.groups[0] = num;
        }
    }

    public void setEventSize(int size) throws EtException {
        if (size < 1) {
            throw new EtException("events must have at least one byte");
        }
        this.eventSize = size;
    }

    public void setGroups(int[] groups) throws EtException {
        if (groups.length < 1) {
            throw new EtException("events must have at least one group");
        }
        for (int num : groups) {
            if (num >= 1) continue;
            throw new EtException("each event group must contain at least one event");
        }
        this.groups = (int[])groups.clone();
    }

    public void setStationsMax(int num) throws EtException {
        if (num < 2) {
            throw new EtException("must have at least 2 stations");
        }
        this.stationsMax = num;
    }

    public void setAttachmentsMax(int num) throws EtException {
        if (num < 1) {
            throw new EtException("must be able to have at least one attachment");
        }
        this.attachmentsMax = num;
    }

    public void setDebug(int level) throws EtException {
        if (level != 0 && level != 4 && level != 3 && level != 2 && level != 1) {
            throw new EtException("bad debug value");
        }
        this.debug = level;
    }

    public void setTcpSendBufSize(int tcpSendBufSize) throws EtException {
        if (tcpSendBufSize < 0) {
            throw new EtException("buffer size must be >= than 0");
        }
        this.tcpSendBufSize = tcpSendBufSize;
    }

    public void setTcpRecvBufSize(int tcpRecvBufSize) throws EtException {
        if (tcpRecvBufSize < 0) {
            throw new EtException("buffer size must be >= than 0");
        }
        this.tcpRecvBufSize = tcpRecvBufSize;
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public void setUdpPort(int port) throws EtException {
        if (port < 1024) {
            throw new EtException("port number must be greater than 1023");
        }
        this.udpPort = port;
    }

    public void setServerPort(int port) throws EtException {
        if (port < 1024) {
            throw new EtException("port number must be greater than 1023");
        }
        this.serverPort = port;
    }

    public void setMulticastPort(int port) throws EtException {
        if (port < 1024) {
            throw new EtException("port number must be greater than 1023");
        }
        this.multicastPort = port;
    }

    public boolean selfConsistent() {
        int count = 0;
        for (int i : this.groups) {
            count += i;
        }
        if (count != this.numEvents) {
            System.out.println("events in groups != total event number");
            return false;
        }
        return true;
    }
}

