/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.monitorGui.Monitor;
import org.jlab.coda.et.monitorGui.MonitorSingleSystem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MonitorConfiguration
extends DefaultHandler {
    private SAXParser parser;
    private static boolean setValidation = true;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setSchemaFullSupport = true;
    private StringBuffer buffer = new StringBuffer(100);
    private HashMap<String, Object> dataStorage = new HashMap(100);
    private Monitor monitor;
    private boolean isColor;
    private boolean readWindowParametersOnly;
    private boolean finishedReadingWindowParameters;
    private String currentElement;
    private String findMethod;
    private Color[] mainColors = new Color[6];
    private Point windowLocation;
    private Dimension windowSize;

    public MonitorConfiguration(Monitor mon) {
        this.monitor = mon;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(new File("monitorConfiguration.xsd"));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        factory.setSchema(schema);
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void setMonitor(Monitor mon) {
        this.monitor = mon;
    }

    public Point getWindowLocation() {
        return new Point(this.windowLocation);
    }

    public Dimension getWindowSize() {
        return new Dimension(this.windowSize);
    }

    public Color[] getWindowColors() {
        return (Color[])this.mainColors.clone();
    }

    public void loadWindowParameters(File file) throws IOException, SAXException {
        this.loadWindowParameters(file.getPath());
    }

    public void loadWindowParameters(String fileName) throws IOException, SAXException {
        File f = new File(fileName);
        this.readWindowParametersOnly = true;
        this.parser.parse(f, (DefaultHandler)this);
        this.readWindowParametersOnly = false;
        this.finishedReadingWindowParameters = false;
    }

    public void load(String fileName) throws IOException, SAXException {
        File f = new File(fileName);
        this.parser.parse(f, (DefaultHandler)this);
    }

    public void load(File file) throws IOException, SAXException {
        this.load(file.getPath());
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes attrs) {
        this.currentElement = local;
        if (local.indexOf("Color") > -1) {
            try {
                Color c = new Color(Integer.parseInt(attrs.getValue("red")), Integer.parseInt(attrs.getValue("green")), Integer.parseInt(attrs.getValue("blue")));
                this.dataStorage.put(this.currentElement, c);
                this.isColor = true;
            }
            catch (NumberFormatException ex) {}
        } else if (local.equals("broadcasting") || local.equals("multicasting") || local.equals("broadAndMulticasting") || local.equals("direct") || local.equals("udpToHost")) {
            this.findMethod = this.currentElement;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.finishedReadingWindowParameters || ch == null || length == 0) {
            return;
        }
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String local, String qname) {
        if (this.finishedReadingWindowParameters) {
            return;
        }
        if (this.isColor) {
            this.isColor = false;
        } else if (this.buffer.length() > 0) {
            this.dataStorage.put(this.currentElement, this.buffer.toString());
            this.buffer.setLength(0);
        }
        if (local.equals("graphics")) {
            StringTokenizer tok;
            if (this.readWindowParametersOnly) {
                if (this.dataStorage.containsKey("titleColor")) {
                    this.mainColors[0] = (Color)this.dataStorage.get("titleColor");
                }
                if (this.dataStorage.containsKey("backgroundColor")) {
                    this.mainColors[1] = (Color)this.dataStorage.get("backgroundColor");
                }
                if (this.dataStorage.containsKey("selectedTabColor")) {
                    this.mainColors[2] = (Color)this.dataStorage.get("selectedTabColor");
                }
                if (this.dataStorage.containsKey("tabsBackgroundColor")) {
                    this.mainColors[3] = (Color)this.dataStorage.get("tabsBackgroundColor");
                }
                if (this.dataStorage.containsKey("textColor")) {
                    this.mainColors[4] = (Color)this.dataStorage.get("textColor");
                }
                if (this.dataStorage.containsKey("textBackgroundColor")) {
                    this.mainColors[5] = (Color)this.dataStorage.get("textBackgroundColor");
                }
                int w = Integer.parseInt(((String)this.dataStorage.get("width")).trim());
                int h = Integer.parseInt(((String)this.dataStorage.get("height")).trim());
                int x = Integer.parseInt(((String)this.dataStorage.get("xPosition")).trim());
                int y = Integer.parseInt(((String)this.dataStorage.get("yPosition")).trim());
                this.windowLocation = new Point(x, y);
                this.windowSize = new Dimension(w, h);
                this.finishedReadingWindowParameters = true;
                this.dataStorage.clear();
                return;
            }
            if (this.dataStorage.containsKey("fileNameList")) {
                tok = new StringTokenizer((String)this.dataStorage.get("fileNameList"));
                while (tok.hasMoreTokens()) {
                    this.monitor.addFileName(tok.nextToken());
                }
            }
            if (this.dataStorage.containsKey("hostList")) {
                tok = new StringTokenizer((String)this.dataStorage.get("hostList"));
                while (tok.hasMoreTokens()) {
                    this.monitor.addHostname(tok.nextToken());
                }
            }
            this.dataStorage.clear();
        } else if (local.equals("etConnection")) {
            String etSystem = (String)this.dataStorage.get("fileName");
            int period = Integer.parseInt((String)this.dataStorage.get("period"));
            int divider = Integer.parseInt((String)this.dataStorage.get("dividerPosition"));
            int orientation = 1;
            if (((String)this.dataStorage.get("orientation")).equals("vertical")) {
                orientation = 0;
            }
            Color[] colors = new Color[10];
            if (this.dataStorage.containsKey("stationColor")) {
                colors[0] = (Color)this.dataStorage.get("stationColor");
            }
            if (this.dataStorage.containsKey("stationIdleColor")) {
                colors[1] = (Color)this.dataStorage.get("stationIdleColor");
            }
            if (this.dataStorage.containsKey("attachmentColor")) {
                colors[2] = (Color)this.dataStorage.get("attachmentColor");
            }
            if (this.dataStorage.containsKey("eventColor")) {
                colors[3] = (Color)this.dataStorage.get("eventColor");
            }
            if (this.dataStorage.containsKey("lineColor")) {
                colors[4] = (Color)this.dataStorage.get("lineColor");
            }
            if (this.dataStorage.containsKey("textColor")) {
                colors[5] = (Color)this.dataStorage.get("textColor");
            }
            if (this.dataStorage.containsKey("textBackgroundColor")) {
                colors[6] = (Color)this.dataStorage.get("textBackgroundColor");
            }
            if (this.dataStorage.containsKey("backgroundColor")) {
                colors[7] = (Color)this.dataStorage.get("backgroundColor");
            }
            if (this.dataStorage.containsKey("treeTextColor")) {
                colors[8] = (Color)this.dataStorage.get("treeTextColor");
            }
            if (this.dataStorage.containsKey("treeBackgroundColor")) {
                colors[9] = (Color)this.dataStorage.get("treeBackgroundColor");
            }
            int index = 0;
            int ttl = 0;
            int dummy = 11111;
            int broadcastPort = 0;
            int multicastPort = 0;
            int port = 0;
            String host = null;
            EtSystemOpenConfig config = null;
            try {
                if (this.findMethod.equals("broadcasting")) {
                    if (this.dataStorage.containsKey("location")) {
                        host = (String)this.dataStorage.get("location");
                        host = host.equals("local") ? ".local" : (host.equals("remote") ? ".remote" : ".anywhere");
                    } else {
                        host = (String)this.dataStorage.get("host");
                        this.monitor.addHostname(host);
                    }
                    broadcastPort = Integer.parseInt((String)this.dataStorage.get("broadcastPort"));
                    StringTokenizer tok = new StringTokenizer((String)this.dataStorage.get("broadcastAddressList"));
                    String[] addrs = new String[tok.countTokens()];
                    while (tok.hasMoreTokens()) {
                        addrs[index++] = tok.nextToken();
                    }
                    config = new EtSystemOpenConfig(etSystem, broadcastPort, host);
                } else if (this.findMethod.equals("multicasting")) {
                    if (this.dataStorage.containsKey("location")) {
                        host = (String)this.dataStorage.get("location");
                        host = host.equals("local") ? ".local" : (host.equals("remote") ? ".remote" : ".anywhere");
                    } else {
                        host = (String)this.dataStorage.get("host");
                        this.monitor.addHostname(host);
                    }
                    ttl = Integer.parseInt((String)this.dataStorage.get("ttl"));
                    multicastPort = Integer.parseInt((String)this.dataStorage.get("multicastPort"));
                    StringTokenizer tok = new StringTokenizer((String)this.dataStorage.get("multicastAddressList"));
                    String[] addrs = new String[tok.countTokens()];
                    while (tok.hasMoreTokens()) {
                        addrs[index++] = tok.nextToken();
                    }
                    int udpPort = 11111;
                    if (this.dataStorage.containsKey("udpPort")) {
                        udpPort = Integer.parseInt((String)this.dataStorage.get("udpPort"));
                    }
                    config = new EtSystemOpenConfig(etSystem, host, Arrays.asList(addrs), udpPort, multicastPort, ttl);
                } else if (this.findMethod.equals("broadAndMulticasting")) {
                    if (this.dataStorage.containsKey("location")) {
                        host = (String)this.dataStorage.get("location");
                        host = host.equals("local") ? ".local" : (host.equals("remote") ? ".remote" : ".anywhere");
                    } else {
                        host = (String)this.dataStorage.get("host");
                        this.monitor.addHostname(host);
                    }
                    ttl = Integer.parseInt((String)this.dataStorage.get("ttl"));
                    broadcastPort = Integer.parseInt((String)this.dataStorage.get("broadcastPort"));
                    multicastPort = Integer.parseInt((String)this.dataStorage.get("multicastPort"));
                    StringTokenizer tok = new StringTokenizer((String)this.dataStorage.get("broadcastAddressList"));
                    String[] bAddrs = new String[tok.countTokens()];
                    while (tok.hasMoreTokens()) {
                        bAddrs[index++] = tok.nextToken();
                    }
                    index = 0;
                    tok = new StringTokenizer((String)this.dataStorage.get("multicastAddressList"));
                    String[] mAddrs = new String[tok.countTokens()];
                    while (tok.hasMoreTokens()) {
                        mAddrs[index++] = tok.nextToken();
                    }
                    config = new EtSystemOpenConfig(etSystem, host, null, Arrays.asList(mAddrs), true, 3, dummy, broadcastPort, multicastPort, ttl, 2);
                } else if (this.findMethod.equals("direct")) {
                    if (this.dataStorage.containsKey("location")) {
                        host = (String)this.dataStorage.get("location");
                        if (host.equals("local")) {
                            host = ".local";
                        }
                    } else {
                        host = (String)this.dataStorage.get("host");
                        this.monitor.addHostname(host);
                    }
                    port = Integer.parseInt((String)this.dataStorage.get("tcpPort"));
                    config = new EtSystemOpenConfig(etSystem, host, port);
                }
            }
            catch (EtException ex) {
                // empty catch block
            }
            this.monitor.addFileName(etSystem);
            this.monitor.addEtSystem(config, period, divider, orientation, colors);
            this.dataStorage.clear();
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(": line ");
        str.append(ex.getLineNumber());
        str.append(" :col ");
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public void save(File file) throws FileNotFoundException {
        String fileName = file.getPath();
        try {
            int i;
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "ASCII");
            StringBuffer text = new StringBuffer(1000);
            text.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            text.append("<configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            text.append("            xsi:noNamespaceSchemaLocation=\"monitorConfiguration.xsd\">\n\n");
            text.append("  <graphics>\n    <width>");
            text.append(this.monitor.getMonitorWidth());
            text.append("</width>\n    <height>");
            text.append(this.monitor.getMonitorHeight());
            text.append("</height>\n    <xPosition>");
            text.append(this.monitor.getX());
            text.append("</xPosition>\n    <yPosition>");
            text.append(this.monitor.getY());
            text.append("</yPosition>\n");
            Color monColor = this.monitor.getTitleColor();
            if (monColor.getRGB() != this.monitor.titleColorDefault.getRGB()) {
                text.append("    <titleColor red=\"");
                text.append(monColor.getRed());
                text.append("\" green=\"");
                text.append(monColor.getGreen());
                text.append("\" blue=\"");
                text.append(monColor.getBlue());
                text.append("\"/>\n");
            }
            if ((monColor = this.monitor.getBackgroundColor()).getRGB() != this.monitor.backgroundColorDefault.getRGB()) {
                text.append("    <backgroundColor red=\"");
                text.append(monColor.getRed());
                text.append("\" green=\"");
                text.append(monColor.getGreen());
                text.append("\" blue=\"");
                text.append(monColor.getBlue());
                text.append("\"/>\n");
            }
            if ((monColor = this.monitor.getSelectedTabColor()).getRGB() != this.monitor.selectedTabColorDefault.getRGB()) {
                text.append("    <selectedTabColor red=\"");
                text.append(monColor.getRed());
                text.append("\" green=\"");
                text.append(monColor.getGreen());
                text.append("\" blue=\"");
                text.append(monColor.getBlue());
                text.append("\"/>\n");
            }
            if ((monColor = this.monitor.getTabsBackgroundColor()).getRGB() != this.monitor.tabsBackgroundColorDefault.getRGB()) {
                text.append("    <tabsBackgroundColor red=\"");
                text.append(monColor.getRed());
                text.append("\" green=\"");
                text.append(monColor.getGreen());
                text.append("\" blue=\"");
                text.append(monColor.getBlue());
                text.append("\"/>\n");
            }
            if ((monColor = this.monitor.getTextBackgroundColor()).getRGB() != this.monitor.textBackgroundColorDefault.getRGB()) {
                text.append("    <textBackgroundColor red=\"");
                text.append(monColor.getRed());
                text.append("\" green=\"");
                text.append(monColor.getGreen());
                text.append("\" blue=\"");
                text.append(monColor.getBlue());
                text.append("\"/>\n");
            }
            if ((monColor = this.monitor.getTextColor()).getRGB() != this.monitor.textColorDefault.getRGB()) {
                text.append("    <textColor red=\"");
                text.append(monColor.getRed());
                text.append("\" green=\"");
                text.append(monColor.getGreen());
                text.append("\" blue=\"");
                text.append(monColor.getBlue());
                text.append("\"/>\n");
            }
            osw.write(text.toString());
            text.setLength(0);
            String[] names = this.monitor.getHostnames();
            if (names != null) {
                text.append("    <hostList>");
                for (i = 0; i < names.length; ++i) {
                    text.append("\n      ");
                    text.append(names[i]);
                }
                text.append("\n    </hostList>\n");
            }
            if ((names = this.monitor.getFileNames()) != null) {
                text.append("    <fileNameList>");
                for (i = 0; i < names.length; ++i) {
                    text.append("\n      ");
                    text.append(names[i]);
                }
                text.append("\n    </fileNameList>\n");
            }
            text.append("  </graphics>\n\n");
            osw.write(text.toString());
            text.setLength(0);
            EtSystem use = null;
            for (Map.Entry<String, EtSystem> entry : this.monitor.connections.entrySet()) {
                Iterator<String> j;
                String host;
                use = entry.getValue();
                String key = entry.getKey();
                EtSystemOpenConfig config = use.getConfig();
                text.append("  <etConnection>\n    <fileName>");
                text.append(config.getEtName());
                text.append("</fileName>\n");
                int method = config.getNetworkContactMethod();
                if (method == 1) {
                    text.append("    <broadcasting>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else if (host.equals(".remote")) {
                        text.append("      <location>remote</location>\n");
                    } else if (host.equals(".anywhere")) {
                        text.append("      <location>anywhere</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <broadcastAddressList>");
                    text.append("\n        255.255.255.255");
                    text.append("\n      </broadcastAddressList>\n      <broadcastPort>");
                    text.append(config.getUdpPort());
                    text.append("</broadcastPort>\n    </broadcasting>\n");
                } else if (method == 0) {
                    text.append("    <multicasting>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else if (host.equals(".remote")) {
                        text.append("      <location>remote</location>\n");
                    } else if (host.equals(".anywhere")) {
                        text.append("      <location>anywhere</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <multicastAddressList>");
                    j = config.getMulticastAddrs().iterator();
                    while (j.hasNext()) {
                        text.append("\n        ");
                        text.append(j.next());
                    }
                    text.append("\n      </multicastAddressList>\n      <multicastPort>");
                    text.append(config.getMulticastPort());
                    text.append("</multicastPort>\n      <ttl>");
                    text.append(config.getTTL());
                    text.append("</ttl>\n    </multicasting>\n");
                } else if (method == 3) {
                    text.append("    <broadAndMulticasting>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else if (host.equals(".remote")) {
                        text.append("      <location>remote</location>\n");
                    } else if (host.equals(".anywhere")) {
                        text.append("      <location>anywhere</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <broadcastAddressList>");
                    text.append("\n        255.255.255.255");
                    text.append("\n      </broadcastAddressList>\n      <broadcastPort>");
                    text.append(config.getUdpPort());
                    text.append("</broadcastPort>\n");
                    text.append("      <multicastAddressList>");
                    j = config.getMulticastAddrs().iterator();
                    while (j.hasNext()) {
                        text.append("\n        ");
                        text.append(j.next());
                    }
                    text.append("\n      </multicastAddressList>\n      <multicastPort>");
                    text.append(config.getMulticastPort());
                    text.append("</multicastPort>\n      <ttl>");
                    text.append(config.getTTL());
                    text.append("</ttl>\n    </broadAndMulticasting>\n");
                } else if (method == 2) {
                    text.append("    <direct>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <tcpPort>");
                    text.append(config.getTcpPort());
                    text.append("</tcpPort>\n");
                    text.append("    </direct>\n");
                } else {
                    text.append("    <udpToHost>\n");
                    host = config.getHost();
                    if (host.equals(".local")) {
                        text.append("      <location>local</location>\n");
                    } else {
                        text.append("      <host>");
                        text.append(host);
                        text.append("</host>\n");
                    }
                    text.append("      <udpPort>");
                    text.append(config.getUdpPort());
                    text.append("</udpPort>\n");
                    text.append("    </udpToHost>\n");
                }
                MonitorSingleSystem singleMonitor = this.monitor.monitors.get(key);
                text.append("    <period>");
                text.append(singleMonitor.getUpdatePeriod());
                text.append("</period>\n    <dividerPosition>");
                text.append(singleMonitor.getDividerPosition());
                text.append("</dividerPosition>\n    <orientation>");
                if (singleMonitor.getOrientation() == 1) {
                    text.append("horizontal");
                } else {
                    text.append("vertical");
                }
                text.append("</orientation>\n");
                monColor = singleMonitor.getEventColor();
                if (monColor.getRGB() != singleMonitor.eventColorDefault.getRGB()) {
                    text.append("    <eventColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                if ((monColor = singleMonitor.getStationColor()).getRGB() != singleMonitor.stationColorDefault.getRGB()) {
                    text.append("    <stationColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                if ((monColor = singleMonitor.getStationIdleColor()).getRGB() != singleMonitor.stationIdleColorDefault.getRGB()) {
                    text.append("    <stationIdleColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                if ((monColor = singleMonitor.getAttachmentColor()).getRGB() != singleMonitor.attachColorDefault.getRGB()) {
                    text.append("    <attachmentColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                if ((monColor = singleMonitor.getLineColor()).getRGB() != singleMonitor.lineColorDefault.getRGB()) {
                    text.append("    <lineColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                if ((monColor = singleMonitor.getTextColor()).getRGB() != singleMonitor.textColorDefault.getRGB()) {
                    text.append("    <textColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                if ((monColor = singleMonitor.getTextBackgroundColor()).getRGB() != singleMonitor.textBackgroundColorDefault.getRGB()) {
                    text.append("    <textBackgroundColor red=\"");
                    text.append(monColor.getRed());
                    text.append("\" green=\"");
                    text.append(monColor.getGreen());
                    text.append("\" blue=\"");
                    text.append(monColor.getBlue());
                    text.append("\"/>\n");
                }
                text.append("  </etConnection>\n\n");
                osw.write(text.toString());
                text.setLength(0);
            }
            text.append("</configuration>\n");
            osw.write(text.toString());
            osw.close();
            fos.close();
        }
        catch (UnsupportedEncodingException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

