/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jlab.coda.et.system.ListeningThread;
import org.jlab.coda.et.system.SystemConfig;
import org.jlab.coda.et.system.SystemCreate;

class SystemUdpServer
extends Thread {
    private int port;
    private SystemCreate sys;
    private SystemConfig config;

    SystemUdpServer(SystemCreate sys) {
        this.sys = sys;
        this.config = sys.getConfig();
        this.port = this.config.getServerPort();
    }

    @Override
    public void run() {
        ListeningThread lis;
        DatagramSocket sock;
        if (this.config.getDebug() >= 4) {
            System.out.println("Running UDP Listening Threads");
        }
        if (this.port < 1) {
            this.port = 11111;
        }
        if (this.config.getMulticastAddrs().size() > 0) {
            try {
                System.out.println("setting up for multicast on port " + this.config.getMulticastPort());
                sock = new MulticastSocket(this.config.getMulticastPort());
                sock.setReceiveBufferSize(512);
                sock.setSendBufferSize(512);
                lis = new ListeningThread(this.sys, (MulticastSocket)sock);
                lis.start();
            }
            catch (IOException e) {
                System.out.println("cannot listen on port " + this.config.getMulticastPort() + " for multicasting");
                e.printStackTrace();
            }
            if (this.config.getMulticastPort() == this.config.getUdpPort()) {
                return;
            }
        }
        try {
            System.out.println("setting up for broadcast on port " + this.config.getUdpPort());
            sock = new DatagramSocket(this.config.getUdpPort());
            sock.setBroadcast(true);
            sock.setReceiveBufferSize(512);
            sock.setSendBufferSize(512);
            lis = new ListeningThread(this.sys, sock);
            lis.start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

