/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.system;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantLock;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.EtEventSelectable;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.system.AttachmentLocal;
import org.jlab.coda.et.system.EventList;
import org.jlab.coda.et.system.SystemCreate;

public class StationLocal
extends Thread
implements EtEventSelectable {
    private SystemCreate sys;
    private int id;
    private String name;
    private EtStationConfig config;
    private volatile int status;
    private volatile boolean killConductor;
    private volatile boolean wasLast;
    private final ReentrantLock stopTransferLock;
    private LinkedList<StationLocal> parallelStations;
    private EventList inputList;
    private EventList outputList;
    private HashSet<AttachmentLocal> attachments;
    private EtEventSelectable selector;

    public StationLocal(SystemCreate sys, String name, EtStationConfig config, int id) throws EtException {
        this.id = id;
        this.sys = sys;
        this.name = name;
        this.config = new EtStationConfig(config);
        this.status = 0;
        this.parallelStations = new LinkedList();
        this.stopTransferLock = new ReentrantLock();
        this.inputList = new EventList();
        this.outputList = new EventList();
        this.attachments = new HashSet(110);
        this.selector = this;
        if (config.getSelectMode() == 3) {
            try {
                Object f = Class.forName(config.getSelectClass()).newInstance();
                this.selector = (EtEventSelectable)f;
            }
            catch (ClassNotFoundException ex) {
                throw new EtException("station cannot load select class " + config.getSelectClass());
            }
            catch (InstantiationException ex) {
                throw new EtException("station cannot instantiate class " + config.getSelectClass());
            }
            catch (IllegalAccessException ex) {
                throw new EtException("station cannot load class " + config.getSelectClass());
            }
            if (sys.getConfig().getDebug() >= 4) {
                System.out.println(name + " loaded select class " + config.getSelectClass());
            }
        }
    }

    public int getStationId() {
        return this.id;
    }

    public String getStationName() {
        return this.name;
    }

    public EventList getInputList() {
        return this.inputList;
    }

    public EventList getOutputList() {
        return this.outputList;
    }

    public ReentrantLock getStopTransferLock() {
        return this.stopTransferLock;
    }

    public EtStationConfig getConfig() {
        return this.config;
    }

    public LinkedList<StationLocal> getParallelStations() {
        return this.parallelStations;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public HashSet<AttachmentLocal> getAttachments() {
        return this.attachments;
    }

    public boolean isKillConductor() {
        return this.killConductor;
    }

    public void killConductor() {
        this.killConductor = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlockMode(int mode) {
        if (this.config.getBlockMode() == mode) {
            return;
        }
        byte[] byArray = this.sys.getStationLock();
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                try {
                    this.config.setBlockMode(mode);
                }
                catch (EtException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCue(int cue) {
        if (this.config.getCue() == cue) {
            return;
        }
        byte[] byArray = this.sys.getStationLock();
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                try {
                    this.config.setCue(cue);
                }
                catch (EtException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrescale(int prescale) {
        if (this.config.getPrescale() == prescale) {
            return;
        }
        byte[] byArray = this.sys.getStationLock();
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                try {
                    this.config.setPrescale(prescale);
                }
                catch (EtException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelectWords(int[] select) {
        if (this.config.getSelect() == select) {
            return;
        }
        byte[] byArray = this.sys.getStationLock();
        synchronized (byArray) {
            EventList eventList = this.inputList;
            synchronized (eventList) {
                try {
                    this.config.setSelect((int[])select.clone());
                }
                catch (EtException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUserMode(int mode) {
        if (this.config.getUserMode() == mode) {
            return;
        }
        byte[] byArray = this.sys.getStationLock();
        synchronized (byArray) {
            try {
                this.config.setUserMode(mode);
            }
            catch (EtException etException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRestoreMode(int mode) {
        if (this.config.getRestoreMode() == mode) {
            return;
        }
        byte[] byArray = this.sys.getStationLock();
        synchronized (byArray) {
            try {
                this.config.setRestoreMode(mode);
            }
            catch (EtException etException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean select(SystemCreate sys, StationLocal stat, EtEvent ev) {
        boolean result = false;
        int[] select = stat.config.getSelect();
        int[] control = ev.getControl();
        for (int i = 0; i < 6; ++i) {
            result = i % 2 == 0 ? result || select[i] != -1 && select[i] == control[i] : result || select[i] != -1 && (select[i] & control[i]) != 0;
        }
        return result;
    }

    private void shellSort(int n, int[] a, int[] b) {
        int inc = 1;
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (int i = (inc /= 3) + 1; i <= n; ++i) {
                int v = a[i];
                int w = b[i];
                int j = i;
                while (a[j - inc] > v) {
                    a[j] = a[j - inc];
                    b[j] = b[j - inc];
                    if ((j -= inc) > inc) continue;
                }
                a[j] = v;
                b[j] = w;
            }
        } while (inc > 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ListIterator<Object> pIterator = null;
        ArrayList<EtEventImpl> getList = new ArrayList<EtEventImpl>(this.sys.getConfig().getNumEvents());
        ArrayList<EtEventImpl> putList = new ArrayList<EtEventImpl>(this.sys.getConfig().getNumEvents());
        int idle = 2;
        int active = 3;
        boolean blocking = true;
        boolean nonBlocking = false;
        boolean selectAll = true;
        boolean parallel = true;
        this.status = this.name.equals("GRAND_CENTRAL") ? 3 : 2;
        while (true) {
            EventList inList;
            StationLocal currentStat;
            ListIterator<StationLocal> statIterator;
            StationLocal stat;
            Object i2;
            EventList eventList = this.outputList;
            synchronized (eventList) {
                while (this.outputList.getEvents().size() < 1) {
                    try {
                        this.outputList.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (!this.killConductor) continue;
                    return;
                }
            }
            this.outputList.get(getList);
            boolean writeAll = false;
            this.stopTransferLock.lock();
            int position = this.sys.getStations().indexOf(this);
            if (position < 0) {
                position = 1;
                i2 = this.sys.getStations().listIterator(1);
                while (i2.hasNext()) {
                    stat = i2.next();
                    if (stat.config.getFlowMode() == 1 && stat.parallelStations.indexOf(this) > -1) break;
                    ++position;
                }
            }
            if (!(statIterator = this.sys.getStations().listIterator(position + 1)).hasNext()) {
                currentStat = this.sys.getStations().getFirst();
                inList = currentStat.inputList;
                i2 = inList;
                synchronized (i2) {
                    inList.putInLow(getList);
                    getList.clear();
                    inList.notifyAll();
                }
                this.stopTransferLock.unlock();
                continue;
            }
            currentStat = statIterator.next();
            inList = currentStat.inputList;
            while (getList.size() > 0) {
                block82: {
                    int count;
                    List<EtEventImpl> subList;
                    boolean parallelIsActive = false;
                    boolean rrobinOrEqualcue = false;
                    StationLocal startStation = null;
                    StationLocal firstActive = null;
                    if (currentStat.config.getFlowMode() == 1) {
                        pIterator = currentStat.parallelStations.listIterator();
                        while (pIterator.hasNext()) {
                            stat = (StationLocal)pIterator.next();
                            if (stat.status != 3) continue;
                            parallelIsActive = true;
                            firstActive = stat;
                            break;
                        }
                        if (parallelIsActive && (currentStat.config.getSelectMode() == 4 || currentStat.config.getSelectMode() == 5)) {
                            rrobinOrEqualcue = true;
                        }
                    }
                    if (!rrobinOrEqualcue && (parallelIsActive || currentStat.status == 3)) {
                        if (currentStat.config.getFlowMode() == 1) {
                            currentStat = firstActive;
                            inList = currentStat.inputList;
                        }
                        block22: while (true) {
                            EventList i2 = inList;
                            synchronized (i2) {
                                EtEventImpl ev;
                                ListIterator<EtEventImpl> i3;
                                long listTry;
                                int prescale;
                                if (currentStat.id == 0) {
                                    writeAll = true;
                                } else if (currentStat.config.getSelectMode() == 1 && currentStat.config.getBlockMode() == 1) {
                                    int getListSize = getList.size();
                                    if (currentStat.config.getPrescale() == 1) {
                                        writeAll = true;
                                    } else {
                                        prescale = currentStat.config.getPrescale();
                                        listTry = inList.getEventsTry();
                                        subList = getList.subList(0, (int)((listTry + (long)getListSize) / (long)prescale - listTry / (long)prescale));
                                        putList.addAll(subList);
                                        subList.clear();
                                    }
                                    inList.setEventsTry(inList.getEventsTry() + (long)getListSize);
                                } else if (currentStat.config.getSelectMode() == 1 && currentStat.config.getBlockMode() == 0) {
                                    if (inList.getEvents().size() < currentStat.config.getCue()) {
                                        int available;
                                        count = currentStat.config.getCue() - inList.getEvents().size();
                                        subList = getList.subList(0, count > (available = getList.size()) ? available : count);
                                        putList.addAll(subList);
                                        subList.clear();
                                    }
                                } else if (currentStat.config.getBlockMode() == 1) {
                                    prescale = currentStat.config.getPrescale();
                                    i3 = getList.listIterator();
                                    while (i3.hasNext()) {
                                        ev = i3.next();
                                        if (!currentStat.selector.select(this.sys, currentStat, ev)) continue;
                                        listTry = inList.getEventsTry();
                                        inList.setEventsTry(listTry + 1L);
                                        if (listTry % (long)prescale != 0L) continue;
                                        putList.add(ev);
                                        i3.remove();
                                    }
                                } else if (currentStat.config.getBlockMode() == 0 && inList.getEvents().size() < currentStat.config.getCue()) {
                                    count = currentStat.config.getCue() - inList.getEvents().size();
                                    i3 = getList.listIterator();
                                    while (i3.hasNext()) {
                                        ev = i3.next();
                                        if (!currentStat.selector.select(this.sys, currentStat, ev)) continue;
                                        putList.add(ev);
                                        i3.remove();
                                        if (--count >= 1) continue;
                                    }
                                }
                                if (putList.size() > 0 || writeAll) {
                                    if (currentStat.id == 0) {
                                        inList.putInLow(getList);
                                        getList.clear();
                                        writeAll = false;
                                    } else if (writeAll) {
                                        inList.putAll(getList);
                                        getList.clear();
                                        writeAll = false;
                                    } else {
                                        inList.putAll(putList);
                                        putList.clear();
                                    }
                                    inList.notifyAll();
                                }
                            }
                            if (!parallelIsActive) continue;
                            while (pIterator.hasNext()) {
                                stat = (StationLocal)pIterator.next();
                                if (stat.status == 3) {
                                    currentStat = stat;
                                    inList = currentStat.inputList;
                                    continue block22;
                                }
                                if (stat.status != 3) continue;
                                if (parallelIsActive && getList.size() > 0) continue block22;
                            }
                            break block82;
                            break;
                        }
                        {
                            break block82;
                            break;
                        }
                    }
                    if (rrobinOrEqualcue && parallelIsActive) {
                        int eventsToPut;
                        int index;
                        int[] numEvents;
                        int eventsAlreadyPut;
                        int lastEventIndex = 0;
                        int numActiveStations = 0;
                        if (currentStat.config.getSelectMode() == 4) {
                            boolean startLooking = false;
                            stat = currentStat;
                            pIterator = currentStat.parallelStations.listIterator(1);
                            while (true) {
                                if (stat.status == 3) {
                                    if (startLooking) {
                                        startStation = stat;
                                        startLooking = false;
                                    }
                                    ++numActiveStations;
                                }
                                if (stat.wasLast) {
                                    stat.wasLast = false;
                                    startLooking = true;
                                }
                                if (!pIterator.hasNext()) break;
                                stat = (StationLocal)pIterator.next();
                            }
                            if (startStation == null) {
                                startStation = firstActive;
                            }
                            int num = getList.size() / numActiveStations;
                            int extra = getList.size() % numActiveStations;
                            count = 0;
                            eventsAlreadyPut = 0;
                            numEvents = new int[numActiveStations];
                            for (int i4 = 0; i4 < numActiveStations; ++i4) {
                                if (i4 < extra) {
                                    numEvents[i4] = num + 1;
                                    if (i4 == extra - 1) {
                                        lastEventIndex = i4;
                                    }
                                } else {
                                    numEvents[i4] = num;
                                }
                                if (extra == 0) {
                                    lastEventIndex = numActiveStations - 1;
                                }
                                int numOfEvents = numEvents[i4];
                                index = i4;
                                for (int j = 0; j < numOfEvents; ++j) {
                                    putList.add(getList.get(index));
                                    index += numActiveStations;
                                }
                            }
                            stat = startStation;
                            inList = stat.inputList;
                            count = 0;
                            index = currentStat.parallelStations.indexOf(startStation) + 1;
                            pIterator = currentStat.parallelStations.listIterator(index);
                            while (true) {
                                if (stat.status == 3) {
                                    if (count == lastEventIndex) {
                                        stat.wasLast = true;
                                    }
                                    if ((eventsToPut = numEvents[count++]) > 0) {
                                        EventList i4 = inList;
                                        synchronized (i4) {
                                            subList = putList.subList(eventsAlreadyPut, eventsAlreadyPut + eventsToPut);
                                            inList.putAll(subList);
                                            inList.setEventsTry(inList.getEventsTry() + (long)eventsToPut);
                                            inList.notifyAll();
                                        }
                                        eventsAlreadyPut += eventsToPut;
                                    }
                                }
                                if (count >= numActiveStations) break;
                                if (pIterator.hasNext()) {
                                    stat = (StationLocal)pIterator.next();
                                    inList = stat.inputList;
                                    continue;
                                }
                                stat = firstActive;
                                inList = stat.inputList;
                                index = currentStat.parallelStations.indexOf(stat) + 1;
                                pIterator = currentStat.parallelStations.listIterator(index);
                            }
                            putList.clear();
                        } else {
                            int i5;
                            int eventsLeft = getList.size();
                            int eventsDoledOut = 0;
                            eventsAlreadyPut = 0;
                            int stationsWithSameCue = 0;
                            int[] place = new int[this.sys.getConfig().getStationsMax() + 1];
                            int[] inListCount = new int[this.sys.getConfig().getStationsMax() + 1];
                            for (i5 = 1; i5 <= this.sys.getConfig().getStationsMax(); ++i5) {
                                place[i5] = i5;
                            }
                            stat = firstActive;
                            while (true) {
                                if (stat.status == 3) {
                                    inListCount[numActiveStations + 1] = stat.inputList.getEvents().size();
                                    ++numActiveStations;
                                }
                                if (!pIterator.hasNext()) break;
                                stat = (StationLocal)pIterator.next();
                            }
                            this.shellSort(numActiveStations, inListCount, place);
                            int nextHigherCue = 0;
                            int min = inListCount[1];
                            numEvents = new int[numActiveStations];
                            while (eventsDoledOut < eventsLeft) {
                                int eventsPerStation;
                                stationsWithSameCue = 0;
                                for (i5 = 1; i5 <= numActiveStations; ++i5) {
                                    if (min == inListCount[i5] + numEvents[place[i5] - 1]) {
                                        ++stationsWithSameCue;
                                        continue;
                                    }
                                    nextHigherCue = inListCount[i5];
                                    break;
                                }
                                if (stationsWithSameCue == numActiveStations || eventsLeft - eventsDoledOut < (nextHigherCue - min) * stationsWithSameCue) {
                                    eventsToPut = eventsLeft - eventsDoledOut;
                                    eventsPerStation = eventsToPut / stationsWithSameCue;
                                    int extra = eventsToPut % stationsWithSameCue;
                                    count = 0;
                                    for (i5 = 1; i5 <= stationsWithSameCue; ++i5) {
                                        if (count++ < extra) {
                                            int n = place[i5] - 1;
                                            numEvents[n] = numEvents[n] + (eventsPerStation + 1);
                                            continue;
                                        }
                                        int n = place[i5] - 1;
                                        numEvents[n] = numEvents[n] + eventsPerStation;
                                    }
                                    break;
                                }
                                eventsPerStation = nextHigherCue - min;
                                for (i5 = 1; i5 <= stationsWithSameCue; ++i5) {
                                    int n = place[i5] - 1;
                                    numEvents[n] = numEvents[n] + eventsPerStation;
                                }
                                min = nextHigherCue;
                                eventsDoledOut += eventsPerStation * stationsWithSameCue;
                            }
                            stat = firstActive;
                            count = 0;
                            index = currentStat.parallelStations.indexOf(stat) + 1;
                            pIterator = currentStat.parallelStations.listIterator(index);
                            while (true) {
                                if (stat.status == 3) {
                                    if ((eventsToPut = numEvents[count++]) < 1) {
                                        if (!pIterator.hasNext()) break;
                                        stat = (StationLocal)pIterator.next();
                                        continue;
                                    }
                                    EventList eventList2 = inList = stat.inputList;
                                    synchronized (eventList2) {
                                        subList = getList.subList(eventsAlreadyPut, eventsAlreadyPut + eventsToPut);
                                        inList.putAll(subList);
                                        inList.setEventsTry(inList.getEventsTry() + (long)eventsToPut);
                                        inList.notifyAll();
                                    }
                                    eventsAlreadyPut += eventsToPut;
                                }
                                if (!pIterator.hasNext()) break;
                                stat = (StationLocal)pIterator.next();
                            }
                        }
                        getList.clear();
                    }
                }
                if (currentStat.id == 0) break;
                currentStat = statIterator.hasNext() ? statIterator.next() : this.sys.getStations().getFirst();
                inList = currentStat.inputList;
            }
            this.stopTransferLock.unlock();
        }
    }
}

