/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et.monitorGui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpen;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.monitorGui.ConnectionThread;
import org.jlab.coda.et.monitorGui.MonitorConfiguration;
import org.jlab.coda.et.monitorGui.MonitorFonts;
import org.jlab.coda.et.monitorGui.MonitorSingleSystem;
import org.jlab.coda.et.monitorGui.WholeNumberField;
import org.xml.sax.SAXException;

public class Monitor
extends JFrame {
    private static MonitorConfiguration config;
    private static File configurationFile;
    private final JTabbedPane tabbedPane;
    private final JFrame openFrame;
    private final JMenu disconnectMenu;
    private final JMenu loadConnectionParametersMenu;
    private JComboBox bAddress;
    private JComboBox mAddress;
    private JComboBox etName;
    private JComboBox hostname;
    private JComboBox cast;
    private WholeNumberField ttl;
    private WholeNumberField udpPort;
    private WholeNumberField mcastPort;
    private WholeNumberField tcpPort;
    private WholeNumberField period;
    private JButton connect;
    private String currentMonitorKey;
    private int defaultPeriod;
    public final Map<String, EtSystem> connections = Collections.synchronizedMap(new HashMap(20));
    public final Map<String, MonitorSingleSystem> monitors = Collections.synchronizedMap(new HashMap(20));
    public final Color textColorDefault = Color.black;
    public final Color textBackgroundColorDefault = Color.white;
    public final Color titleColorDefault = Color.black;
    public final Color backgroundColorDefault = new Color(238, 220, 130);
    public final Color selectedTabColorDefault = Color.yellow;
    public final Color tabsBackgroundColorDefault = Color.cyan;
    private Color textColor = this.textColorDefault;
    private Color textBackgroundColor = this.textBackgroundColorDefault;
    private Color titleColor = this.titleColorDefault;
    private Color backgroundColor = this.backgroundColorDefault;
    private Color selectedTabColor = this.selectedTabColorDefault;
    private Color tabsBackgroundColor = this.tabsBackgroundColorDefault;

    public Monitor() {
        this(null, null, null);
    }

    public Monitor(Color[] colors, Dimension frameSize, Point frameLocation) {
        super("ET System Monitor");
        if (colors != null) {
            if (colors[0] != null) {
                this.titleColor = colors[0];
            }
            if (colors[1] != null) {
                this.backgroundColor = colors[1];
            }
            if (colors[2] != null) {
                this.selectedTabColor = colors[2];
            }
            if (colors[3] != null) {
                this.tabsBackgroundColor = colors[3];
            }
            if (colors[4] != null) {
                this.textColor = colors[4];
            }
            if (colors[5] != null) {
                this.textBackgroundColor = colors[5];
            }
        }
        if (frameLocation != null) {
            this.setLocation(frameLocation);
        }
        this.defaultPeriod = 5;
        UIManager.put("ComboBox.foreground", this.textColor);
        UIManager.put("ComboBox.background", this.textBackgroundColor);
        UIManager.put("TabbedPane.selected", this.selectedTabColor);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(MonitorFonts.buttonTabMenuFont);
        this.tabbedPane.setBackground(this.backgroundColor);
        this.tabbedPane.setForeground(this.titleColor);
        if (frameSize == null) {
            frameSize = new Dimension(1100, 700);
        }
        this.tabbedPane.setPreferredSize(frameSize);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane source = (JTabbedPane)e.getSource();
                int tabIndex = source.getSelectedIndex();
                if (tabIndex < 1) {
                    Monitor.this.period.setValue(Monitor.this.defaultPeriod);
                    Monitor.this.currentMonitorKey = "Help";
                    return;
                }
                Monitor.this.currentMonitorKey = source.getTitleAt(tabIndex);
                int updatePeriod = Monitor.this.monitors.get(Monitor.this.currentMonitorKey).getUpdatePeriod();
                Monitor.this.period.setValue(updatePeriod);
            }
        });
        this.getContentPane().setBackground(this.tabsBackgroundColor);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.openFrame = new JFrame("Open ET System");
        this.disconnectMenu = new JMenu("Disconnect");
        this.loadConnectionParametersMenu = new JMenu("Load Connection Parameters");
        this.makeEtOpenWindow();
        this.makeMenubar();
        this.tabbedPane.addTab("Help", null, this.makeHelpPane(), "help");
        this.currentMonitorKey = "Help";
    }

    private void setUpdatePeriod() {
        if (this.currentMonitorKey.equals("Help")) {
            return;
        }
        int updatePeriod = this.period.getValue();
        MonitorSingleSystem mon = this.monitors.get(this.currentMonitorKey);
        mon.setUpdatePeriod(updatePeriod);
    }

    public void addFileName(String name) {
        boolean nameIsThere = false;
        int count = this.etName.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals((String)this.etName.getItemAt(i))) continue;
            return;
        }
        if (!nameIsThere) {
            this.etName.addItem(name);
        }
    }

    public boolean addHostname(String name) {
        if (name.equals(".local") || name.equals(".remote") || name.equals(".anywhere")) {
            return false;
        }
        boolean nameIsThere = false;
        int count = this.hostname.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!name.equals((String)this.hostname.getItemAt(i))) continue;
            return true;
        }
        if (!nameIsThere) {
            this.hostname.addItem(name);
        }
        return true;
    }

    public void addBroadcastAddress(String addr) {
        this.bAddress.addItem(addr);
    }

    public void addMulticastAddress(String addr) {
        this.mAddress.addItem(addr);
    }

    public String[] getFileNames() {
        int count = this.etName.getItemCount();
        if (count == 0) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = (String)this.etName.getItemAt(i);
        }
        return names;
    }

    public String[] getHostnames() {
        int count = this.hostname.getItemCount() - 3;
        if (count < 1) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = (String)this.hostname.getItemAt(i + 3);
        }
        return names;
    }

    public int getMonitorWidth() {
        return this.tabbedPane.getWidth();
    }

    public int getMonitorHeight() {
        return this.tabbedPane.getHeight();
    }

    public Color getTextColor() {
        return new Color(this.textColor.getRGB());
    }

    public Color getTextBackgroundColor() {
        return new Color(this.textBackgroundColor.getRGB());
    }

    public Color getTitleColor() {
        return new Color(this.titleColor.getRGB());
    }

    public Color getBackgroundColor() {
        return new Color(this.backgroundColor.getRGB());
    }

    public Color getSelectedTabColor() {
        return new Color(this.selectedTabColor.getRGB());
    }

    public Color getTabsBackgroundColor() {
        return new Color(this.tabsBackgroundColor.getRGB());
    }

    private boolean isValidIpAddress(String addr) {
        StringTokenizer tok = new StringTokenizer(addr, ".");
        if (tok.countTokens() != 4) {
            return false;
        }
        try {
            while (tok.hasMoreTokens()) {
                String num = tok.nextToken();
                int number = Integer.parseInt(num);
                if (number < 0 || number > 255) {
                    return false;
                }
                if (num.charAt(0) != '0' || number == 0 && num.length() <= 1) continue;
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean isValidMulticastAddress(String addr) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return address.isMulticastAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Monitor frame = null;
            if (args.length > 0) {
                if (args.length != 2) {
                    System.out.println("Usage: java Monitor [-f,-file <configFile>]");
                    return;
                }
                if (!args[0].equalsIgnoreCase("-f") && !args[0].equalsIgnoreCase("-file")) {
                    System.out.println("Usage: java Monitor [-f,-file <configFile>]");
                    return;
                }
                configurationFile = new File(args[1]);
                config = new MonitorConfiguration(null);
                config.loadWindowParameters(configurationFile);
                Color[] colors = config.getWindowColors();
                Dimension size = config.getWindowSize();
                Point location = config.getWindowLocation();
                frame = new Monitor(colors, size, location);
                config.setMonitor(frame);
                config.load(configurationFile);
            } else {
                frame = new Monitor();
                config = new MonitorConfiguration(frame);
            }
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.setVisible(true);
            MonitorSingleSystem mon = null;
            DefaultMutableTreeNode monNode = null;
            class Updater
            extends Thread {
                MonitorSingleSystem mon;

                public void setMonitor(MonitorSingleSystem m) {
                    this.mon = m;
                }

                public Updater(MonitorSingleSystem m) {
                    this.mon = m;
                }

                @Override
                public void run() {
                    if (this.mon.isInitialized()) {
                        this.mon.updateDisplay();
                        this.mon.treeDidChange();
                    } else {
                        this.mon.staticDisplay();
                        this.mon.updateDisplay();
                        this.mon.updateUI();
                    }
                }
            }
            Updater updater = new Updater(mon);
            while (true) {
                Map<String, MonitorSingleSystem> map = frame.monitors;
                synchronized (map) {
                    Iterator<Map.Entry<String, MonitorSingleSystem>> i = frame.monitors.entrySet().iterator();
                    while (i.hasNext()) {
                        mon = i.next().getValue();
                        monNode = mon.getNode();
                        try {
                            if (!mon.timeToUpdate()) continue;
                            mon.getData();
                            updater.setMonitor(mon);
                            SwingUtilities.invokeLater(updater);
                        }
                        catch (EtException ex) {
                        }
                        catch (Exception ex) {
                            String key = mon.getKey();
                            frame.removeConnection(frame, mon, key, false);
                            i.remove();
                            frame.connections.remove(key);
                        }
                    }
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception ex) {
            System.out.println("Unrecoverable error in ET monitor:");
            ex.printStackTrace();
            return;
        }
    }

    private void makeMenubar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBackground(this.backgroundColor);
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setFont(MonitorFonts.buttonTabMenuFont);
        fileMenu.setBackground(this.backgroundColor);
        fileMenu.setForeground(this.titleColor);
        menuBar.add(fileMenu);
        final JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        JMenuItem menuItem = new JMenuItem("Save Configuration");
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                if (configurationFile == null) {
                    if (fc.showSaveDialog(Monitor.this) == 1) {
                        return;
                    }
                    file = fc.getSelectedFile();
                } else {
                    file = configurationFile;
                }
                try {
                    config.save(file);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(new JFrame(), "Cannot write to file \"" + file.getName() + "\"", "Error", 0);
                    return;
                }
                configurationFile = file;
            }
        });
        menuItem = new JMenuItem("Save Configuration As");
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(Monitor.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        int n;
                        if (file.exists() && (n = JOptionPane.showConfirmDialog(new JFrame(), "Overwrite existing file?", "WARNING", 0)) == 1) {
                            return;
                        }
                        config.save(file);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Cannot write to file \"" + file.getName() + "\"", "Error", 0);
                        return;
                    }
                    configurationFile = file;
                }
            }
        });
        menuItem = new JMenuItem("Load Configuration");
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showDialog(Monitor.this, "Load");
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        config.load(file);
                    }
                    catch (SAXException ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Cannot load file \"" + file.getName() + "\"", "Error", 0);
                        return;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Cannot load file \"" + file.getName() + "\"", "Error", 0);
                        return;
                    }
                }
            }
        });
        menuItem = new JMenuItem("Quit");
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        fileMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenu viewMenu = new JMenu("View");
        viewMenu.setFont(MonitorFonts.buttonTabMenuFont);
        viewMenu.setBackground(this.backgroundColor);
        viewMenu.setForeground(this.titleColor);
        menuBar.add(viewMenu);
        this.period = new WholeNumberField(this.defaultPeriod, 5, 1, Integer.MAX_VALUE);
        this.period.setFont(MonitorFonts.inputFont);
        this.period.setAlignmentX(0.0f);
        this.period.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
                Monitor.this.setUpdatePeriod();
            }
        });
        this.period.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
                Monitor.this.setUpdatePeriod();
            }
        });
        JMenu updatePeriod = new JMenu("Update Period (sec)");
        updatePeriod.setFont(MonitorFonts.buttonTabMenuFont);
        updatePeriod.setBackground(this.backgroundColor);
        updatePeriod.setForeground(this.titleColor);
        updatePeriod.add(this.period);
        viewMenu.add(updatePeriod);
        this.loadConnectionParametersMenu.setFont(MonitorFonts.buttonTabMenuFont);
        this.loadConnectionParametersMenu.setBackground(this.backgroundColor);
        this.loadConnectionParametersMenu.setForeground(this.titleColor);
        viewMenu.add(this.loadConnectionParametersMenu);
        menuItem = new JMenuItem("Change Orientation");
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        viewMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Monitor.this.currentMonitorKey.equals("Help")) {
                    return;
                }
                MonitorSingleSystem mon = Monitor.this.monitors.get(Monitor.this.currentMonitorKey);
                int orient = mon.getOrientation();
                if (orient == 1) {
                    mon.setOrientation(0);
                } else {
                    mon.setOrientation(1);
                }
            }
        });
        JMenu connectMenu = new JMenu("Connections");
        connectMenu.setFont(MonitorFonts.buttonTabMenuFont);
        connectMenu.setBackground(this.backgroundColor);
        connectMenu.setForeground(this.titleColor);
        menuBar.add(connectMenu);
        menuItem = new JMenuItem("Connect to ET System");
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        connectMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitor.this.openFrame.setVisible(true);
                Monitor.this.openFrame.setState(0);
            }
        });
        this.disconnectMenu.setFont(MonitorFonts.buttonTabMenuFont);
        this.disconnectMenu.setBackground(this.backgroundColor);
        this.disconnectMenu.setForeground(this.titleColor);
        connectMenu.add(this.disconnectMenu);
    }

    private JScrollPane makeHelpPane() {
        JTextArea text = new JTextArea(10, 200);
        text.setFont(MonitorFonts.helpFont);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setTabSize(3);
        text.setEditable(false);
        text.setBorder(new EmptyBorder(20, 20, 20, 20));
        JScrollPane pane = new JScrollPane(text);
        text.append("CONNECTING TO AN ET SYSTEM\nSelect the \"Connect to ET System\" option of the \"Connections\" menu. There are a number of options on the appearing window which must be set.\n\n1) ET Name\nThis is the name of the ET system (actually, its file) that you want to connect to. The names of several ET systems can be stored in its list. The \"X\" button is for removing unwanted entries.\n\n2) ET Location\nTo look for the named ET system on the local computer or host, select \"local\". To look only on another computer, select \"remote\", or \"anywhere\" if you don't care where the ET system is. If you know the name of the computer, this is the place to type it in.\n\n3) Find ET by\nThere are several ways to connect to an ET system. The following list showing the available choices:\n\n\ta) broadcasting\nThis selection is generally chosen when the name of the host that the ET system is residing on is unknown or if the user wants to write a very general application with no hostnames \"hardcoded\" or input in some fashion. (If a specific hostname is used, a UDP packet is sent directly to that host in addition to a broadcast being made.)\nA UDP broadcast is made on all the subnet broadcast addresses listed in the \"Subnet Addresses\" entry. Items can be removed with the \"X\" button. This broadcast is sent to the port found in the \"UDP Port\" entry. Once an ET system receives the broadcast, it responds by sending its host name and the tcp port on which it is listening. This information is used to establish a permanent tcp connection.\n\n\tb) multicasting\nAs in broadcasting, this selection is generally chosen when the name of the host that the ET system is residing on is unknown or if the user wants to write a very general application with no hostnames \"hardcoded\" or input in some fashion. (If a specific hostname is used, a UDP packet is sent directly to that host on the port in the \"UDP Port\" entry in addition to a multicast being made.)\nA UDP multicast is made on all the multicast addresses listed in the \"Multicast Addresses\" entry. Items can be removed with the \"X\" button. This multicast is sent to the port found in the \"Multicast Port\" entry, and its \"ttl\" value can be set as well. (It defaults to \"1\" which should limit its scope to the local subnets.) Once an ET system receives the multicast, it responds by sending its host name and the tcp port on which it is listening. This information is used to establish a permanent tcp connection.\n\n\tc) broad & multicasting\nThis selection can simultaneously UDP broadcast and UDP multicast.\n\n\td) direct connection\nA direct, permanent tcp connection is made between the ET system and the user. In this case, a specific hostname must be used (not \"local\", \"remote\", or \"anywhere\"). The \"TCP Port\" entry is used for the port number.\n\nRESETTING CONNECTION PARAMETERS\nReseting all connection parameters to those previously used to make an actual connection can be done by selecting the \"Load connection parameters\" item from the \"View\" menu. Simply select from the list of existing connections.\n\n\n\nVIEWING AN ET SYSTEM\nAfter connecting to an ET system, a tab appears with the ET system's name on it. By selecting this tab, the user can see all the system parameters in text form on the left side of the window and a visual representation on the right side. Not all text information is relevant for all systems. For example, the ET systems written in Java do not have process or mutex information available. Text information is divided into sections with a short explanation of each following:\n\n1) System - general ET system parameters\n\ta) Static Info - information that does NOT change\n\t\tHost - host system is running on, language code was written in, and unix pid\n\t\tPorts - the tcp, udp, and multicast port numbers\n\t\tEvents - total # of events, size of each, # of temporary (extra large) events\n\t\tMax - maximum number of stations, attachments, and processes allowed\n\t\tNetwork interfaces - list of host's network interfaces\n\t\tMulticast addreses - list of multicast addresses the system is listening on\n\n\tb) Dynamic Info - information that can or will change in time\n\t\tEvents rate - rate of events leaving GRAND_CENTRAL station\n\t\tEvents owned by - number of events owned by each attachment & system.\n\t\tIdle stations - list of stations with no attachments (receive no events)\n\t\tAll stations - list of all stations in proper order\n\t\tStations - current number of stations, attachments, and temporary events\n\t\tProcesses - # of non-system, unix processes with access to shared memory (Solaris)\n\t\tHeartbeat - value of non-Java system's counter in shared memory (changes if alive)\n\t\tLocked Mutexes - on non-Java systems, locked pthread mutexes.\n\n2) Stations - stations are listed by name under this heading\n\ta) Configuration - parameters which define station behavior\n\t\t- active or idle,  blocking or nonblocking,  prescale & cue values\n\t\t- single user, multiple users, or the exact number of allowed users\n\t\t- events restored to station's input, output, or to GRAND_CENTRAL station\n\t\t- select all events, those matching default condition, or matching user condition\n\t\t- values of integers in selection array\n\t\t- class or library & function of user's matching condition\n\n\tb) Statistics - \n\t\t- total number of attachments and their id numbers\n\t\t- current # of events in input list, total # put in input, # tried to put in input\n\t\t- current # of events in output list, total # put in output list\n\n3) Processes - on Solaris, local unix processes with attachments are listed by id #\n\t- total # of attachments, list of attachments' ids, unix pid, current heartbeat value\n\n4) Attachments - attachments are listed by their id numbers\n\t- name of station attached to, host attachment is running on\n\t- is attachment blocked waiting to read events?\n\t- has attachment been told to quit reading events and return?\n\t- unix pid and process id (non-Java)\n\t- # events currently owned, total #: newly made, gotten, put, and dumped\n\n\n\nSETTING AN UPDATE PERIOD\nEach ET system has its information updated at a regular period which can be set by selecting the \"View\" menu item and typing in the period value.\n\n\n\nDISCONNECTING AN ET SYSTEM\nEach ET system can be removed from the monitor by selecting the \"Connections\" menu item followed by selecting the \"Disconnect\" item, and then selecting the system to be removed.\n\n\n\nCONFIGURATION FILES\nConfiguration files can be created, saved, and loaded through the \"File\" menu item. The configuration files are in XML format and use a schema defined in the file \"monitorConfiguration.xsd\". Without going into great detail, configuration files store all current connections and the current state of the application. Colors used in this application, as well as the main window's size and placement, can be set in the configuration file. These particular parameters, however, will only be set in the application if the configuration file is given on the command line (-f or -file). Once the monitor is up and running, loading a configuration file simply adds any additional ET system connections listed there as well as adding items to the \"ET Name\" or \"ET Location\" lists.\n\nSetting colors in a configuration file can only be done by hand-editing it. Modifying the colors in the main application can be done by inserting the following lines (without the explanation) in any order, under the \"<graphics>\" element. Simply change the red, green, and blue values (between 0 and 255 inclusive) to suit:\n\n\tText on menus, titles, buttons, tabs (default black):\n\t\t<titleColor  red=\"0\" green=\"0\" blue=\"0\"/>\n\n\tGeneral background: (default lightGoldenrod2)\n\t\t<backgroundColor  red=\"238\" green=\"220\" blue=\"130\"/>\n\n\tSelected tab background (default yellow):\n\t\t<selectedTabColor  red=\"255\" green=\"255\" blue=\"0\"/>\n\n\tBehind all tabs background (default cyan):\n\t\t<tabsBackgroundColor  red=\"150\" green=\"255\" blue=\"255\"/>\n\n\tText in entry widgets (default black):\n\t\t<textColor  red=\"0\" green=\"0\" blue=\"0\"/>\n\n\tText entry widget background (default white):\n\t\t<textBackgroundColor  red=\"255\" green=\"255\" blue=\"255\"/>\n\nColors may also be changed in the view of a monitored ET system. To do so, the following lines may be added. HOWEVER, THEY MAY ONLY BE ADDED AT THE END OF EACH \"<etConnection>\" ELEMENT AND ONLY IN THE GIVEN ORDER:\n\n\tEvents (default red):\n\t\t<eventColor  red=\"255\" green=\"0\" blue=\"0\"/>\n\n\tStations Active (default cyan):\n\t\t<stationColor  red=\"0\" green=\"255\" blue=\"255\"/>\n\n\tStations Idle (default pink):\n\t\t<stationIdleColor  red=\"255\" green=\"192\" blue=\"203\"/>\n\n\tAttachments (default magenta):\n\t\t<attachmentColor  red=\"255\" green=\"0\" blue=\"255\"/>\n\n\tLines between stations and attachments (default black):\n\t\t<lineColor  red=\"0\" green=\"0\" blue=\"0\"/>\n\n\tText in stations and attachments (default black):\n\t\t<textColor  red=\"0\" green=\"0\" blue=\"0\"/>\n\n\tStation and attachment text background (default white):\n\t\t<textBackgroundColor  red=\"255\" green=\"255\" blue=\"255\"/>\n\n\tGraph background (default white):\n\t\t<backgroundColor  red=\"255\" green=\"255\" blue=\"255\"/>\n\n\tText of tree widget (default black):\n\t\t<treeTextColor  red=\"0\" green=\"0\" blue=\"0\"/>\n\n\tTree widget background (default white):\n\t\t<treeBackgroundColor  red=\"255\" green=\"255\" blue=\"255\"/>");
        return pane;
    }

    private void makeEtOpenWindow() {
        int edge1 = 20;
        int edge2 = 10;
        int edge3 = 5;
        int prefWidth = 500;
        int maxWidth = 800;
        int indent = 15;
        int horSpace = 10;
        int verSpace = 10;
        int prefRemBut = 50;
        int maxRemBut = 70;
        int prefHeight1 = 50;
        int maxHeight = 60;
        int prefHeight2 = 40;
        int prefHalf = prefWidth / 2 - edge2 - horSpace / 2;
        int maxHalf = maxWidth / 2 - edge2 - horSpace / 2;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String selectedItem = (String)jcb.getSelectedItem();
                int numItems = jcb.getItemCount();
                boolean addNewItem = true;
                if (selectedItem == null || selectedItem.equals("")) {
                    addNewItem = false;
                } else if (numItems == 0) {
                    addNewItem = true;
                } else {
                    for (int i = 0; i < numItems; ++i) {
                        String listItem = (String)jcb.getItemAt(i);
                        if (!listItem.equals(selectedItem)) continue;
                        addNewItem = false;
                        break;
                    }
                }
                if (addNewItem) {
                    jcb.addItem(selectedItem);
                }
            }
        };
        JPanel openPanel = new JPanel();
        openPanel.setBackground(this.backgroundColor);
        openPanel.setLayout(new BoxLayout(openPanel, 1));
        openPanel.setBorder(new EmptyBorder(edge1, edge1, edge1, edge1));
        TitledBorder border1 = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "ET Name", 1, 1, MonitorFonts.titleFont, this.titleColor);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setBorder(border1);
        p1.setBackground(this.backgroundColor);
        p1.setPreferredSize(new Dimension(prefWidth, prefHeight1 + edge3));
        p1.setMaximumSize(new Dimension(maxWidth, maxHeight + edge3));
        p1.setAlignmentX(0.0f);
        this.etName = new JComboBox();
        this.etName.setBackground(this.textBackgroundColor);
        this.etName.setEditable(true);
        this.etName.setFont(MonitorFonts.inputFont);
        this.etName.setAlignmentX(0.5f);
        this.etName.setPreferredSize(new Dimension(prefWidth - indent, prefHeight1));
        this.etName.setMaximumSize(new Dimension(maxWidth - indent, maxHeight));
        this.etName.addActionListener(al);
        Component c = this.etName.getEditor().getEditorComponent();
        c.setBackground(this.textBackgroundColor);
        c.setForeground(this.textColor);
        JButton removeName = new JButton("X");
        removeName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.etName.getSelectedIndex();
                if (index > -1) {
                    Monitor.this.etName.removeItemAt(index);
                }
            }
        });
        removeName.setAlignmentX(0.0f);
        removeName.setForeground(this.titleColor);
        removeName.setBackground(this.backgroundColor);
        removeName.setPreferredSize(new Dimension(prefRemBut, prefHeight2));
        removeName.setMaximumSize(new Dimension(maxRemBut, maxHeight));
        p1.add(Box.createRigidArea(new Dimension(indent, 0)));
        p1.add(this.etName);
        p1.add(removeName);
        TitledBorder border2 = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "ET Location", 1, 1, MonitorFonts.titleFont, this.titleColor);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.setBorder(border2);
        p2.setBackground(this.backgroundColor);
        p2.setPreferredSize(new Dimension(prefWidth, prefHeight1 + edge3));
        p2.setMaximumSize(new Dimension(maxWidth, maxHeight + edge3));
        p2.setAlignmentX(0.0f);
        this.hostname = new JComboBox<String>(new String[]{"local", "remote", "anywhere"});
        this.hostname.setEditable(true);
        this.hostname.setBackground(this.textBackgroundColor);
        this.hostname.setFont(MonitorFonts.inputFont);
        this.hostname.setPreferredSize(new Dimension(prefWidth - indent, prefHeight1));
        this.hostname.setMaximumSize(new Dimension(maxWidth - indent, maxHeight));
        this.hostname.addActionListener(al);
        c = this.hostname.getEditor().getEditorComponent();
        c.setBackground(this.textBackgroundColor);
        c.setForeground(this.textColor);
        JButton removeHost = new JButton("X");
        removeHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.hostname.getSelectedIndex();
                if (index > 2) {
                    Monitor.this.hostname.removeItemAt(index);
                }
            }
        });
        removeHost.setAlignmentX(0.0f);
        removeHost.setForeground(this.titleColor);
        removeHost.setBackground(this.backgroundColor);
        removeHost.setPreferredSize(new Dimension(prefRemBut, prefHeight2));
        removeHost.setMaximumSize(new Dimension(maxRemBut, maxHeight));
        p2.add(Box.createRigidArea(new Dimension(indent, 0)));
        p2.add(this.hostname);
        p2.add(removeHost);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(2, 2, horSpace, 0));
        p3.setBackground(this.backgroundColor);
        p3.setPreferredSize(new Dimension(prefWidth, prefHeight2 * 2));
        p3.setMaximumSize(new Dimension(maxWidth, maxHeight * 2));
        p3.setBorder(new EmptyBorder(edge2, edge2, edge2, edge2));
        p3.setAlignmentX(0.0f);
        JLabel l4 = new JLabel("Subnet Addresses", 2);
        l4.setVerticalAlignment(3);
        l4.setFont(MonitorFonts.titleFont);
        l4.setForeground(this.titleColor);
        l4.setOpaque(true);
        l4.setBackground(this.backgroundColor);
        l4.setAlignmentX(0.0f);
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, 0));
        p4.setBackground(this.backgroundColor);
        p4.setPreferredSize(new Dimension(prefHalf, prefHeight2));
        p4.setMaximumSize(new Dimension(maxHalf, maxHeight));
        p4.setAlignmentX(0.0f);
        this.bAddress = new JComboBox();
        this.bAddress.addItem("129.57.35.255");
        this.bAddress.setEditable(true);
        this.bAddress.setBackground(this.textBackgroundColor);
        this.bAddress.setFont(MonitorFonts.inputFont);
        this.bAddress.setAlignmentX(0.0f);
        this.bAddress.setPreferredSize(new Dimension(prefHalf - prefRemBut, prefHeight2));
        this.bAddress.setMaximumSize(new Dimension(maxHalf - maxRemBut, maxHeight));
        this.bAddress.addActionListener(al);
        c = this.bAddress.getEditor().getEditorComponent();
        c.setBackground(this.textBackgroundColor);
        c.setForeground(this.textColor);
        final JButton remove1 = new JButton("X");
        remove1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.bAddress.getSelectedIndex();
                if (index > -1) {
                    Monitor.this.bAddress.removeItemAt(index);
                }
            }
        });
        remove1.setAlignmentX(0.0f);
        remove1.setForeground(this.titleColor);
        remove1.setBackground(this.backgroundColor);
        remove1.setPreferredSize(new Dimension(prefRemBut, prefHeight2));
        remove1.setMaximumSize(new Dimension(maxRemBut, maxHeight));
        p4.add(this.bAddress);
        p4.add(remove1);
        JLabel l5 = new JLabel("Multicast Addresses", 2);
        l5.setVerticalAlignment(3);
        l5.setFont(MonitorFonts.titleFont);
        l5.setForeground(this.titleColor);
        l5.setOpaque(true);
        l5.setBackground(this.backgroundColor);
        l5.setAlignmentX(0.0f);
        JPanel p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, 0));
        p5.setBackground(this.backgroundColor);
        p5.setPreferredSize(new Dimension(prefHalf, prefHeight2));
        p5.setMaximumSize(new Dimension(maxHalf, maxHeight));
        p5.setAlignmentX(0.0f);
        this.mAddress = new JComboBox();
        this.mAddress.setEditable(true);
        this.mAddress.setBackground(this.textBackgroundColor);
        this.mAddress.setFont(MonitorFonts.inputFont);
        this.mAddress.setAlignmentX(0.0f);
        this.mAddress.setPreferredSize(new Dimension(prefHalf - prefRemBut, prefHeight2));
        this.mAddress.setMaximumSize(new Dimension(maxHalf - maxRemBut, maxHeight));
        this.mAddress.addActionListener(al);
        c = this.mAddress.getEditor().getEditorComponent();
        c.setBackground(this.textBackgroundColor);
        c.setForeground(this.textColor);
        final JButton remove2 = new JButton("X");
        remove2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Monitor.this.mAddress.getSelectedIndex();
                if (index > -1) {
                    Monitor.this.mAddress.removeItemAt(index);
                }
            }
        });
        remove2.setAlignmentX(0.0f);
        remove2.setForeground(this.titleColor);
        remove2.setBackground(this.backgroundColor);
        remove2.setPreferredSize(new Dimension(prefRemBut, prefHeight2));
        remove2.setMaximumSize(new Dimension(maxRemBut, maxHeight));
        p5.add(this.mAddress);
        p5.add(remove2);
        p3.add(l4);
        p3.add(l5);
        p3.add(p4);
        p3.add(p5);
        JPanel p6 = new JPanel();
        p6.setLayout(new GridLayout(1, 1, horSpace, 0));
        p6.setBackground(this.backgroundColor);
        p6.setPreferredSize(new Dimension(prefWidth, prefHeight2 * 2));
        p6.setMaximumSize(new Dimension(maxWidth, maxHeight * 2));
        p6.setBorder(new EmptyBorder(edge2, edge2, 0, edge2));
        p6.setAlignmentX(0.0f);
        JPanel p7 = new JPanel();
        p7.setLayout(new BoxLayout(p7, 0));
        p7.setBackground(this.backgroundColor);
        p7.setAlignmentX(0.0f);
        JPanel p8 = new JPanel();
        p8.setLayout(new GridLayout(2, 2, 0, 2));
        p8.setBackground(this.backgroundColor);
        p8.setAlignmentX(0.0f);
        JPanel p9 = new JPanel();
        p9.setLayout(new GridLayout(2, 1, 0, 2));
        p9.setBackground(this.backgroundColor);
        p9.setPreferredSize(new Dimension((int)((double)prefHalf * 0.67), prefHeight1 * 2));
        p9.setMaximumSize(new Dimension((int)((double)maxHalf * 0.67), maxHeight * 2));
        JPanel p10 = new JPanel();
        p10.setLayout(new GridLayout(2, 1, 0, 2));
        p10.setBackground(this.backgroundColor);
        p10.setPreferredSize(new Dimension((int)((double)prefHalf * 0.33), prefHeight1 * 2));
        p10.setMaximumSize(new Dimension((int)((double)maxHalf * 0.33), maxHeight * 2));
        JLabel l0 = new JLabel("UDP Port: ", 4);
        JLabel l1 = new JLabel("TCP Port: ", 4);
        JLabel l2 = new JLabel("Multicast Port: ", 4);
        JLabel l3 = new JLabel("TTL Value: ", 4);
        l0.setFont(MonitorFonts.titleFont);
        l1.setFont(MonitorFonts.titleFont);
        l2.setFont(MonitorFonts.titleFont);
        l3.setFont(MonitorFonts.titleFont);
        l0.setForeground(this.titleColor);
        l1.setForeground(this.titleColor);
        l2.setForeground(this.titleColor);
        l3.setForeground(this.titleColor);
        this.udpPort = new WholeNumberField(11111, 8, 1024, 65535);
        this.udpPort.setAlignmentX(0.0f);
        this.udpPort.setFont(MonitorFonts.inputFont);
        this.udpPort.setForeground(this.textColor);
        this.udpPort.setBackground(this.textBackgroundColor);
        this.udpPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.udpPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.udpPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.mcastPort = new WholeNumberField(11112, 8, 1024, 65535);
        this.mcastPort.setAlignmentX(0.0f);
        this.mcastPort.setFont(MonitorFonts.inputFont);
        this.mcastPort.setForeground(this.textColor);
        this.mcastPort.setBackground(this.textBackgroundColor);
        this.mcastPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.mcastPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.mcastPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.tcpPort = new WholeNumberField(11111, 8, 1024, 65535);
        this.tcpPort.setFont(MonitorFonts.inputFont);
        this.tcpPort.setAlignmentX(0.0f);
        this.tcpPort.setForeground(this.textColor);
        this.tcpPort.setBackground(this.textBackgroundColor);
        this.tcpPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.tcpPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.tcpPort.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.ttl = new WholeNumberField(32, 6, 0, 255);
        this.ttl.setFont(MonitorFonts.inputFont);
        this.ttl.setAlignmentX(0.0f);
        this.ttl.setForeground(this.textColor);
        this.ttl.setBackground(this.textBackgroundColor);
        this.ttl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.ttl.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        this.ttl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                WholeNumberField source = (WholeNumberField)e.getSource();
                source.correctValue();
            }
        });
        p9.add(l2);
        p9.add(l3);
        p10.add(this.mcastPort);
        p10.add(this.ttl);
        p7.add(p9);
        p7.add(p10);
        p8.add(l0);
        p8.add(this.udpPort);
        p8.add(l1);
        p8.add(this.tcpPort);
        p6.add(p8);
        p6.add(p7);
        JPanel p14 = new JPanel();
        p14.setLayout(new BoxLayout(p14, 0));
        p14.setBackground(this.backgroundColor);
        p14.setPreferredSize(new Dimension(prefWidth, prefHeight2));
        p14.setMaximumSize(new Dimension(maxWidth, maxHeight));
        p14.setAlignmentX(0.0f);
        this.cast = new JComboBox<String>(new String[]{"broadcasting", "multicasting", "broad & multicasting", "direct connection"});
        this.cast.setEditable(false);
        this.cast.setFont(MonitorFonts.inputFont);
        this.cast.setBackground(this.textBackgroundColor);
        this.cast.setPreferredSize(new Dimension(prefWidth - 2 * edge2, prefHeight2));
        this.cast.setMaximumSize(new Dimension(maxWidth - 2 * edge2, maxHeight));
        this.cast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String selecteditem = (String)jcb.getSelectedItem();
                if (selecteditem.equals("broadcasting")) {
                    Monitor.this.bAddress.setEnabled(true);
                    Monitor.this.udpPort.setEnabled(true);
                    remove1.setEnabled(true);
                    Monitor.this.mcastPort.setEnabled(false);
                    Monitor.this.ttl.setEnabled(false);
                    Monitor.this.tcpPort.setEnabled(false);
                    Monitor.this.mAddress.setEnabled(false);
                    remove2.setEnabled(false);
                } else if (selecteditem.equals("multicasting")) {
                    Monitor.this.ttl.setEnabled(true);
                    Monitor.this.mcastPort.setEnabled(true);
                    Monitor.this.mAddress.setEnabled(true);
                    remove2.setEnabled(true);
                    Monitor.this.udpPort.setEnabled(true);
                    Monitor.this.bAddress.setEnabled(false);
                    Monitor.this.tcpPort.setEnabled(false);
                    remove1.setEnabled(false);
                } else if (selecteditem.equals("broad & multicasting")) {
                    Monitor.this.tcpPort.setEnabled(false);
                    Monitor.this.udpPort.setEnabled(true);
                    Monitor.this.mcastPort.setEnabled(true);
                    Monitor.this.mAddress.setEnabled(true);
                    Monitor.this.bAddress.setEnabled(true);
                    remove1.setEnabled(true);
                    remove2.setEnabled(true);
                    Monitor.this.ttl.setEnabled(true);
                } else if (selecteditem.equals("direct connection")) {
                    Monitor.this.tcpPort.setEnabled(true);
                    Monitor.this.udpPort.setEnabled(false);
                    Monitor.this.mcastPort.setEnabled(false);
                    Monitor.this.bAddress.setEnabled(false);
                    Monitor.this.mAddress.setEnabled(false);
                    remove1.setEnabled(false);
                    remove2.setEnabled(false);
                    Monitor.this.ttl.setEnabled(false);
                } else {
                    Monitor.this.udpPort.setEnabled(true);
                    Monitor.this.bAddress.setEnabled(false);
                    Monitor.this.mcastPort.setEnabled(false);
                    remove1.setEnabled(false);
                    Monitor.this.ttl.setEnabled(false);
                    Monitor.this.tcpPort.setEnabled(false);
                    Monitor.this.mAddress.setEnabled(false);
                    remove2.setEnabled(false);
                }
            }
        });
        this.cast.setSelectedIndex(0);
        p14.add(Box.createRigidArea(new Dimension(edge2, 0)));
        p14.add(this.cast);
        p14.add(Box.createRigidArea(new Dimension(edge2, 0)));
        TitledBorder border3 = new TitledBorder(new EtchedBorder(), "Find ET by", 1, 1, MonitorFonts.titleFont, this.titleColor);
        JPanel p15 = new JPanel();
        p15.setLayout(new BoxLayout(p15, 1));
        p15.setBorder(border3);
        p15.setBackground(this.backgroundColor);
        p15.setPreferredSize(new Dimension(prefWidth, 5 * prefHeight2 + 2 * edge2));
        p15.setMaximumSize(new Dimension(maxWidth, 5 * maxHeight + 2 * edge2));
        p15.add(Box.createRigidArea(new Dimension(0, edge2)));
        p15.add(p14);
        p15.add(p3);
        p15.add(p6);
        p15.add(Box.createRigidArea(new Dimension(0, edge2)));
        JPanel p16 = new JPanel();
        p16.setLayout(new GridLayout(1, 2, 10, 0));
        p16.setBackground(this.backgroundColor);
        p16.setPreferredSize(new Dimension(prefWidth, prefHeight2));
        p16.setMaximumSize(new Dimension(maxWidth, maxHeight));
        p16.setAlignmentX(0.0f);
        this.connect = new JButton("Connect");
        this.connect.setFont(MonitorFonts.buttonTabMenuFont);
        this.connect.setForeground(this.titleColor);
        this.connect.setBackground(this.backgroundColor);
        this.connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtSystemOpenConfig config = Monitor.this.getEtSystemConfig();
                if (config == null) {
                    return;
                }
                Monitor.this.addEtSystem(config);
            }
        });
        JButton dismiss = new JButton("Dismiss");
        dismiss.setFont(MonitorFonts.buttonTabMenuFont);
        dismiss.setForeground(this.titleColor);
        dismiss.setBackground(this.backgroundColor);
        dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitor.this.openFrame.setVisible(false);
            }
        });
        p16.add(this.connect);
        p16.add(dismiss);
        openPanel.add(Box.createRigidArea(new Dimension(0, verSpace)));
        openPanel.add(p1);
        openPanel.add(Box.createRigidArea(new Dimension(0, verSpace)));
        openPanel.add(p2);
        openPanel.add(Box.createRigidArea(new Dimension(0, verSpace)));
        openPanel.add(p15);
        openPanel.add(Box.createRigidArea(new Dimension(0, verSpace)));
        openPanel.add(p16);
        this.openFrame.getContentPane().add(openPanel);
        this.openFrame.pack();
    }

    private void addEtSystem(EtSystemOpenConfig config) {
        ConnectionThread t = new ConnectionThread(this, config);
        t.start();
    }

    public void addEtSystem(EtSystemOpenConfig config, int updatePeriod, int dividerLocation, int orientation, Color[] colors) {
        ConnectionThread t = new ConnectionThread(this, config, updatePeriod, dividerLocation, orientation, colors);
        t.start();
    }

    private EtSystemOpenConfig getEtSystemConfig() {
        try {
            boolean specifingHostname = false;
            EtSystemOpenConfig config = null;
            String etSystem = (String)this.etName.getSelectedItem();
            String host = (String)this.hostname.getSelectedItem();
            String howToConnect = (String)this.cast.getSelectedItem();
            if (host.equals("local")) {
                host = ".local";
                specifingHostname = true;
            } else if (host.equals("remote")) {
                host = ".remote";
            } else if (host.equals("anywhere")) {
                host = ".anywhere";
            } else {
                specifingHostname = true;
            }
            if (howToConnect.equals("broadcasting")) {
                int port = this.udpPort.getValue();
                config = new EtSystemOpenConfig(etSystem, port, host);
            } else if (howToConnect.equals("multicasting")) {
                int nAddrs = this.mAddress.getItemCount();
                String[] addresses = new String[nAddrs];
                for (int i = 0; i < nAddrs; ++i) {
                    addresses[i] = (String)this.mAddress.getItemAt(i);
                    if (this.isValidMulticastAddress(addresses[i])) continue;
                    throw new EtException("Invalid multicast address \"" + addresses[i] + "\" in list.");
                }
                int uPort = this.udpPort.getValue();
                int mPort = this.mcastPort.getValue();
                int ttlval = this.ttl.getValue();
                config = new EtSystemOpenConfig(etSystem, host, Arrays.asList(addresses), uPort, mPort, ttlval);
            } else if (howToConnect.equals("broad & multicasting")) {
                int nAddrs = 0;
                String[] mAddresses = null;
                nAddrs = this.mAddress.getItemCount();
                mAddresses = new String[nAddrs];
                for (int i = 0; i < nAddrs; ++i) {
                    mAddresses[i] = (String)this.mAddress.getItemAt(i);
                    if (this.isValidMulticastAddress(mAddresses[i])) continue;
                    throw new EtException("Invalid multicast address \"" + mAddresses[i] + "\" in list.");
                }
                int uPort = this.udpPort.getValue();
                int mPort = this.mcastPort.getValue();
                int tPort = this.tcpPort.getValue();
                int ttlval = this.ttl.getValue();
                config = new EtSystemOpenConfig(etSystem, host, null, Arrays.asList(mAddresses), true, 3, tPort, uPort, mPort, ttlval, 2);
            } else if (howToConnect.equals("direct connection")) {
                if (!specifingHostname) {
                    throw new EtException("Specify a host's name (not remote, or anywhere) to make a direct connection.");
                }
                int port = this.tcpPort.getValue();
                config = new EtSystemOpenConfig(etSystem, host, port);
            }
            return config;
        }
        catch (EtException ex) {
            JOptionPane.showMessageDialog(new JFrame(), ex.getMessage(), "Error", 0);
            return null;
        }
    }

    public EtSystem makeConnection(EtSystemOpenConfig config) {
        EtSystemOpen open;
        block13: {
            if (config == null) {
                return null;
            }
            config.setConnectRemotely(true);
            open = new EtSystemOpen(config);
            this.openFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.connect.setEnabled(false);
            try {
                open.connect();
            }
            catch (UnknownHostException ex) {
                JOptionPane.showMessageDialog(new JFrame(), config.getHost() + " is an unknown host", "Error", 0);
                this.openFrame.setCursor(Cursor.getDefaultCursor());
                this.connect.setEnabled(true);
                return null;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
                this.openFrame.setCursor(Cursor.getDefaultCursor());
                this.connect.setEnabled(true);
                return null;
            }
            catch (EtTooManyException ex) {
                String host = null;
                Object[] hosts = open.getAllHosts();
                int port = 0;
                int[] ports = open.getAllPorts();
                if (hosts.length <= 1) break block13;
                host = (String)JOptionPane.showInputDialog(new JFrame(), "Choose the ET system responding from host:", "ET System Choice", -1, null, hosts, hosts[0]);
                if (host == null) {
                    return null;
                }
                for (int i = 0; i < hosts.length; ++i) {
                    if (!host.equals(hosts[i])) continue;
                    port = ports[i];
                }
                try {
                    config.setHost(host);
                    config.setTcpPort(port);
                    config.setNetworkContactMethod(2);
                    open.connect();
                }
                catch (Exception except) {
                    JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
                    this.openFrame.setCursor(Cursor.getDefaultCursor());
                    this.connect.setEnabled(true);
                    return null;
                }
            }
            catch (EtException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Cannot find or connect to " + config.getEtName(), "Error", 0);
                this.openFrame.setCursor(Cursor.getDefaultCursor());
                this.connect.setEnabled(true);
                return null;
            }
        }
        this.openFrame.setCursor(Cursor.getDefaultCursor());
        this.connect.setEnabled(true);
        String key = open.getHostAddress().indexOf(".") < 0 ? new String(config.getEtName() + " (" + open.getHostAddress() + ")") : new String(config.getEtName() + " (" + open.getHostAddress().substring(0, open.getHostAddress().indexOf(".")) + ")");
        if (this.connections.containsKey(key)) {
            open.disconnect();
            JOptionPane.showMessageDialog(new JFrame(), "You are already connected to " + config.getEtName() + " on " + config.getHost(), "ERROR", 0);
            return null;
        }
        EtSystem use = null;
        try {
            use = new EtSystem(open, 0);
        }
        catch (Exception ex) {
            open.disconnect();
            JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
        }
        this.connections.put(key, use);
        final EtSystem useObject = use;
        JMenuItem menuItem = new JMenuItem(key);
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        this.loadConnectionParametersMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int method;
                EtSystemOpenConfig config = useObject.getConfig();
                Monitor.this.addFileName(config.getEtName());
                Monitor.this.etName.setSelectedItem(config.getEtName());
                String host = config.getHost();
                if (host.equals(".local")) {
                    host = "local";
                } else if (host.equals(".remote")) {
                    host = "remote";
                } else if (host.equals(".anywhere")) {
                    host = "anywhere";
                }
                if (Monitor.this.addHostname(host)) {
                    Monitor.this.hostname.setSelectedItem(host);
                }
                if ((method = config.getNetworkContactMethod()) == 1) {
                    Monitor.this.cast.setSelectedItem("broadcasting");
                    Monitor.this.bAddress.removeAllItems();
                    Monitor.this.bAddress.addItem("255.255.255.255");
                    Monitor.this.udpPort.setValue(config.getUdpPort());
                } else if (method == 0) {
                    Monitor.this.cast.setSelectedItem("multicasting");
                    Monitor.this.mAddress.removeAllItems();
                    HashSet<String> set = config.getMulticastAddrs();
                    Iterator<String> i = set.iterator();
                    while (i.hasNext()) {
                        Monitor.this.mAddress.addItem(i.next());
                    }
                    Monitor.this.mcastPort.setValue(config.getMulticastPort());
                    Monitor.this.udpPort.setValue(config.getUdpPort());
                    Monitor.this.ttl.setValue(config.getTTL());
                } else if (method == 3) {
                    Monitor.this.cast.setSelectedItem("broad & multicasting");
                    Monitor.this.bAddress.removeAllItems();
                    Monitor.this.bAddress.addItem("255.255.255.255");
                    Monitor.this.mAddress.removeAllItems();
                    HashSet<String> set = config.getMulticastAddrs();
                    Iterator<String> i = set.iterator();
                    while (i.hasNext()) {
                        Monitor.this.mAddress.addItem(i.next());
                    }
                    Monitor.this.mcastPort.setValue(config.getMulticastPort());
                    Monitor.this.udpPort.setValue(config.getUdpPort());
                    Monitor.this.ttl.setValue(config.getTTL());
                } else if (method == 2) {
                    Monitor.this.cast.setSelectedItem("direct connection");
                    Monitor.this.tcpPort.setValue(config.getTcpPort());
                }
            }
        });
        return use;
    }

    private void removeConnection(Monitor monitor, MonitorSingleSystem mon, String key, boolean notInIterator) {
        JMenuItem mi;
        int j;
        monitor.tabbedPane.remove(mon.getDisplayPane());
        int count = monitor.disconnectMenu.getItemCount();
        for (j = 0; j < count; ++j) {
            mi = monitor.disconnectMenu.getItem(j);
            if (!mi.getText().equals(key)) continue;
            monitor.disconnectMenu.remove(mi);
            break;
        }
        count = monitor.loadConnectionParametersMenu.getItemCount();
        for (j = 0; j < count; ++j) {
            mi = monitor.loadConnectionParametersMenu.getItem(j);
            if (!mi.getText().equals(key)) continue;
            monitor.loadConnectionParametersMenu.remove(mi);
            break;
        }
        mon.close();
        if (notInIterator) {
            monitor.monitors.remove(key);
            monitor.connections.remove(key);
        }
        int index = monitor.tabbedPane.getSelectedIndex();
        monitor.currentMonitorKey = key = monitor.tabbedPane.getTitleAt(index);
        if (key.equals("Help")) {
            monitor.period.setValue(monitor.defaultPeriod);
        } else {
            mon = monitor.monitors.get(key);
            monitor.period.setValue(mon.getUpdatePeriod());
        }
    }

    public void displayEtSystem(EtSystemOpenConfig config, EtSystem use) {
        this.displayEtSystem(config, use, this.defaultPeriod, this.tabbedPane.getWidth() / 2, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayEtSystem(EtSystemOpenConfig config, EtSystem use, int updatePeriod, int dividerLocation, int orientation, Color[] colors) {
        final MonitorSingleSystem et = new MonitorSingleSystem(use, this.tabbedPane, updatePeriod, dividerLocation, orientation, colors);
        DefaultMutableTreeNode etNode = et.getNode();
        final String key = use.getHost().indexOf(".") < 0 ? new String(config.getEtName() + " (" + use.getHost() + ")") : new String(config.getEtName() + " (" + use.getHost().substring(0, use.getHost().indexOf(".")) + ")");
        Map<String, MonitorSingleSystem> map = this.monitors;
        synchronized (map) {
            this.monitors.put(key, et);
        }
        JMenuItem menuItem = new JMenuItem(key);
        menuItem.setFont(MonitorFonts.buttonTabMenuFont);
        menuItem.setBackground(this.backgroundColor);
        menuItem.setForeground(this.titleColor);
        this.disconnectMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitor.this.removeConnection(Monitor.this, et, key, true);
            }
        });
    }
}

