/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.et.exception.EtException;

public class EtUtils {
    public static void shortToBytes(short data, ByteOrder byteOrder, byte[] dest, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >>> 8);
            dest[off + 1] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >>> 8);
        }
    }

    public static void intToBytes(int data, ByteOrder byteOrder, byte[] dest, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >> 24);
            dest[off + 1] = (byte)(data >> 16);
            dest[off + 2] = (byte)(data >> 8);
            dest[off + 3] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >> 8);
            dest[off + 2] = (byte)(data >> 16);
            dest[off + 3] = (byte)(data >> 24);
        }
    }

    public static void longToBytes(long data, ByteOrder byteOrder, byte[] dest, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >> 56);
            dest[off + 1] = (byte)(data >> 48);
            dest[off + 2] = (byte)(data >> 40);
            dest[off + 3] = (byte)(data >> 32);
            dest[off + 4] = (byte)(data >> 24);
            dest[off + 5] = (byte)(data >> 16);
            dest[off + 6] = (byte)(data >> 8);
            dest[off + 7] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >> 8);
            dest[off + 2] = (byte)(data >> 16);
            dest[off + 3] = (byte)(data >> 24);
            dest[off + 4] = (byte)(data >> 32);
            dest[off + 5] = (byte)(data >> 40);
            dest[off + 6] = (byte)(data >> 48);
            dest[off + 7] = (byte)(data >> 56);
        }
    }

    public static void shortToBytes(short shortVal, byte[] b, int off) {
        EtUtils.shortToBytes(shortVal, null, b, off);
    }

    public static void intToBytes(int intVal, byte[] b, int off) {
        EtUtils.intToBytes(intVal, null, b, off);
    }

    public static void longToBytes(long longVal, byte[] b, int off) {
        EtUtils.longToBytes(longVal, null, b, off);
    }

    public static short bytesToShort(byte[] data, ByteOrder byteOrder, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((0xFF & data[off]) << 8 | 0xFF & data[1 + off]);
        }
        return (short)(0xFF & data[off] | 0xFF & data[1 + off] << 8);
    }

    public static int bytesToInt(byte[] data, ByteOrder byteOrder, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (0xFF & data[off]) << 24 | (0xFF & data[1 + off]) << 16 | (0xFF & data[2 + off]) << 8 | 0xFF & data[3 + off];
        }
        return 0xFF & data[off] | (0xFF & data[1 + off]) << 8 | (0xFF & data[2 + off]) << 16 | (0xFF & data[3 + off]) << 24;
    }

    public static long bytesToLong(byte[] data, ByteOrder byteOrder, int off) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (long)(0xFF & data[off]) << 56 | (long)(0xFF & data[1 + off]) << 48 | (long)(0xFF & data[2 + off]) << 40 | (long)(0xFF & data[3 + off]) << 32 | (long)(0xFF & data[4 + off]) << 24 | (long)(0xFF & data[5 + off]) << 16 | (long)(0xFF & data[6 + off]) << 8 | (long)(0xFF & data[7 + off]);
        }
        return (long)(0xFF & data[off]) | (long)(0xFF & data[1 + off]) << 8 | (long)(0xFF & data[2 + off]) << 16 | (long)(0xFF & data[3 + off]) << 24 | (long)(0xFF & data[4 + off]) << 32 | (long)(0xFF & data[5 + off]) << 40 | (long)(0xFF & data[6 + off]) << 48 | (long)(0xFF & data[7 + off]) << 56;
    }

    public static short bytesToShort(byte[] b, int off) {
        return EtUtils.bytesToShort(b, null, off);
    }

    public static int bytesToInt(byte[] b, int off) {
        return EtUtils.bytesToInt(b, null, off);
    }

    public static long bytesToLong(byte[] b, int off) {
        return EtUtils.bytesToLong(b, null, off);
    }

    public static void swapArrayInt(byte[] b, int off) {
        byte b1 = b[off];
        byte b2 = b[off + 1];
        byte b3 = b[off + 2];
        byte b4 = b[off + 3];
        b[off + 3] = b1;
        b[off + 2] = b2;
        b[off + 1] = b3;
        b[off] = b4;
    }

    public static void swapArrayShort(byte[] b, int off) {
        byte b1 = b[off];
        byte b2 = b[off + 1];
        b[off + 1] = b1;
        b[off] = b2;
    }

    public static List<String> getAllBroadcastAddresses() {
        LinkedList<String> ipList = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : inAddrs) {
                    Inet4Address bAddr;
                    try {
                        bAddr = (Inet4Address)ifAddr.getBroadcast();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    String broadcastIP = bAddr.getHostAddress();
                    ipList.add(broadcastIP);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (ipList.size() < 1) {
            ipList.add("255.255.255.255");
        }
        return ipList;
    }

    public static List<String> orderIPAddresses(List<String> ipAddresses) {
        HashSet<String> ipSet = new HashSet<String>(ipAddresses);
        LinkedList<String> ipList = new LinkedList<String>();
        block6: for (String ip : ipSet) {
            boolean ipAddressAdded = false;
            try {
                Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                while (enumer.hasMoreElements()) {
                    NetworkInterface ni = enumer.nextElement();
                    if (!ni.isUp() || ni.isLoopback()) continue;
                    List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                    for (InterfaceAddress ifAddr : inAddrs) {
                        Inet4Address addrv4;
                        try {
                            addrv4 = (Inet4Address)ifAddr.getAddress();
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        int prefixLength = ifAddr.getNetworkPrefixLength();
                        int subnetMask = 0;
                        for (int j = 0; j < prefixLength; ++j) {
                            subnetMask |= 1 << 31 - j;
                        }
                        String localIP = addrv4.getHostAddress();
                        try {
                            if (!EtUtils.onSameSubnet2(ip, localIP, subnetMask)) continue;
                            ipList.addFirst(ip);
                            ipAddressAdded = true;
                            continue block6;
                        }
                        catch (EtException e) {
                        }
                    }
                }
            }
            catch (SocketException e) {
                continue;
            }
            if (ipAddressAdded) continue;
            ipList.addLast(ip);
        }
        return ipList;
    }

    static boolean onSameSubnet2(String ipAddress1, String ipAddress2, int subnetMask) throws EtException {
        if (ipAddress1 == null || ipAddress2 == null) {
            throw new EtException("null arg(s)");
        }
        byte[] ipBytes1 = EtUtils.isDottedDecimal(ipAddress1);
        byte[] ipBytes2 = EtUtils.isDottedDecimal(ipAddress2);
        if (ipBytes1 == null || ipBytes2 == null) {
            throw new EtException("one or both IP address args are not dot-decimal format");
        }
        int addr1 = ipBytes1[0] << 24 | ipBytes1[1] << 16 | ipBytes1[2] << 8 | ipBytes1[3];
        int addr2 = ipBytes2[0] << 24 | ipBytes2[1] << 16 | ipBytes2[2] << 8 | ipBytes2[3];
        return (addr1 & subnetMask) == (addr2 & subnetMask);
    }

    static byte[] isDottedDecimal(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        Pattern pattern = Pattern.compile(IP_ADDRESS);
        Matcher matcher = pattern.matcher(ipAddress);
        if (!matcher.matches()) {
            return null;
        }
        int[] hostInts = new int[4];
        for (int i = 1; i <= 4; ++i) {
            hostInts[i - 1] = Integer.parseInt(matcher.group(i));
            if (hostInts[i - 1] <= 255 && hostInts[i - 1] >= 0) continue;
            return null;
        }
        byte[] hostBytes = new byte[]{(byte)hostInts[0], (byte)hostInts[1], (byte)hostInts[2], (byte)hostInts[3]};
        return hostBytes;
    }
}

