/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jlab.coda.et.DatagramReceive;
import org.jlab.coda.et.EtConstants;
import org.jlab.coda.et.EtJniAccess;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.EtUtils;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;

public class EtSystemOpen {
    private EtSystemOpenConfig config;
    private Socket sock;
    private String hostAddress;
    private ArrayList<String> hostAddresses;
    private int tcpPort;
    private LinkedHashMap<ArrayList<String>, Integer> responders;
    private boolean connected;
    private boolean etOnLocalHost;
    private int debug;
    private boolean useJniLibrary;
    private EtJniAccess jni;
    private int endian;
    private int numEvents;
    private long eventSize;
    private int version;
    private int stationSelectInts;
    private int language;
    private boolean bit64;
    private ArrayList<String> localHostIpAddrs;
    private final boolean foundServer = true;
    private final boolean cannotFindServer = false;
    private final boolean gotMatch = true;
    private final boolean noMatch = false;

    public EtSystemOpen(EtSystemOpenConfig config) {
        block3: {
            this.foundServer = true;
            this.cannotFindServer = false;
            this.gotMatch = true;
            this.noMatch = false;
            this.config = new EtSystemOpenConfig(config);
            this.debug = 2;
            this.responders = new LinkedHashMap(20);
            this.hostAddresses = new ArrayList();
            this.localHostIpAddrs = new ArrayList();
            try {
                InetAddress[] haddrs;
                for (InetAddress ia : haddrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
                    this.localHostIpAddrs.add(ia.getHostAddress());
                }
            }
            catch (UnknownHostException e) {
                if (this.debug < 3) break block3;
                System.out.println("EtSystemOpen constructor: cannot find local IP addresses");
            }
        }
    }

    public void setDebug(int debug) throws EtException {
        if (debug != 0 && debug != 1 && debug != 2 && debug != 3 && debug != 4) {
            throw new EtException("bad debug argument");
        }
        this.debug = debug;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public long getEventSize() {
        return this.eventSize;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public ArrayList<String> getHostAddresses() {
        return this.hostAddresses;
    }

    public String getName() {
        return this.config.getEtName();
    }

    public int getEndian() {
        return this.endian;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLanguage() {
        return this.language;
    }

    public int getSelectInts() {
        return this.stationSelectInts;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public int getDebug() {
        return this.debug;
    }

    public EtSystemOpenConfig getConfig() {
        return new EtSystemOpenConfig(this.config);
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public boolean isBit64() {
        return this.bit64;
    }

    public LinkedHashMap<ArrayList<String>, Integer> getResponders() {
        return this.responders;
    }

    public boolean usingJniLibrary() {
        return this.useJniLibrary;
    }

    public EtJniAccess getJni() {
        return this.jni;
    }

    public String[] getAllHosts() {
        if (this.responders.size() == 0) {
            if (this.hostAddress == null) {
                return null;
            }
            return new String[]{this.hostAddress};
        }
        return (String[])this.responders.keySet().toArray();
    }

    public int[] getAllPorts() {
        if (this.responders.size() == 0) {
            if (this.tcpPort == 0) {
                return null;
            }
            return new int[]{this.tcpPort};
        }
        Integer[] p = (Integer[])this.responders.values().toArray();
        int[] ports = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            ports[i] = p[i];
        }
        return ports;
    }

    private boolean findServerPort(int totalWait) throws IOException, UnknownHostException, EtTooManyException {
        MulticastSocket socket;
        MulticastSocket socket2;
        int waitTime;
        boolean match = false;
        int totalPacketsSent = 0;
        int sendPacketLimit = 4;
        int[] timeOuts = new int[]{100, 1000, 2000, 4000};
        int socketTimeOut = 8000;
        String specifiedHost = null;
        HashSet<String> knownHostIpAddrs = new HashSet<String>();
        if (totalWait >= 80) {
            waitTime = (totalWait - 10) / 7;
            timeOuts[0] = 10;
            timeOuts[1] = waitTime;
            timeOuts[2] = 2 * waitTime;
            timeOuts[3] = 4 * waitTime;
            socketTimeOut = totalWait + 1000;
        }
        this.responders.clear();
        this.hostAddresses.clear();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(122);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(EtConstants.magicNumbers[0]);
        dos.writeInt(EtConstants.magicNumbers[1]);
        dos.writeInt(EtConstants.magicNumbers[2]);
        dos.writeInt(14);
        dos.writeInt(this.config.getEtName().length() + 1);
        try {
            dos.write(this.config.getEtName().getBytes("ASCII"));
            dos.writeByte(0);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        dos.flush();
        final byte[] sbuffer = baos.toByteArray();
        dos.close();
        baos.close();
        class Send {
            int port;
            String address;
            InetAddress addr;
            MulticastSocket socket;
            DatagramPacket packet;

            Send(String address, MulticastSocket socket, int port) throws UnknownHostException {
                this.port = port;
                this.address = address;
                this.socket = socket;
                this.addr = InetAddress.getByName(address);
                this.packet = new DatagramPacket(sbuffer, sbuffer.length, this.addr, port);
            }
        }
        LinkedList<Send> sendList = new LinkedList<Send>();
        String localHost = null;
        InetAddress localAddr = null;
        try {
            localAddr = InetAddress.getLocalHost();
            localHost = localAddr.getHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        if (!this.config.getHost().equals(".remote") && !this.config.getHost().equals(".anywhere")) {
            InetAddress[] haddrs;
            socket2 = new MulticastSocket();
            try {
                socket2.setSoTimeout(socketTimeOut);
            }
            catch (SocketException ex) {
                // empty catch block
            }
            specifiedHost = this.config.getHost().equals(".local") || this.config.getHost().equals("localhost") ? localHost : this.config.getHost();
            for (InetAddress ia : haddrs = InetAddress.getAllByName(specifiedHost)) {
                knownHostIpAddrs.add(ia.getHostAddress());
            }
            sendList.add(new Send(specifiedHost, socket2, this.config.getUdpPort()));
            if (this.debug >= 4) {
                System.out.println("findServerPort: send to local or specified host " + specifiedHost + " on port " + this.config.getUdpPort());
            }
        }
        if (this.config.getNetworkContactMethod() == 1 || this.config.getNetworkContactMethod() == 3) {
            if (this.config.getBroadcastAddrs().size() < 1) {
                socket2 = new MulticastSocket();
                try {
                    socket2.setSoTimeout(socketTimeOut);
                    socket2.setBroadcast(true);
                }
                catch (SocketException ex) {
                    // empty catch block
                }
                sendList.add(new Send("255.255.255.255", socket2, this.config.getUdpPort()));
                if (this.debug >= 4) {
                    System.out.println("findServerPort: broadcasting to " + "255.255.255.255" + " on port " + this.config.getUdpPort());
                }
            } else {
                for (String addr : this.config.getBroadcastAddrs()) {
                    socket = new MulticastSocket();
                    try {
                        socket.setSoTimeout(socketTimeOut);
                        socket.setBroadcast(true);
                    }
                    catch (SocketException ex) {
                        // empty catch block
                    }
                    sendList.add(new Send(addr, socket, this.config.getUdpPort()));
                    if (this.debug < 4) continue;
                    System.out.println("findServerPort: broadcasting to " + addr + " on port " + this.config.getUdpPort());
                }
            }
        }
        if (this.config.getNetworkContactMethod() == 0 || this.config.getNetworkContactMethod() == 3) {
            for (String addr : this.config.getMulticastAddrs()) {
                socket = new MulticastSocket();
                try {
                    socket.setSoTimeout(socketTimeOut);
                }
                catch (SocketException ex) {
                    // empty catch block
                }
                if (this.config.getTTL() != 1) {
                    socket.setTimeToLive(this.config.getTTL());
                }
                sendList.add(new Send(addr, socket, this.config.getMulticastPort()));
                if (this.debug < 4) continue;
                System.out.println("findServerPort: multicasting to " + addr + " on port " + this.config.getMulticastPort());
            }
        }
        class Get {
            byte[] buffer = new byte[4096];
            DatagramReceive thread;
            DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
            MulticastSocket socket;

            Get(MulticastSocket sock) {
                this.socket = sock;
            }

            void start() {
                this.thread = new DatagramReceive(this.packet, this.socket);
                this.thread.start();
            }
        }
        LinkedList<Get> receiveList = new LinkedList<Get>();
        for (Send sender : sendList) {
            Get receiver = new Get(sender.socket);
            receiveList.add(receiver);
            if (this.debug >= 4) {
                System.out.println("findServerPort: starting thread to socket " + sender.socket);
            }
            receiver.start();
        }
        Thread.yield();
        while (totalPacketsSent < sendPacketLimit) {
            for (Send sender : sendList) {
                sender.socket.send(sender.packet);
            }
            waitTime = timeOuts[totalPacketsSent++];
            block20: while (true) {
                if (this.debug >= 4) {
                    System.out.println("findServerPort: wait for " + waitTime + " milliseconds");
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
                for (Get receiver : receiveList) {
                    int status = receiver.thread.waitForReply(10);
                    if (this.debug >= 4) {
                        System.out.println("findServerPort: receive on socket " + receiver.socket + ", status = " + status);
                    }
                    if (status == -1 || status == 0 || status != 1) continue;
                    if (this.replyMatch(receiver.packet, knownHostIpAddrs)) {
                        if (this.debug >= 4) {
                            System.out.println("findServerPort: found match");
                        }
                        match = true;
                    } else if (this.debug >= 4) {
                        System.out.println("findServerPort: no match");
                    }
                    waitTime = 50;
                    receiver.start();
                    Thread.yield();
                    continue block20;
                }
                break;
            }
            if (match || totalPacketsSent >= sendPacketLimit) break;
            if (this.debug < 4) continue;
            System.out.println("findServerPort: timedout, try again with longer wait");
        }
        if (match) {
            if ((this.config.getHost().equals(".remote") || this.config.getHost().equals(".anywhere")) && this.responders.size() > 1) {
                Map.Entry<ArrayList<String>, Integer> entry2;
                Iterator<Map.Entry<ArrayList<String>, Integer>> i;
                if (this.config.getResponsePolicy() == 0) {
                    i = this.responders.entrySet().iterator();
                    entry2 = i.next();
                    this.hostAddresses = entry2.getKey();
                    this.hostAddress = this.hostAddresses.get(0);
                    this.tcpPort = (Integer)entry2.getValue();
                    this.etOnLocalHost = this.isHostLocal(this.hostAddresses);
                } else if (this.config.getResponsePolicy() == 1) {
                    this.etOnLocalHost = false;
                    for (Map.Entry<ArrayList<String>, Integer> entry2 : this.responders.entrySet()) {
                        ArrayList addrList = (ArrayList)entry2.getKey();
                        if (!this.isHostLocal(addrList)) continue;
                        this.hostAddresses = entry2.getKey();
                        this.hostAddress = this.hostAddresses.get(0);
                        this.tcpPort = entry2.getValue();
                        this.etOnLocalHost = true;
                        break;
                    }
                    if (!this.etOnLocalHost) {
                        i = this.responders.entrySet().iterator();
                        entry2 = i.next();
                        this.hostAddresses = entry2.getKey();
                        this.hostAddress = this.hostAddresses.get(0);
                        this.tcpPort = entry2.getValue();
                    }
                } else {
                    throw new EtTooManyException("too many responding ET systems");
                }
            }
            return true;
        }
        if (this.debug >= 4) {
            System.out.println("findServerPort: cannot find server, quitting");
        }
        this.hostAddresses.clear();
        this.hostAddress = null;
        this.tcpPort = 0;
        return false;
    }

    private boolean replyMatch(DatagramPacket packet, HashSet<String> knownHostIpAddrs) throws IOException, UnknownHostException {
        int i;
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.getData());
        DataInputStream dis = new DataInputStream(bais);
        ArrayList<String> addresses = new ArrayList<String>(20);
        int magic1 = dis.readInt();
        int magic2 = dis.readInt();
        int magic3 = dis.readInt();
        if (magic1 != EtConstants.magicNumbers[0] || magic2 != EtConstants.magicNumbers[1] || magic3 != EtConstants.magicNumbers[2]) {
            return false;
        }
        int version = dis.readInt();
        if (version != 14) {
            return false;
        }
        int port = dis.readInt();
        if (port < 1 || port > 65536) {
            return false;
        }
        int cast = dis.readInt();
        if (cast != 1 && cast != 0 && cast != 3) {
            return false;
        }
        int length = dis.readInt();
        if (length < 1 || length > 16) {
            return false;
        }
        byte[] buf = new byte[length];
        dis.readFully(buf, 0, length);
        String repliedIpAddress = null;
        try {
            repliedIpAddress = new String(buf, 0, length - 1, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        length = dis.readInt();
        if (length < 1 || length > 256) {
            return false;
        }
        buf = new byte[length];
        dis.readFully(buf, 0, length);
        String repliedUname = null;
        try {
            repliedUname = new String(buf, 0, length - 1, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        length = dis.readInt();
        if (length < 1 || length > 256) {
            return false;
        }
        buf = new byte[length];
        dis.readFully(buf, 0, length);
        String canonicalName = null;
        try {
            canonicalName = new String(buf, 0, length - 1, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int numAddrs = dis.readInt();
        if (numAddrs < 0) {
            return false;
        }
        String repliedHostAddress = null;
        for (i = 0; i < numAddrs; ++i) {
            int addr = dis.readInt();
            length = dis.readInt();
            buf = new byte[length];
            dis.readFully(buf, 0, length);
            try {
                repliedHostAddress = new String(buf, 0, length - 1, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            addresses.add(repliedHostAddress);
        }
        if (this.debug >= 4) {
            System.out.println("replyMatch: port = " + port + ", replied IP addr = " + repliedIpAddress + ", uname = " + repliedUname);
            for (i = 0; i < numAddrs; ++i) {
                System.out.println("          : addr " + (i + 1) + " = " + (String)addresses.get(i));
            }
            System.out.println();
        }
        dis.close();
        bais.close();
        if (this.config.getHost().equals(".anywhere")) {
            if (this.debug >= 4) {
                System.out.println("replyMatch: ET is anywhere, addresses = ");
                for (String address : addresses) {
                    System.out.println("            " + address);
                }
            }
            this.responders.put(addresses, port);
            this.hostAddresses = addresses;
            this.hostAddress = (String)addresses.get(0);
            this.tcpPort = port;
            return true;
        }
        if (this.config.getHost().equals(".remote")) {
            for (String address : addresses) {
                for (String localIP : this.localHostIpAddrs) {
                    if (!localIP.equals(address)) continue;
                    if (this.debug >= 4) {
                        System.out.println("replyMatch: ET is local but looking for remote, " + address);
                    }
                    return false;
                }
            }
            if (this.debug >= 4) {
                System.out.println("replyMatch: ET is remote, addresses = ");
                for (String address : addresses) {
                    System.out.println("            " + address);
                }
            }
            this.responders.put(addresses, port);
            this.etOnLocalHost = false;
            this.hostAddresses = addresses;
            this.hostAddress = (String)addresses.get(0);
            this.tcpPort = port;
            return true;
        }
        if (this.config.getHost().equals(".local") || this.config.getHost().equals("localhost")) {
            for (String address : addresses) {
                for (String localIP : this.localHostIpAddrs) {
                    if (!localIP.equals(address)) continue;
                    if (this.debug >= 4) {
                        System.out.println("replyMatch: ET is local, " + address);
                    }
                    this.etOnLocalHost = true;
                    this.hostAddresses = addresses;
                    this.hostAddress = address;
                    this.tcpPort = port;
                    return true;
                }
            }
            if (this.debug >= 4) {
                System.out.println("replyMatch: no local match");
            }
        } else {
            if (this.debug >= 4) {
                System.out.println("replyMatch: <name>, addresses = ");
                for (String address : addresses) {
                    System.out.println("            " + address);
                }
            }
            for (String address : addresses) {
                for (String hostIP : knownHostIpAddrs) {
                    if (!hostIP.equals(address)) continue;
                    if (this.debug >= 4) {
                        System.out.println("replyMatch: <name> matched, " + address);
                    }
                    this.etOnLocalHost = this.isHostLocal(addresses);
                    this.hostAddresses = addresses;
                    this.hostAddress = address;
                    this.tcpPort = port;
                    return true;
                }
            }
        }
        return false;
    }

    private void connectToEtServer() throws IOException, EtException {
        DataInputStream dis = new DataInputStream(this.sock.getInputStream());
        DataOutputStream dos = new DataOutputStream(this.sock.getOutputStream());
        dos.writeInt(EtConstants.magicNumbers[0]);
        dos.writeInt(EtConstants.magicNumbers[1]);
        dos.writeInt(EtConstants.magicNumbers[2]);
        dos.writeInt(0);
        dos.writeInt(this.config.getEtName().length() + 1);
        dos.writeInt(0);
        dos.writeLong(0L);
        try {
            dos.write(this.config.getEtName().getBytes("ASCII"));
            dos.writeByte(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        dos.flush();
        if (dis.readInt() != 0) {
            throw new EtException("found the wrong ET system");
        }
        this.endian = dis.readInt();
        this.numEvents = dis.readInt();
        this.eventSize = dis.readLong();
        this.version = dis.readInt();
        this.stationSelectInts = dis.readInt();
        this.language = dis.readInt();
        this.bit64 = dis.readInt() > 0;
        dis.skipBytes(4);
        if (this.version != 14) {
            this.disconnect();
            throw new EtException("may not open wrong version ET system");
        }
        if (this.stationSelectInts != 6) {
            this.disconnect();
            throw new EtException("may not open ET system with different # of select integers");
        }
        this.connected = true;
        if (this.debug >= 4) {
            System.out.println("open: endian = " + (this.endian == 0 ? "big" : "little") + ", nevents = " + this.numEvents + ", event size = " + this.eventSize + ", version = " + this.version + ",\n      selectInts = " + this.stationSelectInts + ", language = " + (this.language == 1 ? "C" : "java"));
        }
    }

    private boolean isHostLocal(String host) throws UnknownHostException {
        InetAddress[] allHostAddresses = InetAddress.getAllByName(host);
        for (String localIP : this.localHostIpAddrs) {
            boolean match = false;
            for (InetAddress ip : allHostAddresses) {
                if (!localIP.equals(ip.getHostAddress())) continue;
                match = true;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private boolean isHostLocal(ArrayList<String> addrs) throws UnknownHostException {
        for (String localIP : this.localHostIpAddrs) {
            boolean match = false;
            for (String ip : addrs) {
                if (!localIP.equals(ip)) continue;
                match = true;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public synchronized void connect() throws IOException, EtException, EtTooManyException {
        long t2;
        this.useJniLibrary = false;
        Exception excep = null;
        boolean gotConnection = false;
        long t1 = t2 = System.currentTimeMillis();
        while (t2 <= t1 + this.config.getWaitTime()) {
            List<Object> addrList;
            this.sock = null;
            if (this.config.getNetworkContactMethod() == 2) {
                if (this.debug >= 4) {
                    System.out.println("connect: make a direct connection");
                }
                this.tcpPort = this.config.getTcpPort();
                this.etOnLocalHost = this.config.getHost().equals(".local") || this.config.getHost().equals("localhost") ? true : this.isHostLocal(this.config.getHost());
                if (this.etOnLocalHost) {
                    this.useJniLibrary = true;
                    this.hostAddresses = (ArrayList)this.localHostIpAddrs.clone();
                    this.hostAddress = this.hostAddresses.get(0);
                } else {
                    this.hostAddress = InetAddress.getByName(this.config.getHost()).getHostAddress();
                }
            } else {
                if (this.debug >= 4) {
                    System.out.println("connect: try to find server port");
                }
                if (!this.findServerPort((int)this.config.getWaitTime())) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    t2 = System.currentTimeMillis();
                    continue;
                }
                if (this.etOnLocalHost) {
                    this.useJniLibrary = true;
                }
            }
            if (this.debug >= 4) {
                System.out.println("connect(): try to connect to ET system " + (this.useJniLibrary ? "locally" : "remotely"));
            }
            if (this.config.isConnectRemotely()) {
                this.useJniLibrary = false;
            }
            if (this.hostAddresses == null || this.hostAddresses.size() < 1) {
                addrList = new LinkedList<String>();
                addrList.add(this.hostAddress);
            } else {
                addrList = EtUtils.orderIPAddresses(this.hostAddresses);
            }
            for (String string : addrList) {
                excep = null;
                try {
                    this.sock = new Socket();
                    if (this.config.isNoDelay()) {
                        this.sock.setTcpNoDelay(true);
                    }
                    this.sock.setSoTimeout(2000);
                    this.sock.setKeepAlive(true);
                    if (this.config.getTcpRecvBufSize() > 0) {
                        this.sock.setReceiveBufferSize(this.config.getTcpRecvBufSize());
                    }
                    if (this.config.getTcpSendBufSize() > 0) {
                        this.sock.setSendBufferSize(this.config.getTcpSendBufSize());
                    }
                    if (this.config.getNetworkInterface() != null) {
                        this.sock.bind(new InetSocketAddress(this.config.getNetworkInterface(), 0));
                    }
                    System.out.println("connect(): try connect to host " + string + " on port " + this.tcpPort);
                    try {
                        this.sock.connect(new InetSocketAddress(string, this.tcpPort), 3000);
                    }
                    catch (SocketTimeoutException e) {
                        System.out.println("connect(): timed out, try again");
                        continue;
                    }
                    System.out.println("connect(): SUCCESS creating socket");
                    break;
                }
                catch (SocketException ex) {
                    System.out.println("connect(): FAILED setting socket options");
                    excep = ex;
                }
                catch (IOException ex) {
                    System.out.println("connect(): FAILED creating connection to " + string);
                    excep = ex;
                }
                catch (Exception ex) {
                    System.out.println("connect(): FAILED creating connection to " + string);
                    excep = ex;
                }
            }
            if (this.sock == null || !this.sock.isConnected()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                t2 = System.currentTimeMillis();
                continue;
            }
            try {
                this.connectToEtServer();
                gotConnection = true;
                break;
            }
            catch (IOException ex) {
                excep = ex;
            }
            catch (EtException ex) {
                excep = ex;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            t2 = System.currentTimeMillis();
        }
        if (!gotConnection) {
            throw new IOException("Cannot create network connection to ET system", excep);
        }
        if (this.useJniLibrary) {
            try {
                RandomAccessFile file = new RandomAccessFile(this.config.getEtName(), "rw");
                FileChannel fileChannel = file.getChannel();
                MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 64L);
                int byteOrder = buffer.getInt();
                if (byteOrder != 67305985) {
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.debug >= 4) {
                    System.out.println("byteOrder = " + Integer.toHexString(byteOrder));
                }
                int next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("systemType = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("major version = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("minor version = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("num select ints = " + next);
                }
                next = buffer.getInt();
                if (this.debug >= 4) {
                    System.out.println("head byte size = " + next);
                }
                long nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("event byte size = " + nextLong);
                }
                nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("header position = " + nextLong);
                }
                long dataPosition = nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("data position = " + nextLong);
                }
                long totalFileSize = nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("total file size = " + nextLong + ", but is really " + fileChannel.size());
                }
                long usedFileSize = nextLong = buffer.getLong();
                if (this.debug >= 4) {
                    System.out.println("used file size = " + nextLong);
                }
                fileChannel.close();
                this.jni = EtJniAccess.getInstance(this.config.getEtName());
            }
            catch (EtTimeoutException e) {
                this.useJniLibrary = false;
            }
            catch (EtException e) {
                this.useJniLibrary = false;
                System.out.println("Error in opening ET with jni, Et exception, use sockets only to talk to ET system");
            }
            catch (IOException e) {
                this.useJniLibrary = false;
                System.out.println("Error in opening ET with jni, IO exception, use sockets only to talk to ET system");
            }
        }
    }

    public synchronized void disconnect() {
        this.connected = false;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

