/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.et;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.enums.Age;
import org.jlab.coda.et.enums.DataStatus;
import org.jlab.coda.et.enums.Modify;
import org.jlab.coda.et.enums.Priority;
import org.jlab.coda.et.exception.EtException;

public class EtEventImpl
implements EtEvent {
    private static final int numSelectInts = 6;
    private static final int[] controlInitValues = new int[6];
    private int id;
    private Age age;
    private int group;
    private Priority priority;
    private int owner;
    private int length;
    private int memSize;
    private int sizeLimit;
    private DataStatus dataStatus;
    private Modify modify;
    private int byteOrder;
    private int[] control;
    private byte[] data;
    private ByteBuffer dataBuffer;
    private boolean isJava;

    public EtEventImpl(int size) {
        this.memSize = size;
        this.isJava = true;
        this.data = new byte[size];
        this.control = new int[6];
        this.dataBuffer = ByteBuffer.wrap(this.data);
        this.init();
    }

    EtEventImpl(int size, int limit, boolean isJava, boolean noBuffer) {
        this.memSize = size;
        this.sizeLimit = limit;
        this.isJava = isJava;
        this.control = new int[6];
        if (!noBuffer) {
            this.data = new byte[size];
            this.dataBuffer = ByteBuffer.wrap(this.data);
        }
        this.init();
    }

    EtEventImpl(int size, int limit, int status, int id, int age, int owner, int modify, int length, int priority, int byteOrder, int[] control) {
        this.isJava = false;
        this.memSize = size;
        this.sizeLimit = limit;
        this.dataStatus = DataStatus.getStatus(status);
        this.id = id;
        this.age = Age.getAge(age);
        this.owner = owner;
        this.modify = Modify.getModify(modify);
        this.length = length;
        this.priority = Priority.getPriority(priority);
        this.byteOrder = byteOrder;
        this.control = control != null ? (int[])control.clone() : new int[6];
    }

    EtEventImpl(int size, int limit, int id, int owner, int modify, int length, int priority, int byteOrder, ByteBuffer buffer) {
        this.isJava = false;
        this.memSize = size;
        this.sizeLimit = limit;
        this.dataStatus = DataStatus.OK;
        this.age = Age.NEW;
        this.control = new int[6];
        this.id = id;
        this.owner = owner;
        this.modify = Modify.getModify(modify);
        this.length = length;
        this.priority = Priority.getPriority(priority);
        this.byteOrder = byteOrder;
        this.dataBuffer = buffer;
        if (byteOrder == 16909060) {
            this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else if (byteOrder == 67305985) {
            this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    EtEventImpl(int size, int limit, int status, int id, int age, int owner, int modify, int length, int priority, int byteOrder, int[] control, ByteBuffer buffer) {
        this.isJava = false;
        this.memSize = size;
        this.sizeLimit = limit;
        this.dataStatus = DataStatus.getStatus(status);
        this.id = id;
        this.age = Age.getAge(age);
        this.owner = owner;
        this.modify = Modify.getModify(modify);
        this.length = length;
        this.priority = Priority.getPriority(priority);
        this.control = control != null ? control : new int[6];
        this.byteOrder = byteOrder;
        this.dataBuffer = buffer;
        if (byteOrder == 16909060) {
            this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else if (byteOrder == 67305985) {
            this.dataBuffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    public EtEventImpl(EtEventImpl ev) {
        this.isJava = ev.isJava;
        this.memSize = ev.memSize;
        this.sizeLimit = ev.sizeLimit;
        this.dataStatus = ev.dataStatus;
        this.id = ev.id;
        this.age = ev.age;
        this.owner = ev.owner;
        this.group = ev.group;
        this.modify = ev.modify;
        this.length = ev.length;
        this.priority = ev.priority;
        this.byteOrder = ev.byteOrder;
        this.control = (int[])ev.control.clone();
        this.data = (byte[])ev.data.clone();
        this.dataBuffer = ByteBuffer.wrap(this.data);
        this.dataBuffer.limit(ev.dataBuffer.limit());
        this.dataBuffer.position(ev.dataBuffer.position());
    }

    @Override
    public void init() {
        this.age = Age.NEW;
        this.priority = Priority.LOW;
        this.owner = -1;
        this.length = 0;
        this.modify = Modify.NOTHING;
        this.byteOrder = 67305985;
        this.dataStatus = DataStatus.OK;
        System.arraycopy(controlInitValues, 0, this.control, 0, 6);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Age getAge() {
        return this.age;
    }

    @Override
    public int getGroup() {
        return this.group;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    public int getPriorityValue() {
        return this.priority.getValue();
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public int getMemSize() {
        return this.memSize;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public DataStatus getDataStatus() {
        return this.dataStatus;
    }

    public int getDataStatusValue() {
        return this.dataStatus.getValue();
    }

    @Override
    public Modify getModify() {
        return this.modify;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder == 67305985 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public int getRawByteOrder() {
        return this.byteOrder;
    }

    @Override
    public int[] getControl() {
        return (int[])this.control.clone();
    }

    @Override
    public byte[] getData() throws UnsupportedOperationException {
        return this.dataBuffer.array();
    }

    @Override
    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setAge(Age age) {
        this.age = age;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    @Override
    public void setPriority(Priority pri) {
        this.priority = pri;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    @Override
    public void setLength(int len) throws EtException {
        if (len < 0 || len > this.sizeLimit) {
            throw new EtException("bad value for event data length");
        }
        this.length = len;
    }

    public void setLengthFromServer(int len) throws EtException {
        if (len < 0) {
            throw new EtException("bad value for event data length");
        }
        this.length = len;
    }

    public void setMemSize(int memSize) {
        this.memSize = memSize;
    }

    public void setDataStatus(DataStatus status) {
        this.dataStatus = status;
    }

    public void setModify(Modify modify) {
        this.modify = modify;
    }

    @Override
    public void setByteOrder(int endian) throws EtException {
        if (endian == 0) {
            this.byteOrder = 67305985;
        } else if (endian == 1) {
            this.byteOrder = 16909060;
        } else if (endian == 2) {
            this.byteOrder = 67305985;
        } else if (endian == 3) {
            this.byteOrder = 16909060;
        } else if (endian == 4) {
            this.byteOrder = Integer.reverseBytes(this.byteOrder);
        } else {
            throw new EtException("bad value for byte order");
        }
    }

    @Override
    public void setByteOrder(ByteOrder order) {
        if (order == null) {
            return;
        }
        this.byteOrder = order == ByteOrder.BIG_ENDIAN ? 67305985 : 16909060;
    }

    @Override
    public void setRawByteOrder(int byteOrder) throws EtException {
        if (byteOrder != 67305985 && byteOrder != 16909060) {
            throw new EtException("invalid value for byteOrder arg");
        }
        this.byteOrder = byteOrder;
    }

    @Override
    public void setControl(int[] con) throws EtException {
        if (con == null) {
            return;
        }
        if (con.length != 6) {
            throw new EtException("wrong number of elements in control array");
        }
        System.arraycopy(con, 0, this.control, 0, 6);
    }

    public void setData(byte[] data) {
        if (data == null) {
            return;
        }
        this.data = data;
        this.length = data.length;
        this.memSize = data.length;
    }

    public void setDataBuffer(ByteBuffer dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    @Override
    public boolean needToSwap() {
        return this.byteOrder != 67305985;
    }
}

