/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;

public final class SegmentHeader
extends BaseStructureHeader {
    public SegmentHeader() {
    }

    public SegmentHeader(int n, DataType dataType) {
        super(n, dataType);
    }

    public SegmentHeader(int n, int n2) {
        super(n, n2);
    }

    @Override
    public int getHeaderLength() {
        return 1;
    }

    @Override
    protected void toArray(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[n] = this.byteValue(this.tag);
            byArray[n + 1] = this.byteValue(this.dataType);
            ByteDataTransformer.shortToBytes(this.shortValue(this.length), byArray, n + 2);
        } else {
            ByteDataTransformer.shortToBytes(Short.reverseBytes(this.shortValue(this.length)), byArray, n);
            byArray[n + 2] = this.byteValue(this.dataType);
            byArray[n + 3] = this.byteValue(this.tag);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(String.format("segment length: %d\n", this.length));
        stringBuffer.append(String.format("number:         %d\n", this.number));
        stringBuffer.append(String.format("data type:      %s\n", this.getDataTypeName()));
        stringBuffer.append(String.format("tag:            %d\n", this.tag));
        return stringBuffer.toString();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.put(this.byteValue(this.tag));
            byteBuffer.put(this.byteValue(this.dataType));
            byteBuffer.putShort(this.shortValue(this.length));
        } else {
            byteBuffer.putShort(this.shortValue(this.length));
            byteBuffer.put(this.byteValue(this.dataType));
            byteBuffer.put(this.byteValue(this.tag));
        }
        return 4;
    }
}

