/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.SegmentHeader;
import org.jlab.coda.jevio.StructureType;

public class EvioSegment
extends BaseStructure {
    public static final String ELEMENT_NAME = "segment";

    public EvioSegment() {
        this(new SegmentHeader());
    }

    public EvioSegment(SegmentHeader segmentHeader) {
        super(segmentHeader);
    }

    public EvioSegment(int n, DataType dataType) {
        this(new SegmentHeader(n, dataType));
    }

    public EvioSegment(int n, int n2) {
        this(new SegmentHeader(n, n2));
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.SEGMENT;
    }

    @Override
    public void toXML(XMLStreamWriter xMLStreamWriter) {
        try {
            this.commonXMLStart(xMLStreamWriter);
            if (DataType.getDataType(this.header.dataType).isStructure()) {
                xMLStreamWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xMLStreamWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType));
            xMLStreamWriter.writeAttribute("tag", "" + this.header.tag);
            xMLStreamWriter.writeAttribute("length", "" + this.header.length);
            xMLStreamWriter.writeAttribute("ndata", "" + this.getNumberDataItems());
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xMLStreamWriter);
            this.decreaseXmlIndent();
            this.commonXMLClose(xMLStreamWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }
}

