/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.BlockHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.ByteParser;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioProgressListener;
import org.jlab.coda.jevio.IEvioStructure;

public class EvioFile {
    private static final int MAGIC_OFFSET = 28;
    private MappedByteBuffer mappedByteBuffer;
    private ByteOrder byteOrder;
    private BlockHeader blockHeader = new BlockHeader();
    private static final String ROOT_ELEMENT = "evio-data";
    private int eventNumber = 0;
    private int eventCount = -1;
    private String path;

    public EvioFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.path = new String(file.getAbsolutePath());
        FileChannel fileChannel = fileInputStream.getChannel();
        this.mapFile(fileChannel);
        fileChannel.close();
        this.mappedByteBuffer.position(0);
    }

    public EvioFile(String string) throws IOException {
        this(new File(string));
    }

    public String getPath() {
        return this.path;
    }

    public int getNumEventsRemaining() throws EvioException {
        return this.getEventCount() - this.eventNumber;
    }

    private synchronized void mapFile(FileChannel fileChannel) throws IOException {
        long l = fileChannel.size();
        this.mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
    }

    public int fileSize() {
        return this.mappedByteBuffer.capacity();
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    protected synchronized ReadStatus nextBlockHeader() {
        if (this.mappedByteBuffer.remaining() < 32) {
            this.mappedByteBuffer.clear();
            return ReadStatus.END_OF_FILE;
        }
        try {
            this.byteOrder = this.mappedByteBuffer.order();
            int n = this.mappedByteBuffer.getInt(28);
            if (n != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.mappedByteBuffer.order(this.byteOrder);
            }
            try {
                int n2;
                this.blockHeader.setBufferStartingPosition(this.mappedByteBuffer.position());
                int[] nArray = new int[8];
                for (n2 = 0; n2 < 8; ++n2) {
                    nArray[n2] = this.mappedByteBuffer.getInt();
                }
                n2 = nArray[5] & 0xFF;
                if (n2 != 1 && n2 != 2 && n2 != 3) {
                    throw new EvioException("Reading file of unsupported evio version (" + n2 + ")");
                }
                this.blockHeader.setVersion(n2);
                this.blockHeader.setSize(nArray[0]);
                this.blockHeader.setNumber(nArray[1]);
                this.blockHeader.setHeaderLength(nArray[2]);
                this.blockHeader.setStart(nArray[3]);
                this.blockHeader.setEnd(nArray[4]);
                this.blockHeader.setReserved1(nArray[6]);
                this.blockHeader.setMagicNumber(nArray[7]);
            }
            catch (EvioException evioException) {
                evioException.printStackTrace();
                return ReadStatus.EVIO_EXCEPTION;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            System.err.println("ERROR endOfBuffer " + bufferUnderflowException);
            this.mappedByteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
        return ReadStatus.SUCCESS;
    }

    public synchronized EvioEvent nextEvent() throws EvioException {
        ReadStatus readStatus;
        EvioEvent evioEvent = new EvioEvent();
        BaseStructureHeader baseStructureHeader = evioEvent.getHeader();
        if (this.mappedByteBuffer.position() == 0 && (readStatus = this.nextBlockHeader()) != ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading block header in nextEvent.");
        }
        int n = this.blockBytesRemaining();
        if (n < 0) {
            throw new EvioException("Number of block bytes remaining is negative.");
        }
        if (n == 0) {
            ReadStatus readStatus2 = this.nextBlockHeader();
            if (readStatus2 == ReadStatus.SUCCESS) {
                return this.nextEvent();
            }
            if (readStatus2 == ReadStatus.END_OF_FILE) {
                return null;
            }
            throw new EvioException("Failed reading block header in nextEvent.");
        }
        if (this.blockHeader.getBufferEndingPosition() == this.mappedByteBuffer.position()) {
            return null;
        }
        int n2 = this.mappedByteBuffer.getInt();
        if (n2 < 1) {
            return null;
        }
        baseStructureHeader.setLength(n2);
        if ((n -= 4) == 0) {
            ReadStatus readStatus3 = this.nextBlockHeader();
            if (readStatus3 == ReadStatus.END_OF_FILE) {
                return null;
            }
            if (readStatus3 != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            n = this.blockBytesRemaining();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            baseStructureHeader.setTag(ByteDataTransformer.shortBitsToInt(this.mappedByteBuffer.getShort()));
            baseStructureHeader.setDataType(ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get()));
            baseStructureHeader.setNumber(ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get()));
        } else {
            baseStructureHeader.setNumber(ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get()));
            baseStructureHeader.setDataType(ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get()));
            baseStructureHeader.setTag(ByteDataTransformer.shortBitsToInt(this.mappedByteBuffer.getShort()));
        }
        n -= 4;
        int n3 = baseStructureHeader.getLength() - 1;
        int n4 = 4 * n3;
        try {
            byte[] byArray = new byte[n4];
            int n5 = n4;
            int n6 = 0;
            while (n5 > n) {
                this.mappedByteBuffer.get(byArray, n6, n);
                ReadStatus readStatus4 = this.nextBlockHeader();
                if (readStatus4 == ReadStatus.END_OF_FILE) {
                    return null;
                }
                if (readStatus4 != ReadStatus.SUCCESS) {
                    throw new EvioException("Failed reading block header after crossing boundary in nextEvent.");
                }
                n5 -= n;
                n6 += n;
                n = this.blockBytesRemaining();
            }
            this.mappedByteBuffer.get(byArray, n6, n5);
            evioEvent.setRawBytes(byArray);
            evioEvent.setByteOrder(this.byteOrder);
            evioEvent.setEventNumber(++this.eventNumber);
            return evioEvent;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("Out Of Memory\neventDataSizeBytes = " + n4 + "\n" + "bytes Remaining = " + n + "\n" + "event Count: " + this.eventCount);
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized EvioEvent parseNextEvent() throws EvioException {
        EvioEvent evioEvent = this.nextEvent();
        if (evioEvent != null) {
            this.parseEvent(evioEvent);
        }
        return evioEvent;
    }

    public synchronized void parseEvent(EvioEvent evioEvent) throws EvioException {
        EventParser.getInstance().parseEvent(evioEvent);
    }

    private int blockBytesRemaining() {
        try {
            return this.blockHeader.bytesRemaining(this.mappedByteBuffer.position());
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
            return -1;
        }
    }

    public void rewind() {
        this.mappedByteBuffer.position(0);
        this.eventNumber = 0;
    }

    public int position() {
        return this.mappedByteBuffer.position();
    }

    public void position(int n) {
        this.mappedByteBuffer.position(n);
    }

    public void close() {
        this.mappedByteBuffer.clear();
    }

    public BlockHeader getCurrentBlockHeader() {
        return this.blockHeader;
    }

    public EvioEvent gotoEventNumber(int n) {
        if (n < 1) {
            return null;
        }
        this.rewind();
        try {
            for (int i = 1; i < n; ++i) {
                EvioEvent evioEvent = this.nextEvent();
                if (evioEvent != null) continue;
                throw new EvioException("Asked to go to event: " + n + ", which is beyond the end of file");
            }
            return this.parseNextEvent();
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
            return null;
        }
    }

    public WriteStatus toXMLFile(String string) {
        return this.toXMLFile(string, null);
    }

    public WriteStatus toXMLFile(String string, IEvioProgressListener iEvioProgressListener) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return WriteStatus.CANNOT_OPEN_FILE;
        }
        XMLStreamWriter xMLStreamWriter = null;
        try {
            xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(fileOutputStream);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeComment("Event source file: " + string);
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeStartElement(ROOT_ELEMENT);
            xMLStreamWriter.writeAttribute("numevents", "" + this.getEventCount());
            this.rewind();
            try {
                EvioEvent evioEvent;
                while ((evioEvent = this.parseNextEvent()) != null) {
                    evioEvent.toXML(xMLStreamWriter);
                    if (iEvioProgressListener == null) continue;
                    iEvioProgressListener.completed(evioEvent.getEventNumber(), this.getEventCount());
                }
            }
            catch (EvioException evioException) {
                evioException.printStackTrace();
                return WriteStatus.UNKNOWN_ERROR;
            }
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (EvioException evioException) {
            return WriteStatus.EVIO_EXCEPTION;
        }
        this.rewind();
        System.out.println("XML write was successful");
        return WriteStatus.SUCCESS;
    }

    public int getEventCount() throws EvioException {
        if (this.eventCount < 0) {
            this.rewind();
            this.eventCount = 0;
            while (this.nextEvent() != null) {
                ++this.eventCount;
            }
            this.rewind();
        }
        return this.eventCount;
    }

    public static boolean compareEventFiles(File file, File file2) {
        int n;
        Object object;
        long l;
        if (file == null || file2 == null) {
            System.out.println("In compareEventFiles, one or both files are null.");
            return false;
        }
        if (!file.exists() || !file2.exists()) {
            System.out.println("In compareEventFiles, one or both files do not exist.");
            return false;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            System.out.println("In compareEventFiles, one or both files is a directory.");
            return false;
        }
        if (!file.canRead() || !file2.canRead()) {
            System.out.println("In compareEventFiles, one or both files cannot be read.");
            return false;
        }
        String string = file.getName();
        String string2 = file2.getName();
        long l2 = file.length();
        if (l2 != (l = file2.length())) {
            System.out.println(string + " and " + string2 + " have the different lengths.");
            System.out.println(string + ": " + l2);
            System.out.println(string2 + ": " + l);
            return false;
        }
        System.out.println(string + " and " + string2 + " have the same length: " + l2);
        try {
            EvioFile evioFile = new EvioFile(file);
            object = new EvioFile(file2);
            int n2 = evioFile.getEventCount();
            n = ((EvioFile)object).getEventCount();
            if (n2 != n) {
                System.out.println(string + " and " + string2 + " have the different #events.");
                System.out.println(string + ": " + n2);
                System.out.println(string2 + ": " + n);
                return false;
            }
            System.out.println(string + " and " + string2 + " have the same #events: " + n2);
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        System.out.print("Byte by byte comparison...");
        System.out.flush();
        int n3 = (int)(1L + l2 / 10L);
        try {
            object = new FileInputStream(file);
            FileInputStream fileInputStream = new FileInputStream(file);
            n = 0;
            while ((long)n < l2) {
                try {
                    int n4 = ((FileInputStream)object).read();
                    int n5 = fileInputStream.read();
                    if (n4 != n5) {
                        System.out.println(string + " and " + string2 + " different at byte offset: " + n);
                        return false;
                    }
                    if (n % n3 == 0) {
                        System.out.print(".");
                        System.out.flush();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return false;
                }
                ++n;
            }
            System.out.println("");
            try {
                ((FileInputStream)object).close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        System.out.println("files " + string + " and " + file2.getPath() + " are identical.");
        return true;
    }

    private static int[] fakeIntArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1076895760;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = "../../testdata/littleOut.ev";
        ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
        byteBuffer.putInt(8192);
        byteBuffer.putInt(1);
        byteBuffer.putInt(8);
        byteBuffer.putInt(8);
        byteBuffer.putInt(60);
        byteBuffer.putInt(2);
        byteBuffer.putInt(0);
        byteBuffer.putInt(-1059454720);
        byteBuffer.putInt(51);
        int n = 11;
        int n2 = 3;
        int n3 = 16;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(18);
        n = 20;
        n2 = 2;
        n3 = 16;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(16);
        n = 21;
        n2 = 1;
        n3 = 11;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(1);
        byteBuffer.putInt(2);
        byteBuffer.putInt(3);
        byteBuffer.putInt(4);
        byteBuffer.putInt(5);
        byteBuffer.putInt(16);
        byteBuffer.putInt(32);
        byteBuffer.putInt(48);
        byteBuffer.putInt(64);
        byteBuffer.putInt(80);
        byteBuffer.putInt(256);
        byteBuffer.putInt(512);
        byteBuffer.putInt(768);
        byteBuffer.putInt(1024);
        byteBuffer.putInt(1280);
        byteBuffer.putInt(3);
        n = 22;
        n2 = 2;
        n3 = 13;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        int n4 = 1;
        n = 23;
        n3 = 11;
        byteBuffer.putInt(n4 & 0xFFFF | n3 << 16 & 0xFF0000 | n << 24);
        byteBuffer.putInt(100992003);
        byteBuffer.putInt(3);
        n = 24;
        n2 = 2;
        n3 = 12;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        n4 = 1;
        n = 25;
        n3 = 11;
        byteBuffer.putInt(n4 & 0xFFFF | n3 << 16 & 0xF0000 | n << 20);
        byteBuffer.putInt(117835012);
        byteBuffer.putInt(2);
        n = 12;
        n2 = 2;
        n3 = 1;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(67305985);
        byteBuffer.putInt(4);
        n = 13;
        n2 = 2;
        n3 = 4;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putShort((short)1027);
        byteBuffer.putShort((short)513);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)2);
        byteBuffer.putShort((short)3);
        byteBuffer.putShort((short)4);
        byteBuffer.putInt(3);
        n = 14;
        n2 = 2;
        n3 = 9;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putLong(1311693406324658740L);
        byteBuffer.putInt(2);
        n = 15;
        n2 = 2;
        n3 = 2;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putFloat(1.23E-4f);
        byteBuffer.putInt(3);
        n = 16;
        n2 = 2;
        n3 = 8;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putDouble(-5.6789E-300);
        byteBuffer.putInt(3);
        n = 17;
        n2 = 2;
        n3 = 3;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byte[] byArray = new byte[8];
        byArray[0] = 67;
        byArray[1] = 79;
        byArray[2] = 68;
        byArray[3] = 65;
        byArray[4] = 51;
        byArray[5] = 15;
        byteBuffer.put(byArray);
        String string2 = "../../testdata/BigEndianOut.ev";
        File file = new File(string2);
        try {
            object2 = new FileOutputStream(file);
            object = ((FileOutputStream)object2).getChannel();
            byteBuffer.rewind();
            System.out.println("read ev file: " + string2 + " size: " + file.length());
            ((FileChannel)object).write(byteBuffer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byteBuffer.position(32);
        object2 = byteBuffer.slice();
        object = new ByteParser();
        class MyListener
        implements IEvioListener {
            MyListener() {
            }

            @Override
            public void startEventParse(EvioEvent evioEvent) {
            }

            @Override
            public void endEventParse(EvioEvent evioEvent) {
            }

            @Override
            public void gotStructure(EvioEvent evioEvent, IEvioStructure iEvioStructure) {
                BaseStructureHeader baseStructureHeader = iEvioStructure.getHeader();
                System.out.println("------------------");
                System.out.println("" + iEvioStructure);
                switch (baseStructureHeader.getDataTypeEnum()) {
                    case FLOAT32: {
                        float[] fArray;
                        System.out.println("        FLOAT VALS");
                        for (float f : fArray = iEvioStructure.getFloatData()) {
                            System.out.println("         " + f);
                        }
                        break;
                    }
                    case DOUBLE64: {
                        double[] dArray;
                        System.out.println("        DOUBLE VALS");
                        for (double d : dArray = iEvioStructure.getDoubleData()) {
                            System.out.println("         " + d);
                        }
                        break;
                    }
                    case SHORT16: {
                        short[] sArray;
                        System.out.println("        SHORT VALS");
                        for (short s : sArray = iEvioStructure.getShortData()) {
                            System.out.println("        0x" + Integer.toHexString(s));
                        }
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        int[] nArray;
                        System.out.println("        INT VALS");
                        for (int n : nArray = iEvioStructure.getIntData()) {
                            System.out.println("        0x" + Integer.toHexString(n));
                        }
                        break;
                    }
                    case LONG64: {
                        long[] lArray;
                        System.out.println("        LONG VALS");
                        for (long l : lArray = iEvioStructure.getLongData()) {
                            System.out.println("        0x" + Long.toHexString(l));
                        }
                        break;
                    }
                    case CHAR8: 
                    case UCHAR8: {
                        byte[] byArray;
                        System.out.println("        BYTE VALS");
                        for (byte by : byArray = iEvioStructure.getByteData()) {
                            System.out.println("         " + by);
                        }
                        break;
                    }
                    case CHARSTAR8: {
                        String[] stringArray;
                        System.out.println("        STRING VALS");
                        for (String string : stringArray = iEvioStructure.getStringData()) {
                            System.out.println("         " + string);
                        }
                        break;
                    }
                }
            }
        }
        ((ByteParser)object).addEvioListener(new MyListener());
        ((ByteBuffer)object2).rewind();
        EvioEvent evioEvent = null;
        try {
            evioEvent = ((ByteParser)object).parseEvent((ByteBuffer)object2);
            System.out.println("Event = " + evioEvent.toString());
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
        }
        System.out.println("\nSWITCH BUFFER TO LITTLE ENDIAN HERE\n");
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(216);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(216);
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            ((ByteBuffer)object2).rewind();
            ByteDataTransformer.swap((ByteBuffer)object2, byteBuffer2);
            byteBuffer2.rewind();
            ByteDataTransformer.swap(byteBuffer2, byteBuffer3);
            System.out.println("new buffer byte order is " + byteBuffer2.order());
            byArray2 = evioEvent.toArray();
            EvioEvent evioEvent2 = ByteDataTransformer.swap(evioEvent);
            byArray3 = evioEvent2.toArray();
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
        }
        ((ByteBuffer)object2).rewind();
        byteBuffer3.rewind();
        boolean bl = false;
        for (int i = 0; i < 144; ++i) {
            if (((ByteBuffer)object2).get() == byteBuffer3.get()) continue;
            bl = true;
            break;
        }
        if (bl) {
            System.out.println("Double swapped buffer is different!!!");
        } else {
            System.out.println("Double swapped buffer is SAME!!!");
        }
        ((ByteBuffer)object2).rewind();
        ByteBuffer byteBuffer4 = ByteBuffer.wrap(byArray2);
        bl = false;
        for (int i = 0; i < 144; ++i) {
            if (((ByteBuffer)object2).get() == byteBuffer4.get()) continue;
            bl = true;
            break;
        }
        if (bl) {
            System.out.println("toArray array is different!!!");
        } else {
            System.out.println("toArray array is SAME!!!");
        }
        byteBuffer2.rewind();
        ByteBuffer byteBuffer5 = ByteBuffer.wrap(byArray3);
        bl = false;
        for (int i = 0; i < 144; ++i) {
            if (byteBuffer2.get() == byteBuffer5.get()) continue;
            bl = true;
            break;
        }
        if (bl) {
            System.out.println("toArray array swapped is different!!!");
        } else {
            System.out.println("toArray array swapped is SAME!!!");
        }
        byteBuffer2.rewind();
        try {
            evioEvent = ((ByteParser)object).parseEvent(byteBuffer2);
            System.out.println("Event (dest)  = " + evioEvent.toString());
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
        }
        File file2 = new File(string);
        System.out.println("read ev file: " + string + " size: " + file2.length());
        try {
            EvioFile evioFile = new EvioFile(string);
            MappedByteBuffer mappedByteBuffer = evioFile.getMappedByteBuffer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static enum WriteStatus {
        SUCCESS,
        CANNOT_OPEN_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

