/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeModel;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.SegmentHeader;
import org.jlab.coda.jevio.TagSegmentHeader;

public class ByteParser {
    private EventListenerList evioListenerList;
    protected boolean notificationActive = true;
    private IEvioFilter evioFilter;

    public EvioEvent parseEvent(byte[] byArray, ByteOrder byteOrder) throws EvioException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        return this.parseEvent(byteBuffer);
    }

    public EvioEvent parseEvent(ByteBuffer byteBuffer) throws EvioException {
        return (EvioEvent)this.parseBank(byteBuffer, null, null);
    }

    public EvioEvent readEvent(DataInputStream dataInputStream, ByteOrder byteOrder) throws IOException, EvioException {
        int n;
        int n2 = n = dataInputStream.readInt();
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            n2 = Integer.reverseBytes(n);
        }
        byte[] byArray = new byte[4 * (n2 + 1)];
        dataInputStream.readFully(byArray, 4, 4 * n2);
        ByteDataTransformer.intToBytes(n, byArray, 0);
        return this.parseEvent(byArray, byteOrder);
    }

    private BaseStructure parseBank(ByteBuffer byteBuffer, EvioEvent evioEvent, BaseStructure baseStructure) throws EvioException {
        EvioBank evioBank;
        BankHeader bankHeader = this.createBankHeader(byteBuffer);
        if (evioEvent == null) {
            evioEvent = new EvioEvent(bankHeader);
            evioEvent.treeModel = new DefaultTreeModel(evioEvent);
            evioBank = evioEvent;
        } else {
            evioBank = new EvioBank(bankHeader);
            evioBank.setParent(baseStructure);
            evioEvent.insert(evioBank, baseStructure);
        }
        return this.parseStructure(byteBuffer, evioEvent, evioBank);
    }

    private BaseStructure parseSegment(ByteBuffer byteBuffer, EvioEvent evioEvent, BaseStructure baseStructure) throws EvioException {
        SegmentHeader segmentHeader = this.createSegmentHeader(byteBuffer);
        EvioSegment evioSegment = new EvioSegment(segmentHeader);
        evioSegment.setParent(baseStructure);
        evioEvent.insert(evioSegment, baseStructure);
        return this.parseStructure(byteBuffer, evioEvent, evioSegment);
    }

    private BaseStructure parseTagSegment(ByteBuffer byteBuffer, EvioEvent evioEvent, BaseStructure baseStructure) throws EvioException {
        TagSegmentHeader tagSegmentHeader = this.createTagSegmentHeader(byteBuffer);
        EvioTagSegment evioTagSegment = new EvioTagSegment(tagSegmentHeader);
        evioTagSegment.setParent(baseStructure);
        evioEvent.insert(evioTagSegment, baseStructure);
        return this.parseStructure(byteBuffer, evioEvent, evioTagSegment);
    }

    private BaseStructure parseStructure(ByteBuffer byteBuffer, EvioEvent evioEvent, BaseStructure baseStructure) throws EvioException {
        BaseStructureHeader baseStructureHeader = baseStructure.getHeader();
        byteBuffer.mark();
        int n = baseStructureHeader.getLength() + 1 - baseStructureHeader.getHeaderLength();
        byte[] byArray = new byte[4 * n];
        byteBuffer.get(byArray, 0, byArray.length);
        baseStructure.setRawBytes(byArray);
        baseStructure.setByteOrder(byteBuffer.order());
        if (!baseStructureHeader.getDataTypeEnum().isStructure()) {
            this.notifyEvioListeners(evioEvent, baseStructure);
            return baseStructure;
        }
        byteBuffer.reset();
        this.parseData(byteBuffer, baseStructureHeader.getDataTypeEnum(), n, evioEvent, baseStructure);
        return baseStructure;
    }

    private BankHeader createBankHeader(ByteBuffer byteBuffer) {
        BankHeader bankHeader = new BankHeader();
        bankHeader.setLength(byteBuffer.getInt());
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            bankHeader.setTag(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
            bankHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            bankHeader.setNumber(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
        } else {
            bankHeader.setNumber(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            bankHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            bankHeader.setTag(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
        }
        return bankHeader;
    }

    private SegmentHeader createSegmentHeader(ByteBuffer byteBuffer) {
        SegmentHeader segmentHeader = new SegmentHeader();
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            segmentHeader.setTag(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            segmentHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            segmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
        } else {
            segmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
            segmentHeader.setDataType(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
            segmentHeader.setTag(ByteDataTransformer.byteBitsToInt(byteBuffer.get()));
        }
        return segmentHeader;
    }

    private TagSegmentHeader createTagSegmentHeader(ByteBuffer byteBuffer) {
        TagSegmentHeader tagSegmentHeader = new TagSegmentHeader();
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            int n = ByteDataTransformer.shortBitsToInt(byteBuffer.getShort());
            tagSegmentHeader.setTag(n >>> 4);
            tagSegmentHeader.setDataType(n & 0xF);
            tagSegmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
        } else {
            tagSegmentHeader.setLength(ByteDataTransformer.shortBitsToInt(byteBuffer.getShort()));
            int n = ByteDataTransformer.shortBitsToInt(byteBuffer.getShort());
            tagSegmentHeader.setTag(n >>> 4);
            tagSegmentHeader.setDataType(n & 0xF);
        }
        return tagSegmentHeader;
    }

    private void parseData(ByteBuffer byteBuffer, DataType dataType, int n, EvioEvent evioEvent, BaseStructure baseStructure) throws EvioException {
        switch (dataType) {
            case BANK: 
            case ALSOBANK: {
                int n2;
                BaseStructure baseStructure2;
                for (n2 = 0; n2 < n; n2 += baseStructure2.getHeader().getLength() + 1) {
                    baseStructure2 = this.parseBank(byteBuffer, evioEvent, baseStructure);
                }
                if (n2 == n) break;
                throw new EvioException("Data not in evio format");
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                int n2;
                while (n2 < n) {
                    BaseStructure baseStructure3 = this.parseSegment(byteBuffer, evioEvent, baseStructure);
                    n2 += baseStructure3.getHeader().getLength() + 1;
                }
                if (n2 == n) break;
                throw new EvioException("Data not in evio format");
            }
            case TAGSEGMENT: 
            case ALSOTAGSEGMENT: {
                int n2;
                while (n2 < n) {
                    BaseStructure baseStructure4 = this.parseTagSegment(byteBuffer, evioEvent, baseStructure);
                    n2 += baseStructure4.getHeader().getLength() + 1;
                }
                if (n2 == n) break;
                throw new EvioException("Data not in evio format");
            }
        }
        this.notifyEvioListeners(evioEvent, baseStructure);
    }

    protected void notifyEvioListeners(EvioEvent evioEvent, IEvioStructure iEvioStructure) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        if (this.evioFilter != null && !this.evioFilter.accept(iEvioStructure.getStructureType(), iEvioStructure.getHeader())) {
            return;
        }
        Object[] objectArray = this.evioListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IEvioListener.class) continue;
            ((IEvioListener)objectArray[i + 1]).gotStructure(evioEvent, iEvioStructure);
        }
    }

    public void removeEvioListener(IEvioListener iEvioListener) {
        if (iEvioListener == null || this.evioListenerList == null) {
            return;
        }
        this.evioListenerList.remove(IEvioListener.class, iEvioListener);
    }

    public void addEvioListener(IEvioListener iEvioListener) {
        if (iEvioListener == null) {
            return;
        }
        if (this.evioListenerList == null) {
            this.evioListenerList = new EventListenerList();
        }
        this.evioListenerList.add(IEvioListener.class, iEvioListener);
    }

    public boolean isNotificationActive() {
        return this.notificationActive;
    }

    public void setNotificationActive(boolean bl) {
        this.notificationActive = bl;
    }

    public void setEvioFilter(IEvioFilter iEvioFilter) {
        this.evioFilter = iEvioFilter;
    }
}

