/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.ByteParser;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;

public class ByteDataTransformer {
    public static int[] getAsIntArray(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        int n = byArray.length / 4;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        return nArray;
    }

    public static short[] getAsShortArray(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        int n = byArray.length / 2;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = byteBuffer.getShort();
        }
        return sArray;
    }

    public static long[] getAsLongArray(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        int n = byArray.length / 8;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = byteBuffer.getLong();
        }
        return lArray;
    }

    public static double[] getAsDoubleArray(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        int n = byArray.length / 8;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = byteBuffer.getDouble();
        }
        return dArray;
    }

    public static float[] getAsFloatArray(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        int n = byArray.length / 4;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = byteBuffer.getFloat();
        }
        return fArray;
    }

    public static final void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF000000) >>> 24);
        byArray[n2 + 1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[n2 + 2] = (byte)((n & 0xFF00) >>> 8);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static final void shortToBytes(short s, byte[] byArray, int n) {
        byArray[n] = (byte)((s & 0xFF00) >>> 8);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public static final int shortBitsToInt(short s) {
        return s & 0xFFFF;
    }

    public static final int byteBitsToInt(byte by) {
        return by & 0xFF;
    }

    public static void swap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws EvioException {
        ByteOrder byteOrder = byteBuffer.order();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byteOrder2 = ByteOrder.LITTLE_ENDIAN;
        }
        if (byteBuffer2 != null) {
            byteBuffer2.order(byteOrder2);
        }
        try {
            ByteDataTransformer.swapBank(byteBuffer, byteBuffer2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new EvioException("Data not in evio format", bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EvioException("Data not in evio format", bufferUnderflowException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EvioException("Data not in evio format", indexOutOfBoundsException);
        }
        if (byteBuffer2 == null) {
            byteBuffer.order(byteOrder2);
        }
    }

    public static EvioEvent swap(EvioBank evioBank) throws EvioException {
        ByteOrder byteOrder = evioBank.getByteOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] byArray = evioBank.toArray();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(evioBank.getByteOrder());
        try {
            ByteDataTransformer.swapBank(byteBuffer, null);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new EvioException("Data not in evio format", bufferOverflowException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new EvioException("Data not in evio format", bufferUnderflowException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new EvioException("Data not in evio format", indexOutOfBoundsException);
        }
        ByteParser byteParser = new ByteParser();
        byteBuffer.rewind();
        byteBuffer.order(byteOrder);
        return byteParser.parseEvent(byteBuffer);
    }

    private static void copyData(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) {
        if (byteBuffer2 == null) {
            return;
        }
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray, 0, n2);
        byteBuffer2.put(byArray, 0, n2);
    }

    private static void swapIntArray(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) {
        if (byteBuffer2 == null) {
            for (int i = 0; i < n; ++i) {
                int n2 = byteBuffer.position();
                byteBuffer.putInt(Integer.reverseBytes(byteBuffer.getInt(n2)));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byteBuffer2.putInt(byteBuffer.getInt());
            }
        }
    }

    private static void swapLongArray(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) {
        int n2 = n / 2;
        if (byteBuffer2 == null) {
            for (int i = 0; i < n2; ++i) {
                int n3 = byteBuffer.position();
                byteBuffer.putLong(Long.reverseBytes(byteBuffer.getLong(n3)));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byteBuffer2.putLong(byteBuffer.getLong());
            }
        }
    }

    private static void swapShortArray(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) {
        int n2 = 2 * n;
        if (byteBuffer2 == null) {
            for (int i = 0; i < n2; ++i) {
                int n3 = byteBuffer.position();
                byteBuffer.putShort(Short.reverseBytes(byteBuffer.getShort(n3)));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                byteBuffer2.putShort(byteBuffer.getShort());
            }
        }
    }

    private static int swapBank(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws EvioException {
        byteBuffer.mark();
        int n = byteBuffer.getInt() - 1;
        DataType dataType = DataType.getDataType(byteBuffer.getInt() >> 8 & 0xFF);
        byteBuffer.reset();
        ByteDataTransformer.swapIntArray(byteBuffer, 2, byteBuffer2);
        ByteDataTransformer.swapData(byteBuffer, dataType, n, byteBuffer2);
        return n + 2;
    }

    private static int swapSegment(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws EvioException {
        byteBuffer.mark();
        int n = byteBuffer.getInt();
        byteBuffer.reset();
        int n2 = n & 0xFFFF;
        DataType dataType = DataType.getDataType(n >> 16 & 0xFF);
        ByteDataTransformer.swapIntArray(byteBuffer, 1, byteBuffer2);
        ByteDataTransformer.swapData(byteBuffer, dataType, n2, byteBuffer2);
        return n2 + 1;
    }

    private static int swapTagSegment(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws EvioException {
        byteBuffer.mark();
        int n = byteBuffer.getInt();
        byteBuffer.reset();
        int n2 = n & 0xFFFF;
        DataType dataType = DataType.getDataType(n >> 16 & 0xF);
        ByteDataTransformer.swapIntArray(byteBuffer, 1, byteBuffer2);
        ByteDataTransformer.swapData(byteBuffer, dataType, n2, byteBuffer2);
        return n2 + 1;
    }

    private static void swapData(ByteBuffer byteBuffer, DataType dataType, int n, ByteBuffer byteBuffer2) throws EvioException {
        switch (dataType) {
            case INT32: 
            case UINT32: 
            case FLOAT32: {
                ByteDataTransformer.swapIntArray(byteBuffer, n, byteBuffer2);
                break;
            }
            case SHORT16: 
            case USHORT16: {
                ByteDataTransformer.swapShortArray(byteBuffer, n, byteBuffer2);
                break;
            }
            case LONG64: 
            case ULONG64: 
            case DOUBLE64: {
                ByteDataTransformer.swapLongArray(byteBuffer, n, byteBuffer2);
                break;
            }
            case UNKNOWN32: 
            case CHAR8: 
            case UCHAR8: 
            case CHARSTAR8: {
                ByteDataTransformer.copyData(byteBuffer, n, byteBuffer2);
                break;
            }
            case BANK: 
            case ALSOBANK: {
                int n2;
                for (n2 = 0; n2 < n; n2 += ByteDataTransformer.swapBank(byteBuffer, byteBuffer2)) {
                }
                if (n2 == n) break;
                throw new EvioException("Data not in evio format");
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                int n2;
                while (n2 < n) {
                    n2 += ByteDataTransformer.swapSegment(byteBuffer, byteBuffer2);
                }
                if (n2 == n) break;
                throw new EvioException("Data not in evio format");
            }
            case TAGSEGMENT: 
            case ALSOTAGSEGMENT: {
                int n2;
                while (n2 < n) {
                    n2 += ByteDataTransformer.swapTagSegment(byteBuffer, byteBuffer2);
                }
                if (n2 == n) break;
                throw new EvioException("Data not in evio format");
            }
            default: {
                ByteDataTransformer.copyData(byteBuffer, n, byteBuffer2);
            }
        }
    }
}

