/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteOrder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.IEvioWriter;

public abstract class BaseStructureHeader
implements IEvioWriter {
    protected int length;
    protected int tag = 0;
    protected int dataType = 0;
    protected int number;

    public BaseStructureHeader() {
    }

    public BaseStructureHeader(int n, DataType dataType) {
        this(n, dataType.getValue(), 0);
    }

    public BaseStructureHeader(int n, int n2) {
        this(n, n2, 0);
    }

    public BaseStructureHeader(int n, DataType dataType, int n2) {
        this(n, dataType.getValue(), n2);
    }

    public BaseStructureHeader(int n, int n2, int n3) {
        this.tag = n;
        this.dataType = n2;
        this.number = n3;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        if (n < 0) {
            n += 256;
        }
        this.number = n;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public abstract int getHeaderLength();

    protected abstract void toArray(byte[] var1, int var2, ByteOrder var3);

    public int getTag() {
        return this.tag;
    }

    public void setTag(int n) {
        this.tag = n;
    }

    public String getDataTypeName() {
        return DataType.getName(this.dataType);
    }

    public DataType getDataTypeEnum() {
        return DataType.getDataType(this.dataType);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(String.format("structure length: %d\n", this.length));
        stringBuffer.append(String.format("data type:   %s\n", this.getDataTypeName()));
        stringBuffer.append(String.format("tag:         %d\n", this.tag));
        return stringBuffer.toString();
    }

    public byte byteValue(Integer n) {
        return n.byteValue();
    }

    public short shortValue(Integer n) {
        return n.shortValue();
    }
}

