/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;

public class Test {
    private String subject = "evio";
    private String type = "event";
    private String name = "evoiProducer";
    private String description = "evio producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay;
    private int count = 50000;
    private boolean debug;

    Test(String[] stringArray) {
        this.decodeCommandLine(stringArray);
    }

    private void decodeCommandLine(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-h")) {
                Test.usage();
                System.exit(-1);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-n")) {
                this.name = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-d")) {
                this.description = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-u")) {
                this.UDL = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-s")) {
                this.subject = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-t")) {
                this.type = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(stringArray[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(stringArray[i + 1]);
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            Test.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java Test\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-c <count>]         set # of messages to send before printing output\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] stringArray) {
        try {
            Test test = new Test(stringArray);
            test.run();
        }
        catch (cMsgException cMsgException2) {
            System.out.println(cMsgException2.toString());
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int n) {
        if (n < 0) {
            n = 0;
        }
        double d2 = Math.pow(10.0, n);
        String string = "" + (double)Math.round(d * d2) / d2;
        if (n == 0) {
            return string.substring(0, string.length() - 2);
        }
        while (string.length() - string.indexOf(".") < n + 1) {
            string = string + "0";
        }
        return string;
    }

    public void run() throws cMsgException {
        int n = 0;
        int n2 = n++;
        int n3 = n++ % 1000;
        System.out.println("I =  " + n2 + ", k = " + n3 + ", j = " + n);
    }

    public void run2() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg producer sending to:\n    subject = " + this.subject + "\n    type    = " + this.type + "\n    UDL     = " + this.UDL);
        }
        cMsg cMsg2 = new cMsg(this.UDL, this.name, this.description);
        try {
            cMsg2.connect();
        }
        catch (cMsgException cMsgException2) {
            cMsgException2.printStackTrace();
            return;
        }
        cMsgMessage cMsgMessage2 = new cMsgMessage();
        cMsgMessage2.setSubject(this.subject);
        cMsgMessage2.setType(this.type);
        ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
        byteBuffer.putInt(51);
        int n = 11;
        int n2 = 3;
        int n3 = 16;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(18);
        n = 20;
        n2 = 2;
        n3 = 16;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(16);
        n = 21;
        n2 = 1;
        n3 = 11;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(1);
        byteBuffer.putInt(2);
        byteBuffer.putInt(3);
        byteBuffer.putInt(4);
        byteBuffer.putInt(5);
        byteBuffer.putInt(16);
        byteBuffer.putInt(32);
        byteBuffer.putInt(48);
        byteBuffer.putInt(64);
        byteBuffer.putInt(80);
        byteBuffer.putInt(256);
        byteBuffer.putInt(512);
        byteBuffer.putInt(768);
        byteBuffer.putInt(1024);
        byteBuffer.putInt(1280);
        byteBuffer.putInt(3);
        n = 22;
        n2 = 2;
        n3 = 13;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        int n4 = 1;
        n = 23;
        n3 = 11;
        byteBuffer.putInt(n4 & 0xFFFF | n3 << 16 & 0xFF0000 | n << 24);
        byteBuffer.putInt(100992003);
        byteBuffer.putInt(3);
        n = 24;
        n2 = 2;
        n3 = 12;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        n4 = 1;
        n = 25;
        n3 = 11;
        byteBuffer.putInt(n4 & 0xFFFF | n3 << 16 & 0xF0000 | n << 20);
        byteBuffer.putInt(117835012);
        byteBuffer.putInt(2);
        n = 12;
        n2 = 2;
        n3 = 1;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putInt(67305985);
        byteBuffer.putInt(4);
        n = 13;
        n2 = 2;
        n3 = 4;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putShort((short)1027);
        byteBuffer.putShort((short)513);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)2);
        byteBuffer.putShort((short)3);
        byteBuffer.putShort((short)4);
        byteBuffer.putInt(3);
        n = 14;
        n2 = 2;
        n3 = 9;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putLong(1311693406324658740L);
        byteBuffer.putInt(2);
        n = 15;
        n2 = 2;
        n3 = 2;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putFloat(1.23E-4f);
        byteBuffer.putInt(3);
        n = 16;
        n2 = 2;
        n3 = 8;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byteBuffer.putDouble(-5.6789E-300);
        byteBuffer.putInt(3);
        n = 17;
        n2 = 2;
        n3 = 3;
        byteBuffer.putInt(n2 & 0xFF | n3 << 8 & 0xFF00 | n << 16);
        byte[] byArray = new byte[8];
        byArray[0] = 67;
        byArray[1] = 79;
        byArray[2] = 68;
        byArray[3] = 65;
        byArray[4] = 51;
        byArray[5] = 15;
        byteBuffer.put(byArray);
        byteBuffer.flip();
        cMsgMessage2.setByteArrayNoCopy(byteBuffer.array(), 0, 240);
        cMsgMessage2.setByteArrayEndian(0);
        String string = "<?xml version=\"1.0\" ?><!-- dictionary corresponding to evio event --><dictionary>    <!-- dictionary entries -->    <xmldumpDictEntry name=\"cMsgEvent\"        tag=\"11\"   num=\"3\"/>    <xmldumpDictEntry name=\"cMsgBank1\"        tag=\"20\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgIntBank1\"     tag=\"21\"   num=\"2.1\"/>    <xmldumpDictEntry name=\"cMsgBank2\"        tag=\"22\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgIntSeg1\"      tag=\"23\"   />    <xmldumpDictEntry name=\"cMsgBank3\"        tag=\"24\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgIntTagSeg1\"   tag=\"25\"  />    <xmldumpDictEntry name=\"cMsgIntBank2\"     tag=\"12\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgShortBank1\"   tag=\"13\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgLongBank1\"    tag=\"14\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgFloatBank1\"   tag=\"15\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgDoubleBank1\"  tag=\"16\"   num=\"2\"/>    <xmldumpDictEntry name=\"cMsgStringBank1\"  tag=\"17\"   num=\"2\"/></dictionary>";
        cMsgPayloadItem cMsgPayloadItem2 = new cMsgPayloadItem("dictionary", string);
        cMsgMessage2.addPayloadItem(cMsgPayloadItem2);
        double d = 0.0;
        double d2 = 0.0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        while (true) {
            long l4 = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                cMsg2.send(cMsgMessage2);
                cMsg2.flush(0);
                if (this.delay == 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long l5 = System.currentTimeMillis();
            if (l3 == 0L) {
                long l6 = l5 - l4;
                d = (double)this.count / (double)l6 * 1000.0;
                d2 = (double)(l2 += (long)this.count) / (double)(l += l6) * 1000.0;
                if (!this.debug) continue;
                System.out.println(Test.doubleToString(d, 1) + " Hz, Avg = " + Test.doubleToString(d2, 1) + " Hz");
                continue;
            }
            --l3;
        }
    }
}

