/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.StructureType;
import org.jlab.coda.jevio.TagSegmentHeader;

public class EvioTagSegment
extends BaseStructure {
    public static final String ELEMENT_NAME = "tagsegment";

    public EvioTagSegment() {
        this(new TagSegmentHeader());
    }

    public EvioTagSegment(TagSegmentHeader tagSegmentHeader) {
        super(tagSegmentHeader);
    }

    public EvioTagSegment(int n, DataType dataType) {
        this(new TagSegmentHeader(n, dataType));
    }

    public EvioTagSegment(int n, int n2) {
        this(new TagSegmentHeader(n, n2));
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.TAGSEGMENT;
    }

    @Override
    public void toXML(XMLStreamWriter xMLStreamWriter) {
        try {
            this.commonXMLStart(xMLStreamWriter);
            if (DataType.getDataType(this.header.dataType).isStructure()) {
                xMLStreamWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xMLStreamWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType));
            xMLStreamWriter.writeAttribute("tag", "" + this.header.tag);
            xMLStreamWriter.writeAttribute("length", "" + this.header.length);
            xMLStreamWriter.writeAttribute("ndata", "" + this.getNumberDataItems());
            this.increaseXmlIndent();
            this.commonXMLDataWrite(xMLStreamWriter);
            this.decreaseXmlIndent();
            this.commonXMLClose(xMLStreamWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }
}

