/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.NameProvider;

public class EvioEvent
extends EvioBank {
    public static final String ELEMENT_NAME = "event";
    protected DefaultTreeModel treeModel;
    private int eventNumber;

    public EvioEvent() {
    }

    public EvioEvent(BankHeader bankHeader) {
        super(bankHeader);
    }

    public EvioEvent(int n, DataType dataType, int n2) {
        this(new BankHeader(n, dataType, n2));
    }

    public EvioEvent(int n, int n2, int n3) {
        this(new BankHeader(n, n2, n3));
    }

    @Override
    public String toString() {
        String string = this.getDescription();
        if (NameProvider.NO_NAME_STRING.equals(string)) {
            string = null;
        }
        String string2 = "<Event>  len (ints): " + this.header.length + " " + " tag: " + this.header.tag + " num: " + this.header.number;
        if (string != null) {
            string2 = string2 + " [" + string + "]";
        }
        return string2;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void insert(BaseStructure baseStructure, BaseStructure baseStructure2) {
        this.treeModel.insertNodeInto(baseStructure, baseStructure2, baseStructure2.getChildCount());
    }

    public void vistAllStructures(IEvioListener iEvioListener) {
        this.visitAllDescendants(this, iEvioListener, null);
    }

    public void vistAllStructures(IEvioListener iEvioListener, IEvioFilter iEvioFilter) {
        this.visitAllDescendants(this, iEvioListener, iEvioFilter);
    }

    private void visitAllDescendants(BaseStructure baseStructure, IEvioListener iEvioListener, IEvioFilter iEvioFilter) {
        if (iEvioListener != null) {
            boolean bl = true;
            if (iEvioFilter != null) {
                bl = iEvioFilter.accept(baseStructure.getStructureType(), baseStructure.header);
            }
            if (bl) {
                iEvioListener.gotStructure(this, baseStructure);
            }
        }
        if (!baseStructure.isLeaf()) {
            for (BaseStructure baseStructure2 : baseStructure.getChildren()) {
                this.visitAllDescendants(baseStructure2, iEvioListener, iEvioFilter);
            }
        }
    }

    public List<BaseStructure> getMatchingStructures(IEvioFilter iEvioFilter) {
        final Vector<BaseStructure> vector = new Vector<BaseStructure>(25, 10);
        IEvioListener iEvioListener = new IEvioListener(){

            @Override
            public void startEventParse(EvioEvent evioEvent) {
            }

            @Override
            public void endEventParse(EvioEvent evioEvent) {
            }

            @Override
            public void gotStructure(EvioEvent evioEvent, IEvioStructure iEvioStructure) {
                vector.add((BaseStructure)iEvioStructure);
            }
        };
        this.vistAllStructures(iEvioListener, iEvioFilter);
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public void setEventNumber(int n) {
        this.eventNumber = n;
    }

    @Override
    public void toXML(XMLStreamWriter xMLStreamWriter) {
        try {
            int n = this.header.length + 1;
            xMLStreamWriter.writeComment(" Buffer " + this.getEventNumber() + " contains " + n + " words (" + 4 * n + " bytes)");
            this.commonXMLStart(xMLStreamWriter);
            xMLStreamWriter.writeAttribute("format", "evio");
            xMLStreamWriter.writeAttribute("count", "" + this.getEventNumber());
            if (DataType.getDataType(this.header.dataType).isStructure()) {
                xMLStreamWriter.writeAttribute("content", this.xmlContentAttributeName);
            }
            xMLStreamWriter.writeAttribute("data_type", String.format("0x%x", this.header.dataType));
            xMLStreamWriter.writeAttribute("length", "" + this.header.length);
            xMLStreamWriter.writeAttribute("tag", "" + this.header.tag);
            xMLStreamWriter.writeAttribute("num", "" + this.header.number);
            this.commonXMLClose(xMLStreamWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    @Override
    public String getXMLElementName() {
        return ELEMENT_NAME;
    }
}

