/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioFile;

public class EventWriter {
    private static int BLOCK_LENGTH_OFFSET = 0;
    private static int HEADER_LENGTH_OFFSET = 8;
    private static int START_OFFSET = 12;
    private static int END_OFFSET = 16;
    private static int VERSION_OFFSET = 20;
    private static int RESERVED1_OFFSET = 24;
    private static int DEFAULT_BLOCK_SIZE = 8192;
    private DataOutputStream dataOutputStream;
    private int blockSize;
    private ByteBuffer blockBuffer;
    private boolean updatedStart;
    private int blockNumber = 0;
    private int lastEventWritten = 0;

    public EventWriter(File file) throws EvioException {
        this(file, DEFAULT_BLOCK_SIZE);
    }

    public EventWriter(String string) throws EvioException {
        this(new File(string), DEFAULT_BLOCK_SIZE);
    }

    public EventWriter(File file, int n) throws EvioException {
        this.blockSize = n;
        try {
            this.dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EvioException(fileNotFoundException.getMessage());
        }
    }

    public EventWriter(File file, int n, boolean bl) throws EvioException {
        this.blockSize = n;
        if (file == null) {
            throw new EvioException("Null file in EventWriter constructor");
        }
        if (file.exists() && file.isFile()) {
            if (bl) {
                boolean bl2 = file.delete();
                if (!bl2) {
                    throw new EvioException("File in EventWriter constructor already exists, and could not be deleted. \nFile: " + file.getPath());
                }
            } else {
                throw new EvioException("File in EventWriter constructor already exists, and user requested no deletion. \nFile: " + file.getPath());
            }
        }
        try {
            this.dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EvioException("Fow whatever reason, the file could not be opened. \n It could mean there is no permission to open the file for writing \nor that the file was a directory.File: " + file.getPath());
        }
    }

    private void getCleanBuffer() {
        if (this.blockBuffer == null) {
            this.blockBuffer = ByteBuffer.allocate(4 * this.blockSize);
            this.blockBuffer.order(ByteOrder.nativeOrder());
        } else {
            this.blockBuffer.clear();
        }
        this.updatedStart = false;
        this.blockBuffer.putInt(this.blockSize);
        this.blockBuffer.putInt(this.blockNumber++);
        this.blockBuffer.putInt(8);
        this.blockBuffer.putInt(0);
        this.blockBuffer.putInt(this.blockSize);
        this.blockBuffer.putInt(2);
        this.blockBuffer.putInt(0);
        this.blockBuffer.putInt(-1059454720);
    }

    public void close() {
        try {
            int n = this.blockBuffer.position();
            if (n > 0) {
                this.dataOutputStream.write(this.blockBuffer.array());
            }
            this.dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeEvent(EvioBank evioBank) throws EvioException {
        if (evioBank == null) {
            throw new EvioException("Attempt to write null event using EventWriter");
        }
        if (this.blockBuffer == null) {
            this.getCleanBuffer();
        }
        int n = evioBank.getTotalBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        evioBank.write(byteBuffer);
        if (!this.updatedStart) {
            this.updateStart(this.blockBuffer.position() / 4);
            this.updatedStart = true;
        }
        this.updateReserved1(++this.lastEventWritten);
        byteBuffer.position(0);
        while (byteBuffer.remaining() > this.blockBuffer.remaining()) {
            this.updateEnd(this.blockSize);
            int n2 = this.blockBuffer.remaining();
            for (int i = 0; i < n2; ++i) {
                this.blockBuffer.put(byteBuffer.get());
            }
            try {
                this.dataOutputStream.write(this.blockBuffer.array());
                this.getCleanBuffer();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (byteBuffer.remaining() > 0) {
            this.blockBuffer.put(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            this.updateEnd(this.blockBuffer.position() / 4);
        }
    }

    private void updateBlockLength(int n) {
        this.blockBuffer.putInt(BLOCK_LENGTH_OFFSET, n);
    }

    private void updateStart(int n) {
        this.blockBuffer.putInt(START_OFFSET, n);
    }

    private void updateEnd(int n) {
        this.blockBuffer.putInt(END_OFFSET, n);
    }

    private void updateReserved1(int n) {
        this.blockBuffer.putInt(RESERVED1_OFFSET, n);
    }

    public static void main(String[] stringArray) {
        String string = "../../testdata/out.ev";
        String string2 = "../../testdata/out_copy.ev";
        int n = 0;
        try {
            EvioEvent evioEvent;
            EvioFile evioFile = new EvioFile(new File(string));
            EventWriter eventWriter = new EventWriter(new File(string2));
            while ((evioEvent = evioFile.parseNextEvent()) != null) {
                eventWriter.writeEvent(evioEvent);
                ++n;
            }
            eventWriter.close();
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("copied: " + n + " events.");
        EvioFile.compareEventFiles(new File(string), new File(string2));
    }
}

