/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.StructureType;

public class EventBuilder {
    private EvioEvent event;

    public EventBuilder(int n, DataType dataType, int n2) {
        this.event = new EvioEvent(n, dataType, n2);
    }

    public EventBuilder(EvioEvent evioEvent) {
        this.event = evioEvent;
    }

    public void setAllHeaderLengths() {
        this.event.setAllHeaderLengths();
    }

    public void clearData(BaseStructure baseStructure) {
        if (baseStructure != null) {
            baseStructure.rawBytes = null;
            baseStructure.doubleData = null;
            baseStructure.floatData = null;
            baseStructure.intData = null;
            baseStructure.longData = null;
            baseStructure.shortData = null;
        }
    }

    public void addChild(BaseStructure baseStructure, BaseStructure baseStructure2) throws EvioException {
        if (baseStructure2 == null) {
            throw new EvioException("Attempt to add null child in addChild.");
        }
        if (baseStructure2.getByteOrder() != this.event.getByteOrder()) {
            throw new EvioException("Attempt to add child with opposite byte order.");
        }
        DataType dataType = baseStructure.header.getDataTypeEnum();
        if (dataType.isStructure()) {
            switch (dataType) {
                case BANK: 
                case ALSOBANK: {
                    if (baseStructure2.getStructureType() == StructureType.BANK) break;
                    String string = "Type mismatch in addChild. Parent content type: " + (Object)((Object)dataType) + " child type: " + (Object)((Object)baseStructure2.getStructureType());
                    throw new EvioException(string);
                }
                case SEGMENT: 
                case ALSOSEGMENT: {
                    if (baseStructure2.getStructureType() == StructureType.SEGMENT) break;
                    String string = "Type mismatch in addChild. Parent content type: " + (Object)((Object)dataType) + " child type: " + (Object)((Object)baseStructure2.getStructureType());
                    throw new EvioException(string);
                }
                case TAGSEGMENT: 
                case ALSOTAGSEGMENT: {
                    if (baseStructure2.getStructureType() == StructureType.TAGSEGMENT) break;
                    String string = "Type mismatch in addChild. Parent content type: " + (Object)((Object)dataType) + " child type: " + (Object)((Object)baseStructure2.getStructureType());
                    throw new EvioException(string);
                }
            }
        } else {
            String string = "Type mismatch in addChild. Parent content type: " + (Object)((Object)dataType) + " cannot have children.";
            throw new EvioException(string);
        }
        baseStructure.insert(baseStructure2);
        this.setAllHeaderLengths();
    }

    public void remove(BaseStructure baseStructure) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Attempt to remove null child.");
        }
        BaseStructure baseStructure2 = baseStructure.getParent();
        if (baseStructure2 == null) {
            throw new EvioException("Attempt to remove root node, i.e., the event. Don't remove an event. Just discard it.");
        }
        baseStructure.removeFromParent();
        this.setAllHeaderLengths();
    }

    public void appendIntData(BaseStructure baseStructure, int[] nArray) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append int data to a null structure.");
        }
        baseStructure.appendIntData(nArray);
        this.setAllHeaderLengths();
    }

    public void appendShortData(BaseStructure baseStructure, short[] sArray) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append short data to a null structure.");
        }
        baseStructure.appendShortData(sArray);
        this.setAllHeaderLengths();
    }

    public void appendLongData(BaseStructure baseStructure, long[] lArray) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append long data to a null structure.");
        }
        baseStructure.appendLongData(lArray);
        this.setAllHeaderLengths();
    }

    public void appendByteData(BaseStructure baseStructure, byte[] byArray) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append byte data to a null structure.");
        }
        baseStructure.appendByteData(byArray);
        this.setAllHeaderLengths();
    }

    public void appendFloatData(BaseStructure baseStructure, float[] fArray) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append float data to a null structure.");
        }
        baseStructure.appendFloatData(fArray);
        this.setAllHeaderLengths();
    }

    public void appendStringData(BaseStructure baseStructure, String string) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append String to a null structure.");
        }
        baseStructure.appendStringData(string);
        this.setAllHeaderLengths();
    }

    public void appendDoubleData(BaseStructure baseStructure, double[] dArray) throws EvioException {
        if (baseStructure == null) {
            throw new EvioException("Tried to append double data to a null structure.");
        }
        baseStructure.appendDoubleData(dArray);
    }

    public EvioEvent getEvent() {
        return this.event;
    }

    public void setEvent(EvioEvent evioEvent) {
        this.event = evioEvent;
    }

    public static void main(String[] stringArray) {
        String string = "C:\\Documents and Settings\\heddle\\My Documents\\test.ev";
        EventWriter eventWriter = null;
        try {
            eventWriter = new EventWriter(new File(string));
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
            System.exit(1);
        }
        int n = 1;
        int n2 = 11;
        try {
            EventBuilder eventBuilder = new EventBuilder(n2, DataType.INT32, n++);
            EvioEvent evioEvent = eventBuilder.getEvent();
            eventBuilder.appendIntData(evioEvent, EventBuilder.fakeIntArray(25));
            eventBuilder.appendIntData(evioEvent, EventBuilder.fakeIntArray(10));
            eventWriter.writeEvent(evioEvent);
            eventBuilder = new EventBuilder(n2, DataType.BANK, n++);
            EvioEvent evioEvent2 = eventBuilder.getEvent();
            EvioBank evioBank = new EvioBank(22, DataType.DOUBLE64, 0);
            eventBuilder.appendDoubleData(evioBank, EventBuilder.fakeDoubleArray(10));
            eventBuilder.addChild(evioEvent2, evioBank);
            eventWriter.writeEvent(evioEvent2);
            evioEvent2.getHeader().setNumber(n++);
            EvioBank evioBank2 = new EvioBank(33, DataType.BANK, 0);
            eventBuilder.addChild(evioEvent2, evioBank2);
            EvioBank evioBank3 = new EvioBank(34, DataType.SHORT16, 1);
            eventBuilder.addChild(evioBank2, evioBank3);
            eventBuilder.appendShortData(evioBank3, EventBuilder.fakeShortArray(5));
            EvioBank evioBank4 = new EvioBank(33, DataType.SEGMENT, 0);
            eventBuilder.addChild(evioBank2, evioBank4);
            EvioSegment evioSegment = new EvioSegment(34, DataType.SHORT16);
            eventBuilder.addChild(evioBank4, evioSegment);
            eventBuilder.appendShortData(evioSegment, EventBuilder.fakeShortArray(7));
            EvioSegment evioSegment2 = new EvioSegment(34, DataType.SHORT16);
            eventBuilder.addChild(evioBank4, evioSegment2);
            eventBuilder.appendShortData(evioSegment2, EventBuilder.fakeShortArray(10));
            EvioBank evioBank5 = new EvioBank(45, DataType.TAGSEGMENT, 0);
            eventBuilder.addChild(evioBank2, evioBank5);
            EvioTagSegment evioTagSegment = new EvioTagSegment(34, DataType.INT32);
            eventBuilder.addChild(evioBank5, evioTagSegment);
            eventBuilder.appendIntData(evioTagSegment, EventBuilder.fakeIntArray(3));
            EvioTagSegment evioTagSegment2 = new EvioTagSegment(34, DataType.CHARSTAR8);
            eventBuilder.addChild(evioBank5, evioTagSegment2);
            eventBuilder.appendStringData(evioTagSegment2, "This is a string");
            eventWriter.writeEvent(evioEvent2);
        }
        catch (EvioException evioException) {
            evioException.printStackTrace();
        }
        eventWriter.close();
        System.out.println("Test completed.");
    }

    private static int[] fakeIntArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i + 1;
        }
        return nArray;
    }

    private static short[] fakeShortArray(int n) {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(i + 1);
        }
        return sArray;
    }

    private static char[] fakeCharArray() {
        char[] cArray = new char[]{'T', 'h', 'i', 's', ' ', 'i', 's', ' ', 'c', 'h', 'a', 'r', ' ', 'd', 'a', 't', 'a', '.'};
        return cArray;
    }

    private static double[] fakeDoubleArray(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = i + 1;
        }
        return dArray;
    }
}

