/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.IEvioWriter;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.StructureType;

public abstract class BaseStructure
implements IEvioStructure,
MutableTreeNode,
IEvioWriter {
    protected BaseStructureHeader header;
    protected byte[] rawBytes;
    protected int[] intData;
    protected long[] longData;
    protected short[] shortData;
    protected double[] doubleData;
    protected float[] floatData;
    protected StringBuffer stringData;
    private int stringEnd;
    protected int numberDataItems;
    protected String xmlIndent = "";
    protected String xmlElementName;
    protected String xmlContentAttributeName;
    protected ByteOrder byteOrder;
    private BaseStructure parent;
    protected Vector<BaseStructure> children;

    public BaseStructure(BaseStructureHeader baseStructureHeader) {
        this.header = baseStructureHeader;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.setXmlNames();
    }

    @Override
    public abstract StructureType getStructureType();

    public abstract void toXML(XMLStreamWriter var1);

    public abstract String getXMLElementName();

    public String toXML() {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
            this.toXML(xMLStreamWriter);
            return stringWriter.toString();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            return null;
        }
    }

    protected void setXmlNames() {
        boolean bl = false;
        DataType dataType = this.header.getDataTypeEnum();
        switch (dataType) {
            case CHAR8: {
                this.xmlElementName = "int8";
                break;
            }
            case UCHAR8: {
                this.xmlElementName = "uint8";
                break;
            }
            case SHORT16: {
                this.xmlElementName = "int16";
                break;
            }
            case USHORT16: {
                this.xmlElementName = "uint16";
                break;
            }
            case INT32: {
                this.xmlElementName = "int32";
                break;
            }
            case UINT32: {
                this.xmlElementName = "uint32";
                break;
            }
            case LONG64: {
                this.xmlElementName = "int64";
                break;
            }
            case ULONG64: {
                this.xmlElementName = "uint64";
                break;
            }
            case FLOAT32: {
                this.xmlElementName = "float32";
                break;
            }
            case DOUBLE64: {
                this.xmlElementName = "float64";
                break;
            }
            case CHARSTAR8: {
                this.xmlElementName = "string";
                break;
            }
            case UNKNOWN32: {
                bl = true;
                this.xmlContentAttributeName = "unknown32";
                break;
            }
            case TAGSEGMENT: 
            case ALSOTAGSEGMENT: {
                bl = true;
                this.xmlContentAttributeName = "tagsegment";
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                bl = true;
                this.xmlContentAttributeName = "segment";
                break;
            }
            case BANK: 
            case ALSOBANK: {
                bl = true;
                this.xmlContentAttributeName = "bank";
                break;
            }
            default: {
                this.xmlElementName = "unknown";
            }
        }
        if (bl) {
            StructureType structureType = this.getStructureType();
            this.xmlElementName = structureType == StructureType.UNKNOWN32 ? "unknown32" : this.getXMLElementName();
        }
    }

    protected void setXmlIndent(String string) {
        this.xmlIndent = string;
    }

    protected void increaseXmlIndent() {
        this.xmlIndent = this.xmlIndent + "   ";
    }

    protected void decreaseXmlIndent() {
        this.xmlIndent = this.xmlIndent.substring(0, this.xmlIndent.length() - 3);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean isSwap() {
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public String getDescription() {
        return NameProvider.getName(this);
    }

    public String toString() {
        StructureType structureType = this.getStructureType();
        DataType dataType = this.header.getDataTypeEnum();
        String string = this.getDescription();
        if (NameProvider.NO_NAME_STRING.equals(string)) {
            string = null;
        }
        String string2 = (Object)((Object)structureType) + " of " + (Object)((Object)dataType) + "s " + " len (ints): " + this.header.length + " " + " tag: " + this.header.tag;
        if (this instanceof EvioBank) {
            string2 = string2 + " num: " + this.header.number;
        }
        string2 = this.rawBytes == null ? string2 + " data: null" : string2 + " datalen (bytes): " + this.rawBytes.length;
        if (string != null) {
            string2 = string2 + " [" + string + "]";
        }
        int n = this.children == null ? 0 : this.children.size();
        string2 = string2 + " <#children: " + n + ">";
        return string2;
    }

    @Override
    public BaseStructureHeader getHeader() {
        return this.header;
    }

    public int getNumberDataItems() {
        if (this.isContainer()) {
            this.numberDataItems = this.header.getLength() + 1 - this.header.getHeaderLength();
        }
        if (this.numberDataItems < 1) {
            int n = 0;
            DataType dataType = this.header.getDataTypeEnum();
            switch (dataType) {
                case CHAR8: 
                case UCHAR8: {
                    n = 1;
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    n = 2;
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    n = 4;
                    break;
                }
                case LONG64: 
                case ULONG64: 
                case DOUBLE64: {
                    n = 8;
                    break;
                }
                case CHARSTAR8: {
                    String[] stringArray = this.getStringData();
                    this.numberDataItems = stringArray.length;
                    break;
                }
            }
            if (n > 0) {
                this.numberDataItems = this.rawBytes.length / n;
            }
        }
        return this.numberDataItems;
    }

    public int getTotalBytes() {
        return 4 * (this.header.getLength() + 1);
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public void setRawBytes(byte[] byArray) {
        this.rawBytes = byArray;
    }

    @Override
    public int[] getIntData() {
        switch (this.header.getDataTypeEnum()) {
            case INT32: 
            case UINT32: {
                if (this.intData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.intData = ByteDataTransformer.getAsIntArray(this.rawBytes, this.byteOrder);
                }
                return this.intData;
            }
        }
        return null;
    }

    @Override
    public long[] getLongData() {
        switch (this.header.getDataTypeEnum()) {
            case LONG64: 
            case ULONG64: {
                if (this.longData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.longData = ByteDataTransformer.getAsLongArray(this.rawBytes, this.byteOrder);
                }
                return this.longData;
            }
        }
        return null;
    }

    @Override
    public float[] getFloatData() {
        switch (this.header.getDataTypeEnum()) {
            case FLOAT32: {
                if (this.floatData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.floatData = ByteDataTransformer.getAsFloatArray(this.rawBytes, this.byteOrder);
                }
                return this.floatData;
            }
        }
        return null;
    }

    @Override
    public double[] getDoubleData() {
        switch (this.header.getDataTypeEnum()) {
            case DOUBLE64: {
                if (this.doubleData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.doubleData = ByteDataTransformer.getAsDoubleArray(this.rawBytes, this.byteOrder);
                }
                return this.doubleData;
            }
        }
        return null;
    }

    @Override
    public short[] getShortData() {
        switch (this.header.getDataTypeEnum()) {
            case SHORT16: 
            case USHORT16: {
                if (this.shortData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    this.shortData = ByteDataTransformer.getAsShortArray(this.rawBytes, this.byteOrder);
                }
                return this.shortData;
            }
        }
        return null;
    }

    @Override
    public byte[] getByteData() {
        switch (this.header.getDataTypeEnum()) {
            case CHAR8: 
            case UCHAR8: 
            case CHARSTAR8: {
                return this.rawBytes;
            }
        }
        return null;
    }

    @Override
    public String[] getStringData() {
        switch (this.header.getDataTypeEnum()) {
            case CHARSTAR8: {
                int n;
                if (this.stringData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.stringData = new StringBuffer(new String(this.rawBytes, "US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                boolean bl = true;
                if (this.stringData.charAt(this.stringData.length() - 1) != '\u0004') {
                    bl = false;
                }
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                for (n = 0; n < this.stringData.length(); ++n) {
                    char c = this.stringData.charAt(n);
                    if (c == '\u0000') {
                        linkedList.add(n);
                        if (bl) continue;
                        break;
                    }
                    if ((c < ' ' || c == '\u007f') && c != '\n') break;
                }
                String[] stringArray = new String[linkedList.size()];
                int n2 = 0;
                for (int i = 0; i < linkedList.size(); ++i) {
                    n = (Integer)linkedList.get(i);
                    stringArray[i] = this.stringData.substring(n2, n);
                    n2 = n + 1;
                }
                return stringArray;
            }
        }
        return null;
    }

    private String getStringDataOrig() {
        switch (this.header.getDataTypeEnum()) {
            case CHARSTAR8: {
                if (this.stringData == null) {
                    if (this.rawBytes == null) {
                        return null;
                    }
                    try {
                        this.stringData = new StringBuffer(new String(this.rawBytes, "US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                String string = null;
                try {
                    int n = 0;
                    for (int i = this.rawBytes.length - 1; i >= 0 && this.rawBytes[i] < 32; --i) {
                        ++n;
                    }
                    string = new String(this.rawBytes, 0, this.rawBytes.length - n, "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                return string;
            }
        }
        return null;
    }

    @Override
    public BaseStructure getParent() {
        return this.parent;
    }

    public Enumeration<?> children() {
        if (this.children == null) {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (this.children == null) {
            this.children = new Vector(10);
        }
        this.children.add(n, (BaseStructure)mutableTreeNode);
    }

    public void insert(MutableTreeNode mutableTreeNode) {
        if (this.children == null) {
            this.children = new Vector(10);
        }
        this.insert(mutableTreeNode, this.children.size());
    }

    @Override
    public void remove(int n) {
        this.children.remove(n);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this.children.remove(mutableTreeNode);
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (BaseStructure)mutableTreeNode;
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public boolean getAllowsChildren() {
        return this.header.getDataTypeEnum().isStructure();
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.children.elementAt(n);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.size() < 1;
    }

    public boolean isContainer() {
        return this.header.getDataTypeEnum().isStructure();
    }

    protected void childrenToXML(XMLStreamWriter xMLStreamWriter) {
        if (this.children == null) {
            return;
        }
        this.increaseXmlIndent();
        for (BaseStructure baseStructure : this.children) {
            baseStructure.setXmlIndent(this.xmlIndent);
            baseStructure.toXML(xMLStreamWriter);
        }
        this.decreaseXmlIndent();
    }

    protected void commonXMLStart(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeCharacters(this.xmlIndent);
            xMLStreamWriter.writeStartElement(this.xmlElementName);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    protected void commonXMLDataWrite(XMLStreamWriter xMLStreamWriter) {
        if (!this.isLeaf()) {
            return;
        }
        try {
            String string = String.format("\n%s", this.xmlIndent);
            BaseStructureHeader baseStructureHeader = this.getHeader();
            switch (baseStructureHeader.getDataTypeEnum()) {
                case DOUBLE64: {
                    double[] dArray = this.getDoubleData();
                    for (int i = 0; i < dArray.length; ++i) {
                        if (i % 2 == 0) {
                            xMLStreamWriter.writeCharacters(string);
                        }
                        String string2 = String.format("%24.16e  ", dArray[i]);
                        xMLStreamWriter.writeCharacters(string2);
                    }
                    break;
                }
                case FLOAT32: {
                    float[] fArray = this.getFloatData();
                    for (int i = 0; i < fArray.length; ++i) {
                        if (i % 2 == 0) {
                            xMLStreamWriter.writeCharacters(string);
                        }
                        String string3 = String.format("%14.7e  ", Float.valueOf(fArray[i]));
                        xMLStreamWriter.writeCharacters(string3);
                    }
                    break;
                }
                case LONG64: 
                case ULONG64: {
                    long[] lArray = this.getLongData();
                    for (int i = 0; i < lArray.length; ++i) {
                        if (i % 2 == 0) {
                            xMLStreamWriter.writeCharacters(string);
                        }
                        String string4 = String.format("%20d  ", lArray[i]);
                        xMLStreamWriter.writeCharacters(string4);
                    }
                    break;
                }
                case INT32: 
                case UINT32: {
                    int[] nArray = this.getIntData();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (i % 5 == 0) {
                            xMLStreamWriter.writeCharacters(string);
                        }
                        String string5 = String.format("%11d  ", nArray[i]);
                        xMLStreamWriter.writeCharacters(string5);
                    }
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    short[] sArray = this.getShortData();
                    for (int i = 0; i < sArray.length; ++i) {
                        if (i % 5 == 0) {
                            xMLStreamWriter.writeCharacters(string);
                        }
                        String string6 = String.format("%6d  ", sArray[i]);
                        xMLStreamWriter.writeCharacters(string6);
                    }
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    byte[] byArray = this.getByteData();
                    for (int i = 0; i < byArray.length; ++i) {
                        if (i % 5 == 0) {
                            xMLStreamWriter.writeCharacters(string);
                        }
                        String string7 = String.format("%4d  ", byArray[i]);
                        xMLStreamWriter.writeCharacters(string7);
                    }
                    break;
                }
                case CHARSTAR8: {
                    String[] stringArray;
                    for (String string8 : stringArray = this.getStringData()) {
                        xMLStreamWriter.writeCharacters("\n");
                        xMLStreamWriter.writeCData(string8);
                    }
                    break;
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    protected int dataLength() {
        int n = 0;
        if (this.isLeaf()) {
            BaseStructureHeader baseStructureHeader = this.getHeader();
            switch (baseStructureHeader.getDataTypeEnum()) {
                case DOUBLE64: {
                    double[] dArray = this.getDoubleData();
                    if (dArray == null) break;
                    n = 2 * dArray.length;
                    break;
                }
                case FLOAT32: {
                    float[] fArray = this.getFloatData();
                    if (fArray == null) break;
                    n = fArray.length;
                    break;
                }
                case LONG64: 
                case ULONG64: {
                    long[] lArray = this.getLongData();
                    if (lArray == null) break;
                    n = 2 * lArray.length;
                    break;
                }
                case INT32: 
                case UINT32: {
                    int[] nArray = this.getIntData();
                    if (nArray == null) break;
                    n = nArray.length;
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    short[] sArray = this.getShortData();
                    if (this.shortData == null) break;
                    n = 1 + (sArray.length - 1) / 2;
                    break;
                }
                case CHAR8: 
                case UCHAR8: 
                case CHARSTAR8: {
                    byte[] byArray = this.getByteData();
                    if (byArray == null) break;
                    n = 1 + (byArray.length - 1) / 4;
                }
            }
        }
        return n;
    }

    protected void commonXMLClose(XMLStreamWriter xMLStreamWriter) {
        this.childrenToXML(xMLStreamWriter);
        try {
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeCharacters(this.xmlIndent);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    public Vector<BaseStructure> getChildren() {
        return this.children;
    }

    public int setAllHeaderLengths() {
        int n;
        if (this.isLeaf()) {
            n = this.dataLength();
        } else {
            n = 0;
            if (this.children == null) {
                System.err.println("Non leaf with null children!");
                System.exit(1);
            }
            for (BaseStructure baseStructure : this.children) {
                n += baseStructure.setAllHeaderLengths();
                ++n;
            }
        }
        if (this instanceof EvioBank) {
            ++n;
        }
        this.header.setLength(n);
        return n;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        int n;
        block16: {
            block15: {
                n = byteBuffer.position();
                this.header.write(byteBuffer);
                if (!this.isLeaf()) break block15;
                BaseStructureHeader baseStructureHeader = this.getHeader();
                switch (baseStructureHeader.getDataTypeEnum()) {
                    case DOUBLE64: {
                        double[] dArray = this.getDoubleData();
                        if (dArray == null) break;
                        for (double d : dArray) {
                            byteBuffer.putDouble(d);
                        }
                        break block16;
                    }
                    case FLOAT32: {
                        float[] fArray = this.getFloatData();
                        if (fArray == null) break;
                        for (float f : fArray) {
                            byteBuffer.putFloat(f);
                        }
                        break block16;
                    }
                    case LONG64: 
                    case ULONG64: {
                        long[] lArray = this.getLongData();
                        if (lArray == null) break;
                        for (long l : lArray) {
                            byteBuffer.putLong(l);
                        }
                        break block16;
                    }
                    case INT32: 
                    case UINT32: {
                        int[] nArray = this.getIntData();
                        if (nArray == null) break;
                        for (int n2 : nArray) {
                            byteBuffer.putInt(n2);
                        }
                        break block16;
                    }
                    case SHORT16: 
                    case USHORT16: {
                        short[] sArray = this.getShortData();
                        if (sArray == null) break;
                        for (short s : sArray) {
                            byteBuffer.putShort(s);
                        }
                        if (sArray.length % 2 <= 0) break;
                        byteBuffer.putShort((short)0);
                        break;
                    }
                    case CHAR8: 
                    case UCHAR8: 
                    case CHARSTAR8: {
                        byte[] byArray = this.getByteData();
                        if (byArray == null) break;
                        for (byte by : byArray) {
                            byteBuffer.put(by);
                        }
                        byte[] byArray2 = new byte[]{0, 0, 0};
                        int[] nArray = new int[]{0, 3, 2, 1};
                        byteBuffer.put(byArray2, 0, nArray[byArray.length % 4]);
                    }
                }
                break block16;
            }
            for (BaseStructure baseStructure : this.children) {
                baseStructure.write(byteBuffer);
            }
        }
        return byteBuffer.position() - n;
    }

    public void appendIntData(int[] nArray) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.INT32 && dataType != DataType.UINT32) {
            throw new EvioException("Tried to append int data to a structure of type: " + (Object)((Object)dataType));
        }
        if (nArray == null) {
            return;
        }
        if (this.intData == null) {
            this.intData = nArray;
            this.numberDataItems = nArray.length;
        } else {
            int n = this.intData.length;
            int n2 = nArray.length;
            this.intData = Arrays.copyOf(this.intData, n + n2);
            System.arraycopy(nArray, 0, this.intData, n, n2);
            this.numberDataItems += nArray.length;
        }
        this.setAllHeaderLengths();
    }

    public void appendShortData(short[] sArray) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.SHORT16 && dataType != DataType.USHORT16) {
            throw new EvioException("Tried to append short data to a structure of type: " + (Object)((Object)dataType));
        }
        if (sArray == null) {
            return;
        }
        if (this.shortData == null) {
            this.shortData = sArray;
            this.numberDataItems = sArray.length;
        } else {
            int n = this.shortData.length;
            int n2 = sArray.length;
            this.shortData = Arrays.copyOf(this.shortData, n + n2);
            System.arraycopy(sArray, 0, this.shortData, n, n2);
            this.numberDataItems += sArray.length;
        }
        this.setAllHeaderLengths();
    }

    public void appendLongData(long[] lArray) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.LONG64 && dataType != DataType.ULONG64) {
            throw new EvioException("Tried to append long data to a structure of type: " + (Object)((Object)dataType));
        }
        if (lArray == null) {
            return;
        }
        if (this.longData == null) {
            this.longData = lArray;
            this.numberDataItems = lArray.length;
        } else {
            int n = this.longData.length;
            int n2 = lArray.length;
            this.longData = Arrays.copyOf(this.longData, n + n2);
            System.arraycopy(lArray, 0, this.longData, n, n2);
            this.numberDataItems += lArray.length;
        }
        this.setAllHeaderLengths();
    }

    public void appendByteData(byte[] byArray) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.CHAR8 && dataType != DataType.UCHAR8) {
            throw new EvioException("Tried to append byte data to a structure of type: " + (Object)((Object)dataType));
        }
        if (byArray == null) {
            return;
        }
        if (this.rawBytes == null) {
            this.rawBytes = byArray;
            this.numberDataItems = byArray.length;
        } else {
            int n = this.rawBytes.length;
            int n2 = byArray.length;
            this.rawBytes = Arrays.copyOf(this.rawBytes, n + n2);
            System.arraycopy(byArray, 0, this.rawBytes, n, n2);
            this.numberDataItems += byArray.length;
        }
        this.setAllHeaderLengths();
    }

    public void appendFloatData(float[] fArray) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.FLOAT32) {
            throw new EvioException("Tried to append float data to a structure of type: " + (Object)((Object)dataType));
        }
        if (fArray == null) {
            return;
        }
        if (this.floatData == null) {
            this.floatData = fArray;
            this.numberDataItems = fArray.length;
        } else {
            int n = this.floatData.length;
            int n2 = fArray.length;
            this.floatData = Arrays.copyOf(this.floatData, n + n2);
            System.arraycopy(fArray, 0, this.floatData, n, n2);
            this.numberDataItems += fArray.length;
        }
        this.setAllHeaderLengths();
    }

    public void appendStringData(String string) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.CHARSTAR8) {
            throw new EvioException("Tried to append string to a structure of type: " + (Object)((Object)dataType));
        }
        if (string == null) {
            return;
        }
        if (this.stringData == null) {
            this.stringData = new StringBuffer(string.length() + 1);
            this.numberDataItems = 1;
        } else {
            this.stringData.delete(this.stringEnd, this.stringData.length());
            ++this.numberDataItems;
        }
        this.stringData.append(string);
        this.stringData.append('\u0000');
        this.stringEnd = this.stringData.length();
        int[] nArray = new int[]{4, 3, 2, 1};
        switch (nArray[this.stringData.length() % 4]) {
            case 4: {
                this.stringData.append("\u0004\u0004\u0004\u0004");
                break;
            }
            case 3: {
                this.stringData.append("\u0004\u0004\u0004");
                break;
            }
            case 2: {
                this.stringData.append("\u0004\u0004");
                break;
            }
            case 1: {
                this.stringData.append('\u0004');
            }
        }
        try {
            this.rawBytes = this.stringData.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setAllHeaderLengths();
    }

    public void appendDoubleData(double[] dArray) throws EvioException {
        DataType dataType = this.header.getDataTypeEnum();
        if (dataType != DataType.DOUBLE64) {
            throw new EvioException("Tried to append double data to a structure of type: " + (Object)((Object)dataType));
        }
        if (dArray == null) {
            return;
        }
        if (this.doubleData == null) {
            this.doubleData = dArray;
            this.numberDataItems = dArray.length;
        } else {
            int n = this.doubleData.length;
            int n2 = dArray.length;
            this.doubleData = Arrays.copyOf(this.doubleData, n + n2);
            System.arraycopy(dArray, 0, this.doubleData, n, n2);
            this.numberDataItems += dArray.length;
        }
        this.setAllHeaderLengths();
    }
}

