/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;

public final class BankHeader
extends BaseStructureHeader {
    public BankHeader() {
    }

    public BankHeader(int n, DataType dataType, int n2) {
        super(n, dataType, n2);
    }

    public BankHeader(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    @Override
    public int getHeaderLength() {
        return 2;
    }

    @Override
    protected void toArray(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            ByteDataTransformer.intToBytes(this.length, byArray, n);
            ByteDataTransformer.shortToBytes(this.shortValue(this.tag), byArray, n + 4);
            byArray[n + 6] = this.byteValue(this.dataType);
            byArray[n + 7] = this.byteValue(this.number);
        } else {
            ByteDataTransformer.intToBytes(Integer.reverseBytes(this.length), byArray, n);
            byArray[n + 4] = this.byteValue(this.number);
            byArray[n + 5] = this.byteValue(this.dataType);
            ByteDataTransformer.shortToBytes(Short.reverseBytes(this.shortValue(this.tag)), byArray, n + 6);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(String.format("bank length: %d\n", this.length));
        stringBuffer.append(String.format("number:      %d\n", this.number));
        stringBuffer.append(String.format("data type:   %s\n", this.getDataTypeName()));
        stringBuffer.append(String.format("tag:         %d\n", this.tag));
        return stringBuffer.toString();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.length);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.putShort(this.shortValue(this.tag));
            byteBuffer.put(this.byteValue(this.dataType));
            byteBuffer.put(this.byteValue(this.number));
        } else {
            byteBuffer.put(this.byteValue(this.number));
            byteBuffer.put(this.byteValue(this.dataType));
            byteBuffer.putShort(this.shortValue(this.tag));
        }
        return 8;
    }
}

